/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.google;

import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.push.google.GcmPacketExtension;
import com.humuson.tms.sender.push.google.LoggingConnectionListener;
import com.humuson.tms.sender.push.google.PushContent;
import com.humuson.tms.sender.push.google.TmsStanzaFilter;
import com.humuson.tms.sender.result.ResultBuilder;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.date.DateUtil;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLSocketFactory;
import net.minidev.json.JSONValue;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.PingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PushActor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PushActor.class);
    TmsSenderCommonConfig tmsCommonConfig;
    private BlockingQueue<String> targetMessageIds;
    private final int MAX_XMPP_DOWNSTREAM = 100;
    protected Object LOCK_PUSH_DATA = new Object();
    protected Object LOCK_RESULT_DATA = new Object();
    protected int sendWaitCnt = 0;
    protected int resultWaitCnt = 0;
    private boolean startFlag = false;
    private XMPPTCPConnection connection;
    protected volatile boolean connectionDraining = false;

    public void registTargetData(String messageId, String targetData) {
        try {
            this.targetMessageIds.put(messageId);
            this.send(targetData, false);
        }
        catch (InterruptedException | SmackException.NotConnectedException e) {
            log.error("send xmpp error {}", e);
        }
    }

    protected TmsResponse createResultData(String code, String messageId, String message_type, String detail) {
        TmsResponse result = new TmsResponse();
        String[] commonTargetData = messageId.split("-");
        result.setSiteID(commonTargetData[0]);
        result.setSchdId(commonTargetData[1]);
        result.setSendId(commonTargetData[2]);
        result.setTargetSeq(commonTargetData[3]);
        result.setWorkday(commonTargetData[4]);
        result.setMemberId(commonTargetData[5]);
        result.setMemberIdSeq(commonTargetData[6]);
        result.setCode(message_type);
        result.setDetail(detail);
        result.setType("R");
        result.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        return result;
    }

    public PushActor(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.targetMessageIds = new LinkedBlockingDeque<String>(100);
    }

    @PostConstruct
    public void init() {
        ProviderManager.addExtensionProvider((String)this.tmsCommonConfig.getXmppConfig().getElementName(), (String)this.tmsCommonConfig.getXmppConfig().getNameSpace(), (Object)new ExtensionElementProvider<ExtensionElement>(){

            public ExtensionElement parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
                String json = parser.nextText();
                return new GcmPacketExtension(json, PushActor.this.tmsCommonConfig.getXmppConfig().getElementName(), PushActor.this.tmsCommonConfig.getXmppConfig().getNameSpace());
            }
        });
    }

    public boolean sendDownstreamMessage(String jsonRequest) throws SmackException.NotConnectedException, InterruptedException {
        if (!this.connectionDraining) {
            this.send(jsonRequest, false);
            return true;
        }
        log.info("Dropping downstream message since the connection is draining");
        return false;
    }

    public String nextMessageId() {
        return "m-".concat(UUID.randomUUID().toString());
    }

    public String nextMessageId(String memberId, String memberIdSeq) {
        return "m-".concat(UUID.randomUUID().toString());
    }

    public void send(String jsonRequest, boolean ack) throws SmackException.NotConnectedException, InterruptedException {
        log.debug("xmppConfig.getGcmElementName() {}", (Object)this.tmsCommonConfig.getXmppConfig().getElementName());
        log.debug("tmsCommonConfig.getXmppConfig().getGcmNameSpace() {}", (Object)this.tmsCommonConfig.getXmppConfig().getNameSpace());
        Stanza request = new GcmPacketExtension(jsonRequest, this.tmsCommonConfig.getXmppConfig().getElementName(), this.tmsCommonConfig.getXmppConfig().getNameSpace()).toPacket();
        this.connection.sendStanza(request);
    }

    protected void handleUpstreamMessage(Map<String, Object> jsonObject) throws InterruptedException {
        String category = (String)jsonObject.get("category");
        String from = (String)jsonObject.get("from");
        Map payload = (Map)jsonObject.get("data");
        payload.put("ECHO", "Application: " + category);
        log.info("payload {}", (Object)payload);
        String echo = PushContent.createJsonMessage(from, this.nextMessageId(), payload, "echo:CollapseKey", null, false);
        try {
            log.info("upstream message is {}", (Object)jsonObject.toString());
            this.sendDownstreamMessage(echo);
        }
        catch (SmackException.NotConnectedException e) {
            log.warn("Not connected anymore, echo message is not sent {}", (Throwable)e);
        }
    }

    protected void handleAckReceipt(Map<String, Object> jsonObject) {
        String messageId = (String)jsonObject.get("message_id");
        String from = (String)jsonObject.get("from");
        String messageType = (String)jsonObject.get("message_type");
        TmsResponse result = this.createResultData("1000", messageId, messageType, null);
        this.resultDataProcess(result);
        log.info("ackReceipt messageId {}, from {}", (Object)messageId, (Object)from);
    }

    protected void handleNackReceipt(Map<String, Object> jsonObject) {
        String messageId = (String)jsonObject.get("message_id");
        String messageType = (String)jsonObject.get("message_type");
        String from = (String)jsonObject.get("from");
        String errorDetail = (String)jsonObject.get("error_description");
        TmsResponse result = this.createResultData("1000", messageId, messageType, errorDetail);
        this.resultDataProcess(result);
        log.info("nackReceipt messageId: {}, from: {}, errorDetail: {}", new Object[]{messageId, from, errorDetail});
    }

    protected void handleControlMessage(Map<String, Object> jsonObject) {
        log.info("handleControlMessage(): " + jsonObject);
        String controlType = (String)jsonObject.get("control_type");
        if ("CONNECTION_DRAINING".equals(controlType)) {
            this.connectionDraining = true;
        } else {
            log.info("Unrecognized control type: {} This could happen if new features are added to the CCS protocol.", (Object)controlType);
        }
    }

    public void connect(String senderId, String apiKey) throws XMPPException, IOException, SmackException, InterruptedException {
        XMPPTCPConnectionConfiguration config = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppDomain(this.tmsCommonConfig.getXmppConfig().getXmppServer())).setHost(this.tmsCommonConfig.getXmppConfig().getXmppServer())).setCompressionEnabled(false).setPort(Integer.parseInt(this.tmsCommonConfig.getXmppConfig().getXmppPort()))).setConnectTimeout(0).setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setSendPresence(false)).setDebuggerEnabled(this.tmsCommonConfig.getXmppConfig().isXmppDebug())).setSocketFactory(SSLSocketFactory.getDefault())).build();
        this.connection = new XMPPTCPConnection(config);
        Roster roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        roster.setRosterLoadedAtLogin(false);
        this.connection.connect();
        this.connection.addConnectionListener((ConnectionListener)new LoggingConnectionListener());
        this.connection.addAsyncStanzaListener((StanzaListener)new MyStanzaListener(), (StanzaFilter)new TmsStanzaFilter(senderId));
        this.connection.addPacketInterceptor((StanzaListener)new MyStanzaInterceptor(), (StanzaFilter)new TmsStanzaFilter(senderId));
        final PingManager pingManager = PingManager.getInstanceFor((XMPPConnection)this.connection);
        pingManager.setPingInterval(100);
        pingManager.registerPingFailedListener(new PingFailedListener(){

            public void pingFailed() {
                log.info("The ping failed, restarting the ping interval again ...");
                pingManager.setPingInterval(100);
            }
        });
        this.connection.login((CharSequence)(senderId + "@gcm.googleapis.com"), apiKey);
    }

    public void resultDataProcess(TmsResponse tmsResponse) {
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType("XP").serverId(this.tmsCommonConfig.getServerID()).resultType(tmsResponse.getType()).domain("XMPP");
        TmsSendResult result = null;
        try {
            result = targetDataResult.memberId(tmsResponse.getMemberId()).memberIdSeq(tmsResponse.getMemberIdSeq()).errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).schdId(tmsResponse.getSchdId()).sendId(tmsResponse.getSendId()).targetSeq(tmsResponse.getTargetSeq()).workday(tmsResponse.getWorkday()).siteId(tmsResponse.getSiteID()).startDate(tmsResponse.getStartDate()).endDate(tmsResponse.getStartDate()).build();
            this.tmsCommonConfig.getWrapperRedisTemplate().hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
        }
        catch (Exception e) {
            log.error("Error Process Error targetMemberId :{}, ErrorMsg :{} ", new Object[]{tmsResponse.getMemberId(), tmsResponse.getDetail(), e});
        }
    }

    @Override
    public void run() {
        this.startFlag = true;
        while (this.connection.isConnected()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.startFlag = false;
        log.error("Connection fail -> reconnect process Start");
    }

    public BlockingQueue<String> getTargetMessageIds() {
        return this.targetMessageIds;
    }

    public boolean isStartFlag() {
        return this.startFlag;
    }

    public XMPPTCPConnection getConnection() {
        return this.connection;
    }

    private class MyStanzaListener
    implements StanzaListener {
        private int proccessCnt = 0;

        private MyStanzaListener() {
        }

        public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
            log.info("Received: {}", (Object)packet.toXML());
            String resultData = packet.toXML().toString();
            int startPoint = resultData.indexOf("{");
            int endPoint = resultData.lastIndexOf("}") + 1;
            String message = null;
            if (startPoint >= 0) {
                message = resultData.substring(startPoint, endPoint).replaceAll("&quot;", "'");
                Map jsonObject = null;
                try {
                    jsonObject = (Map)JSONValue.parseWithException((String)message);
                    Object messageType = jsonObject.get("message_type");
                    if (jsonObject.containsKey("message_id")) {
                        ++this.proccessCnt;
                        PushActor.this.targetMessageIds.take();
                    }
                    if (messageType == null) {
                        PushActor.this.handleUpstreamMessage(jsonObject);
                        String messageId = (String)jsonObject.get("message_id");
                        String from = (String)jsonObject.get("from");
                        PushContent pushContent = new PushContent();
                        String ack = pushContent.createJsonAck(from, messageId);
                        PushActor.this.send(ack, true);
                    } else if ("ack".equals(messageType.toString())) {
                        PushActor.this.handleAckReceipt(jsonObject);
                    } else if ("nack".equals(messageType.toString())) {
                        PushActor.this.handleNackReceipt(jsonObject);
                    } else if ("control".equals(messageType.toString())) {
                        PushActor.this.handleControlMessage(jsonObject);
                    } else {
                        log.warn("Unrecognized message type {}", (Object)messageType.toString());
                    }
                }
                catch (Exception e) {
                    log.error("Failed to process packet {}", (Throwable)e);
                }
            }
        }
    }

    private class MyStanzaInterceptor
    implements StanzaListener {
        private MyStanzaInterceptor() {
        }

        public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
        }
    }
}

