/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.auth;

import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApnsKey
implements ECKey {
    private static final Logger log = LoggerFactory.getLogger(ApnsKey.class);
    private final String teamId;
    private final String keyId;
    private final ECKey key;
    public static final String APNS_SIGNATURE_ALGORITHM = "SHA256withECDSA";

    protected ECKey getKey() {
        return this.key;
    }

    public ApnsKey(String keyId, String teamId, ECKey key) {
        Objects.requireNonNull(keyId, "Key identifier must not be null.");
        Objects.requireNonNull(teamId, "Team identifier must not be null.");
        Objects.requireNonNull(key, "Key must not be null.");
        this.keyId = keyId;
        this.teamId = teamId;
        this.key = key;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.key.getParams();
    }

    public String getTeamId() {
        return this.teamId;
    }

    public String getKeyId() {
        return this.keyId;
    }
}

