/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import com.eatthepath.pushy.apns.DeliveryPriority;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsApnsConfig;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.push.PushResultListener;
import com.humuson.tms.sender.push.apns.actor.ApnsConfiguration;
import com.humuson.tms.sender.push.apns.actor.ApnsConnection;
import com.humuson.tms.sender.push.apns.actor.ApnsUtil;
import com.humuson.tms.sender.push.apns.model.TmsApnsContentModel;
import com.humuson.tms.sender.push.apns.model.TmsApnsModel;
import com.humuson.tms.sender.push.apns.util.TokenUtil;
import com.humuson.tms.sender.result.ResultBuilder;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.date.DateUtil;
import com.vdurmont.emoji.EmojiParser;
import io.netty.util.internal.StringUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsNewApnsSender
implements SenderActor,
PushResultListener {
    private static final Logger log = LoggerFactory.getLogger(TmsNewApnsSender.class);
    private TmsSenderCommonConfig tmsCommonConfig;
    private final ApnsConfiguration configuration;
    private final ApnsConnection apnsConnection;

    public TmsNewApnsSender(TmsSenderCommonConfig commonConfig, ApnsConfiguration configuration) throws SSLException {
        this.tmsCommonConfig = commonConfig;
        this.configuration = configuration;
        this.apnsConnection = new ApnsConnection(commonConfig, configuration, (PushResultListener)this);
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse tmsResponse = new TmsResponse();
        tmsResponse.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        tmsResponse.setCode("TMS0");
        tmsResponse.setDetail("SUCCESS");
        TmsApnsContentModel tmsApnsContentModel = new TmsApnsContentModel();
        TmsApnsModel tmsApnsModel = new TmsApnsModel();
        try {
            if (targetData.has("PUSH_MSG") && !"".equals(targetData.getString("PUSH_MSG"))) {
                tmsApnsContentModel.setContent(targetData.getString("PUSH_MSG"));
            } else {
                tmsApnsContentModel.setContent(pinfo.getPushMsg());
            }
            if (targetData.has("PUSH_VALUE") && !"".equals(targetData.getString("PUSH_VALUE"))) {
                tmsApnsContentModel.setLinkUrl(targetData.getString("PUSH_VALUE"));
            } else {
                tmsApnsContentModel.setLinkUrl(pinfo.getPushValue());
            }
            if (targetData.has("SUBJECT") && !"".equals(targetData.getString("SUBJECT"))) {
                tmsApnsContentModel.setSubject(targetData.getString("SUBJECT"));
            } else {
                tmsApnsContentModel.setSubject(pinfo.getSubject());
            }
            if (targetData.has("CONTENT_TYPE")) {
                tmsApnsContentModel.setContentType(targetData.getString("CONTENT_TYPE"));
            } else {
                tmsApnsContentModel.setContentType(pinfo.getContentType());
            }
        }
        catch (JSONException e) {
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail("SD3001|APNS sender Error : Target Content can't convert to Json data error");
            if (log.isDebugEnabled()) {
                log.error("SD3001|APNS sender Error : Target Content can't convert to Json data error : {}", (Throwable)e);
            }
            return tmsResponse;
        }
        try {
            if (targetData.has("TMS_M_ID")) {
                tmsApnsModel.setMemberId(targetData.getString("TMS_M_ID"));
            }
            tmsApnsModel.setMemberIdSeq(targetData.getString("UNIQUE_SEQ"));
            tmsApnsModel.setToken(targetData.getString("TMS_M_TARGET"));
            tmsApnsModel.setMessageId(SenderUtil.createMessageId(pinfo, targetData.getString("TMS_M_ID"), targetData.getString("UNIQUE_SEQ")));
        }
        catch (JSONException e) {
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail("SD3001|APNS sender Error : Target data can't convert to Json data error");
            if (log.isDebugEnabled()) {
                log.error("SD3001|APNS sender Error : Target data can't convert to Json data error : {}", (Throwable)e);
            }
            return tmsResponse;
        }
        String payloadStr = this.createPayload(tmsApnsModel, tmsApnsContentModel, pinfo);
        String token = TokenUtil.sanitizeTokenString(tmsApnsModel.getToken());
        String messageId = tmsApnsModel.getMessageId();
        Date invalidationTime = ApnsUtil.getInvalidationTime(1800);
        try {
            tmsResponse.setMemberId(tmsApnsModel.getMemberId());
            tmsResponse.setMemberIdSeq(tmsApnsModel.getMemberIdSeq());
            SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, this.configuration.getTopicName(), payloadStr, Instant.now().plus(Duration.ofSeconds(1800L)), DeliveryPriority.IMMEDIATE, null, messageId, UUID.randomUUID());
            log.info("APNS payload : {}", (Object)pushNotification);
            String response = this.apnsConnection.sendSyncPacket(pushNotification);
            if (!"TMS0".equals(response)) {
                tmsResponse.setCode("TMS9");
                tmsResponse.setDetail(response);
            }
            return tmsResponse;
        }
        catch (Exception e) {
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail("SD3101|APNS sender Error : Token Validation Error");
            if (log.isDebugEnabled()) {
                log.error("SD3101|APNS sender Error : Token Validation Error", (Throwable)e);
            }
            return tmsResponse;
        }
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ArrayList<TmsResponse> resultList = new ArrayList<TmsResponse>();
        for (JSONObject targetData : targetList) {
            resultList.add(this.targetDataSendToServer(targetData, pinfo, chinfo));
        }
        return resultList;
    }

    @Override
    public void createTargetData(String targetData) {
    }

    public String createPayload(TmsApnsModel tmsApnsModel, TmsApnsContentModel tmsApnsContentModel, TMSCommonPInfo pinfo) {
        SimpleApnsPayloadBuilder payloadBuilder = new SimpleApnsPayloadBuilder();
        payloadBuilder.setAlertTitle(tmsApnsContentModel.getSubject()).setAlertBody(EmojiParser.parseToUnicode((String)tmsApnsContentModel.getContent())).setSound(StringUtil.isNullOrEmpty((String)pinfo.getSound()) ? "default" : pinfo.getSound()).addCustomProperty("l", (Object)tmsApnsContentModel.getLinkUrl()).addCustomProperty("t", (Object)tmsApnsContentModel.getContentType()).addCustomProperty("i", (Object)tmsApnsModel.getMessageId()).addCustomProperty("send", (Object)pinfo.getSendId()).addCustomProperty("schd", (Object)pinfo.getSchdId()).addCustomProperty("wc", (Object)pinfo.getWorkday()).addCustomProperty("tc", (Object)pinfo.getTrackingClose()).addCustomProperty("mem", (Object)tmsApnsModel.getMemberId().concat("|").concat(tmsApnsModel.getMemberIdSeq())).addCustomProperty("send-time", (Object)DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        if (pinfo.getPushImg() != null) {
            payloadBuilder.setMutableContent(true);
            payloadBuilder.addCustomProperty("c", (Object)ApnsUtil.makeImgParams(pinfo.getPushImg()));
        }
        return payloadBuilder.build();
    }

    @Override
    public void processSuccessful(String response, String messageId) {
        TmsResponse result = this.createResultData(messageId, "1000", "SUCCESS");
        this.resultDataProcess(result);
    }

    @Override
    public void processError(String response, String messageId) {
        String errorCode = TmsApnsConfig.APNS_ERROR_CODE_MAP.get(response);
        TmsResponse result = this.createResultData(messageId, errorCode, response);
        this.resultDataProcess(result);
    }

    public void resultDataProcess(TmsResponse tmsResponse) {
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType("PU").serverId(this.tmsCommonConfig.getServerID()).resultType(tmsResponse.getType()).domain("APNS");
        try {
            TmsSendResult result = targetDataResult.memberId(tmsResponse.getMemberId()).memberIdSeq(tmsResponse.getMemberIdSeq()).errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).schdId(tmsResponse.getSchdId()).sendId(tmsResponse.getSendId()).targetSeq(tmsResponse.getTargetSeq()).workday(tmsResponse.getWorkday()).siteId(tmsResponse.getSiteID()).startDate(tmsResponse.getStartDate()).endDate(tmsResponse.getStartDate()).build();
            if (log.isDebugEnabled()) {
                log.debug("redisKey:{}, field:{}, value:{}", new Object[]{result.getRedisKey(), result.getRedisField(), result.getRedisValue()});
            }
            this.tmsCommonConfig.getWrapperRedisTemplate().hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
        }
        catch (Exception e) {
            log.error("Error Process Error targetMemberId :{}, ErrorMsg :{} ", new Object[]{tmsResponse.getMemberId(), tmsResponse.getDetail(), e});
        }
    }

    protected TmsResponse createResultData(String messageId, String code, String detail) {
        TmsResponse result = new TmsResponse();
        String[] commonTargetData = messageId.split("\t");
        result.setSiteID(commonTargetData[0]);
        result.setSchdId(commonTargetData[1]);
        result.setSendId(commonTargetData[2]);
        result.setTargetSeq(commonTargetData[3]);
        result.setWorkday(commonTargetData[4]);
        result.setMemberId(commonTargetData[5]);
        result.setMemberIdSeq(commonTargetData[6]);
        result.setCode(code);
        result.setDetail(detail);
        result.setType("S");
        result.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        return result;
    }
}

