/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.push.apns.actor.ApnsConfiguration;
import com.humuson.tms.sender.push.apns.actor.TmsNewApnsSender;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsApnsMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsApnsMessageListener.class);
    private TmsSenderCommonConfig commonConfig;
    Map<String, TmsNewApnsSender> apnsSenderConcurrentMap = new ConcurrentHashMap<String, TmsNewApnsSender>();

    public TmsApnsMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse targetResult = new TmsResponse();
        try {
            Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
            pinfo.setApnsPath(appinfos.get("I_PUSH_CERT").toString());
            pinfo.setApnsPwd(appinfos.get("I_PUSH_PWD").toString());
            targetResult.setDetail("SUCCESS");
            targetResult.setCode("TMS0");
        }
        catch (Exception e) {
            targetResult.setDetail("Redis AppInfo is invalid. appGrpId:" + pinfo.getAppGrpId() + "error:" + e.toString());
            targetResult.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            targetResult.setCode("TMS9");
            return targetResult;
        }
        Thread t = Thread.currentThread();
        String threadName = t.getName();
        String apnsSenderName = threadName.concat("@").concat(pinfo.getAppGrpId());
        TmsResponse result = null;
        String errorDetail = null;
        TmsNewApnsSender apnsSender = this.apnsSenderConcurrentMap.get(apnsSenderName);
        if (apnsSender == null) {
            String strCertBase64 = pinfo.getApnsPath();
            if (strCertBase64 == null) {
                Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
                strCertBase64 = (String)appinfos.get("I_PUSH_CERT");
            }
            byte[] valueDecoded = Base64.decodeBase64((String)strCertBase64);
            try {
                String password = HumusonDecryptor.decrypt((String)pinfo.getApnsPwd(), (String)this.commonConfig.getHumusonEncKey());
                ApnsConfiguration configuration = new ApnsConfiguration(valueDecoded, pinfo.getAppGrpId(), password);
                configuration.setConcurrentConnections(3);
                apnsSender = new TmsNewApnsSender(this.commonConfig, configuration);
                this.apnsSenderConcurrentMap.put(apnsSenderName, apnsSender);
            }
            catch (Exception e) {
                log.error("Apns error [InvalidSSLConfig] {}", (Throwable)e);
                errorDetail = e.toString();
                targetResult.setCode("TMS9");
                targetResult.setDetail(errorDetail);
                targetResult.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                TmsResponse tmsResponse = targetResult;
                return tmsResponse;
            }
        }
        try {
            result = apnsSender.targetDataSendToServer(targetData, pinfo, chinfo);
            if (errorDetail != null) {
                result.setDetail(errorDetail);
            }
            log.info("APNS result [memberId:{}, code:{}, detail:{}]", new Object[]{result.getMemberId(), result.getCode(), result.getDetail()});
            return result;
        }
        catch (Exception e) {
            TmsResponse tmsResponse = new TmsResponse();
            tmsResponse.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail(e.toString());
            return tmsResponse;
        }
    }

    public String createApnsServiceKey(String appGrpId, String threadId) {
        String serviceKey = "";
        serviceKey = appGrpId.concat("_").concat(threadId);
        return serviceKey;
    }

    public TmsResponse checkResultValue(TmsResponse result, TmsResponse targetResult) {
        if (!result.getCode().equals(targetResult.getCode())) {
            result.setCode(result.getCode());
        }
        if (!result.getDetail().equals(targetResult.getDetail())) {
            result.setDetail(result.getDetail());
        }
        return result;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ArrayList<TmsResponse> targetResultlist = new ArrayList<TmsResponse>();
        String startDate = DateUtil.getFullDate((String)"yyyyMMddHHmmss");
        for (JSONObject targetData : targetListData) {
            try {
                targetResultlist.add(this.sendProcess(targetData, pinfo, chinfo));
            }
            catch (Exception e) {
                TmsResponse errorData = new TmsResponse();
                targetResultlist.add(errorData.createErrorData(chinfo.getTargetMemberId(), chinfo.getTargetMemberIdSeq(), e.toString()));
            }
        }
        return targetResultlist;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.equals("") && status.equals("") && domain.toUpperCase().equals("APNS");
    }

    public void resultDataProcess(TmsResponse tmsResponse) {
        try {
            TmsSendResult result = TmsResult.newResult("S").channelType("PU").serverId(this.commonConfig.getServerID()).resultType(tmsResponse.getType()).domain("APNS").memberId(tmsResponse.getMemberId()).memberIdSeq(tmsResponse.getMemberIdSeq()).errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).schdId(tmsResponse.getSchdId()).sendId(tmsResponse.getSendId()).targetSeq(tmsResponse.getTargetSeq()).workday(tmsResponse.getWorkday()).siteId(tmsResponse.getSiteID()).startDate(tmsResponse.getStartDate()).endDate(tmsResponse.getStartDate()).build();
            this.commonConfig.getWrapperRedisTemplate().hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
        }
        catch (Exception e) {
            log.error("Error Process Error targetMemberId :{}, ErrorMsg :{} ", new Object[]{tmsResponse.getMemberId(), tmsResponse.getMemberId(), tmsResponse.getDetail(), e});
        }
    }
}

