/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P12Util {
    private static final Logger log = LoggerFactory.getLogger(P12Util.class);

    public static KeyStore.PrivateKeyEntry getFirstPrivateKeyEntryFromP12InputStream(InputStream p12InputStream, String password) throws KeyStoreException, IOException {
        Objects.requireNonNull(password, "Password may be blank, but must not be null.");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try {
            keyStore.load(p12InputStream, password.toCharArray());
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
        Enumeration<String> aliases = keyStore.aliases();
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(password.toCharArray());
        while (aliases.hasMoreElements()) {
            KeyStore.Entry entry;
            String alias = aliases.nextElement();
            try {
                try {
                    entry = keyStore.getEntry(alias, passwordProtection);
                }
                catch (UnsupportedOperationException e) {
                    entry = keyStore.getEntry(alias, null);
                }
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new KeyStoreException(e);
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
            return (KeyStore.PrivateKeyEntry)entry;
        }
        throw new KeyStoreException("Key store did not contain any private key entries.");
    }

    public static String getTopicName(String pushCert, String password) {
        HashMap<String, String> subjectMap = new HashMap<String, String>();
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            p12.load(new FileInputStream(pushCert), password.toCharArray());
            Enumeration<String> e = p12.aliases();
            while (e.hasMoreElements()) {
                String[] subjectArray;
                String alias = e.nextElement();
                X509Certificate c = (X509Certificate)p12.getCertificate(alias);
                Principal subject = c.getSubjectDN();
                for (String s : subjectArray = subject.toString().split(",")) {
                    String[] str = s.trim().split("=");
                    subjectMap.put(str[0], str[1]);
                }
            }
        }
        catch (KeyStoreException e1) {
            log.error("KeyStoreException", (Throwable)e1);
        }
        catch (NoSuchAlgorithmException e1) {
            log.error("NoSuchAlgorithmException", (Throwable)e1);
        }
        catch (CertificateException e1) {
            log.error("CertificateException", (Throwable)e1);
        }
        catch (FileNotFoundException e1) {
            log.error("FileNotFoundException", (Throwable)e1);
        }
        catch (IOException e1) {
            log.error("IOException", (Throwable)e1);
        }
        return (String)subjectMap.get("UID");
    }
}

