/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsUtil {
    private static final Logger log = LoggerFactory.getLogger(ApnsUtil.class);

    public static String getTopicName(String pushCert, String password) {
        try {
            return ApnsUtil.getTopicName(new FileInputStream(pushCert), password);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException [pushCert:{}]", (Object)pushCert);
            return null;
        }
    }

    public static String getTopicName(byte[] pushCert, String password) {
        return ApnsUtil.getTopicName(new ByteArrayInputStream(pushCert), password);
    }

    public static String getTopicName(InputStream p12InputStream, String password) {
        HashMap<String, String> subjectMap = new HashMap<String, String>();
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            p12.load(p12InputStream, password.toCharArray());
            Enumeration<String> e = p12.aliases();
            while (e.hasMoreElements()) {
                String[] subjectArray;
                String alias = e.nextElement();
                X509Certificate c = (X509Certificate)p12.getCertificate(alias);
                Principal subject = c.getSubjectDN();
                for (String s : subjectArray = subject.toString().split(",")) {
                    String[] str = s.trim().split("=");
                    if (!str[0].trim().equals("UID")) continue;
                    subjectMap.put(str[0].trim(), str[1].trim());
                }
            }
        }
        catch (KeyStoreException e1) {
            log.error("KeyStoreException", (Throwable)e1);
        }
        catch (NoSuchAlgorithmException e1) {
            log.error("NoSuchAlgorithmException", (Throwable)e1);
        }
        catch (CertificateException e1) {
            log.error("CertificateException", (Throwable)e1);
        }
        catch (FileNotFoundException e1) {
            log.error("FileNotFoundException", (Throwable)e1);
        }
        catch (IOException e1) {
            log.error("IOException", (Throwable)e1);
        }
        return (String)subjectMap.get("UID");
    }

    public static String makeImgParams(String richImg) {
        String[] richImgArray;
        if (richImg == null) {
            return "";
        }
        JSONObject imgParamJson = new JSONObject();
        ArrayList<String> imgList = new ArrayList<String>();
        for (String imgUrl : richImgArray = richImg.split(",")) {
            imgList.add(imgUrl);
        }
        imgParamJson.put((Object)"img", imgList);
        return imgParamJson.toJSONString();
    }

    public static Date getInvalidationTime(int ttl) {
        long ttlmillisecs = System.currentTimeMillis() + (long)(ttl * 1000);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ttlmillisecs);
        return calendar.getTime();
    }
}

