/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.push.AbstractConnection;
import com.humuson.tms.sender.push.PushResultListener;
import com.humuson.tms.sender.push.apns.actor.ApnsConfiguration;
import java.util.UUID;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ApnsConnection
extends AbstractConnection<SimpleApnsPushNotification, ApnsClient> {
    private static final Logger log = LoggerFactory.getLogger(ApnsConnection.class);
    final ApnsConfiguration configuration;
    TmsSenderCommonConfig commonConfig;

    public ApnsConnection(TmsSenderCommonConfig commonConfig, ApnsConfiguration configuration, PushResultListener listener) throws SSLException {
        super(configuration.getTopicName(), configuration.getPassword(), listener);
        this.commonConfig = commonConfig;
        this.configuration = configuration;
        this.connection = configuration.getConfiguration().build();
    }

    @Override
    public void connect() throws Exception {
        this.connectionDraining = false;
        this.connected = true;
    }

    @Override
    public void login() throws Exception {
        this.authenticated = true;
    }

    @Override
    public boolean sendPacket(SimpleApnsPushNotification pushNotification) {
        if (this.connectionDraining.booleanValue()) {
            log.info("APNS connection is draining ...");
            return false;
        }
        PushNotificationFuture sendNotificationFuture = ((ApnsClient)this.connection).sendNotification((ApnsPushNotification)pushNotification);
        sendNotificationFuture.whenComplete((response, cause) -> {
            if (response != null) {
                String rejectionReason = response.getRejectionReason();
                String messageId = ((SimpleApnsPushNotification)response.getPushNotification()).getCollapseId();
                UUID notificationUUID = ((SimpleApnsPushNotification)response.getPushNotification()).getApnsId();
                if (StringUtils.isEmpty((Object)rejectionReason)) {
                    log.info("APNS success token:{}, collapseId:{}, uuid:{}", new Object[]{((SimpleApnsPushNotification)response.getPushNotification()).getToken(), messageId, notificationUUID});
                    this.processSuccessful("TMS0", messageId);
                } else {
                    log.error("APNS error messageId:{}, rejectionReason:{}, uuid:{}", new Object[]{messageId, rejectionReason, notificationUUID});
                    this.processError(rejectionReason, messageId);
                }
            } else {
                log.error(cause.getMessage(), cause);
            }
        });
        return true;
    }

    @Override
    public String sendSyncPacket(SimpleApnsPushNotification pushNotification) {
        try {
            log.info("pushNotification :{}", (Object)pushNotification.toString());
            PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)((ApnsClient)this.connection).sendNotification((ApnsPushNotification)pushNotification).get();
            String rejectionReason = pushNotificationResponse.getRejectionReason();
            if (StringUtils.isEmpty((Object)rejectionReason)) {
                log.info("APNS success token:{}, collapseId(msgUid):{}", (Object)((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getToken(), (Object)pushNotification.getCollapseId());
                return "TMS0";
            }
            log.info("APNS fail :{}, token:{}, collapseId(msgUid):{}", new Object[]{rejectionReason, ((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getToken(), pushNotification.getCollapseId()});
            return rejectionReason;
        }
        catch (Exception e) {
            log.error("apns unknown error", (Throwable)e);
            return "TMS9";
        }
    }

    @Override
    public void close() {
        do {
            log.info("pending message is not empty... sleep 2 seconds");
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!this.connectionPendingMessages.isEmpty());
        ((ApnsClient)this.connection).close();
    }
}

