/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.apns.actor;

import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsClientMetricsListener;
import com.humuson.tms.crypto.SSLChecker;
import com.humuson.tms.sender.push.apns.actor.ApnsUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ApnsConfiguration.class);
    final ApnsClientBuilder configuration;
    private String username;
    private String password;
    private String topicName;
    private byte[] pushCert;
    private int defaultConcurrentConnections = 3;
    private boolean isProduct = true;
    private boolean isExpired = false;

    public ApnsConfiguration(byte[] certByte, String username, String password) throws Exception {
        this.username = username;
        this.password = password;
        this.pushCert = certByte;
        this.topicName = ApnsUtil.getTopicName(this.pushCert, password);
        this.isProduct = SSLChecker.isProduction((byte[])this.pushCert, (String)password);
        boolean isValidPassword = SSLChecker.isValidPassword((byte[])this.pushCert, (String)password);
        log.debug("isValid password : {}", (Object)isValidPassword);
        this.isExpired = SSLChecker.isExpired((InputStream)new ByteArrayInputStream(this.pushCert), (String)password);
        log.debug("isExpired : {}", (Object)this.isExpired);
        log.debug("isProduct : {}", (Object)this.isProduct);
        this.configuration = new ApnsClientBuilder();
        this.configuration.setGracefulShutdownTimeout(Duration.ofSeconds(10L)).setApnsServer(this.isProduct ? "api.push.apple.com" : "api.sandbox.push.apple.com").setIdlePingInterval(Duration.ofSeconds(100L)).setClientCredentials((InputStream)new ByteArrayInputStream(certByte), password);
        this.setConcurrentConnections(this.defaultConcurrentConnections);
    }

    public void setConcurrentConnections(int concurrentConnections) {
        this.configuration.setConcurrentConnections(concurrentConnections);
    }

    public void setMetricsListener(ApnsClientMetricsListener listener) {
        this.configuration.setMetricsListener(listener);
    }

    public ApnsClientBuilder getConfiguration() {
        return this.configuration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public byte[] getPushCert() {
        return this.pushCert;
    }

    public int getDefaultConcurrentConnections() {
        return this.defaultConcurrentConnections;
    }

    public boolean isProduct() {
        return this.isProduct;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setPushCert(byte[] pushCert) {
        this.pushCert = pushCert;
    }

    public void setDefaultConcurrentConnections(int defaultConcurrentConnections) {
        this.defaultConcurrentConnections = defaultConcurrentConnections;
    }

    public void setProduct(boolean isProduct) {
        this.isProduct = isProduct;
    }

    public void setExpired(boolean isExpired) {
        this.isExpired = isExpired;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApnsConfiguration)) {
            return false;
        }
        ApnsConfiguration other = (ApnsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApnsClientBuilder this$configuration = this.getConfiguration();
        ApnsClientBuilder other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        if (!Arrays.equals(this.getPushCert(), other.getPushCert())) {
            return false;
        }
        if (this.getDefaultConcurrentConnections() != other.getDefaultConcurrentConnections()) {
            return false;
        }
        if (this.isProduct() != other.isProduct()) {
            return false;
        }
        return this.isExpired() == other.isExpired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApnsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApnsClientBuilder $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 0 : $configuration.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 0 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 0 : $password.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 0 : $topicName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPushCert());
        result = result * 59 + this.getDefaultConcurrentConnections();
        result = result * 59 + (this.isProduct() ? 79 : 97);
        result = result * 59 + (this.isExpired() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ApnsConfiguration(configuration=" + this.getConfiguration() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", topicName=" + this.getTopicName() + ", pushCert=" + Arrays.toString(this.getPushCert()) + ", defaultConcurrentConnections=" + this.getDefaultConcurrentConnections() + ", isProduct=" + this.isProduct() + ", isExpired=" + this.isExpired() + ")";
    }
}

