/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackOffStrategy {
    private static final Logger log = LoggerFactory.getLogger(BackOffStrategy.class);
    public static final int DEFAULT_RETRIES = 3;
    public static final long DEFAULT_WAIT_TIME_IN_MILLI = 1000L;
    private int numberOfRetries;
    private int numberOfTriesLeft;
    private long defaultTimeToWait;
    private long timeToWait;
    private Random random = new Random();

    public BackOffStrategy() {
        this(3, 1000L);
    }

    public BackOffStrategy(int numberOfRetries, long defaultTimeToWait) {
        this.numberOfRetries = numberOfRetries;
        this.numberOfTriesLeft = numberOfRetries;
        this.defaultTimeToWait = defaultTimeToWait;
        this.timeToWait = defaultTimeToWait;
    }

    public boolean shouldRetry() {
        return this.numberOfTriesLeft > 0;
    }

    public void errorOccured2() throws Exception {
        --this.numberOfTriesLeft;
        if (!this.shouldRetry()) {
            throw new Exception("Retry Failed: Total of attempts: " + this.numberOfRetries + ". Total waited time: " + this.timeToWait + "ms.");
        }
        this.waitUntilNextTry();
        this.timeToWait *= 2L;
        this.timeToWait += (long)this.random.nextInt(500);
    }

    public void errorOccured() {
        --this.numberOfTriesLeft;
        if (!this.shouldRetry()) {
            log.info("Retry Failed: Total of attempts: " + this.numberOfRetries + ". Total waited time: " + this.timeToWait + "ms.");
        }
        this.waitUntilNextTry();
        this.timeToWait *= 2L;
        this.timeToWait += (long)this.random.nextInt(500);
    }

    private void waitUntilNextTry() {
        try {
            Thread.sleep(this.timeToWait);
        }
        catch (InterruptedException e) {
            log.error("Error waiting until next try for the backoff strategy.", (Throwable)e);
        }
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    public void doNotRetry() {
        this.numberOfTriesLeft = 0;
    }

    public void reset() {
        this.numberOfTriesLeft = this.numberOfRetries;
        this.timeToWait = this.defaultTimeToWait;
    }
}

