/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push;

import com.humuson.tms.sender.push.BackOffStrategy;
import com.humuson.tms.sender.push.PushResultListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection<T, R>
implements PushResultListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnection.class);
    protected final Map<String, T> connectionPendingMessages = new ConcurrentHashMap<String, T>();
    protected R connection;
    protected PushResultListener listener = null;
    protected volatile String username;
    protected volatile String password;
    protected volatile Boolean connectionDraining = false;
    protected volatile Boolean connected = false;
    protected volatile Boolean authenticated = false;
    protected String sessionId;
    protected String connectionId;
    protected volatile int threadCount = 1;

    public AbstractConnection(String username, String password, PushResultListener listener) {
        this.username = username;
        this.password = password;
        this.listener = listener;
    }

    public abstract void connect() throws Exception;

    public abstract void login() throws Exception;

    public abstract void close();

    public boolean sendPacket(String messageId, T payload) {
        if (!this.connectionDraining.booleanValue()) {
            log.info("payload : {}", (Object)payload.toString());
            this.connectionPendingMessages.put(messageId, payload);
            return this.sendPacket(payload);
        }
        return false;
    }

    public String sendSyncPacket(String messageId, T payload) {
        this.connectionPendingMessages.put(messageId, payload);
        return this.sendSyncPacket(payload);
    }

    public abstract boolean sendPacket(T var1);

    public abstract String sendSyncPacket(T var1);

    @Override
    public void processSuccessful(String response, String messageId) {
        this.removeMessageFromPendingMessages(messageId);
        if (this.listener != null) {
            this.listener.processSuccessful(response, messageId);
        }
    }

    @Override
    public void processError(String response, String messageId) {
        this.removeMessageFromPendingMessages(messageId);
        if (this.listener != null) {
            this.listener.processError(response, messageId);
        }
    }

    protected void resendPendingMessages() {
        log.info("Sending pending messages through the new connection");
        log.info("Pending messages size: {}", (Object)this.connectionPendingMessages.size());
        HashMap<String, T> messagesToResend = new HashMap<String, T>(this.connectionPendingMessages);
        for (Map.Entry message : messagesToResend.entrySet()) {
            this.sendPacket((String)message.getKey(), message.getValue());
        }
    }

    public synchronized void reconnect(boolean isPenddingMsgResend) {
        log.info("Initiating reconnection ...");
        BackOffStrategy backoff = new BackOffStrategy(5, 1000L);
        while (backoff.shouldRetry()) {
            try {
                this.connect();
                if (isPenddingMsgResend) {
                    this.resendPendingMessages();
                }
                backoff.doNotRetry();
            }
            catch (Exception e) {
                log.error("The notifier server could not reconnect after the connection draining message");
                backoff.errorOccured();
            }
        }
    }

    protected void removeMessageFromPendingMessages(String messageId) {
        if (messageId != null) {
            this.connectionPendingMessages.remove(messageId);
        }
    }

    public Boolean getConnectionDraining() {
        return this.connectionDraining;
    }

    public Boolean getConnected() {
        return this.connected;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }
}

