/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.monitor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.util.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TmsCheckScheduler {
    private static final Logger log = LoggerFactory.getLogger(TmsCheckScheduler.class);
    @Value(value="${tms.daemon-type:SD}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Value(value="${tms.sender.memory-check.max-percent:80}")
    private int memoryMaxPercent;
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    DecimalFormat df = new DecimalFormat("#0");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.sender.monitor.check-interval:30000}")
    public void schedule() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        String smemUsed = this.df.format((double)memUsage.getUsed() / 1048576.0);
        String smemMax = this.df.format((double)memUsage.getMax() / 1048576.0);
        String[] dates = DateUtil.getDivideDateDefault();
        String key = "JSTAT".concat(":").concat(this.daemonType);
        String field = this.daemonId + ":" + dates[0];
        String oldValue = "";
        try {
            oldValue = this.wrapperRedisTemplate.hmget(key, field);
            oldValue = oldValue == null || oldValue.trim().isEmpty() ? "" : oldValue + "|";
            log.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{key, field, dates[1], smemMax, smemUsed});
            this.wrapperRedisTemplate.hmset(key, field, oldValue + dates[1] + ":" + smemMax + ":" + smemUsed);
        }
        catch (Exception e) {
            log.error("[ERROR] JSTAT Update:{}", (Object)e.toString());
        }
        finally {
            this.wrapperRedisTemplate.close();
            memoryMxBean = null;
            memUsage = null;
            smemUsed = null;
            smemMax = null;
            dates = null;
            key = null;
            field = null;
        }
    }

    @Scheduled(fixedDelayString="${tms.sender.memory-check.critical-intrval:10000}")
    public void scheduleCheckCritical() {
        if (this.isCheckMemory()) {
            try {
                System.gc();
            }
            catch (Exception e) {
                log.debug("[ERROR] GARBAGE colloertor has an error : {} ", (Object)e.getMessage());
            }
            log.info("Using Memroy Critical Over. Performed GC.");
        }
    }

    public boolean isCheckMemory() {
        boolean res = false;
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String useMemory = df.format((double)memUsage.getUsed() / 1048576.0);
        String totalMemory = df.format((double)memUsage.getMax() / 1048576.0);
        int usePercent = (int)(Double.parseDouble(useMemory) / Double.parseDouble(totalMemory) * 100.0);
        log.info("[CheckMemory] totalMemory:{}/useMemory:{} / criticalPercent:{} %/ usePercent:{} %", new Object[]{totalMemory, useMemory, this.memoryMaxPercent, usePercent});
        if (usePercent >= this.memoryMaxPercent) {
            res = true;
        }
        return res;
    }
}

