/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.mail.actor;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsMailConfig;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.mail.model.TmsEmailVo;
import com.humuson.tms.sender.smtp.NioClientChannelHandler;
import com.humuson.tms.sender.smtp.NioClientChannelInitializer;
import com.humuson.tms.sender.smtp.SmtpConnection;
import com.humuson.tms.sender.smtp.SmtpResponseFuture;
import com.humuson.tms.sender.smtp.TmsDefaultSmtpResponse;
import com.humuson.tms.util.FileUtil;
import com.humuson.tms.util.date.DateUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.smtp.DefaultLastSmtpContent;
import io.netty.handler.codec.smtp.DefaultSmtpContent;
import io.netty.handler.codec.smtp.SmtpRequest;
import io.netty.handler.codec.smtp.SmtpRequests;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TmsMailSenderActor
extends SmtpConnection
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsMailSenderActor.class);
    public static final int DEFAULT_PORT = 25;
    public static final int DEFAULT_TIME_OUT = 1000;
    public static final String DEFAULT_LOCALHOST = "localhost";
    public static final String CRLF = "\r\n";
    private TmsSenderCommonConfig tmsCommonConfig;
    private int retryCnt = 0;
    private EventLoopGroup eventLoopGroup;
    private Bootstrap bootstrap;
    private Channel ch;
    private TmsDefaultSmtpResponse response;
    private TmsMailConfig mailConfig;
    private final boolean relay;

    public TmsMailSenderActor(TmsSenderCommonConfig tmsCommonConfig, EventLoopGroup eventLoopGroup) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.eventLoopGroup = eventLoopGroup;
        this.mailConfig = tmsCommonConfig.getTmsMailConfig();
        this.relay = this.mailConfig.getRelayEnable().trim().equalsIgnoreCase("true");
        log.info("[event group RELAY SENDING IS {} ]", (Object)this.relay);
        System.out.println("event group RELAY SENDING IS " + this.relay);
    }

    public TmsMailSenderActor(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.mailConfig = tmsCommonConfig.getTmsMailConfig();
        this.relay = this.mailConfig.getRelayEnable().trim().equalsIgnoreCase("true");
        log.info("[RELAY SENDING IS {} ]", (Object)this.relay);
        System.out.println("RELAY SENDING IS " + this.relay);
    }

    public Channel getChannel() {
        return this.ch;
    }

    public String createContent(TmsEmailVo tmsEmailVo, String lang) throws Exception {
        String content = null;
        try {
            content = tmsEmailVo.isCheckContentUrlYn() ? SenderUtil.getContent(tmsEmailVo.getContentUrl(), lang) : FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
        }
        catch (IOException e) {
            try {
                content = FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
            }
            catch (Exception e2) {
                content = SenderUtil.getContent(tmsEmailVo.getContentUrl(), lang);
            }
        }
        catch (Exception e) {
            log.error("read content Url or File error {}", (Object)e.toString());
            throw e;
        }
        if (content == null || content.trim().isEmpty()) {
            log.error("This Content is Empty. Url : [{}], path : [{}]", (Object)tmsEmailVo.getContentUrl(), (Object)tmsEmailVo.getContentPath());
            throw new Exception("This Content is Empty. Url : [" + tmsEmailVo.getContentUrl() + "], path : [" + tmsEmailVo.getContentPath() + "]");
        }
        content = content.replaceAll("@TMS_M_TARGET@", tmsEmailVo.getTmsMEmail());
        return content;
    }

    public TmsEmailVo createMailVo(JSONObject targetData, TMSCommonPInfo pinfo) throws JSONException {
        TmsEmailVo tmsEmailVo = new TmsEmailVo();
        try {
            tmsEmailVo.setStartData(DateUtil.getFullDate((String)"yyyyMMddHH24mmss"));
            tmsEmailVo.setMemberId(targetData.getString("TMS_M_ID"));
            tmsEmailVo.setMemberIdSeq(targetData.getString("UNIQUE_SEQ"));
            tmsEmailVo.setTmsMEmail(targetData.getString("TMS_M_TARGET"));
            tmsEmailVo.setDomain(targetData.getString("DOMAIN"));
            tmsEmailVo.setFromEmail(pinfo.getFromEmail());
            tmsEmailVo.setHost(targetData.getString("host"));
            if (targetData.has("FULL_CONTENT_URL")) {
                tmsEmailVo.setContentUrl(targetData.getString("FULL_CONTENT_URL"));
                tmsEmailVo.setCheckContentUrlYn(true);
            }
            if (targetData.has("FULL_CONTENT_PATH")) {
                tmsEmailVo.setContentPath(targetData.getString("FULL_CONTENT_PATH"));
            }
        }
        catch (JSONException e) {
            log.error("JSON parsing Error {}", (Throwable)e);
            throw new JSONException("[createMailVo] target Data parsing Error ");
        }
        return tmsEmailVo;
    }

    public void sendInit(String host, int timeOut) throws InterruptedException, ExecutionException, TimeoutException {
        final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
        this.ch = this.bootstrap.connect((SocketAddress)new InetSocketAddress(host, 25)).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                } else {
                    future.channel().disconnect();
                }
            }
        }).channel();
        TmsDefaultSmtpResponse tmsSmtpresponce = (TmsDefaultSmtpResponse)smtpResponseFuture.get(timeOut, TimeUnit.MILLISECONDS);
        tmsSmtpresponce.setReturnCode("INIT");
        this.response = tmsSmtpresponce;
    }

    public void sendMessage(SmtpRequest smtpRequest, String type, int timeOut) throws InterruptedException, ExecutionException, TimeoutException {
        this.sendMessage(smtpRequest, type, timeOut, true);
    }

    public void sendMessage(SmtpRequest smtpRequest, String type, int timeOut, boolean isResult) throws InterruptedException, ExecutionException, TimeoutException {
        final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
        this.ch.writeAndFlush((Object)smtpRequest).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                } else {
                    future.channel().disconnect();
                }
            }
        });
        TmsDefaultSmtpResponse tmsSmtpresponce = (TmsDefaultSmtpResponse)smtpResponseFuture.get(timeOut, TimeUnit.MILLISECONDS);
        tmsSmtpresponce.setReturnCode(type);
        if (isResult) {
            this.response = tmsSmtpresponce;
        }
    }

    public void sendMessage(DefaultSmtpContent content, String type, int timeOut) throws InterruptedException, ExecutionException, TimeoutException {
        final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
        this.ch.writeAndFlush((Object)content).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                } else {
                    future.channel().disconnect();
                }
            }
        });
        if (!StringUtils.isEmpty((Object)type)) {
            TmsDefaultSmtpResponse tmsSmtpresponce = (TmsDefaultSmtpResponse)smtpResponseFuture.get(timeOut, TimeUnit.MILLISECONDS);
            tmsSmtpresponce.setReturnCode(type);
            this.response = tmsSmtpresponce;
        }
    }

    public void connectTargetDomain(EventLoopGroup event, String localhost, int port) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(event);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new NioClientChannelInitializer());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        bootstrap.bind(localhost, port);
        this.bootstrap = bootstrap;
    }

    public Bootstrap getConnectTargetDomain(EventLoopGroup event, String localhost, int port) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(event);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new NioClientChannelInitializer());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        bootstrap.bind(localhost, port);
        return bootstrap;
    }

    public Channel createConnection(String host) throws InterruptedException {
        Channel channel = null;
        Bootstrap bootstrap = super.connectTargetDomain(this.eventLoopGroup);
        channel = bootstrap.connect(host, 25).sync().channel();
        return channel;
    }

    public TmsResponse targetSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) throws Exception {
        ++this.retryCnt;
        return this.targetDataSendToServer(targetData, pinfo, chinfo);
    }

    public boolean checkChannelStatus() {
        return this.ch.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse mailResponse;
        block46: {
            String error = null;
            String resultCode = null;
            mailResponse = null;
            String action = "";
            String localhost = DEFAULT_LOCALHOST;
            String nicIp = null;
            Object logDetail = null;
            if (!this.tmsCommonConfig.getTmsMailConfig().getLocalhost().isEmpty()) {
                localhost = this.tmsCommonConfig.getTmsMailConfig().getLocalhost();
                nicIp = this.tmsCommonConfig.getTmsMailConfig().getNicIp();
            }
            if (nicIp == null) {
                nicIp = localhost;
            }
            SenderUtil.init();
            TmsEmailVo tmsEmailVo = this.createMailVo(targetData, pinfo);
            mailResponse = new TmsResponse(targetData.getString("TMS_M_ID"), targetData.getString("UNIQUE_SEQ"), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
            String content = this.createContent(tmsEmailVo, pinfo.getNlsLang());
            mailResponse.setContentSize(content.getBytes().length);
            this.connectTargetDomain(this.eventLoopGroup, nicIp, 25);
            if (this.relay) {
                System.out.println("[[[Relay Sending Host is]]]=" + this.mailConfig.getRelayDomain());
                this.sendInit(this.mailConfig.getRelayDomain(), 10000);
            } else {
                System.out.println("[[[Direct Sending Host is]]]=" + tmsEmailVo.getHost());
                log.info("Direct Sending Host is={}", (Object)tmsEmailVo.getHost());
                this.sendInit(tmsEmailVo.getHost(), 10000);
            }
            action = "sendInit";
            if (this.response.code() == 220 && this.checkChannelStatus()) {
                action = "MAIL_HELO";
                this.sendMessage(SmtpRequests.helo((CharSequence)localhost), "HELO", 30000);
            }
            if (this.response.code() == 250 && this.response.getReturnCode().equals("HELO") && this.checkChannelStatus()) {
                action = "MAIL_FROM";
                this.sendMessage(SmtpRequests.mail((CharSequence)tmsEmailVo.getFromEmail(), (CharSequence[])new CharSequence[0]), "MAILFROM", 30000);
            }
            if (this.response.code() == 250 && this.response.getReturnCode().equals("MAILFROM") && this.checkChannelStatus()) {
                action = "MAIL_RCPT";
                this.sendMessage(SmtpRequests.rcpt((CharSequence)tmsEmailVo.getTmsMEmail(), (CharSequence[])new CharSequence[0]), "RCPT", 30000);
            }
            if (this.response.code() == 250 && this.response.getReturnCode().equals("RCPT") && this.checkChannelStatus()) {
                action = "MAIL_DATA_INIT";
                this.sendMessage(SmtpRequests.data(), "DATA", 30000);
            }
            if (this.response.code() == 354 && this.response.getReturnCode().equals("DATA") && this.checkChannelStatus()) {
                action = "MAIL_DATA_BODY";
                this.sendMessage(new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8)), null, 30000);
                this.sendMessage((DefaultSmtpContent)new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)CRLF, (Charset)CharsetUtil.UTF_8)), "DATABODY", 30000);
            }
            if (this.response.code() == 250 && this.response.getReturnCode().equals("DATABODY") && this.checkChannelStatus()) {
                action = "MAIL_QUIT";
                this.sendMessage(SmtpRequests.quit(), "QUIT", 10000, false);
            }
            if (StringUtils.isEmpty((Object)this.response)) {
                if (!this.checkChannelStatus()) {
                    throw new Exception(this.createConnectionErrorMsg(nicIp, tmsEmailVo.getHost(), "connection fail"));
                }
                throw new Exception(this.createConnectionErrorMsg(nicIp, tmsEmailVo.getHost(), "no response"));
            }
            resultCode = this.response.getReturnCode().concat(".").concat(String.valueOf(this.response.code())).concat(".").concat(tmsEmailVo.getDomain());
            error = this.response.details().toString();
            try {
                if (this.ch != null && this.ch.isActive()) {
                    this.ch.close().sync();
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (mailResponse == null) {
                String mId = null;
                String uniqueSeq = null;
                try {
                    mId = targetData.getString("TMS_M_ID");
                    uniqueSeq = targetData.getString("UNIQUE_SEQ");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (mId != null && uniqueSeq != null) {
                    mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                }
            }
            mailResponse.setCode(resultCode);
            mailResponse.setDetail(error);
            mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            break block46;
            catch (TimeoutException e) {
                log.debug("mail send action:{}, [error] : {}", (Object)action, (Object)e.toString());
                error = e.toString() + ", action:" + action;
                resultCode = "TMS4";
                try {
                    if (this.ch != null && this.ch.isActive()) {
                        this.ch.close().sync();
                    }
                }
                catch (InterruptedException e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                if (mailResponse == null) {
                    String mId = null;
                    String uniqueSeq = null;
                    try {
                        mId = targetData.getString("TMS_M_ID");
                        uniqueSeq = targetData.getString("UNIQUE_SEQ");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (mId != null && uniqueSeq != null) {
                        mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                    }
                }
                mailResponse.setCode(resultCode);
                mailResponse.setDetail(error);
                mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            }
            catch (Exception e2) {
                log.debug("mail send action:{}, [error] : {}", (Object)action, (Object)e2.toString());
                error = e2.toString();
                resultCode = "TMS9";
                {
                    catch (Throwable throwable) {
                        try {
                            if (this.ch != null && this.ch.isActive()) {
                                this.ch.close().sync();
                            }
                        }
                        catch (InterruptedException e3) {
                            log.error(e3.getMessage(), (Throwable)e3);
                            Thread.currentThread().interrupt();
                        }
                        if (mailResponse == null) {
                            String mId = null;
                            String uniqueSeq = null;
                            try {
                                mId = targetData.getString("TMS_M_ID");
                                uniqueSeq = targetData.getString("UNIQUE_SEQ");
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                            if (mId != null && uniqueSeq != null) {
                                mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                            }
                        }
                        mailResponse.setCode(resultCode);
                        mailResponse.setDetail(error);
                        mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                        throw throwable;
                    }
                }
                try {
                    if (this.ch != null && this.ch.isActive()) {
                        this.ch.close().sync();
                    }
                }
                catch (InterruptedException e4) {
                    log.error(e4.getMessage(), (Throwable)e4);
                    Thread.currentThread().interrupt();
                }
                if (mailResponse == null) {
                    String mId = null;
                    String uniqueSeq = null;
                    try {
                        mId = targetData.getString("TMS_M_ID");
                        uniqueSeq = targetData.getString("UNIQUE_SEQ");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (mId != null && uniqueSeq != null) {
                        mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                    }
                }
                mailResponse.setCode(resultCode);
                mailResponse.setDetail(error);
                mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            }
        }
        return mailResponse;
    }

    public String createConnectionErrorMsg(String nic, String host, String cause) {
        StringBuffer strb = new StringBuffer();
        strb.append("[ERROR][");
        strb.append(nic);
        strb.append(" => ");
        strb.append(host);
        strb.append("] channel con error : ");
        strb.append(cause);
        return strb.toString();
    }

    public boolean checkError(int errorCode) {
        switch (errorCode) {
            case 214: {
                return false;
            }
            case 220: {
                return false;
            }
            case 221: {
                return false;
            }
            case 250: {
                return false;
            }
            case 354: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public boolean closeConnection(Channel ch) {
        if (ch != null) {
            ch.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ArrayList<TmsResponse> resultList = new ArrayList();
        try {
            String error;
            String localhost = DEFAULT_LOCALHOST;
            String nicIp = null;
            Object logDetail = null;
            if (!this.tmsCommonConfig.getTmsMailConfig().getLocalhost().isEmpty()) {
                localhost = this.tmsCommonConfig.getTmsMailConfig().getLocalhost();
                nicIp = this.tmsCommonConfig.getTmsMailConfig().getNicIp();
            }
            if (nicIp == null) {
                nicIp = localhost;
            }
            System.out.println(">>>>>>>>>>>>>>>>>>>>> targetDataListSendToServer() <<<<<<<<<<<<<<<<<<<<<<<<<<<");
            log.info("[Bulk][START] domain:{}, host:{}, size:{} , sendId:{}, schdId:{}, targetSeq:{} ===============================", new Object[]{chinfo.getDomain(), chinfo.getHost(), targetList.size(), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq()});
            Bootstrap bootstrap = this.getConnectTargetDomain(this.eventLoopGroup, nicIp, 25);
            final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
            TmsDefaultSmtpResponse responseInit = (TmsDefaultSmtpResponse)smtpResponseFuture.get(10000L, TimeUnit.MILLISECONDS);
            responseInit.setReturnCode("INIT");
            for (int i = 0; i < targetList.size(); ++i) {
                String uniqueSeq;
                String mId;
                String action;
                TmsResponse mailResponse;
                String resultCode;
                JSONObject targetData;
                block47: {
                    targetData = targetList.get(i);
                    error = null;
                    resultCode = null;
                    mailResponse = null;
                    action = "sendInit";
                    targetData.put("host", (Object)chinfo.getHost());
                    TmsDefaultSmtpResponse response = null;
                    SenderUtil.init();
                    TmsEmailVo tmsEmailVo = this.createMailVo(targetData, pinfo);
                    mailResponse = new TmsResponse(targetData.getString("TMS_M_ID"), targetData.getString("UNIQUE_SEQ"), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                    String content = this.createContent(tmsEmailVo, pinfo.getNlsLang());
                    mailResponse.setContentSize(content.getBytes().length);
                    log.info("SYNC bulk email tmsEmailVo.TMS_M_ID:{}, TMS_M_TARGET:{}, contentSize:{}", new Object[]{tmsEmailVo.getMemberId(), tmsEmailVo.getTmsMEmail(), mailResponse.getContentSize()});
                    log.info("mail send [init][response] : {}", response);
                    if (this.ch.isActive()) {
                        action = "helo";
                        this.ch.writeAndFlush((Object)SmtpRequests.helo((CharSequence)localhost)).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                    }
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    log.info("mail send [helo][response] : {}", (Object)response);
                    response.setReturnCode("HELO");
                    if (this.checkError(response.code())) {
                        this.ch.writeAndFlush((Object)SmtpRequests.quit()).sync();
                    } else {
                        action = "MAIL_FROM";
                        this.ch.writeAndFlush((Object)SmtpRequests.mail((CharSequence)tmsEmailVo.getFromEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                        response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                        response.setReturnCode("MAILFROM");
                        log.info("mail send [mail][response] : {}", (Object)response);
                        action = "MAIL_RCPT";
                        this.ch.writeAndFlush((Object)SmtpRequests.rcpt((CharSequence)tmsEmailVo.getTmsMEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                        response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                        response.setReturnCode("RCPT");
                        log.info("mail send [rcpt][response] : {}", (Object)response);
                    }
                    if (this.checkError(response.code())) {
                        this.ch.writeAndFlush((Object)SmtpRequests.quit()).sync();
                    } else {
                        action = "MAIL_DATA_INIT";
                        this.ch.writeAndFlush((Object)SmtpRequests.data()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                        response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                        response.setReturnCode("DATA");
                        log.info("mail send [data][response] : {}", (Object)response);
                        action = "data";
                        this.ch.writeAndFlush((Object)new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly().sync();
                        log.info("mail send [content][response] : {}", (Object)response);
                        action = "MAIL_LAST_DATA";
                        this.ch.writeAndFlush((Object)new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)CRLF, (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                        response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                        response.setReturnCode("DATABODY");
                        log.info("mail send [databody][response] : {}", (Object)response);
                    }
                    if (this.checkError(response.code())) {
                        this.ch.writeAndFlush((Object)SmtpRequests.quit()).sync();
                    } else {
                        action = "RSET";
                        this.ch.writeAndFlush((Object)SmtpRequests.rset()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                            }
                        });
                        response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(10000L, TimeUnit.MILLISECONDS);
                        response.setReturnCode("RSET");
                        log.info("mail send [rset][response] : {}", (Object)response);
                    }
                    if (mailResponse != null) break block47;
                    mId = null;
                    uniqueSeq = null;
                    try {
                        mId = targetData.getString("TMS_M_ID");
                        uniqueSeq = targetData.getString("UNIQUE_SEQ");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (mId != null && uniqueSeq != null) {
                        mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                    }
                }
                mailResponse.setCode(resultCode);
                mailResponse.setDetail(error);
                mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                log.info("MAIL SEND RESULT][BULK] host:{}, usingBulk:true, contentSize:{}, index:{}, {}", new Object[]{chinfo.getHost(), mailResponse.getContentSize(), i, mailResponse.toString()});
                resultList.add(mailResponse);
                continue;
                catch (TimeoutException e) {
                    block48: {
                        log.debug("mail send action:{}, [error] : {}", (Object)action, (Object)e.toString());
                        log.error(e.getMessage(), (Throwable)e);
                        error = e.toString() + ", action:" + action;
                        resultCode = "TMS4";
                        if (mailResponse != null) break block48;
                        mId = null;
                        uniqueSeq = null;
                        try {
                            mId = targetData.getString("TMS_M_ID");
                            uniqueSeq = targetData.getString("UNIQUE_SEQ");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (mId != null && uniqueSeq != null) {
                            mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                        }
                    }
                    mailResponse.setCode(resultCode);
                    mailResponse.setDetail(error);
                    mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                    log.info("MAIL SEND RESULT][BULK] host:{}, usingBulk:true, contentSize:{}, index:{}, {}", new Object[]{chinfo.getHost(), mailResponse.getContentSize(), i, mailResponse.toString()});
                    resultList.add(mailResponse);
                    continue;
                }
                catch (Exception e2) {
                    block49: {
                        log.debug("mail send action:{}, [error] : {}", (Object)action, (Object)e2.toString());
                        log.error(e2.getMessage(), (Throwable)e2);
                        error = e2.toString();
                        resultCode = "TMS9";
                        if (mailResponse != null) break block49;
                        mId = null;
                        uniqueSeq = null;
                        {
                            catch (Throwable throwable) {
                                if (mailResponse == null) {
                                    String mId2 = null;
                                    String uniqueSeq2 = null;
                                    try {
                                        mId2 = targetData.getString("TMS_M_ID");
                                        uniqueSeq2 = targetData.getString("UNIQUE_SEQ");
                                    }
                                    catch (JSONException jSONException) {
                                        // empty catch block
                                    }
                                    if (mId2 != null && uniqueSeq2 != null) {
                                        mailResponse = new TmsResponse(mId2, uniqueSeq2, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                                    }
                                }
                                mailResponse.setCode(resultCode);
                                mailResponse.setDetail(error);
                                mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                                log.info("MAIL SEND RESULT][BULK] host:{}, usingBulk:true, contentSize:{}, index:{}, {}", new Object[]{chinfo.getHost(), mailResponse.getContentSize(), i, mailResponse.toString()});
                                resultList.add(mailResponse);
                                throw throwable;
                            }
                        }
                        try {
                            mId = targetData.getString("TMS_M_ID");
                            uniqueSeq = targetData.getString("UNIQUE_SEQ");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (mId != null && uniqueSeq != null) {
                            mailResponse = new TmsResponse(mId, uniqueSeq, chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                        }
                    }
                    mailResponse.setCode(resultCode);
                    mailResponse.setDetail(error);
                    mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                    log.info("MAIL SEND RESULT][BULK] host:{}, usingBulk:true, contentSize:{}, index:{}, {}", new Object[]{chinfo.getHost(), mailResponse.getContentSize(), i, mailResponse.toString()});
                    resultList.add(mailResponse);
                    continue;
                }
            }
            if (this.ch != null) {
                try {
                    this.ch.write((Object)SmtpRequests.noop());
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            TmsDefaultSmtpResponse endResponse = null;
            this.ch.writeAndFlush((Object)SmtpRequests.quit()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                }
            });
            endResponse = (TmsDefaultSmtpResponse)smtpResponseFuture.get(10000L, TimeUnit.MILLISECONDS);
            endResponse.setReturnCode("QUIT");
            log.debug("mail send [quit][response] : {}", (Object)endResponse);
            String resultCode = this.response.getReturnCode().concat(".").concat(String.valueOf(this.response.code())).concat(".");
            error = this.response.details().toString();
            log.info("[Bulk][QUIT] domain:{}, host:{}, size:{} , sendId:{}, schdId:{}, targetSeq:{}, resultCode:{}, detail:{} END===============================", new Object[]{chinfo.getDomain(), chinfo.getHost(), targetList.size(), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq(), resultCode, error});
        }
        catch (Exception e) {
            try {
                if (this.ch != null && this.ch.isActive()) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                        }
                    });
                    this.ch.write((Object)SmtpRequests.noop());
                }
            }
            catch (Exception e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
            log.error("mail send [error] : {}", (Object)e.toString());
            resultList.clear();
            resultList = this.makeAllErrorList(targetList, chinfo, "TMS9", e.toString());
        }
        finally {
            try {
                if (this.ch != null && this.ch.isActive()) {
                    this.ch.close().sync();
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return resultList;
    }

    public List<TmsResponse> makeAllErrorList(List<JSONObject> targetList, TmsChannelInfo chinfo, String errCode, String error) {
        ArrayList<TmsResponse> resultList = new ArrayList<TmsResponse>();
        for (JSONObject targetData : targetList) {
            try {
                TmsResponse mailResponse = new TmsResponse(targetData.getString("TMS_M_ID"), targetData.getString("UNIQUE_SEQ"), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
                mailResponse.setCode(errCode);
                mailResponse.setDetail(error);
                mailResponse.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                resultList.add(mailResponse);
            }
            catch (Exception e) {
                log.debug("mail makeAllErrorList [targetData]:{}, [error] : {}", (Object)targetData.toString(), (Object)e.toString());
            }
        }
        log.error("all error result List:{}", (Object)((Object)resultList).toString());
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downloadFile(URL url) {
        ByteArrayOutputStream baos = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress id = InetAddress.getByName("mail.humuson.com");
        System.out.println("ID is " + id);
    }
}

