/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.mail.actor;

import com.google.gson.Gson;
import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsMailConfig;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.dns.model.DnsModel;
import com.humuson.tms.sender.mail.actor.TmsMailSenderActor;
import com.humuson.tms.util.date.DateUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.StringUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsMailMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsMailMessageListener.class);
    SecureRandom random = new SecureRandom();
    TmsSenderCommonConfig commonConfig;
    private final boolean isRelay;
    private TmsMailConfig mailConfig;

    public TmsMailMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
        this.mailConfig = commonConfig.getTmsMailConfig();
        this.isRelay = this.mailConfig.getRelayEnable().trim().equalsIgnoreCase("true");
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) throws Exception {
        if (targetData.get("TMS_M_TARGET") == null || !targetData.has("TMS_M_TARGET") || String.valueOf(targetData.get("TMS_M_TARGET")).trim().equals("")) {
            throw new NullPointerException("TMS_M_TARGET is null or Not exist. TMS_M_ID=" + String.valueOf(targetData.get("MEMBER_ID")) + ", SCHD_ID=" + pinfo.getSchdId());
        }
        if (targetData.has("STATUS") && targetData.has("ERROR_DETAIL")) {
            throw new Exception(targetData.getString("ERROR_DETAIL"));
        }
        return true;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ArrayList<TmsResponse> resultList = new ArrayList();
        DnsModel dnsModel = null;
        boolean isSendOk = false;
        String host = null;
        host = this.isRelay ? this.mailConfig.getRelayDomain() : this.dnsDetectHost(dnsModel, chinfo);
        if (this.mailConfig.isDnsOff()) {
            isSendOk = true;
        } else if (this.isRelay || host != null && dnsModel != null && !"D".equals(dnsModel.getUseYn())) {
            isSendOk = true;
        }
        TmsMailSenderActor mailSender = null;
        if (isSendOk) {
            EventLoopGroup evnetLoopGrp = null;
            String targetEventLoopGrpKey = null;
            targetEventLoopGrpKey = chinfo.getTargetDestination().replace(":queue://", "");
            targetEventLoopGrpKey = targetEventLoopGrpKey.replace("queue://", "");
            if (this.commonConfig.getTmsMailConfig().getMailEventGrp().get(targetEventLoopGrpKey) != null) {
                evnetLoopGrp = (EventLoopGroup)this.commonConfig.getTmsMailConfig().getMailEventGrp().get(targetEventLoopGrpKey);
                log.debug("[SD] get EventLoopGrp | key :{} | eventLoopGrp : {}", (Object)targetEventLoopGrpKey, (Object)evnetLoopGrp);
            } else {
                evnetLoopGrp = (EventLoopGroup)this.commonConfig.getTmsMailConfig().getMailEventGrp().get("etc.default");
                log.debug("[SD] get EventLoopGrp | default : etc.default | eventLoopGrp : {}", (Object)targetEventLoopGrpKey, (Object)evnetLoopGrp);
            }
            mailSender = new TmsMailSenderActor(this.commonConfig, evnetLoopGrp);
        } else {
            mailSender = new TmsMailSenderActor(this.commonConfig, null);
        }
        if (!isSendOk) {
            String errorCode = "TMS9";
            String error = "TMS9";
            if (this.dnsOn() && dnsModel.getUseYn().equals("D")) {
                if (!StringUtils.isEmpty((CharSequence)dnsModel.getErrorMsg())) {
                    error = dnsModel.getErrorMsg();
                } else {
                    error = "This data is domain filter target";
                    errorCode = "TMS7";
                }
            }
            resultList = mailSender.makeAllErrorList(targetListData, chinfo, errorCode, error);
            return resultList;
        }
        List<Map<String, String>> listMailConf = this.commonConfig.getTmsMailConfig().getMailPropSetConfiger().getMass();
        boolean isBulkSend = false;
        for (JSONObject targetData : targetListData) {
            TmsResponse sendResult = null;
            try {
                targetData.put("host", (Object)host);
                sendResult = mailSender.targetSendToServer(targetData, pinfo, chinfo);
                if (sendResult != null) {
                    log.info("MAIL SEND RESULT][BULK] host:{}, usingBulk:false, contentSize:{}, {}", new Object[]{host, sendResult.getContentSize(), sendResult.toString()});
                    resultList.add(sendResult);
                    continue;
                }
                log.error("MAIL SEND RESULT][BULK] host:{}, usingBulk:false, sendResult is null", (Object)host);
            }
            catch (Exception e) {
                log.error("Mail send Exception {}", (Throwable)e);
            }
        }
        return resultList;
    }

    private boolean dnsOn() {
        return !this.mailConfig.isDnsOff();
    }

    private String dnsDetectHost(DnsModel dnsModel, TmsChannelInfo chinfo) {
        if (this.isRelay && this.mailConfig.isDnsOff()) {
            return this.mailConfig.getRelayDomain();
        }
        String host = null;
        try {
            dnsModel = this.getDnsData(chinfo.getDomain());
            try {
                if (dnsModel.getMxList() != null && dnsModel.getMxList().size() > 0) {
                    host = dnsModel.getMxList().get(this.random.nextInt(dnsModel.getMxList().size())).getAsString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (host == null && dnsModel.getMx() != null) {
                host = dnsModel.getMx();
            }
            if (host == null && dnsModel.getIp() != null) {
                host = dnsModel.getIp();
            }
        }
        catch (Exception e) {
            log.error("Dns search error channel info is {}", (Object)chinfo, (Object)e);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse sendResult = new TmsResponse(chinfo.getTargetMemberId(), chinfo.getTargetMemberIdSeq(), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
        String errorMsg = null;
        String errorCode = null;
        String domain = chinfo.getDomain();
        EventLoopGroup evnetLoopGrp = null;
        String targetEventLoopGrpKey = null;
        targetEventLoopGrpKey = chinfo.getTargetDestination().replace(":queue://", "");
        targetEventLoopGrpKey = targetEventLoopGrpKey.replace("queue://", "");
        if (this.commonConfig.getTmsMailConfig().getMailEventGrp().get(targetEventLoopGrpKey) != null) {
            evnetLoopGrp = (EventLoopGroup)this.commonConfig.getTmsMailConfig().getMailEventGrp().get(targetEventLoopGrpKey);
            log.info("[SD] get EventLoopGrp | key :{} | eventLoopGrp : {}", (Object)targetEventLoopGrpKey, (Object)evnetLoopGrp);
        } else {
            evnetLoopGrp = (EventLoopGroup)this.commonConfig.getTmsMailConfig().getMailEventGrp().get("etc.default");
            log.info("[SD] get EventLoopGrp | default : etc.default | eventLoopGrp : {}", (Object)targetEventLoopGrpKey, (Object)evnetLoopGrp);
        }
        String host = null;
        DnsModel dnsModel = null;
        if (errorMsg == null && errorCode == null) {
            for (int retryCnt = 0; retryCnt < 2; ++retryCnt) {
                block18: {
                    try {
                        if (this.isRelay) {
                            TmsMailSenderActor mailSender = new TmsMailSenderActor(this.commonConfig, evnetLoopGrp);
                            if (this.isRelay) {
                                host = this.mailConfig.getRelayDomain();
                            }
                            targetData.put("host", (Object)host);
                            sendResult = mailSender.targetSendToServer(targetData, pinfo, chinfo);
                        } else {
                            errorCode = "TMS9";
                            log.info("Sending Mail Error {}", (Object)errorCode);
                            if (dnsModel.getUseYn().equals("D")) {
                                if (!StringUtils.isEmpty((CharSequence)dnsModel.getErrorMsg())) {
                                    errorMsg = dnsModel.getErrorMsg();
                                    errorCode = "TMS9";
                                } else {
                                    errorMsg = "This data is domain filter target";
                                    errorCode = "TMS7";
                                }
                            }
                        }
                        if (sendResult.getDetail() != null) break block18;
                        sendResult.setDetail("");
                    }
                    catch (TimeoutException e) {
                        block19: {
                            log.error("[SendProcess] Mail send retryCnt:{}, detail:{}, {} ", new Object[]{retryCnt, "java.util.concurrent.TimeoutException", sendResult.toString()});
                            if (sendResult.getDetail() != null) break block19;
                            sendResult.setDetail("");
                        }
                        log.info("[SendProcess] Mail send retryCnt:{}, detail:{}, {} ", new Object[]{retryCnt, sendResult.getDetail(), sendResult.toString()});
                        continue;
                    }
                    catch (Exception e2) {
                        block20: {
                            log.error("Mail send Exception {}", (Throwable)e2);
                            errorMsg = e2.toString();
                            errorCode = "TMS9";
                            if (sendResult.getDetail() != null) break block20;
                            sendResult.setDetail("");
                            {
                                catch (Throwable throwable) {
                                    if (sendResult.getDetail() == null) {
                                        sendResult.setDetail("");
                                    }
                                    log.info("[SendProcess] Mail send retryCnt:{}, detail:{}, {} ", new Object[]{retryCnt, sendResult.getDetail(), sendResult.toString()});
                                    throw throwable;
                                }
                            }
                        }
                        log.info("[SendProcess] Mail send retryCnt:{}, detail:{}, {} ", new Object[]{retryCnt, sendResult.getDetail(), sendResult.toString()});
                        break;
                    }
                }
                log.info("[SendProcess] Mail send retryCnt:{}, detail:{}, {} ", new Object[]{retryCnt, sendResult.getDetail(), sendResult.toString()});
                break;
            }
        }
        if (errorMsg != null && errorCode != null) {
            sendResult = this.makeErrorSendResult(sendResult, errorCode, errorMsg);
        }
        log.info("MAIL SEND RESULT host:{}, contentSize:{}, {}", new Object[]{host, sendResult.getContentSize(), sendResult.toString()});
        return sendResult;
    }

    private boolean notRelay(String host, DnsModel dnsModel) {
        return host != null && !dnsModel.getUseYn().equals("D");
    }

    public TmsResponse makeErrorSendResult(TmsResponse sendResult, String errorCode, String errorMsg) {
        sendResult.setCode(errorCode);
        sendResult.setDetail(errorMsg);
        sendResult.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        return sendResult;
    }

    public DnsModel getDnsData(String hostName) throws Exception {
        hostName = hostName.toLowerCase();
        String redisKey = "DINFO".concat(":").concat("SD");
        String value = null;
        try {
            value = this.commonConfig.getWrapperRedisTemplate().hmget(redisKey, hostName);
            if (StringUtil.isNullOrEmpty((String)value)) {
                String defaultRedisKey = "DINFO".concat(":").concat("default");
                value = this.commonConfig.getWrapperRedisTemplate().hmget(defaultRedisKey, hostName);
            }
        }
        catch (Exception e) {
            throw new Exception("Dns Data Read Error");
        }
        DnsModel dnsModel = null;
        if (StringUtil.isNullOrEmpty((String)value)) {
            throw new Exception("This target Data haven't Mx Record or Ip Address : " + redisKey + " domain : [" + hostName + "]");
        }
        Gson gson = new Gson();
        dnsModel = (DnsModel)gson.fromJson(value, DnsModel.class);
        return dnsModel;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) throws JSONException, Exception {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.trim().equals("") && status.trim().equals("");
    }
}

