/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.mail.actor;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.mail.model.TmsEmailVo;
import com.humuson.tms.sender.smtp.NioClientChannelHandler;
import com.humuson.tms.sender.smtp.NioClientChannelInitializer;
import com.humuson.tms.sender.smtp.SmtpConnection;
import com.humuson.tms.sender.smtp.SmtpResponseFuture;
import com.humuson.tms.sender.smtp.TmsDefaultSmtpResponse;
import com.humuson.tms.util.FileUtil;
import com.humuson.tms.util.date.DateUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.smtp.DefaultLastSmtpContent;
import io.netty.handler.codec.smtp.DefaultSmtpContent;
import io.netty.handler.codec.smtp.SmtpRequests;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TmsMailAsyncSenderActor
extends SmtpConnection
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsMailAsyncSenderActor.class);
    public static final int DEFAULT_PORT = 25;
    public static final int DEFAULT_TIME_OUT = 1000;
    public static final String DEFAULT_LOCALHOST = "localhost";
    private TmsSenderCommonConfig tmsCommonConfig;
    private int retryCnt = 0;
    private EventLoopGroup eventLoopGroup;
    private Channel ch;

    public TmsMailAsyncSenderActor(TmsSenderCommonConfig tmsCommonConfig, EventLoopGroup eventLoopGroup) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.eventLoopGroup = eventLoopGroup;
    }

    public Channel getChannel() {
        return this.ch;
    }

    public String createContent(TmsEmailVo tmsEmailVo, String lang) throws Exception {
        String content = null;
        try {
            content = tmsEmailVo.isCheckContentUrlYn() ? SenderUtil.getContent(tmsEmailVo.getContentUrl(), lang) : FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
        }
        catch (IOException e) {
            log.info("[URL read boolean : {} ]first read content File error {}", (Object)tmsEmailVo.isCheckContentUrlYn(), (Object)e.toString());
            log.info("This Content Url : [{}], path : [{}]", (Object)tmsEmailVo.getContentUrl(), (Object)tmsEmailVo.getContentPath());
            try {
                content = FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
            }
            catch (Exception e2) {
                log.error("read content File error {}", (Object)e2.toString());
                throw e2;
            }
        }
        catch (Exception e) {
            log.error("read content Url or File error {}", (Object)e.toString());
            throw e;
        }
        content = content.replaceAll("@TMS_M_TARGET@", tmsEmailVo.getTmsMEmail());
        return content;
    }

    public TmsEmailVo createMailVo(JSONObject targetData, TMSCommonPInfo pinfo) throws JSONException {
        TmsEmailVo tmsEmailVo = new TmsEmailVo();
        try {
            tmsEmailVo.setStartData(DateUtil.getFullDate((String)"yyyyMMddHH24mmss"));
            tmsEmailVo.setMemberId(targetData.getString("TMS_M_ID"));
            tmsEmailVo.setMemberIdSeq(targetData.getString("UNIQUE_SEQ"));
            tmsEmailVo.setTmsMEmail(targetData.getString("TMS_M_TARGET"));
            tmsEmailVo.setDomain(targetData.getString("DOMAIN"));
            tmsEmailVo.setFromEmail(pinfo.getReturnPath());
            tmsEmailVo.setHost(targetData.getString("host"));
            if (targetData.has("FULL_CONTENT_URL")) {
                tmsEmailVo.setContentUrl(targetData.getString("FULL_CONTENT_URL"));
                tmsEmailVo.setCheckContentUrlYn(true);
            }
            if (targetData.has("FULL_CONTENT_PATH")) {
                tmsEmailVo.setContentPath(targetData.getString("FULL_CONTENT_PATH"));
            }
        }
        catch (JSONException e) {
            log.error("JSON parsing Error {}", (Throwable)e);
            throw new JSONException("[createMailVo] target Data parsing Error ");
        }
        return tmsEmailVo;
    }

    public Bootstrap connectTargetDomain(EventLoopGroup event, String localhost, int port) {
        Bootstrap bootstrap = null;
        bootstrap = new Bootstrap();
        bootstrap.group(event);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new NioClientChannelInitializer());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        bootstrap.bind(localhost, port);
        return bootstrap;
    }

    public Channel createConnection(String host) throws InterruptedException {
        Channel channel = null;
        Bootstrap bootstrap = super.connectTargetDomain(this.eventLoopGroup);
        channel = bootstrap.connect(host, 25).sync().channel();
        return channel;
    }

    public TmsResponse targetSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) throws Exception {
        ++this.retryCnt;
        return this.targetDataSendToServer(targetData, pinfo, chinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsDefaultSmtpResponse response = null;
        TmsDefaultSmtpResponse endResponse = null;
        TmsEmailVo tmsEmailVo = null;
        String error = null;
        String resultCode = null;
        String content = null;
        try {
            tmsEmailVo = this.createMailVo(targetData, pinfo);
            content = this.createContent(tmsEmailVo, pinfo.getNlsLang());
            String localhost = DEFAULT_LOCALHOST;
            String nicIp = null;
            Object logDetail = null;
            if (!this.tmsCommonConfig.getTmsMailConfig().getLocalhost().isEmpty()) {
                localhost = this.tmsCommonConfig.getTmsMailConfig().getLocalhost();
                nicIp = this.tmsCommonConfig.getTmsMailConfig().getNicIp();
            }
            if (nicIp == null) {
                nicIp = localhost;
            }
            Bootstrap bootstrap = this.connectTargetDomain(this.eventLoopGroup, localhost, 25);
            final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
            System.out.println("TARGET DATA !! connect");
            this.ch = bootstrap.connect(tmsEmailVo.getHost(), 25).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                    } else {
                        future.channel().disconnect();
                    }
                }
            }).awaitUninterruptibly().channel();
            if (this.ch.isActive()) {
                response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                response.setReturnCode("INIT");
                log.debug("mail send [init][response] : {}", (Object)response);
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)SmtpRequests.helo((CharSequence)localhost)).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
            }
            if (this.ch.isActive()) {
                response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                log.debug("mail send [helo][response] : {}", (Object)response);
                response.setReturnCode("HELO");
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)SmtpRequests.mail((CharSequence)tmsEmailVo.getFromEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
                if (this.ch.isActive()) {
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("MAILFROM");
                    log.debug("mail send [mail][response] : {}", (Object)response);
                }
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)SmtpRequests.rcpt((CharSequence)tmsEmailVo.getTmsMEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
                if (this.ch.isActive()) {
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("RCPT");
                    log.debug("mail send [rcpt][response] : {}", (Object)response);
                }
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)SmtpRequests.data()).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
                if (this.ch.isActive()) {
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("DATA");
                }
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                log.debug("mail send [data][response] : {}", (Object)response);
                this.ch.writeAndFlush((Object)new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly();
                log.debug("mail send [content][response] : {}", (Object)response);
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
                if (this.ch.isActive()) {
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("DATABODY");
                    log.debug("mail send [endData][response] : {}", (Object)response);
                }
                if (this.checkError(response.code())) {
                    this.ch.writeAndFlush((Object)SmtpRequests.quit());
                    throw new Exception(response.details().toString());
                }
                this.ch.writeAndFlush((Object)SmtpRequests.quit()).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        System.out.println(future.isSuccess());
                        if (future.isSuccess()) {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        } else {
                            future.channel().disconnect();
                        }
                    }
                });
                if (this.ch.isActive()) {
                    endResponse = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    endResponse.setReturnCode("QUIT");
                }
                log.debug("mail send [quit][response] : {}", endResponse);
            }
            if (StringUtils.isEmpty((Object)response)) {
                throw new Exception(this.createConnectionErrorMsg(nicIp, tmsEmailVo.getHost()));
            }
            resultCode = response.getReturnCode().concat(".").concat(String.valueOf(response.code())).concat(".").concat(tmsEmailVo.getDomain());
            error = response.details().toString();
            this.ch.write((Object)SmtpRequests.noop());
        }
        catch (TimeoutException e) {
            log.debug("mail send [error] : {}", (Object)e.toString());
            if (this.ch != null && this.ch.isActive()) {
                this.ch.writeAndFlush((Object)SmtpRequests.quit());
            }
            error = e.toString();
            resultCode = "TMS4";
        }
        catch (Exception e) {
            log.debug("mail send [error] : {}", (Object)e.toString());
            if (this.ch != null && this.ch.isActive()) {
                this.ch.writeAndFlush((Object)SmtpRequests.quit());
            }
            error = e.toString();
            resultCode = "TMS9";
        }
        finally {
            if (this.ch != null && this.ch.isActive()) {
                this.ch.close();
            }
        }
        return new TmsResponse(resultCode, "", error, tmsEmailVo.getStartData(), tmsEmailVo.getMemberId(), tmsEmailVo.getMemberIdSeq(), chinfo.getTargetSendId(), chinfo.getTargetSchdId(), chinfo.getTargetSeq());
    }

    public String createConnectionErrorMsg(String nic, String host) {
        StringBuffer strb = new StringBuffer();
        strb.append("[ERROR][");
        strb.append(nic);
        strb.append(" => ");
        strb.append(host);
        strb.append("] channel con error : Not create or disconnect!");
        return strb.toString();
    }

    public boolean checkError(int errorCode) {
        switch (errorCode) {
            case 214: {
                return false;
            }
            case 220: {
                return false;
            }
            case 221: {
                return false;
            }
            case 250: {
                return false;
            }
            case 354: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public boolean closeConnection(Channel ch) {
        if (ch != null) {
            ch.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsDefaultSmtpResponse response = null;
        String error = null;
        String resultCode = null;
        Channel ch = null;
        Object host = null;
        String content = null;
        ArrayList<TmsEmailVo> tmsEmailVos = new ArrayList<TmsEmailVo>();
        try {
            for (JSONObject targetData : targetList) {
                tmsEmailVos.add(this.createMailVo(targetData, pinfo));
            }
            String localhost = DEFAULT_LOCALHOST;
            String nicIp = null;
            if (!this.tmsCommonConfig.getTmsMailConfig().getLocalhost().isEmpty()) {
                localhost = this.tmsCommonConfig.getTmsMailConfig().getLocalhost();
                nicIp = this.tmsCommonConfig.getTmsMailConfig().getNicIp();
            }
            if (nicIp == null) {
                nicIp = localhost;
            }
            Bootstrap bootstrap = this.connectTargetDomain(this.eventLoopGroup, localhost, 25);
            final SmtpResponseFuture smtpResponseFuture = new SmtpResponseFuture();
            ch = bootstrap.connect(chinfo.getHost(), 25).sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                }
            }).channel();
            for (TmsEmailVo tmsEmailVo : tmsEmailVos) {
                content = this.createContent(tmsEmailVo, pinfo.getNlsLang());
                response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                response.setReturnCode("INIT");
                log.debug("mail send [init][response] : {}", (Object)response);
                if (ch.isActive()) {
                    ch.writeAndFlush((Object)SmtpRequests.helo((CharSequence)localhost)).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        }
                    });
                }
                response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                log.debug("mail send [helo][response] : {}", (Object)response);
                response.setReturnCode("HELO");
                if (this.checkError(response.code())) {
                    ch.writeAndFlush((Object)SmtpRequests.quit()).sync();
                } else {
                    ch.writeAndFlush((Object)SmtpRequests.mail((CharSequence)tmsEmailVo.getFromEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        }
                    });
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("MAILFROM");
                    log.debug("mail send [mail][response] : {}", (Object)response);
                    ch.writeAndFlush((Object)SmtpRequests.rcpt((CharSequence)tmsEmailVo.getTmsMEmail(), (CharSequence[])new CharSequence[0])).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        }
                    });
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("RCPT");
                    log.debug("mail send [rcpt][response] : {}", (Object)response);
                }
                if (this.checkError(response.code())) {
                    ch.writeAndFlush((Object)SmtpRequests.quit()).sync();
                } else {
                    ch.writeAndFlush((Object)SmtpRequests.data()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        }
                    });
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("DATA");
                    log.debug("mail send [data][response] : {}", (Object)response);
                    ch.writeAndFlush((Object)new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly().sync();
                    log.debug("mail send [content][response] : {}", (Object)response);
                    ch.writeAndFlush((Object)new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.UTF_8))).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                        }
                    });
                    response = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                    response.setReturnCode("DATABODY");
                    log.debug("mail send [endData][response] : {}", (Object)response);
                }
                TmsDefaultSmtpResponse endResponse = null;
                ch.writeAndFlush((Object)SmtpRequests.quit()).awaitUninterruptibly().sync().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ((NioClientChannelHandler)future.channel().pipeline().get(NioClientChannelHandler.class)).setResponseFuture(smtpResponseFuture);
                    }
                });
                endResponse = (TmsDefaultSmtpResponse)smtpResponseFuture.get(30000L, TimeUnit.MILLISECONDS);
                endResponse.setReturnCode("QUIT");
                log.debug("mail send [quit][response] : {}", (Object)endResponse);
                resultCode = response.getReturnCode().concat(".").concat(String.valueOf(response.code())).concat(".").concat(tmsEmailVo.getDomain());
                error = response.details().toString();
            }
        }
        catch (Exception e) {
            log.debug("mail send [error] : {}", (Throwable)e);
            if (ch != null && ch.isActive()) {
                try {
                    ch.writeAndFlush((Object)SmtpRequests.quit()).awaitUninterruptibly().sync();
                }
                catch (InterruptedException e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
            error = e.toString();
            resultCode = "TMS9";
        }
        finally {
            if (ch != null && ch.isActive()) {
                try {
                    ch.close().sync();
                }
                catch (InterruptedException e) {
                    log.error("send Mail Error [finally]: {}", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downloadFile(URL url) {
        ByteArrayOutputStream baos = null;
        try {
            URLConnection conn = url.openConnection();
            baos = new ByteArrayOutputStream();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

