/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.handler;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.sender.common.TmsSenderConstants;
import com.humuson.tms.sender.common.domain.BizPropSetConfiger;
import com.humuson.tms.sender.common.domain.DnsPropSetConfiger;
import com.humuson.tms.sender.common.domain.LinePropSetConfiger;
import com.humuson.tms.sender.common.domain.MailPropSetConfiger;
import com.humuson.tms.sender.common.domain.PushPropSetConfiger;
import com.humuson.tms.sender.common.domain.SmsPropSetConfiger;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.dns.DnsCheck;
import com.humuson.tms.sender.dns.TmsDns;
import com.humuson.tms.sender.dns.model.DnsModel;
import com.humuson.tms.sender.handler.ChannelHandlerListener;
import com.humuson.tms.sender.handler.model.ChannelTypeInfo;
import com.humuson.tms.sender.result.ResultBuilder;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TmsChannelHandler
extends ChannelHandlerListener {
    private static final Logger log = LoggerFactory.getLogger(TmsChannelHandler.class);
    @Value(value="${tms.daemon-id}")
    private String ServerID;
    @Value(value="${mail.smtp.localhost}")
    String sendIp;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    MailPropSetConfiger domainMailListConfig;
    @Autowired
    SmsPropSetConfiger domainSmsListConfig;
    @Autowired
    PushPropSetConfiger domainPushListConfig;
    @Autowired
    BizPropSetConfiger domainBizListConfig;
    @Autowired
    LinePropSetConfiger domainLineListConfig;
    @Autowired
    DnsPropSetConfiger domainDnsListConfig;
    @Autowired
    @Qualifier(value="activemq-sender")
    ActiveMQSender activeMQsender;
    @Autowired
    SenderUtil sendUtil;

    @Override
    public void validatinoData(TmsChannelInfo tmsChannelVo) throws NullPointerException {
        if (StringUtils.isEmpty((Object)tmsChannelVo.getTargetKey())) {
            log.error("SD0502|validation Error : targetKey is null");
            throw new NullPointerException("targetKey is null");
        }
        if (StringUtils.isEmpty((Object)tmsChannelVo.getTargetMemberId())) {
            log.error("SD0502|validation Error :targetMemberId is null");
            throw new NullPointerException("targetMemberId is null");
        }
        if (StringUtils.isEmpty((Object)tmsChannelVo.getDomain())) {
            log.error("SD0502|validation Error :domain is null");
            throw new NullPointerException("domain is null");
        }
        if (StringUtils.isEmpty((Object)tmsChannelVo.getChannelType())) {
            log.error("SD0502|validation Error : channelType is null");
            throw new NullPointerException("channelType is null");
        }
        String channelType = tmsChannelVo.getChannelType();
        if (!(channelType.equals(ChannelTypeInfo.EMAIL.getColumn()) || channelType.equals(ChannelTypeInfo.SMS.getColumn()) || channelType.equals(ChannelTypeInfo.PUSH.getColumn()) || channelType.equals(ChannelTypeInfo.LINE.getColumn()) || channelType.equals(ChannelTypeInfo.BIZ.getColumn()))) {
            log.error("SD0502|validation Error : channelType is wrong => {}", (Object)channelType);
            throw new NullPointerException("channelType is WRONG : " + channelType);
        }
    }

    @Override
    public void sendMQtargetData(TmsChannelInfo tmsChannelVo) throws NullPointerException {
        String domain = null;
        String destination = null;
        String message = null;
        try {
            String type = null;
            type = tmsChannelVo.getTargetDestination().indexOf(TmsSenderConstants.SenderType.auto.toString()) > 0 ? TmsSenderConstants.SenderType.auto.toString() : (tmsChannelVo.getTargetDestination().indexOf(TmsSenderConstants.SenderType.mass.toString()) > 0 ? TmsSenderConstants.SenderType.mass.toString() : TmsSenderConstants.SenderType.auto.toString());
            domain = this.checkDomain(tmsChannelVo.getDomain(), tmsChannelVo.getChannelType());
            destination = this.createDestination(tmsChannelVo.getChannelType(), domain, tmsChannelVo.getTargetCompany(), type);
            if (tmsChannelVo.getTargetMemberId().equals("SKIP_M_ID")) {
                message = this.createMQMessage(tmsChannelVo);
            } else {
                tmsChannelVo.setMq_send_time(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                message = tmsChannelVo.getTargetData();
            }
            this.activeMQsender.send(destination, message);
            log.info("MQ::[produce] SEND ===== queue:{}, domain:{}, message:{}, priority:{}", new Object[]{destination, domain, message, tmsChannelVo.getMqPriority()});
        }
        catch (Exception e) {
            log.error("SD0505|MQ SEND ERROR]  destination : {} / domain : {} / message : {}], Detail EXception : {}", new Object[]{destination, domain, message, e});
            throw e;
        }
    }

    public String createMQMessage(TmsChannelInfo tmsChannelVo) {
        JsonObject mqMessage = new JsonObject();
        mqMessage.addProperty("domain", tmsChannelVo.getDomain());
        mqMessage.addProperty("channelType", tmsChannelVo.getChannelType());
        mqMessage.addProperty("memberId", tmsChannelVo.getTargetMemberId());
        mqMessage.addProperty("key", tmsChannelVo.getKey());
        mqMessage.addProperty("sendType", tmsChannelVo.getSendType());
        mqMessage.addProperty("company", tmsChannelVo.getTargetCompany());
        mqMessage.addProperty("mq_send_time", DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        return mqMessage.toString();
    }

    public String checkDomain(String domain, String channelType) {
        if (log.isDebugEnabled()) {
            log.debug("checkDomain : domain = {} / channelType = {}", (Object)domain, (Object)channelType);
        }
        List<String> targetDomainList = null;
        switch (channelType) {
            case "EM": {
                targetDomainList = this.domainMailListConfig.getDomainList();
                break;
            }
            case "SM": {
                targetDomainList = this.domainSmsListConfig.getDomainList();
                break;
            }
            case "KA": {
                targetDomainList = this.domainBizListConfig.getDomainList();
                break;
            }
            case "PU": {
                targetDomainList = this.domainPushListConfig.getDomainList();
                break;
            }
            case "LN": {
                targetDomainList = this.domainLineListConfig.getDomainList();
                break;
            }
        }
        for (String str : targetDomainList) {
            if (!str.equals(domain)) continue;
            return str;
        }
        return "default";
    }

    public String createPINFOKey(String schdId) {
        return "PINFO".concat(":").concat(schdId);
    }

    @Override
    public void errorDataProcess(TmsChannelInfo tmsChannelVo, String errorMsg) throws Exception {
        String pinfoKey = this.createPINFOKey(tmsChannelVo.getTargetSchdId());
        String workday = this.wrapperRedisTemplate.hmget(pinfoKey, "WORKDAY");
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType(tmsChannelVo.getChannelType()).schdId(tmsChannelVo.getTargetSchdId()).workday(workday).sendId(tmsChannelVo.getTargetSendId()).targetSeq(tmsChannelVo.getTargetSeq()).resultType("S").errorDetail(errorMsg).errorCode("TMS9").startDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss")).endDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss")).serverId(this.ServerID);
        String memberId = tmsChannelVo.getTargetMemberId();
        if (memberId.equals("SKIP_M_ID")) {
            String targetDomainValues = this.wrapperRedisTemplate.hmget(tmsChannelVo.getTargetDlistKey(), tmsChannelVo.getDomain());
            String[] targetDlistValues = targetDomainValues.split(",");
            ArrayList<String> targetDlistListValues = new ArrayList<String>(Arrays.asList(targetDlistValues));
            for (String targetValue : targetDlistListValues) {
                String[] memeber = null;
                TmsSendResult result = null;
                if (targetValue.indexOf(":") <= -1) continue;
                memeber = targetValue.split(":");
                result = targetDataResult.memberId(memeber[0]).memberIdSeq(memeber[1]).build();
                this.wrapperRedisTemplate.hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
            }
            log.info("TARGET DATA Exception DLIST not sending domainQueue because:{}, domain:{}, memberList:{}", new Object[]{errorMsg, tmsChannelVo.getDomain(), targetDlistValues});
        } else {
            TmsSendResult result = targetDataResult.memberId(tmsChannelVo.getTargetMemberId()).memberIdSeq(tmsChannelVo.getTargetMemberIdSeq()).build();
            this.wrapperRedisTemplate.hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
            log.info("TARGET DATA Exception. not sending domainQueue because:{}, key:{}, field:{}, value:{}", new Object[]{errorMsg, result.getRedisKey(), result.getRedisField(), result.getRedisValue()});
        }
    }

    @Override
    public void endCheckProcess(TmsChannelInfo tmsChannelVo) throws Exception {
        if (tmsChannelVo.getIsEnd().equals("Y")) {
            String sprocfeild;
            String sprockey = this.createSprocKey(tmsChannelVo.getTargetKey());
            String oriData = this.wrapperRedisTemplate.hmget(sprockey, sprocfeild = this.createSprocField(tmsChannelVo.getTargetKey()));
            if (oriData == null) {
                log.error("SD0503|endCheckProcess Error : read to sproc data => is null");
                throw new NullPointerException("read to sproc data => is null");
            }
            oriData = oriData.concat("|").concat("SENDER").concat(":").concat(this.ServerID).concat(":").concat("40").concat(":").concat(this.createCurrentTime());
            if (log.isDebugEnabled()) {
                log.debug("sprockey : {}, sprocfeild : {}", (Object)sprockey, (Object)sprocfeild);
                log.debug("oriData : {}", (Object)oriData);
            }
            this.wrapperRedisTemplate.hmset(sprockey, sprocfeild, oriData);
        }
    }

    public String createSprocKey(String key) {
        String[] data = key.split(":");
        return "SPROC:" + data[1];
    }

    public String createTlistKey(String key) {
        String[] data = key.split(":");
        return "TLIST".concat(":").concat(data[1]).concat(":").concat(data[2]);
    }

    public String createSprocField(String key) {
        String[] data = key.split(":");
        return data[1] + ":" + data[2];
    }

    public String createDestination(String channelType, String domain, String company, String type) {
        String destination = "";
        if (channelType.equals(ChannelTypeInfo.EMAIL.getColumn())) {
            destination = destination.concat(ChannelTypeInfo.EMAIL.getValue()).concat(".");
        } else if (channelType.equals(ChannelTypeInfo.PUSH.getColumn())) {
            destination = destination.concat(ChannelTypeInfo.PUSH.getValue()).concat(".");
        } else if (channelType.equals(ChannelTypeInfo.SMS.getColumn())) {
            destination = destination.concat(ChannelTypeInfo.SMS.getValue()).concat(".");
        } else if (channelType.equals(ChannelTypeInfo.BIZ.getColumn())) {
            destination = destination.concat(ChannelTypeInfo.BIZ.getValue()).concat(".");
        } else if (channelType.equals(ChannelTypeInfo.LINE.getColumn())) {
            destination = destination.concat(ChannelTypeInfo.LINE.getValue()).concat(".");
        } else {
            log.error("SD0504|Create Destination Error : channel Type is wrong");
        }
        destination = type != null ? type.concat(".").concat(destination).concat(company).concat(".").concat(domain) : destination.concat(company).concat(".").concat(domain);
        return destination;
    }

    public String createCurrentTime() {
        long time = System.currentTimeMillis();
        SimpleDateFormat dayTime = new SimpleDateFormat("yyyyMMddHH24mmss");
        String str = dayTime.format(new Date(time));
        return str;
    }

    @Override
    public boolean checkDNs(TmsChannelInfo tmsChannelVo) throws Exception {
        if (this.domainMailListConfig.isDnsOff()) {
            return true;
        }
        if (tmsChannelVo.getChannelType().equals(Constants.ChannelType.EM.toString())) {
            DnsModel targetDnsData = this.getDnsData(this.sendIp, tmsChannelVo.getDomain().toLowerCase());
            String returnType = targetDnsData == null ? "N" : targetDnsData.getUseYn();
            boolean isCreateDns = false;
            switch (returnType) {
                case "Y": {
                    if (!log.isDebugEnabled()) break;
                    log.debug("ServerId : {}, domain : {}", (Object)this.ServerID, (Object)tmsChannelVo.getDomain());
                    break;
                }
                case "D": {
                    if (!log.isDebugEnabled()) break;
                    log.debug("This [domain :{}] is a domain filter target", (Object)tmsChannelVo.getDomain());
                    break;
                }
                case "N": {
                    if (log.isDebugEnabled()) {
                        log.debug("This [domain :{}] is create DNS information", (Object)tmsChannelVo.getDomain());
                    }
                    isCreateDns = true;
                    break;
                }
            }
            isCreateDns = !isCreateDns ? this.checkRecreateDnsData(targetDnsData) : isCreateDns;
            this.createDnsData(tmsChannelVo.getDomain(), targetDnsData, isCreateDns);
        }
        return true;
    }

    private boolean checkRecreateDnsData(DnsModel targetDnsData) {
        if (StringUtils.isEmpty((Object)targetDnsData.getExpirationDate())) {
            return true;
        }
        return Integer.parseInt(targetDnsData.getExpirationDate()) < Integer.parseInt(DateUtil.getFullDate((String)"yyyyMMdd"));
    }

    public void createDnsData(String domain, DnsModel targetDnsData, boolean isRecreate) throws Exception {
        domain = domain.toLowerCase();
        List<Map<String, String>> targetDomainValue = this.domainDnsListConfig.getMass();
        String ip = null;
        String useYn = null;
        String mx = null;
        StringBuffer errorMsg = new StringBuffer();
        DnsModel dnsData = TmsDns.dnsModel(domain, this.sendIp);
        try {
            errorMsg.setLength(0);
            DnsCheck createDns = new DnsCheck();
            if (isRecreate) {
                if (this.domainDnsListConfig.getDomainList().contains(domain)) {
                    for (Map<String, String> targetDomain : targetDomainValue) {
                        if (targetDomain.get("domain").toLowerCase().equals(domain)) {
                            ip = targetDomain.get("ip");
                            useYn = targetDomain.get("useYn");
                        }
                        if (!targetDomain.containsKey("mx")) continue;
                        mx = targetDomain.get("mx");
                    }
                    dnsData = dnsData.useYn(useYn).setIp(ip).setMx(mx);
                } else {
                    if (this.domainDnsListConfig.getIps().size() > 0) {
                        dnsData = createDns.createMxRecord(dnsData, domain, this.domainDnsListConfig.getIps(), errorMsg);
                    }
                    if (StringUtils.isEmpty((Object)dnsData.getMx()) && StringUtils.isEmpty((Object)dnsData.getIp())) {
                        dnsData = createDns.createMxRecord(dnsData, domain);
                    }
                    dnsData = createDns.checkEnableIpAdress(dnsData, domain, errorMsg);
                }
            } else {
                dnsData.setMx(targetDnsData.getMx());
                dnsData.setIp(targetDnsData.getIp());
            }
            if (isRecreate) {
                if (StringUtils.isEmpty((Object)dnsData.getMx()) && StringUtils.isEmpty((Object)dnsData.getIp())) {
                    dnsData.setErrorCnt(3);
                } else {
                    dnsData = createDns.checkEnableConnection(dnsData, errorMsg);
                }
                dnsData.build();
                log.info("SEARCH_DNS] create Dns data ] dns Data : {}", (Object)dnsData.getRedisValue());
                this.setDnsData(dnsData);
            }
        }
        catch (Exception e) {
            errorMsg.append(e.toString());
        }
    }

    public void setDnsData(DnsModel dnsData) throws Exception {
        try {
            log.info("DNS_SEARCH] redis set domain Data | key : {} , field : {} , value : {}", new Object[]{dnsData.getRedisKey(), dnsData.getRedisField(), dnsData.getRedisValue()});
            this.wrapperRedisTemplate.hmset(dnsData.getRedisKey(), dnsData.getRedisField(), dnsData.getRedisValue());
            this.wrapperRedisTemplate.hmset(dnsData.getRedisKey().replace(this.sendIp, "default"), dnsData.getRedisField(), dnsData.getRedisValue());
        }
        catch (Exception e) {
            log.error("SD0505|Dns Search Error : Dns search Result Upload to Redis Error");
            throw new Exception("Dns search Result Upload Error");
        }
    }

    public DnsModel getDnsData(String sendIp, String hostName) throws Exception {
        String redisKey = null;
        redisKey = "DINFO".concat(":").concat("SD");
        String value = null;
        DnsModel dnsModel = null;
        try {
            value = this.wrapperRedisTemplate.hmget(redisKey, hostName);
        }
        catch (Exception e) {
            throw new Exception("Dns Data Read Error");
        }
        if (!StringUtils.isEmpty((Object)value)) {
            Gson gson = new Gson();
            dnsModel = (DnsModel)gson.fromJson(value, DnsModel.class);
        }
        return dnsModel;
    }

    public boolean checkDnsData(DnsModel dnsModel) {
        if (dnsModel.getErrorCnt() > 3) {
            return false;
        }
        return !dnsModel.getUseYn().equals("N") && !dnsModel.getUseYn().equals("D");
    }

    public boolean checkDnsList(List<String> targetDns, String targetDomain) {
        for (String domain : targetDns) {
            if (!domain.equals(targetDomain)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getBulkInfo(TmsChannelInfo tmsChannelVo) throws Exception {
        return this.wrapperRedisTemplate.hgetAllString(tmsChannelVo.getTargetDlistKey());
    }
}

