/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.handler;

import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.handler.Handler;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ChannelHandlerListener
implements Handler,
MessageListener {
    private static final Logger log = LoggerFactory.getLogger(ChannelHandlerListener.class);
    @Autowired
    SenderUtil senderUtil;
    private final String BULK_DOMAIN = "ALL";

    public void onMessage(Message message) {
        ArrayList<TmsChannelInfo> targetDomainList = new ArrayList<TmsChannelInfo>();
        JSONObject mqToJsonObj = new JSONObject();
        try {
            mqToJsonObj = this.senderUtil.MQmsgToJObj(message);
            mqToJsonObj.put("mq_destination", (Object)message.getJMSDestination().toString());
        }
        catch (Exception e) {
            mqToJsonObj = null;
            if (message != null) {
                try {
                    String str = ((TextMessage)message).getText();
                    if (str != null) {
                        log.error("MQ MESSAGE PARSING ERROR. MESSAGE:{}, ERROR:{}", (Object)str, (Object)e);
                    }
                }
                catch (JMSException e1) {
                    log.error("MQ MESSAGE PARSING ERROR. ERROR:{}", (Throwable)e);
                }
            }
            log.error("MQ MESSAGE PARSING ERROR. ERROR:{}", (Throwable)e);
        }
        if (mqToJsonObj == null) {
            return;
        }
        log.info("RECEIVE TO MQ TARGET DATA : {}", (Object)mqToJsonObj.toString());
        try {
            TmsChannelInfo.TmsChannelInfoBuilder channelVoBulider = this.senderUtil.createTmsChannelVo(mqToJsonObj);
            TmsChannelInfo channelVo = channelVoBulider.build();
            channelVo.setMqPriority(message.getJMSPriority());
            if (this.checkBulk(channelVo)) {
                Map<String, String> domainList = this.getBulkInfo(channelVo);
                for (Map.Entry<String, String> domainInfo : domainList.entrySet()) {
                    String domain = null;
                    domain = domainInfo.getKey();
                    log.info("[BULK process ] domain : {}", (Object)domain);
                    if (domain != null || domain != "") {
                        channelVoBulider.domain(domain);
                        channelVoBulider.targetMemberId("SKIP_M_ID");
                    }
                    TmsChannelInfo targetDomainChannelInfo = channelVoBulider.build();
                    targetDomainChannelInfo.setMqPriority(channelVo.getMqPriority());
                    targetDomainList.add(targetDomainChannelInfo);
                }
            } else {
                targetDomainList.add(channelVo);
            }
        }
        catch (Exception e) {
            log.error("TARGET MQ DATA CONVERT ERROR : {}", (Throwable)e);
        }
        for (TmsChannelInfo tmsChannelInfo : targetDomainList) {
            try {
                this.validatinoData(tmsChannelInfo);
                if (!this.checkDNs(tmsChannelInfo)) continue;
                this.sendMQtargetData(tmsChannelInfo);
            }
            catch (Exception e) {
                try {
                    this.errorDataProcess(tmsChannelInfo, e.getMessage());
                }
                catch (Exception e1) {
                    log.error("SD0501|channel Handler Error : {}", (Throwable)e1);
                }
            }
        }
    }

    @Override
    public boolean checkBulk(TmsChannelInfo tmsChannelVo) throws Exception {
        boolean checkFlag = false;
        if (tmsChannelVo.getDomain().equals("ALL")) {
            checkFlag = true;
        }
        return checkFlag;
    }
}

