/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.handler;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.sender.handler.TmsChannelHandler;
import com.humuson.tms.sender.jms.TmsDefaultMessageListenerContainer;
import com.humuson.tms.sender.jms.TmsJmsExceptionListener;
import com.humuson.tms.sender.monitor.TmsMessageListenerFactory;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableJms
public class ChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(ChannelHandler.class);
    @Autowired
    TmsJmsExceptionListener tmsExceptionListener;
    @Autowired
    TmsChannelHandler tmsChannelHandler;
    protected String state;
    @Value(value="${spring.jms.executor.initSize}")
    private String initSize;
    @Value(value="${spring.jms.executor.maxSize}")
    private String maxSize;
    @Value(value="${spring.jms.executor.capacity}")
    private String capacity;
    @Value(value="${tms.sender.queue}")
    public String destinationName;
    @Value(value="${tms.sender.push.useYn:false}")
    private boolean isPushChannel;
    @Value(value="${tms.sender.mail.useYn:false}")
    private boolean isMailChannel;
    @Value(value="${tms.sender.sms.useYn:false}")
    private boolean isSmsChannel;
    @Value(value="${tms.sender.biz.useYn:false}")
    private boolean isBizChannel;
    @Value(value="${tms.sender.line.useYn:false}")
    private boolean isLnChannel;
    @Value(value="${tms.sender.size}")
    public String concurrency;

    @Bean(value={"jms.task.executor"})
    public TaskExecutor taskExecutor() throws Exception {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        this.setConcurrencySize(taskExecutor, "MP-RCV:");
        return taskExecutor;
    }

    private void setConcurrencySize(ThreadPoolTaskExecutor taskExecutor, String name) {
        if (this.concurrency.trim().length() == 3) {
            String[] poolSize = this.concurrency.trim().split("-");
            taskExecutor.setCorePoolSize(Integer.parseInt(poolSize[1]));
            taskExecutor.setMaxPoolSize(Integer.parseInt(poolSize[1]) * 2);
            taskExecutor.setQueueCapacity(Integer.parseInt(this.capacity));
            taskExecutor.setKeepAliveSeconds(30);
        } else {
            taskExecutor.setCorePoolSize(Integer.parseInt(this.initSize));
            taskExecutor.setMaxPoolSize(Integer.parseInt(this.maxSize));
            taskExecutor.setQueueCapacity(Integer.parseInt(this.capacity));
            taskExecutor.setKeepAliveSeconds(30);
        }
        taskExecutor.setThreadGroupName(name);
    }

    @Bean
    public JmsTransactionManager transactionManager(ConnectionFactory connectionFactory) {
        JmsTransactionManager jmsTransactionManager = new JmsTransactionManager();
        jmsTransactionManager.setConnectionFactory(connectionFactory);
        return jmsTransactionManager;
    }

    @Bean
    public TmsMessageListenerFactory createChannelHandler(ConnectionFactory connectionFactory) throws Exception {
        String[] destinationNames;
        ((ActiveMQConnectionFactory)connectionFactory).setOptimizeAcknowledge(true);
        TmsMessageListenerFactory tmsChannelFactory = TmsMessageListenerFactory.listenerManager;
        for (String destination : destinationNames = this.destinationName.split(",")) {
            if (!this.isPushChannel && destination.indexOf(ChannelType.PUSH.getCode().toLowerCase().concat(".")) > -1) {
                log.info("isPushChannel:{} destination is skip [{}]", (Object)this.isPushChannel, (Object)destination);
                continue;
            }
            if (!this.isMailChannel && destination.indexOf(ChannelType.EMAIL.getCode().toLowerCase().concat(".")) > -1) {
                log.info("isMailChannel:{} destination is skip [{}]", (Object)this.isMailChannel, (Object)destination);
                continue;
            }
            if (!this.isBizChannel && destination.indexOf(ChannelType.KAKAO.getCode().toLowerCase().concat(".")) > -1) {
                log.info("isBizChannel:{} destination is skip [{}]", (Object)this.isBizChannel, (Object)destination);
                continue;
            }
            if (!this.isLnChannel && destination.indexOf(ChannelType.LN.getCode().toLowerCase().concat(".")) > -1) {
                log.info("isLnChannel:{} destination is skip [{}]", (Object)this.isLnChannel, (Object)destination);
                continue;
            }
            if (!this.isSmsChannel && destination.indexOf(ChannelType.SMS.getCode().toLowerCase().concat(".")) > -1) {
                log.info("isSmsChannel:{} destination is skip [{}]", (Object)this.isSmsChannel, (Object)destination);
                continue;
            }
            TmsDefaultMessageListenerContainer channelHandlerListener = new TmsDefaultMessageListenerContainer("channelHandler");
            channelHandlerListener.setConnectionFactory(connectionFactory);
            channelHandlerListener.setDestinationName(destination);
            channelHandlerListener.setConcurrency(this.concurrency);
            channelHandlerListener.setMessageListener(this.tmsChannelHandler);
            channelHandlerListener.setRecoveryInterval(10000L);
            channelHandlerListener.setReceiveTimeout(5000L);
            channelHandlerListener.setSessionTransacted(true);
            channelHandlerListener.setTaskExecutor((Executor)this.taskExecutor());
            channelHandlerListener.setExceptionListener(this.tmsExceptionListener);
            channelHandlerListener.afterPropertiesSet();
            channelHandlerListener.start();
        }
        return tmsChannelFactory;
    }
}

