/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.factory;

import com.humuson.tms.sender.common.BasicSenderFactory;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.jms.TmsDefaultMessageListenerContainer;
import com.humuson.tms.sender.jms.TmsJmsExceptionListener;
import com.humuson.tms.sender.monitor.TmsMessageListenerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.annotation.EnableJms;

@EnableJms
public class TmsCreateSenderFactory
implements BasicSenderFactory {
    private static final Logger log = LoggerFactory.getLogger(TmsCreateSenderFactory.class);
    @Autowired
    TmsJmsExceptionListener tmsExceptionListener;
    List<Map<String, String>> chnDomain;
    ConcurrentHashMap<String, TmsDefaultMessageListenerContainer> targetConsumers = new ConcurrentHashMap();
    ConcurrentHashMap<String, MessageConsumer> tmsMessageConsumers = new ConcurrentHashMap();
    ConcurrentHashMap<String, List<Connection>> tmsConsumers = new ConcurrentHashMap();
    String channelTypeName;
    TmsSenderCommonConfig tmsCommonConfig;
    TmsMessageListenerFactory tmsChannelFactory = TmsMessageListenerFactory.listenerManager;
    @Value(value="${spring.activemq.broker-url:}")
    private String brokerUrl;
    @Value(value="${spring.activemq.pool.max-connections:30}")
    public int maxConnections;

    public TmsCreateSenderFactory(List<Map<String, String>> targetDomain) {
        this.chnDomain = targetDomain;
    }

    @Override
    @Autowired
    public void configureJmsListeners(ConnectionFactory connectionFactory, TmsSenderCommonConfig tmsCommonConfig, @Qualifier(value="jms.task.executor") TaskExecutor taskExecutor) throws IllegalArgumentException, SecurityException {
        this.tmsCommonConfig = tmsCommonConfig;
        for (Map<String, String> target : this.chnDomain) {
            try {
                this.connectionConsumer(connectionFactory, target, taskExecutor);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("Exception ", (Throwable)e);
            }
        }
        this.tmsChannelFactory.postNewNotiMsg("Test Message Send");
    }

    @Override
    public String createDestinationName(String company, String domain, String channelType, String type) {
        String destination = null;
        destination = type != null ? type.concat(".").concat(channelType).concat(".").concat(company).concat(".").concat(domain) : channelType.concat(".").concat(company).concat(".").concat(domain);
        return destination;
    }

    public void connectionConsumer(ConnectionFactory connectionFactory, Map<String, String> target, TaskExecutor taskExecutor) throws IllegalArgumentException, ClassNotFoundException {
        String destination = null;
        log.info("target :{}", (Object)target.toString());
        destination = target.containsKey("type") ? this.createDestinationName(target.get("company"), target.get("domain"), this.getChannelTypeName(), target.get("type")) : this.createDestinationName(target.get("company"), target.get("domain"), this.getChannelTypeName(), null);
        ArrayList targetDomainConnections = new ArrayList();
        String[] targetSize = target.get("size").split("-");
        Constructor<?> con = null;
        try {
            Class<?> clazz = Class.forName(target.get("clazz"));
            con = clazz.getDeclaredConstructor(TmsSenderCommonConfig.class);
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("NoSuchMethodException ", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("SecurityException ", (Throwable)e);
        }
        for (int i = 0; i < Integer.parseInt(targetSize[1]); ++i) {
            ActiveMQConnection clientConnection = null;
            MessageConsumer consumer = null;
            Queue queue = null;
            Session session = null;
            try {
                clientConnection = (ActiveMQConnection)connectionFactory.createConnection();
                clientConnection.start();
                session = clientConnection.createSession(false, 1);
                queue = session.createQueue(destination);
                consumer = session.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)con.newInstance(this.tmsCommonConfig));
                log.debug("create consumer client ID : [{}] consumer : [{}] queue : [{}]", new Object[]{destination + "#" + i, consumer, queue});
                this.tmsMessageConsumers.put(destination, consumer);
                continue;
            }
            catch (Exception e) {
                log.error("create consumer error: {}", (Throwable)e);
            }
        }
        this.tmsConsumers.put(destination, targetDomainConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureJmsListener(ConnectionFactory connectionFactory, Map<String, String> target, TaskExecutor taskExecutor) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        log.info("target {}", (Object)target.toString());
        String domain = target.get("domain");
        String destination = null;
        destination = target.containsKey("type") ? this.createDestinationName(target.get("company"), target.get("domain"), this.getChannelTypeName(), target.get("type")) : this.createDestinationName(target.get("company"), target.get("domain"), this.getChannelTypeName(), null);
        if (this.targetConsumers.get(destination) == null) {
            TmsDefaultMessageListenerContainer container = new TmsDefaultMessageListenerContainer(target.get("domain"));
            container.setConnectionFactory(connectionFactory);
            container.setDestinationName(destination);
            container.setConcurrency(target.get("size"));
            container.setCacheLevel(3);
            container.setMaxMessagesPerTask(10);
            String[] targetSize = target.get("size").split("-");
            container.setIdleConsumerLimit(Integer.parseInt(targetSize[0]));
            Constructor<?> con = null;
            try {
                Class<?> clazz = Class.forName(target.get("clazz"));
                con = clazz.getDeclaredConstructor(TmsSenderCommonConfig.class);
            }
            catch (NoSuchMethodException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            container.setMessageListener(con.newInstance(this.tmsCommonConfig));
            container.setExceptionListener(this.tmsExceptionListener);
            container.afterPropertiesSet();
            container.start();
            log.info("Create consumer target Data create Consumer {}", (Object)container.isActive());
            container.setSubject(this.tmsChannelFactory);
            this.targetConsumers.put(destination, container);
            log.info("concurrent : {}", (Object)container.getConcurrentConsumers());
            log.info("activeConsemer : {} ", (Object)container.getActiveConsumerCount());
            log.info("getIdleConsumerLimit : {} ", (Object)container.getIdleConsumerLimit());
            log.info("setCacheLevel : {} ", (Object)container.getCacheLevel());
        } else {
            log.error("this domain [{}] is running", (Object)domain);
        }
    }

    public List<Map<String, String>> getChnDomain() {
        return this.chnDomain;
    }

    public ConcurrentHashMap<String, TmsDefaultMessageListenerContainer> getTargetConsumers() {
        return this.targetConsumers;
    }

    public ConcurrentHashMap<String, MessageConsumer> getTmsMessageConsumers() {
        return this.tmsMessageConsumers;
    }

    public ConcurrentHashMap<String, List<Connection>> getTmsConsumers() {
        return this.tmsConsumers;
    }

    public void setChannelTypeName(String channelTypeName) {
        this.channelTypeName = channelTypeName;
    }

    public String getChannelTypeName() {
        return this.channelTypeName;
    }
}

