/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.dns.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.humuson.tms.util.date.DateUtil;
import org.apache.commons.lang.StringUtils;

public class DnsModel {
    private final String DINFO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String mx;
    private String ip;
    private String hostName;
    private String useYn = "N";
    private String serverId;
    private String regDate;
    private String expirationDate = "";
    private String redisKey;
    private String redisField;
    private String redisValue;
    private String errorMsg;
    private int errorCnt = 0;
    private JsonArray mxList = new JsonArray();

    public JsonArray getMxList() {
        return this.mxList;
    }

    public int getErrorCnt() {
        return this.errorCnt;
    }

    public DnsModel setErrorCnt(int errorCnt) {
        this.errorCnt = errorCnt;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public DnsModel setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUseYn() {
        return this.useYn;
    }

    public String getMx() {
        return this.mx;
    }

    public String getRegDate() {
        return this.regDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public String getRedisField() {
        return this.redisField;
    }

    public String getRedisValue() {
        return this.redisValue;
    }

    public DnsModel(String hostName, String serverId) {
        this.hostName = hostName;
        this.serverId = serverId;
        this.regDate = DateUtil.getFullDate((String)"yyyy-MM-dd HH:mm:ss");
        this.expirationDate = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)7);
    }

    public DnsModel useYn(String useYn) {
        this.useYn = useYn;
        return this;
    }

    public DnsModel setMx(String mx) {
        this.mx = mx;
        return this;
    }

    public DnsModel setMx(String mx, JsonArray mxList) {
        this.mx = mx;
        this.mxList = mxList;
        return this;
    }

    public DnsModel setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String createValue() {
        JsonObject json = new JsonObject();
        json.addProperty("mx", this.mx);
        json.addProperty("ip", this.ip);
        if (StringUtils.isEmpty((String)this.errorMsg)) {
            json.addProperty("useYn", "Y");
        } else {
            json.addProperty("useYn", "D");
        }
        json.addProperty("regDate", this.regDate);
        json.addProperty("expirationDate", this.expirationDate);
        json.addProperty("errorMsg", this.errorMsg);
        json.addProperty("errorCnt", (Number)this.errorCnt);
        json.add("mxList", (JsonElement)this.mxList);
        return json.toString();
    }

    public DnsModel build() {
        this.redisKey = "DINFO".concat(":").concat("SD");
        this.redisField = this.hostName;
        this.redisValue = this.createValue();
        return this;
    }

    public String toString() {
        return "DnsModel(DINFO_DATE_FORMAT=" + this.DINFO_DATE_FORMAT + ", mx=" + this.getMx() + ", ip=" + this.getIp() + ", hostName=" + this.hostName + ", useYn=" + this.getUseYn() + ", serverId=" + this.serverId + ", regDate=" + this.getRegDate() + ", expirationDate=" + this.getExpirationDate() + ", redisKey=" + this.getRedisKey() + ", redisField=" + this.getRedisField() + ", redisValue=" + this.getRedisValue() + ", errorMsg=" + this.getErrorMsg() + ", errorCnt=" + this.getErrorCnt() + ", mxList=" + this.getMxList() + ")";
    }
}

