/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.dns;

import com.google.gson.JsonArray;
import com.humuson.tms.sender.dns.TmsDns;
import com.humuson.tms.sender.dns.model.DnsModel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.xbill.DNS.Address;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class DnsCheck {
    private static final Logger log = LoggerFactory.getLogger(DnsCheck.class);

    public DnsModel createMxRecord(String hostName, String serverId, String dnsIp) throws TextParseException, IOException {
        return this.createMxRecord(TmsDns.dnsModel(hostName, serverId), hostName);
    }

    public DnsModel createMxRecord(DnsModel dnsData, String hostName, List<Map<String, String>> dnsInfos, StringBuffer errorMsg) throws TextParseException, IOException {
        MXRecord mx = null;
        JsonArray mxList = new JsonArray();
        String mxRecordtoStr = null;
        try {
            for (Map<String, String> dnsIp : dnsInfos) {
                String ip = null;
                int port = 0;
                int timeOut = 5;
                if (dnsIp.containsKey("ip")) {
                    ip = dnsIp.get("ip");
                }
                if (dnsIp.containsKey("port")) {
                    port = Integer.parseInt(dnsIp.get("port"));
                }
                if (StringUtils.isEmpty((Object)ip) && port == 0) {
                    throw new NullPointerException("Check application-mail.yml, DNS information is incorrectly registered.");
                }
                log.debug("dns Search data : ip {} port {}", (Object)ip, (Object)port);
                SimpleResolver resolver = new SimpleResolver(ip);
                resolver.setTimeout(timeOut);
                resolver.setPort(port);
                Lookup lookup = null;
                lookup = new Lookup(hostName, 15);
                lookup.setResolver((Resolver)resolver);
                Record[] records = lookup.run();
                if (lookup.getResult() == 0) {
                    for (Record record : records) {
                        System.out.println((MXRecord)record);
                    }
                    if (records != null) {
                        mx = (MXRecord)records[0];
                        mxRecordtoStr = mx.getTarget().toString();
                        mxList.add(mxRecordtoStr);
                        boolean hasPriority = false;
                        if (records.length > 1) {
                            int priority = mx.getPriority();
                            for (int i = 1; i < records.length; ++i) {
                                MXRecord mxTemp = (MXRecord)records[i];
                                mxList.add(mxTemp.getTarget().toString());
                                int priorityTemp = mxTemp.getPriority();
                                if (priority != priorityTemp) {
                                    hasPriority = true;
                                }
                                if (priority <= priorityTemp) continue;
                                mx = mxTemp;
                                mxRecordtoStr = mxTemp.getTarget().toString();
                                priority = mxTemp.getPriority();
                            }
                        }
                        if (hasPriority) {
                            mxList = new JsonArray();
                        }
                    }
                    break;
                }
                System.out.println("this dns [" + dnsIp + "] ip is wrong ");
            }
        }
        catch (Exception e) {
            errorMsg.append(e.toString());
        }
        dnsData.setMx(mxRecordtoStr, mxList);
        return dnsData;
    }

    public DnsModel createMxRecord(String hostName, String serverId, String dnsIp, int dnsPort, int timeOut) throws TextParseException, IOException {
        SimpleResolver resolver = new SimpleResolver(dnsIp);
        resolver.setPort(dnsPort);
        resolver.setTimeout(timeOut);
        return this.createMxRecord(hostName, serverId, resolver);
    }

    public DnsModel checkEnableIpAdress(DnsModel dnsData, String hostName, StringBuffer errorMsg) {
        String domain = dnsData.getMx();
        if (StringUtils.isEmpty((Object)domain)) {
            domain = hostName;
        }
        String ip = null;
        try {
            InetAddress inets = Address.getByName((String)domain);
            ip = inets.getHostAddress();
        }
        catch (UnknownHostException e) {
            errorMsg.append(e.toString());
            dnsData.setErrorMsg(errorMsg.toString());
        }
        dnsData.setIp(ip);
        return dnsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnsModel checkEnableConnection(DnsModel dnsData, StringBuffer errorMsg) {
        int errorCnt = dnsData.getErrorCnt();
        boolean isError = false;
        Socket socket = null;
        String targetConnectionEndPoint = dnsData.getMx();
        if (StringUtils.isEmpty((Object)targetConnectionEndPoint)) {
            targetConnectionEndPoint = dnsData.getIp();
        }
        log.info("RESEARCH_DNS] recheck dns connection START domain [{}]/ errorCnt : {}", (Object)targetConnectionEndPoint, (Object)dnsData.getErrorCnt());
        if (errorCnt < 3) {
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(targetConnectionEndPoint, 25), 10000);
                errorCnt = 0;
            }
            catch (Exception e) {
                isError = true;
                errorMsg.append(e.toString());
                errorMsg.append(" [");
                errorMsg.append(targetConnectionEndPoint);
                errorMsg.append("]");
                ++errorCnt;
            }
            finally {
                try {
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                }
                catch (Exception e) {
                    log.error("Socket close Error.");
                }
            }
            if (isError) {
                dnsData.setErrorMsg(errorMsg.toString());
            }
            dnsData.setErrorCnt(errorCnt);
        }
        log.info("RESEARCH_DNS] recheck dns connection END domain [{}]/ errorCnt : {}", (Object)targetConnectionEndPoint, (Object)dnsData.getErrorCnt());
        return dnsData;
    }

    public DnsModel createMxRecord(String hostName, String serverId, SimpleResolver resolver) throws TextParseException, IOException {
        Lookup lookup = new Lookup(hostName, 15);
        lookup.setResolver((Resolver)resolver);
        Record[] records = null;
        String mxRecord = null;
        JsonArray mxList = new JsonArray();
        records = lookup.run();
        if (lookup.getResult() == 0 && records != null) {
            MXRecord mx = (MXRecord)records[0];
            mxRecord = mx.getTarget().toString();
            mxList.add(mxRecord);
            boolean hasPriority = false;
            if (records.length > 1) {
                int priority = mx.getPriority();
                for (int i = 1; i < records.length; ++i) {
                    MXRecord mxTemp = (MXRecord)records[i];
                    mxList.add(mxTemp.getTarget().toString());
                    int priorityTemp = mxTemp.getPriority();
                    if (priority != priorityTemp) {
                        hasPriority = true;
                    }
                    if (priority <= priorityTemp) continue;
                    mx = mxTemp;
                    mxRecord = mxTemp.getTarget().toString();
                    priority = mxTemp.getPriority();
                }
            }
            if (hasPriority) {
                mxList = new JsonArray();
            }
        }
        return TmsDns.dnsModel(hostName, serverId).setMx(mxRecord, mxList).build();
    }

    public DnsModel createMxRecord(DnsModel dnsData, String hostName) throws TextParseException, IOException {
        MXRecord mx = null;
        Record[] records = null;
        String mxRecord = null;
        JsonArray mxList = new JsonArray();
        records = new Lookup(hostName, 15).run();
        if (records != null) {
            mx = (MXRecord)records[0];
            mxRecord = mx.getTarget().toString();
            mxList.add(mxRecord);
            boolean hasPriority = false;
            if (records.length > 1) {
                int priority = mx.getPriority();
                for (int i = 1; i < records.length; ++i) {
                    MXRecord mxTemp = (MXRecord)records[i];
                    mxList.add(mxTemp.getTarget().toString());
                    int priorityTemp = mxTemp.getPriority();
                    if (priority != priorityTemp) {
                        hasPriority = true;
                    }
                    if (priority <= priorityTemp) continue;
                    mx = mxTemp;
                    mxRecord = mxTemp.getTarget().toString();
                    priority = mxTemp.getPriority();
                }
            }
            if (hasPriority) {
                mxList = new JsonArray();
            }
        }
        return dnsData.setMx(mxRecord, mxList);
    }

    public String getIpAdress(String domain) throws IOException {
        InetAddress inets = null;
        inets = Address.getByName((String)domain);
        return inets.getHostAddress();
    }
}

