/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config.example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.util.StringUtils;

public class YamlPropertiesProcessor
extends YamlProcessor {
    public YamlPropertiesProcessor(Resource resource) throws IOException {
        if (!resource.exists()) {
            throw new FileNotFoundException();
        }
        this.setResources(new Resource[]{resource});
    }

    public Properties createProperties() throws IOException {
        final Properties result = CollectionFactory.createStringAdaptingProperties();
        this.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                result.putAll((Map<?, ?>)properties);
            }
        });
        return result;
    }

    public class YamlResourcePropertySource
    extends PropertiesPropertySource {
        public YamlResourcePropertySource(String name, EncodedResource resource) throws IOException {
            super(name, new YamlPropertiesProcessor(resource.getResource()).createProperties());
        }
    }

    public class YamlPropertySourceFactory
    implements PropertySourceFactory {
        private static final String YML_FILE_EXTENSION = ".yml";

        public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
            String filename = resource.getResource().getFilename();
            if (filename != null && filename.endsWith(YML_FILE_EXTENSION)) {
                return name != null ? new YamlResourcePropertySource(name, resource) : new YamlResourcePropertySource(this.getNameForResource(resource.getResource()), resource);
            }
            return null;
        }

        private String getNameForResource(Resource resource) {
            String name = resource.getDescription();
            if (!StringUtils.hasText((String)name)) {
                name = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
            }
            return name;
        }
    }
}

