/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config.example;

import com.humuson.tms.sender.config.example.ApplicationProperties;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ApplicationPropertiesBindingPostProcessor
implements BeanFactoryAware,
ApplicationContextAware,
ResourceLoaderAware,
EnvironmentAware {
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Environment environment = new StandardEnvironment();

    @PostConstruct
    public void init() throws IOException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, BindException {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(ApplicationProperties.class);
        for (String beanName : beansWithAnnotation.keySet()) {
            Class<?> clazz = beansWithAnnotation.get(beanName).getClass();
            Object newInstance = this.bindPropertiesToTarget(clazz);
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)this.beanFactory;
            configurableListableBeanFactory.registerResolvableDependency(clazz, newInstance);
        }
    }

    private Object bindPropertiesToTarget(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, BindException {
        ApplicationProperties applicationProperties = clazz.getAnnotation(ApplicationProperties.class);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object newInstance = constructor.newInstance(new Object[0]);
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(newInstance);
        factory.setPropertySources(this.loadPropertySources(applicationProperties.locations()));
        factory.setConversionService((ConversionService)new DefaultConversionService());
        if (StringUtils.hasLength((String)applicationProperties.prefix())) {
            factory.setTargetName(applicationProperties.prefix());
        }
        try {
            factory.bindPropertiesToTarget();
        }
        catch (Exception ex) {
            String targetClass = ClassUtils.getShortName(clazz);
            throw new BeanCreationException(clazz.getSimpleName(), "Could not bind properties to " + targetClass + "(" + applicationProperties.toString() + ")", (Throwable)ex);
        }
        return newInstance;
    }

    private PropertySources loadPropertySources(String[] locations) {
        try {
            PropertySourcesLoader loader = new PropertySourcesLoader();
            for (String location : locations) {
                Resource resource = this.resourceLoader.getResource(this.environment.resolvePlaceholders(location));
                String[] profiles = this.environment.getActiveProfiles();
                int i = profiles.length;
                while (i-- > 0) {
                    String profile = profiles[i];
                    loader.load(resource, profile);
                }
                loader.load(resource);
            }
            return loader.getPropertySources();
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

