/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
@ConditionalOnProperty(prefix="tms.sender.sms", name={"useYn"}, havingValue="true", matchIfMissing=true)
public class TmsSmsConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsSmsConfig.class);
    @Value(value="${sms.sms.company}")
    public String smsCompany;
    @Value(value="${sms.sms.tableName}")
    public String smsTableName;
    @Value(value="${sms.mms.company}")
    public String mmsCompany;
    @Value(value="${sms.mms.tableName}")
    public String mmsTableName;
    @Value(value="${sms.mms.attach.seqData}")
    public String mmsAttachSeq;
    @Value(value="${sms.mms.tableName}")
    public String mmsAttachTable;
    @Value(value="${sms.lms.company}")
    public String lmsCompany;
    @Value(value="${sms.lms.tableName}")
    public String lmsTableName;
    @Value(value="${sms.db.url}")
    public String url;
    @Value(value="${sms.db.driver}")
    public String driver;
    @Value(value="${sms.db.user}")
    public String user;
    @Value(value="${sms.db.pwd}")
    public String pwd;
    @Value(value="${sms.db.dbType}")
    public String dbType;
    @Value(value="${sms.sms.sequnce}")
    public String atSequnce;
    @Value(value="${sms.sms.generatedKey}")
    public String atGeneratedKey;
    String encKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;
    @Autowired
    @Qualifier(value="createSmsJdbcTemplate")
    JdbcTemplate smsJdbcTemplate;

    @PostConstruct
    public void onPost() {
        this.encKey = this.tmsCommonConfig.getHumusonKey();
    }

    @Bean(name={"createSmsJdbcTemplate"})
    public JdbcTemplate createJdbcTemplate() {
        log.info("SENDER] SMS Jdbc Template CONNECTION");
        this.smsJdbcTemplate = new JdbcTemplate(this.getDataSource());
        return this.smsJdbcTemplate;
    }

    public DataSource getDataSource() {
        if (this.encKey == null) {
            this.encKey = this.tmsCommonConfig.getHumusonKey();
        }
        DriverManagerDataSource dataSource = null;
        try {
            String decPwd = HumusonDecryptor.decrypt((String)this.pwd, (String)this.encKey);
            dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(this.driver);
            dataSource.setUrl(this.url);
            dataSource.setUsername(this.user);
            dataSource.setPassword(decPwd);
        }
        catch (Exception e) {
            log.error("SENDER] SMS create datasource Error : {}", (Throwable)e);
        }
        return dataSource;
    }

    public String getSmsCompany() {
        return this.smsCompany;
    }

    public String getSmsTableName() {
        return this.smsTableName;
    }

    public String getMmsCompany() {
        return this.mmsCompany;
    }

    public String getMmsTableName() {
        return this.mmsTableName;
    }

    public String getMmsAttachSeq() {
        return this.mmsAttachSeq;
    }

    public String getMmsAttachTable() {
        return this.mmsAttachTable;
    }

    public String getLmsCompany() {
        return this.lmsCompany;
    }

    public String getLmsTableName() {
        return this.lmsTableName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getAtSequnce() {
        return this.atSequnce;
    }

    public String getAtGeneratedKey() {
        return this.atGeneratedKey;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public TmsCommonConfig getTmsCommonConfig() {
        return this.tmsCommonConfig;
    }

    public JdbcTemplate getSmsJdbcTemplate() {
        return this.smsJdbcTemplate;
    }

    public void setSmsCompany(String smsCompany) {
        this.smsCompany = smsCompany;
    }

    public void setSmsTableName(String smsTableName) {
        this.smsTableName = smsTableName;
    }

    public void setMmsCompany(String mmsCompany) {
        this.mmsCompany = mmsCompany;
    }

    public void setMmsTableName(String mmsTableName) {
        this.mmsTableName = mmsTableName;
    }

    public void setMmsAttachSeq(String mmsAttachSeq) {
        this.mmsAttachSeq = mmsAttachSeq;
    }

    public void setMmsAttachTable(String mmsAttachTable) {
        this.mmsAttachTable = mmsAttachTable;
    }

    public void setLmsCompany(String lmsCompany) {
        this.lmsCompany = lmsCompany;
    }

    public void setLmsTableName(String lmsTableName) {
        this.lmsTableName = lmsTableName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setAtSequnce(String atSequnce) {
        this.atSequnce = atSequnce;
    }

    public void setAtGeneratedKey(String atGeneratedKey) {
        this.atGeneratedKey = atGeneratedKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public void setTmsCommonConfig(TmsCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
    }

    public void setSmsJdbcTemplate(JdbcTemplate smsJdbcTemplate) {
        this.smsJdbcTemplate = smsJdbcTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsSmsConfig)) {
            return false;
        }
        TmsSmsConfig other = (TmsSmsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$smsCompany = this.getSmsCompany();
        String other$smsCompany = other.getSmsCompany();
        if (this$smsCompany == null ? other$smsCompany != null : !this$smsCompany.equals(other$smsCompany)) {
            return false;
        }
        String this$smsTableName = this.getSmsTableName();
        String other$smsTableName = other.getSmsTableName();
        if (this$smsTableName == null ? other$smsTableName != null : !this$smsTableName.equals(other$smsTableName)) {
            return false;
        }
        String this$mmsCompany = this.getMmsCompany();
        String other$mmsCompany = other.getMmsCompany();
        if (this$mmsCompany == null ? other$mmsCompany != null : !this$mmsCompany.equals(other$mmsCompany)) {
            return false;
        }
        String this$mmsTableName = this.getMmsTableName();
        String other$mmsTableName = other.getMmsTableName();
        if (this$mmsTableName == null ? other$mmsTableName != null : !this$mmsTableName.equals(other$mmsTableName)) {
            return false;
        }
        String this$mmsAttachSeq = this.getMmsAttachSeq();
        String other$mmsAttachSeq = other.getMmsAttachSeq();
        if (this$mmsAttachSeq == null ? other$mmsAttachSeq != null : !this$mmsAttachSeq.equals(other$mmsAttachSeq)) {
            return false;
        }
        String this$mmsAttachTable = this.getMmsAttachTable();
        String other$mmsAttachTable = other.getMmsAttachTable();
        if (this$mmsAttachTable == null ? other$mmsAttachTable != null : !this$mmsAttachTable.equals(other$mmsAttachTable)) {
            return false;
        }
        String this$lmsCompany = this.getLmsCompany();
        String other$lmsCompany = other.getLmsCompany();
        if (this$lmsCompany == null ? other$lmsCompany != null : !this$lmsCompany.equals(other$lmsCompany)) {
            return false;
        }
        String this$lmsTableName = this.getLmsTableName();
        String other$lmsTableName = other.getLmsTableName();
        if (this$lmsTableName == null ? other$lmsTableName != null : !this$lmsTableName.equals(other$lmsTableName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pwd = this.getPwd();
        String other$pwd = other.getPwd();
        if (this$pwd == null ? other$pwd != null : !this$pwd.equals(other$pwd)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$atSequnce = this.getAtSequnce();
        String other$atSequnce = other.getAtSequnce();
        if (this$atSequnce == null ? other$atSequnce != null : !this$atSequnce.equals(other$atSequnce)) {
            return false;
        }
        String this$atGeneratedKey = this.getAtGeneratedKey();
        String other$atGeneratedKey = other.getAtGeneratedKey();
        if (this$atGeneratedKey == null ? other$atGeneratedKey != null : !this$atGeneratedKey.equals(other$atGeneratedKey)) {
            return false;
        }
        String this$encKey = this.getEncKey();
        String other$encKey = other.getEncKey();
        if (this$encKey == null ? other$encKey != null : !this$encKey.equals(other$encKey)) {
            return false;
        }
        TmsCommonConfig this$tmsCommonConfig = this.getTmsCommonConfig();
        TmsCommonConfig other$tmsCommonConfig = other.getTmsCommonConfig();
        if (this$tmsCommonConfig == null ? other$tmsCommonConfig != null : !this$tmsCommonConfig.equals(other$tmsCommonConfig)) {
            return false;
        }
        JdbcTemplate this$smsJdbcTemplate = this.getSmsJdbcTemplate();
        JdbcTemplate other$smsJdbcTemplate = other.getSmsJdbcTemplate();
        return !(this$smsJdbcTemplate == null ? other$smsJdbcTemplate != null : !this$smsJdbcTemplate.equals(other$smsJdbcTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsSmsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $smsCompany = this.getSmsCompany();
        result = result * 59 + ($smsCompany == null ? 0 : $smsCompany.hashCode());
        String $smsTableName = this.getSmsTableName();
        result = result * 59 + ($smsTableName == null ? 0 : $smsTableName.hashCode());
        String $mmsCompany = this.getMmsCompany();
        result = result * 59 + ($mmsCompany == null ? 0 : $mmsCompany.hashCode());
        String $mmsTableName = this.getMmsTableName();
        result = result * 59 + ($mmsTableName == null ? 0 : $mmsTableName.hashCode());
        String $mmsAttachSeq = this.getMmsAttachSeq();
        result = result * 59 + ($mmsAttachSeq == null ? 0 : $mmsAttachSeq.hashCode());
        String $mmsAttachTable = this.getMmsAttachTable();
        result = result * 59 + ($mmsAttachTable == null ? 0 : $mmsAttachTable.hashCode());
        String $lmsCompany = this.getLmsCompany();
        result = result * 59 + ($lmsCompany == null ? 0 : $lmsCompany.hashCode());
        String $lmsTableName = this.getLmsTableName();
        result = result * 59 + ($lmsTableName == null ? 0 : $lmsTableName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 0 : $driver.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 0 : $user.hashCode());
        String $pwd = this.getPwd();
        result = result * 59 + ($pwd == null ? 0 : $pwd.hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 0 : $dbType.hashCode());
        String $atSequnce = this.getAtSequnce();
        result = result * 59 + ($atSequnce == null ? 0 : $atSequnce.hashCode());
        String $atGeneratedKey = this.getAtGeneratedKey();
        result = result * 59 + ($atGeneratedKey == null ? 0 : $atGeneratedKey.hashCode());
        String $encKey = this.getEncKey();
        result = result * 59 + ($encKey == null ? 0 : $encKey.hashCode());
        TmsCommonConfig $tmsCommonConfig = this.getTmsCommonConfig();
        result = result * 59 + ($tmsCommonConfig == null ? 0 : $tmsCommonConfig.hashCode());
        JdbcTemplate $smsJdbcTemplate = this.getSmsJdbcTemplate();
        result = result * 59 + ($smsJdbcTemplate == null ? 0 : $smsJdbcTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "TmsSmsConfig(smsCompany=" + this.getSmsCompany() + ", smsTableName=" + this.getSmsTableName() + ", mmsCompany=" + this.getMmsCompany() + ", mmsTableName=" + this.getMmsTableName() + ", mmsAttachSeq=" + this.getMmsAttachSeq() + ", mmsAttachTable=" + this.getMmsAttachTable() + ", lmsCompany=" + this.getLmsCompany() + ", lmsTableName=" + this.getLmsTableName() + ", url=" + this.getUrl() + ", driver=" + this.getDriver() + ", user=" + this.getUser() + ", pwd=" + this.getPwd() + ", dbType=" + this.getDbType() + ", atSequnce=" + this.getAtSequnce() + ", atGeneratedKey=" + this.getAtGeneratedKey() + ", encKey=" + this.getEncKey() + ", tmsCommonConfig=" + this.getTmsCommonConfig() + ", smsJdbcTemplate=" + this.getSmsJdbcTemplate() + ")";
    }
}

