/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.sender.common.util.SenderUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.sender.push", name={"useYn"}, havingValue="true", matchIfMissing=true)
public class TmsPushConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsPushConfig.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    SenderUtil senderUtil;
    Map<String, Map<Object, Object>> appInfoCacheMap = new ConcurrentHashMap<String, Map<Object, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAppInfoKey(String appGrpKey) {
        boolean result;
        block6: {
            result = false;
            try {
                if (this.appInfoCacheMap.containsKey(appGrpKey)) {
                    return true;
                }
                result = this.wrapperRedisTemplate.hasKey("AINFO".concat(":").concat(appGrpKey));
                if (!result) break block6;
                Map<String, Map<Object, Object>> map = this.appInfoCacheMap;
                synchronized (map) {
                    this.appInfoCacheMap.put(appGrpKey, this.readAppInfos(appGrpKey));
                }
            }
            catch (Exception e) {
                log.error("read App infos data Error {}", (Throwable)e);
            }
        }
        return result;
    }

    public Map<Object, Object> readAppInfos(String appGrpId) {
        Map appinfos = null;
        try {
            if (!this.appInfoCacheMap.containsKey(appGrpId)) {
                appinfos = this.wrapperRedisTemplate.hgetAll("AINFO".concat(":").concat(appGrpId));
                this.appInfoCacheMap.put(appGrpId, appinfos);
            }
            appinfos = this.appInfoCacheMap.get(appGrpId);
        }
        catch (Exception e) {
            log.error("read App infos data Error {}", (Throwable)e);
        }
        return appinfos;
    }

    public Map<Object, Object> readAppInfo(String key) {
        Map appinfos = null;
        try {
            appinfos = this.wrapperRedisTemplate.hgetAll(key);
        }
        catch (Exception e) {
            log.error("read App infos data Error {}", (Throwable)e);
        }
        return appinfos;
    }

    public List<String> scanAppInfos() {
        List appinfoKeys = null;
        try {
            appinfoKeys = this.wrapperRedisTemplate.scan("AINFO", 1000, 1000);
        }
        catch (Exception e) {
            log.error("read App infos data Error {}", (Throwable)e);
        }
        return appinfoKeys;
    }
}

