/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config;

import com.humuson.tms.sender.common.domain.MailPropSetConfiger;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="tms.sender.mail", name={"useYn"}, havingValue="true", matchIfMissing=true)
public class TmsMailConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsMailConfig.class);
    @Autowired
    MailPropSetConfiger mailPropSetConfiger;
    @Autowired
    @Qualifier(value="MailEventGrp")
    public ConcurrentHashMap<String, NioEventLoopGroup> mailEventGrp;
    @Value(value="${mail.smtp.localhost}")
    String localhost;
    @Value(value="${mail.smtp.nicIp}")
    String nicIp;
    String relayDomain;
    @Value(value="${mail.relay.server:none}")
    String relayServer;
    @Value(value="${mail.relay.enable}")
    String relayEnable;
    @Value(value="${mail.relay.dev}")
    String relayDev;
    @Value(value="${mail.relay.stg}")
    String relayStg;
    @Value(value="${mail.relay.prd}")
    String relayPrd;
    @Value(value="${mail.dnsOff:false}")
    boolean dnsOff;

    public String getRelayDomain() {
        if (this.relayServer.equalsIgnoreCase("dev")) {
            return this.relayDev;
        }
        if (this.relayServer.equalsIgnoreCase("stg")) {
            return this.relayStg;
        }
        if (this.relayServer.equalsIgnoreCase("prd")) {
            return this.relayPrd;
        }
        return this.relayStg;
    }

    @Bean(name={"MailEventGrp"})
    public ConcurrentHashMap<String, NioEventLoopGroup> CreateMailEventGrp() {
        ConcurrentHashMap<String, NioEventLoopGroup> emailEventGrp = new ConcurrentHashMap<String, NioEventLoopGroup>();
        NioEventLoopGroup evenGrp = null;
        for (Map<String, String> target : this.mailPropSetConfiger.getMass()) {
            if (target.get("domain").equals("default")) {
                log.info("[SD] create EventLoopGroup default : {}", (Object)this.createEventLoopKey(target));
                log.info("[SD] create EventLoopGroup default : create eventGrp skil");
                evenGrp = new NioEventLoopGroup(200);
                emailEventGrp.put(this.createEventLoopKey(target), evenGrp);
                continue;
            }
            log.info("[SD] create EventLoopGroup : {}", (Object)this.createEventLoopKey(target));
            evenGrp = new NioEventLoopGroup(10);
            emailEventGrp.put(this.createEventLoopKey(target), evenGrp);
        }
        emailEventGrp.put("etc.default", new NioEventLoopGroup(200));
        return emailEventGrp;
    }

    public String createEventLoopKey(Map<String, String> target) {
        return target.get("type").concat(".mail.").concat(target.get("company")).concat(".").concat(target.get("domain"));
    }

    public MailPropSetConfiger getMailPropSetConfiger() {
        return this.mailPropSetConfiger;
    }

    public ConcurrentHashMap<String, NioEventLoopGroup> getMailEventGrp() {
        return this.mailEventGrp;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public String getNicIp() {
        return this.nicIp;
    }

    public String getRelayServer() {
        return this.relayServer;
    }

    public String getRelayEnable() {
        return this.relayEnable;
    }

    public String getRelayDev() {
        return this.relayDev;
    }

    public String getRelayStg() {
        return this.relayStg;
    }

    public String getRelayPrd() {
        return this.relayPrd;
    }

    public boolean isDnsOff() {
        return this.dnsOff;
    }

    public void setMailPropSetConfiger(MailPropSetConfiger mailPropSetConfiger) {
        this.mailPropSetConfiger = mailPropSetConfiger;
    }

    public void setMailEventGrp(ConcurrentHashMap<String, NioEventLoopGroup> mailEventGrp) {
        this.mailEventGrp = mailEventGrp;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public void setNicIp(String nicIp) {
        this.nicIp = nicIp;
    }

    public void setRelayDomain(String relayDomain) {
        this.relayDomain = relayDomain;
    }

    public void setRelayServer(String relayServer) {
        this.relayServer = relayServer;
    }

    public void setRelayEnable(String relayEnable) {
        this.relayEnable = relayEnable;
    }

    public void setRelayDev(String relayDev) {
        this.relayDev = relayDev;
    }

    public void setRelayStg(String relayStg) {
        this.relayStg = relayStg;
    }

    public void setRelayPrd(String relayPrd) {
        this.relayPrd = relayPrd;
    }

    public void setDnsOff(boolean dnsOff) {
        this.dnsOff = dnsOff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsMailConfig)) {
            return false;
        }
        TmsMailConfig other = (TmsMailConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MailPropSetConfiger this$mailPropSetConfiger = this.getMailPropSetConfiger();
        MailPropSetConfiger other$mailPropSetConfiger = other.getMailPropSetConfiger();
        if (this$mailPropSetConfiger == null ? other$mailPropSetConfiger != null : !this$mailPropSetConfiger.equals(other$mailPropSetConfiger)) {
            return false;
        }
        ConcurrentHashMap<String, NioEventLoopGroup> this$mailEventGrp = this.getMailEventGrp();
        ConcurrentHashMap<String, NioEventLoopGroup> other$mailEventGrp = other.getMailEventGrp();
        if (this$mailEventGrp == null ? other$mailEventGrp != null : !((Object)this$mailEventGrp).equals(other$mailEventGrp)) {
            return false;
        }
        String this$localhost = this.getLocalhost();
        String other$localhost = other.getLocalhost();
        if (this$localhost == null ? other$localhost != null : !this$localhost.equals(other$localhost)) {
            return false;
        }
        String this$nicIp = this.getNicIp();
        String other$nicIp = other.getNicIp();
        if (this$nicIp == null ? other$nicIp != null : !this$nicIp.equals(other$nicIp)) {
            return false;
        }
        String this$relayDomain = this.getRelayDomain();
        String other$relayDomain = other.getRelayDomain();
        if (this$relayDomain == null ? other$relayDomain != null : !this$relayDomain.equals(other$relayDomain)) {
            return false;
        }
        String this$relayServer = this.getRelayServer();
        String other$relayServer = other.getRelayServer();
        if (this$relayServer == null ? other$relayServer != null : !this$relayServer.equals(other$relayServer)) {
            return false;
        }
        String this$relayEnable = this.getRelayEnable();
        String other$relayEnable = other.getRelayEnable();
        if (this$relayEnable == null ? other$relayEnable != null : !this$relayEnable.equals(other$relayEnable)) {
            return false;
        }
        String this$relayDev = this.getRelayDev();
        String other$relayDev = other.getRelayDev();
        if (this$relayDev == null ? other$relayDev != null : !this$relayDev.equals(other$relayDev)) {
            return false;
        }
        String this$relayStg = this.getRelayStg();
        String other$relayStg = other.getRelayStg();
        if (this$relayStg == null ? other$relayStg != null : !this$relayStg.equals(other$relayStg)) {
            return false;
        }
        String this$relayPrd = this.getRelayPrd();
        String other$relayPrd = other.getRelayPrd();
        if (this$relayPrd == null ? other$relayPrd != null : !this$relayPrd.equals(other$relayPrd)) {
            return false;
        }
        return this.isDnsOff() == other.isDnsOff();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsMailConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MailPropSetConfiger $mailPropSetConfiger = this.getMailPropSetConfiger();
        result = result * 59 + ($mailPropSetConfiger == null ? 0 : $mailPropSetConfiger.hashCode());
        ConcurrentHashMap<String, NioEventLoopGroup> $mailEventGrp = this.getMailEventGrp();
        result = result * 59 + ($mailEventGrp == null ? 0 : ((Object)$mailEventGrp).hashCode());
        String $localhost = this.getLocalhost();
        result = result * 59 + ($localhost == null ? 0 : $localhost.hashCode());
        String $nicIp = this.getNicIp();
        result = result * 59 + ($nicIp == null ? 0 : $nicIp.hashCode());
        String $relayDomain = this.getRelayDomain();
        result = result * 59 + ($relayDomain == null ? 0 : $relayDomain.hashCode());
        String $relayServer = this.getRelayServer();
        result = result * 59 + ($relayServer == null ? 0 : $relayServer.hashCode());
        String $relayEnable = this.getRelayEnable();
        result = result * 59 + ($relayEnable == null ? 0 : $relayEnable.hashCode());
        String $relayDev = this.getRelayDev();
        result = result * 59 + ($relayDev == null ? 0 : $relayDev.hashCode());
        String $relayStg = this.getRelayStg();
        result = result * 59 + ($relayStg == null ? 0 : $relayStg.hashCode());
        String $relayPrd = this.getRelayPrd();
        result = result * 59 + ($relayPrd == null ? 0 : $relayPrd.hashCode());
        result = result * 59 + (this.isDnsOff() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TmsMailConfig(mailPropSetConfiger=" + this.getMailPropSetConfiger() + ", mailEventGrp=" + this.getMailEventGrp() + ", localhost=" + this.getLocalhost() + ", nicIp=" + this.getNicIp() + ", relayDomain=" + this.getRelayDomain() + ", relayServer=" + this.getRelayServer() + ", relayEnable=" + this.getRelayEnable() + ", relayDev=" + this.getRelayDev() + ", relayStg=" + this.getRelayStg() + ", relayPrd=" + this.getRelayPrd() + ", dnsOff=" + this.isDnsOff() + ")";
    }
}

