/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
@ConditionalOnProperty(prefix="tms.sender.biz", name={"useYn"}, havingValue="true", matchIfMissing=true)
public class TmsBizTalkConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsBizTalkConfig.class);
    @Value(value="${biz.db.url}")
    public String url;
    @Value(value="${biz.db.driver}")
    public String driver;
    @Value(value="${biz.db.user}")
    public String user;
    @Value(value="${biz.db.pwd}")
    public String pwd;
    @Value(value="${biz.db.dbType}")
    public String dbType;
    @Value(value="${biz.AT.tableName}")
    public String atTable;
    @Value(value="${biz.AT.company}")
    public String atCompany;
    @Value(value="${biz.AT.sequnce}")
    public String atSequnce;
    @Value(value="${biz.AT.generatedKey}")
    public String atGeneratedKey;
    String encKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;
    @Autowired
    @Qualifier(value="createBizJdbcTemplate")
    JdbcTemplate jdbcTemplate;

    @PostConstruct
    public void onPost() {
        this.encKey = this.tmsCommonConfig.getHumusonKey();
    }

    @Bean(name={"createBizJdbcTemplate"})
    public JdbcTemplate createJdbcTemplate() {
        log.info("SENDER] BIZTALK Jdbc Template CONNECTION");
        this.jdbcTemplate = new JdbcTemplate(this.getDataSource());
        return this.jdbcTemplate;
    }

    public DataSource getDataSource() {
        if (this.encKey == null) {
            this.encKey = this.tmsCommonConfig.getHumusonKey();
        }
        DriverManagerDataSource dataSource = null;
        try {
            String decPwd = HumusonDecryptor.decrypt((String)this.pwd, (String)this.encKey);
            dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(this.driver);
            dataSource.setUrl(this.url);
            dataSource.setUsername(this.user);
            dataSource.setPassword(decPwd);
        }
        catch (Exception e) {
            log.error("SENDER] BIZTALK create datasource Error : {}", (Throwable)e);
        }
        return dataSource;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getAtTable() {
        return this.atTable;
    }

    public String getAtCompany() {
        return this.atCompany;
    }

    public String getAtSequnce() {
        return this.atSequnce;
    }

    public String getAtGeneratedKey() {
        return this.atGeneratedKey;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public TmsCommonConfig getTmsCommonConfig() {
        return this.tmsCommonConfig;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setAtTable(String atTable) {
        this.atTable = atTable;
    }

    public void setAtCompany(String atCompany) {
        this.atCompany = atCompany;
    }

    public void setAtSequnce(String atSequnce) {
        this.atSequnce = atSequnce;
    }

    public void setAtGeneratedKey(String atGeneratedKey) {
        this.atGeneratedKey = atGeneratedKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public void setTmsCommonConfig(TmsCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsBizTalkConfig)) {
            return false;
        }
        TmsBizTalkConfig other = (TmsBizTalkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pwd = this.getPwd();
        String other$pwd = other.getPwd();
        if (this$pwd == null ? other$pwd != null : !this$pwd.equals(other$pwd)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$atTable = this.getAtTable();
        String other$atTable = other.getAtTable();
        if (this$atTable == null ? other$atTable != null : !this$atTable.equals(other$atTable)) {
            return false;
        }
        String this$atCompany = this.getAtCompany();
        String other$atCompany = other.getAtCompany();
        if (this$atCompany == null ? other$atCompany != null : !this$atCompany.equals(other$atCompany)) {
            return false;
        }
        String this$atSequnce = this.getAtSequnce();
        String other$atSequnce = other.getAtSequnce();
        if (this$atSequnce == null ? other$atSequnce != null : !this$atSequnce.equals(other$atSequnce)) {
            return false;
        }
        String this$atGeneratedKey = this.getAtGeneratedKey();
        String other$atGeneratedKey = other.getAtGeneratedKey();
        if (this$atGeneratedKey == null ? other$atGeneratedKey != null : !this$atGeneratedKey.equals(other$atGeneratedKey)) {
            return false;
        }
        String this$encKey = this.getEncKey();
        String other$encKey = other.getEncKey();
        if (this$encKey == null ? other$encKey != null : !this$encKey.equals(other$encKey)) {
            return false;
        }
        TmsCommonConfig this$tmsCommonConfig = this.getTmsCommonConfig();
        TmsCommonConfig other$tmsCommonConfig = other.getTmsCommonConfig();
        if (this$tmsCommonConfig == null ? other$tmsCommonConfig != null : !this$tmsCommonConfig.equals(other$tmsCommonConfig)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        return !(this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsBizTalkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 0 : $driver.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 0 : $user.hashCode());
        String $pwd = this.getPwd();
        result = result * 59 + ($pwd == null ? 0 : $pwd.hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 0 : $dbType.hashCode());
        String $atTable = this.getAtTable();
        result = result * 59 + ($atTable == null ? 0 : $atTable.hashCode());
        String $atCompany = this.getAtCompany();
        result = result * 59 + ($atCompany == null ? 0 : $atCompany.hashCode());
        String $atSequnce = this.getAtSequnce();
        result = result * 59 + ($atSequnce == null ? 0 : $atSequnce.hashCode());
        String $atGeneratedKey = this.getAtGeneratedKey();
        result = result * 59 + ($atGeneratedKey == null ? 0 : $atGeneratedKey.hashCode());
        String $encKey = this.getEncKey();
        result = result * 59 + ($encKey == null ? 0 : $encKey.hashCode());
        TmsCommonConfig $tmsCommonConfig = this.getTmsCommonConfig();
        result = result * 59 + ($tmsCommonConfig == null ? 0 : $tmsCommonConfig.hashCode());
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 0 : $jdbcTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "TmsBizTalkConfig(url=" + this.getUrl() + ", driver=" + this.getDriver() + ", user=" + this.getUser() + ", pwd=" + this.getPwd() + ", dbType=" + this.getDbType() + ", atTable=" + this.getAtTable() + ", atCompany=" + this.getAtCompany() + ", atSequnce=" + this.getAtSequnce() + ", atGeneratedKey=" + this.getAtGeneratedKey() + ", encKey=" + this.getEncKey() + ", tmsCommonConfig=" + this.getTmsCommonConfig() + ", jdbcTemplate=" + this.getJdbcTemplate() + ")";
    }
}

