/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.config;

import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.sender.common.domain.BizPropSetConfiger;
import com.humuson.tms.sender.common.domain.LinePropSetConfiger;
import com.humuson.tms.sender.common.domain.MailPropSetConfiger;
import com.humuson.tms.sender.common.domain.PushPropSetConfiger;
import com.humuson.tms.sender.common.domain.SmsPropSetConfiger;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.factory.TmsCreateSenderFactory;
import com.humuson.tms.sender.jms.TmsMessageListenerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyConfigure {
    @Value(value="${tms.sender.push.useYn:false}")
    private boolean isMonitorPush;
    @Value(value="${tms.sender.mail.useYn:false}")
    private boolean isMonitorMail;
    @Value(value="${tms.sender.sms.useYn:false}")
    private boolean isMonitorSms;
    @Value(value="${tms.sender.biz.useYn:false}")
    private boolean isMonitorBiz;
    @Value(value="${tms.sender.line.useYn:false}")
    private boolean isMonitorLn;
    @Autowired(required=false)
    TmsSenderCommonConfig tmsSenderCommonConfig;
    @Autowired
    MailPropSetConfiger mailPropSetConfiger;
    @Autowired
    SmsPropSetConfiger smsPropSetConfiger;
    @Autowired
    BizPropSetConfiger bizPropSetConfiger;
    @Autowired
    LinePropSetConfiger linePropSetConfiger;
    @Autowired
    PushPropSetConfiger pushPropSetConfiger;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    @Qualifier(value="activemq-sender")
    ActiveMQSender sender;

    @Bean(name={"tmsChannelFactory"})
    @Qualifier(value="tmsChannelFactory")
    public TmsMessageListenerFactory createMessageFactory() {
        TmsMessageListenerFactory tmsMessageListenerFactory = new TmsMessageListenerFactory();
        return tmsMessageListenerFactory;
    }

    @Bean(name={"mailFactory"})
    @Qualifier(value="mailFactory")
    public TmsCreateSenderFactory processMail() throws IllegalArgumentException, SecurityException {
        if (this.isMonitorMail) {
            TmsCreateSenderFactory mailFactory = new TmsCreateSenderFactory(this.mailPropSetConfiger.getMass());
            mailFactory.setChannelTypeName("mail");
            return mailFactory;
        }
        return null;
    }

    @Bean(name={"smsFactory"})
    @Qualifier(value="smsFactory")
    public TmsCreateSenderFactory processSms() throws IllegalArgumentException, SecurityException {
        if (this.isMonitorSms) {
            TmsCreateSenderFactory smsFacotry = new TmsCreateSenderFactory(this.smsPropSetConfiger.getMass());
            smsFacotry.setChannelTypeName("sms");
            return smsFacotry;
        }
        return null;
    }

    @Bean(name={"pushFactory"})
    @Qualifier(value="pushFactory")
    public TmsCreateSenderFactory processPush() throws IllegalArgumentException, SecurityException {
        if (this.isMonitorPush) {
            TmsCreateSenderFactory pushFacotry = new TmsCreateSenderFactory(this.pushPropSetConfiger.getMass());
            pushFacotry.setChannelTypeName("push");
            return pushFacotry;
        }
        return null;
    }

    @Bean(name={"bizFactory"})
    @Qualifier(value="bizFactory")
    public TmsCreateSenderFactory processBiz() throws IllegalArgumentException, SecurityException {
        if (this.isMonitorBiz) {
            TmsCreateSenderFactory bizFactory = new TmsCreateSenderFactory(this.bizPropSetConfiger.getMass());
            bizFactory.setChannelTypeName("biz");
            return bizFactory;
        }
        return null;
    }

    @Bean(name={"lineFactory"})
    @Qualifier(value="lineFactory")
    public TmsCreateSenderFactory processLine() throws IllegalArgumentException, SecurityException {
        if (this.isMonitorLn) {
            TmsCreateSenderFactory lineFactory = new TmsCreateSenderFactory(this.linePropSetConfiger.getMass());
            lineFactory.setChannelTypeName("line");
            return lineFactory;
        }
        return null;
    }
}

