/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.common.util;

import com.humuson.tms.config.Constants;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.mail.model.TmsEmailVo;
import com.humuson.tms.sender.result.ResultBuilder;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.FileUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SenderUtil {
    private static final Logger log = LoggerFactory.getLogger(SenderUtil.class);
    public static final String NEXT_VAL = ".NEXTVAL";
    static ConnectionPool connectionPool = new ConnectionPool();

    public JSONObject MQmsgToJObj(Message message) throws JMSException, JSONException {
        String mstToStrData = this.MQmsgToStr(message);
        if (log.isDebugEnabled()) {
            log.debug("MQ receiveData : {}", (Object)mstToStrData);
            log.debug("MQ message : {}", (Object)message);
        }
        if (!"Do Notting".equals(mstToStrData) || mstToStrData == null || !"".equals(mstToStrData)) {
            return this.jsonObjParser(mstToStrData);
        }
        return null;
    }

    public static void init() {
    }

    public static String decryptKeyForEncrypt(String key) {
        try {
            return HumusonDecryptor.decrypt((String)key);
        }
        catch (Exception e) {
            log.error("humuson decrypt error so orginal key return", (Throwable)e);
            return key;
        }
    }

    public static String createContent(TmsEmailVo tmsEmailVo, String lang) throws Exception {
        String content = null;
        try {
            content = tmsEmailVo.isCheckContentUrlYn() ? SenderUtil.getContent(tmsEmailVo.getContentUrl(), lang) : FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
        }
        catch (IOException e) {
            log.info("[URL read boolean : {} ]first read content File error {}", (Object)tmsEmailVo.isCheckContentUrlYn(), (Object)e.toString());
            log.info("This Content Url : [{}], path : [{}]", (Object)tmsEmailVo.getContentUrl(), (Object)tmsEmailVo.getContentPath());
            try {
                content = FileUtil.readLocal((String)tmsEmailVo.getContentPath(), (String)lang);
            }
            catch (Exception e2) {
                log.error("read content File error {}", (Object)e2.toString());
                throw e2;
            }
        }
        catch (Exception e) {
            log.error("read content Url or File error {}", (Object)e.toString());
            throw e;
        }
        if (content == null || content.trim().isEmpty()) {
            log.error("This Content is Empty. Url : [{}], path : [{}]", (Object)tmsEmailVo.getContentUrl(), (Object)tmsEmailVo.getContentPath());
            throw new Exception("This Content is Empty. Url : [" + tmsEmailVo.getContentUrl() + "], path : [" + tmsEmailVo.getContentPath() + "]");
        }
        if (content.indexOf("@TMS_M_TARGET@") > -1) {
            content = content.replace("@TMS_M_TARGET@", tmsEmailVo.getTmsMEmail());
        }
        return content;
    }

    public static String getPINFOKey(String tlistKey) {
        String[] target = tlistKey.split(":");
        if (target[0].equals("TLIST") || target[0].equals("QLIST")) {
            return "PINFO".concat(":").concat(target[1]);
        }
        return "SchdID:ERROR";
    }

    public JSONObject jsonObjParser(String jsonToString) throws JSONException {
        return new JSONObject(jsonToString);
    }

    public String MQmsgToStr(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return textMessage.getText();
        }
        return "Do Notting";
    }

    public static String getContent(String url, String charset) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        try {
            String PROTOCOL = "SSL";
            SSLContext sslContext = SSLContext.getInstance("SSL");
            KeyManager[] keyManagers = null;
            SecureRandom secureRandom = new SecureRandom();
            sslContext.init(keyManagers, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, secureRandom);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            okHttpClientBuilder.sslSocketFactory(sslSocketFactory, new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        okHttpClientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        okHttpClientBuilder.connectionPool(connectionPool);
        okHttpClientBuilder.connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(20000L, TimeUnit.MILLISECONDS).followRedirects(false);
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        Request request = new Request.Builder().addHeader("Content-Type", "text/plain").url(url).get().build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String responseBody = response.body().string();
                return responseBody;
            }
            return null;
        }
        catch (Exception e) {
            log.error("error ", (Throwable)e);
            return null;
        }
    }

    public TmsChannelInfo.TmsChannelInfoBuilder createTmsChannelVo(JSONObject mqToJsonObj) throws JMSException, JSONException {
        TmsChannelInfo.TmsChannelInfoBuilder tmsChannelBuilder = TmsChannelInfo.builder();
        try {
            String chceckDomain = null;
            String checkMemberId = null;
            String[] targetSchdInfo = mqToJsonObj.getString("key").split(":");
            if (mqToJsonObj.has("memberId")) {
                String targetField = mqToJsonObj.getString("memberId");
                if (!targetField.equals("SKIP_M_ID")) {
                    String memberId = null;
                    String uniqueSeq = null;
                    String[] memberIdSeq = targetField.split(":");
                    memberId = memberIdSeq[0];
                    uniqueSeq = memberIdSeq[1];
                    tmsChannelBuilder.targetMemberId(memberId);
                    tmsChannelBuilder.targetMemberIdSeq(uniqueSeq);
                    tmsChannelBuilder.targetField(targetField);
                    checkMemberId = memberId;
                } else {
                    tmsChannelBuilder.targetField(targetField);
                    tmsChannelBuilder.targetMemberId(targetField);
                    checkMemberId = targetField;
                }
            } else {
                tmsChannelBuilder.targetMemberId("SKIP_M_ID");
                checkMemberId = "SKIP_M_ID";
            }
            if (targetSchdInfo.length < 3) {
                log.error("targetKey format Wrong");
            }
            tmsChannelBuilder.key(mqToJsonObj.getString("key"));
            tmsChannelBuilder.targetDestination(mqToJsonObj.getString("mq_destination"));
            tmsChannelBuilder.targetSendId(targetSchdInfo[0]);
            tmsChannelBuilder.targetSchdId(targetSchdInfo[1]);
            tmsChannelBuilder.targetSeq(targetSchdInfo[2]);
            if (mqToJsonObj.has("sendType")) {
                tmsChannelBuilder.sendType(mqToJsonObj.getString("sendType"));
                tmsChannelBuilder.targetKey(this.createTargetRedisKey(targetSchdInfo[1], targetSchdInfo[2], mqToJsonObj.getString("sendType")));
            } else {
                tmsChannelBuilder.sendType(Constants.SendType.S.toString());
                tmsChannelBuilder.targetKey(this.createTargetRedisKey(targetSchdInfo[1], targetSchdInfo[2], Constants.SendType.S.toString()));
            }
            tmsChannelBuilder.targetCompany(mqToJsonObj.getString("company").toLowerCase());
            chceckDomain = mqToJsonObj.getString("domain");
            tmsChannelBuilder.domain(chceckDomain);
            tmsChannelBuilder.channelType(mqToJsonObj.getString("channelType"));
            if (mqToJsonObj.has("mq_send_time")) {
                tmsChannelBuilder.mq_send_time(mqToJsonObj.getString("mq_send_time"));
            }
            tmsChannelBuilder.targetData(mqToJsonObj.toString());
            if (chceckDomain.equals("ALL") || checkMemberId.equals("SKIP_M_ID")) {
                tmsChannelBuilder.targetDlistKey(this.createDomainGrpKey(targetSchdInfo[1], targetSchdInfo[2]));
            }
        }
        catch (JSONException ex) {
            log.error("convert to Vo Error : {}", (Throwable)ex);
            throw new JSONException("convert to Vo Error");
        }
        return tmsChannelBuilder;
    }

    public String createTargetRedisKey(String schdId, String targetSeq, String type) {
        String targetRedisKey = null;
        targetRedisKey = type.equals("Q") ? "QLIST".concat(":").concat(schdId).concat(":").concat(targetSeq) : "TLIST".concat(":").concat(schdId).concat(":").concat(targetSeq);
        return targetRedisKey;
    }

    public String createDomainGrpKey(String schdId, String targetSeq) {
        String domainGrpKey = null;
        domainGrpKey = "DLIST".concat(":").concat(schdId).concat(":").concat(targetSeq);
        return domainGrpKey;
    }

    public static String createDate() {
        SimpleDateFormat today = new SimpleDateFormat("yyyyMMddHH24mmss");
        Date dateObj = new Date();
        return today.format(dateObj);
    }

    public static String createCrlstTime(int intervalMin) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        Calendar c = Calendar.getInstance();
        Date d = new Date();
        c.setTime(d);
        c.add(12, intervalMin);
        return sdf.format(c.getTime());
    }

    public String createRedisFValue(String memberId, String memberIdSeq) {
        return memberId.concat(":").concat(memberIdSeq);
    }

    public static String createMessageId(TMSCommonPInfo pinfo, String memberId, String memberIdSeq) {
        String messageId = pinfo.getSiteId().concat("\t").concat(pinfo.getSchdId()).concat("\t").concat(pinfo.getSendId()).concat("\t").concat(pinfo.getTargetSeq()).concat("\t").concat(pinfo.getWorkday()).concat("\t").concat(memberId).concat("\t").concat(memberIdSeq);
        return messageId;
    }

    public TMSCommonPInfo getPInfo(Map<Object, Object> targetRedisAllData) {
        TMSCommonPInfo tmsCommonPInfo = new TMSCommonPInfo();
        if (targetRedisAllData.get("FROM_EMAIL") != null) {
            tmsCommonPInfo.setFromEmail(targetRedisAllData.get("FROM_EMAIL").toString());
        }
        if (targetRedisAllData.get("CONTENT_TYPE") != null) {
            tmsCommonPInfo.setContentType(targetRedisAllData.get("CONTENT_TYPE").toString());
        }
        if (targetRedisAllData.get("PUSH_VALUE") != null) {
            tmsCommonPInfo.setPushValue(targetRedisAllData.get("PUSH_VALUE").toString());
        }
        if (targetRedisAllData.get("FROM_NUMBER") != null) {
            tmsCommonPInfo.setFromNumber(targetRedisAllData.get("FROM_NUMBER").toString());
        }
        if (targetRedisAllData.get("A_PROJECT_NUM") != null) {
            tmsCommonPInfo.setGcmProjectNum(targetRedisAllData.get("A_PROJECT_NUM").toString());
        }
        if (targetRedisAllData.get("A_API_KEY") != null) {
            tmsCommonPInfo.setGcmApiKey(targetRedisAllData.get("A_API_KEY").toString());
        }
        if (targetRedisAllData.get("I_PUSH_PWD") != null) {
            tmsCommonPInfo.setApnsPwd(targetRedisAllData.get("I_PUSH_PWD").toString());
        }
        if (targetRedisAllData.get("PUSH_MSG") != null) {
            tmsCommonPInfo.setPushMsg(targetRedisAllData.get("PUSH_MSG").toString());
        }
        if (targetRedisAllData.get("SUBJECT") != null) {
            tmsCommonPInfo.setSubject(targetRedisAllData.get("SUBJECT").toString());
        }
        if (targetRedisAllData.get("I_PUSH_CERT") != null) {
            tmsCommonPInfo.setApnsPath(targetRedisAllData.get("I_PUSH_CERT").toString());
        }
        if (targetRedisAllData.get("CONTENT_REUSE") != null) {
            tmsCommonPInfo.setContentReUse(targetRedisAllData.get("CONTENT_REUSE").toString());
        }
        if (targetRedisAllData.get("APP_GRP_ID") != null) {
            tmsCommonPInfo.setAppGrpId(targetRedisAllData.get("APP_GRP_ID").toString());
        }
        if (targetRedisAllData.get("TMS_P_IMG") != null) {
            tmsCommonPInfo.setPushImg(targetRedisAllData.get("TMS_P_IMG").toString());
        }
        if (targetRedisAllData.get("WORKDAY") != null) {
            tmsCommonPInfo.setWorkday(targetRedisAllData.get("WORKDAY").toString());
        }
        if (targetRedisAllData.containsKey("SITE_ID")) {
            tmsCommonPInfo.setSiteId(targetRedisAllData.get("SITE_ID").toString());
        }
        if (targetRedisAllData.containsKey("NLS_LANG")) {
            tmsCommonPInfo.setNlsLang(targetRedisAllData.get("NLS_LANG").toString());
        }
        if (targetRedisAllData.containsKey("SWITCH_FLAG")) {
            tmsCommonPInfo.setSwitchFlag(targetRedisAllData.get("SWITCH_FLAG").toString());
        }
        if (targetRedisAllData.containsKey("SENDER_KEY")) {
            tmsCommonPInfo.setSenderKey(targetRedisAllData.get("SENDER_KEY").toString());
        }
        if (targetRedisAllData.containsKey("TEMPLATE_CODE")) {
            tmsCommonPInfo.setTemplateCode(targetRedisAllData.get("TEMPLATE_CODE").toString());
        }
        if (targetRedisAllData.containsKey("TRACKING_CLOSE")) {
            tmsCommonPInfo.setTrackingClose(targetRedisAllData.get("TRACKING_CLOSE").toString());
        }
        if (targetRedisAllData.containsKey("CAMP_TYPE")) {
            tmsCommonPInfo.setCampType(targetRedisAllData.get("CAMP_TYPE").toString());
        }
        if (targetRedisAllData.containsKey("MKT_YN")) {
            tmsCommonPInfo.setMktYn(targetRedisAllData.get("MKT_YN").toString());
        }
        return tmsCommonPInfo;
    }

    public static TmsSendResult resultDataProcess(TmsResponse tmsResponse, TMSCommonPInfo pinfo, TmsChannelInfo chinfo, String serverID) {
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType(chinfo.getChannelType()).schdId(chinfo.getTargetSchdId()).sendId(chinfo.getTargetSendId()).targetSeq(chinfo.getTargetSeq()).siteId(pinfo.getSiteId()).serverId(serverID).domain(chinfo.getDomain()).workday(pinfo.getWorkday());
        TmsSendResult result = null;
        try {
            result = targetDataResult.memberId(tmsResponse.getMemberId()).memberIdSeq(tmsResponse.getMemberIdSeq()).errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).startDate(tmsResponse.getStartDate()).endDate(tmsResponse.getStartDate()).campType(pinfo.getCampType()).build();
        }
        catch (Exception e) {
            log.error("Error Process Error  targetMemberId :{}, ErrorMsg :{} ", new Object[]{tmsResponse.getMemberId(), tmsResponse.getDetail(), e});
        }
        return result;
    }

    public static String nullCheck(Object target, String defaultValue) {
        return target != null ? target.toString() : defaultValue;
    }

    public static String nullCheck(Object target) {
        return SenderUtil.nullCheck(target, "");
    }

    public static String createInsertString(String[] columList, String schemaName, String tableName, String generatedKeyName, String sqeunce) {
        StringBuilder insertStatement = new StringBuilder();
        insertStatement.append("INSERT INTO ");
        if (schemaName != null) {
            insertStatement.append(schemaName);
            insertStatement.append(".");
        }
        insertStatement.append(tableName);
        insertStatement.append(" (");
        insertStatement.append(generatedKeyName.concat(","));
        int columnCount = 0;
        for (String columnName : columList) {
            if (++columnCount > 1) {
                insertStatement.append(", ");
            }
            insertStatement.append(columnName);
        }
        insertStatement.append(") VALUES(");
        insertStatement.append(sqeunce.concat(NEXT_VAL).concat(","));
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                insertStatement.append(", ");
            }
            insertStatement.append("?");
        }
        insertStatement.append(")");
        return insertStatement.toString();
    }
}

