/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.common;

import com.humuson.tms.config.Constants;
import com.humuson.tms.sender.common.BaiscMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.result.ResultBuilder;
import com.humuson.tms.sender.result.TmsResult;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;

public abstract class TmsMessageListener
implements MessageListener,
BaiscMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsMessageListener.class);
    protected TmsSenderCommonConfig commonConfig;

    public TmsMessageListener(TmsSenderCommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public void onMessage(Message message) {
        Map<Object, Object> mapTargetJsonList = new HashMap();
        JSONObject mqToJsonObj = null;
        try {
            mqToJsonObj = this.commonConfig.getSendUtil().MQmsgToJObj(message);
            mqToJsonObj.put("mq_destination", (Object)message.getJMSDestination().toString());
        }
        catch (Exception e) {
            mqToJsonObj = null;
            if (message != null) {
                try {
                    String str = ((TextMessage)message).getText();
                    if (str != null) {
                        log.error("MQ MESSAGE PARSING ERROR. MESSAGE:{}, ERROR:{}", (Object)str, (Object)e);
                    }
                }
                catch (JMSException e1) {
                    log.error("MQ MESSAGE PARSING ERROR. ERROR:{}", (Throwable)e);
                }
            }
            log.error("MQ MESSAGE PARSING ERROR. ERROR:{}", (Throwable)e);
        }
        if (mqToJsonObj == null) {
            return;
        }
        log.info("RECEIVE TO MQ TARGET DATA : {}", (Object)mqToJsonObj.toString());
        TmsChannelInfo tmsChannelVo = null;
        TMSCommonPInfo tmsCommonPInfo = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("convert to MQ data ... ");
            }
            if ((tmsChannelVo = this.commonConfig.getSendUtil().createTmsChannelVo(mqToJsonObj).build()) == null) {
                String msgText = null;
                try {
                    msgText = ((TextMessage)message).getText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.error("Received MQ data is INVALID. pass this work. destinationName:{}, message: {}", (Object)message.getJMSDestination().toString(), (Object)msgText);
                return;
            }
            tmsCommonPInfo = this.getPInfo(tmsChannelVo.getTargetKey());
            if (tmsCommonPInfo.getSiteId() == null || tmsCommonPInfo.getCampType() == null || tmsCommonPInfo.getWorkday() == null) {
                log.error("Received MQ data's PINFO(PINFO:{}) is INVALID. {}", (Object)tmsChannelVo.getTargetSchdId(), (Object)tmsCommonPInfo.toString());
                return;
            }
            tmsChannelVo.setMqPriority(message.getJMSPriority());
            log.info("[Sender-Start] {} ", (Object)tmsChannelVo.toString());
            if (log.isDebugEnabled()) {
                log.debug("get tmsCommon PINFO Value ... ");
            }
            tmsCommonPInfo.setTargetSeq(tmsChannelVo.getTargetSeq());
            tmsCommonPInfo.setSchdId(tmsChannelVo.getTargetSchdId());
            tmsCommonPInfo.setSendId(tmsChannelVo.getTargetSendId());
            if (log.isDebugEnabled()) {
                log.debug("get target data TLIST vlaue ...");
            }
        }
        catch (Exception e) {
            log.error("create Sender Data wrong [{}]", (Object)e.toString());
            tmsChannelVo.setErrMsg(e.toString());
        }
        try {
            mapTargetJsonList = this.getTargetData(tmsChannelVo);
            if (log.isDebugEnabled()) {
                log.debug("get tms target SUCCESS_DATA:{}, FAIL_DATA:{}", (Object)((List)mapTargetJsonList.get("TARGET_SUCCESS")).toString(), (Object)((List)mapTargetJsonList.get("TARGET_FAIL")).toString());
            }
        }
        catch (Exception e) {
            log.error("getTargetData error: [{}]", (Object)e.toString());
            tmsChannelVo.setErrMsg(e.toString());
        }
        try {
            if (tmsChannelVo.getErrMsg() == null || tmsChannelVo.getErrMsg().trim().isEmpty()) {
                this.startSenderProcess(tmsChannelVo, (List)mapTargetJsonList.get("TARGET_SUCCESS"), tmsCommonPInfo);
            } else {
                this.resultDataAllFail(mapTargetJsonList, tmsCommonPInfo, tmsChannelVo);
            }
        }
        catch (Exception e) {
            log.error("Start Sender Process Error : {}", (Throwable)e);
        }
        if (mapTargetJsonList.size() > 0) {
            log.info("[Sender-End] Send DATA {} ], TLIST SEND CNT[ {} ], TLIST FAIL CNT[ {} ] ", new Object[]{tmsChannelVo.toString(), ((List)mapTargetJsonList.get("TARGET_SUCCESS")).size(), ((List)mapTargetJsonList.get("TARGET_FAIL")).size()});
        } else {
            log.info("[Sender-End] Send DATA {} ], TLIST CNT[ {} ], getErrMsg[ {} ] ", new Object[]{tmsChannelVo.toString(), mapTargetJsonList.size(), tmsChannelVo.getErrMsg()});
        }
        if (mapTargetJsonList.size() > 0) {
            mapTargetJsonList.clear();
        }
    }

    public Map<String, List<JSONObject>> getTargetData(TmsChannelInfo tmsChannelVo) throws Exception {
        CopyOnWriteArrayList<JSONObject> targetSuccessJsonObj = new CopyOnWriteArrayList<JSONObject>();
        CopyOnWriteArrayList<JSONObject> targetErrorJsonObj = new CopyOnWriteArrayList<JSONObject>();
        String targetKey = tmsChannelVo.getTargetKey();
        String targetMemberId = tmsChannelVo.getTargetField();
        String targetDomain = tmsChannelVo.getDomain();
        log.info("[GET REDIS DATA] target key : {} / target memberId : {} / target domain : {}", new Object[]{targetKey, targetMemberId, targetDomain});
        try {
            if (targetMemberId.equals("SKIP_M_ID")) {
                log.debug("[GET REDIS - DLIST] targetDomain : {} / dlist Key : {}", (Object)targetDomain, (Object)tmsChannelVo.getTargetDlistKey());
                String targetDomainValues = this.commonConfig.getWrapperRedisTemplate().hmget(tmsChannelVo.getTargetDlistKey(), targetDomain);
                if (targetDomainValues == null) {
                    targetKey = tmsChannelVo.getTargetDlistKey();
                    targetMemberId = targetDomain;
                }
                String[] targetDlistValues = targetDomainValues.split(",");
                ArrayList<String> targetDlistListValues = new ArrayList<String>(Arrays.asList(targetDlistValues));
                for (String targetValue : targetDlistListValues) {
                    JSONObject jsonTarget = this.getTlistData(tmsChannelVo, targetKey, targetValue);
                    if (jsonTarget == null) continue;
                    if (this.checkTargetData(jsonTarget)) {
                        targetSuccessJsonObj.add(jsonTarget);
                        continue;
                    }
                    if (!jsonTarget.has("STATUS")) {
                        jsonTarget.put("STATUS", (Object)"TMS9");
                        jsonTarget.put("LOG_DETAIL", (Object)"ChannelListener's checkTargetData function is return false.");
                    }
                    targetErrorJsonObj.add(jsonTarget);
                }
            } else {
                JSONObject jsonTarget = this.getTlistData(tmsChannelVo, targetKey, targetMemberId);
                if (jsonTarget != null) {
                    log.info("jsonTarget Data ==== {}", (Object)jsonTarget.toString());
                    if (this.checkTargetData(jsonTarget)) {
                        targetSuccessJsonObj.add(jsonTarget);
                    } else {
                        if (!jsonTarget.has("STATUS")) {
                            jsonTarget.put("STATUS", (Object)"TMS9");
                            jsonTarget.put("LOG_DETAIL", (Object)"ChannelListener's checkTargetData function is return false.");
                        }
                        targetErrorJsonObj.add(jsonTarget);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("[ERROR][REDIS] road redis Data error. key:" + targetKey + ", field :" + targetMemberId + ",Error :" + e.toString());
        }
        HashMap<String, List<JSONObject>> mapList = new HashMap<String, List<JSONObject>>();
        mapList.put("TARGET_SUCCESS", targetSuccessJsonObj);
        mapList.put("TARGET_FAIL", targetErrorJsonObj);
        return mapList;
    }

    public JSONObject getTlistData(TmsChannelInfo tmsChannelVo, String hmKey, String hmValue) throws Exception {
        JSONObject jsonObject = null;
        String tlistData = this.commonConfig.getWrapperRedisTemplate().hmget(hmKey, hmValue);
        if (tlistData == null || tlistData.trim().isEmpty()) {
            if (hmValue.contains(":")) {
                jsonObject = new JSONObject();
                String[] targetData = hmValue.split(":");
                jsonObject.put("TMS_M_ID", (Object)targetData[0]);
                jsonObject.put("UNIQUE_SEQ", (Object)targetData[1]);
                jsonObject.put("SCHD_ID", (Object)tmsChannelVo.getTargetSchdId());
                jsonObject.put("SEND_ID", (Object)tmsChannelVo.getTargetSendId());
                jsonObject.put("TARGET_SEQ", (Object)tmsChannelVo.getTargetSeq());
                jsonObject.put("STATUS", (Object)"TMS9");
                jsonObject.put("LOG_DETAIL", (Object)("TLIST data is empty. RedisKey: " + hmKey + ", RedisField:" + hmValue));
                return jsonObject;
            }
            return null;
        }
        jsonObject = this.jsonObjParser(tlistData);
        return jsonObject;
    }

    public String getSchdID(String tlistKey) {
        String[] target = tlistKey.split(":");
        if (target[0].equals("TLIST") || target[0].equals("QLIST")) {
            return "PINFO".concat(":").concat(target[1]);
        }
        return "SchdID:ERROR";
    }

    public TMSCommonPInfo getPInfo(String tlistKey) throws Exception {
        String pinfoKey = "";
        pinfoKey = SenderUtil.getPINFOKey(tlistKey);
        Map targetRedisAllData = new HashMap();
        TMSCommonPInfo tmsCommonPInfo = new TMSCommonPInfo();
        try {
            targetRedisAllData = this.commonConfig.getWrapperRedisTemplate().hgetAll(pinfoKey);
            if (targetRedisAllData.get("FROM_EMAIL") != null) {
                tmsCommonPInfo.setFromEmail(targetRedisAllData.get("FROM_EMAIL").toString());
            }
            if (targetRedisAllData.get("CONTENT_TYPE") != null) {
                tmsCommonPInfo.setContentType(targetRedisAllData.get("CONTENT_TYPE").toString());
            }
            if (targetRedisAllData.get("PUSH_VALUE") != null) {
                tmsCommonPInfo.setPushValue(targetRedisAllData.get("PUSH_VALUE").toString());
            }
            if (targetRedisAllData.get("FROM_NUMBER") != null) {
                tmsCommonPInfo.setFromNumber(targetRedisAllData.get("FROM_NUMBER").toString());
            }
            if (targetRedisAllData.get("A_PROJECT_NUM") != null) {
                tmsCommonPInfo.setGcmProjectNum(targetRedisAllData.get("A_PROJECT_NUM").toString());
            }
            if (targetRedisAllData.get("A_API_KEY") != null) {
                tmsCommonPInfo.setGcmApiKey(targetRedisAllData.get("A_API_KEY").toString());
            }
            if (targetRedisAllData.get("I_PUSH_PWD") != null) {
                tmsCommonPInfo.setApnsPwd(targetRedisAllData.get("I_PUSH_PWD").toString());
            }
            if (targetRedisAllData.get("PUSH_MSG") != null) {
                tmsCommonPInfo.setPushMsg(targetRedisAllData.get("PUSH_MSG").toString());
            }
            if (targetRedisAllData.get("SUBJECT") != null) {
                tmsCommonPInfo.setSubject(targetRedisAllData.get("SUBJECT").toString());
            }
            if (targetRedisAllData.get("I_PUSH_CERT") != null) {
                tmsCommonPInfo.setApnsPath(targetRedisAllData.get("I_PUSH_CERT").toString());
            }
            if (targetRedisAllData.get("CONTENT_REUSE") != null) {
                tmsCommonPInfo.setContentReUse(targetRedisAllData.get("CONTENT_REUSE").toString());
            }
            if (targetRedisAllData.get("APP_GRP_ID") != null) {
                tmsCommonPInfo.setAppGrpId(targetRedisAllData.get("APP_GRP_ID").toString());
            }
            if (targetRedisAllData.containsKey("TMS_P_IMG")) {
                tmsCommonPInfo.setPushImg(targetRedisAllData.get("TMS_P_IMG").toString());
            }
            if (targetRedisAllData.containsKey("WORKDAY")) {
                tmsCommonPInfo.setWorkday(targetRedisAllData.get("WORKDAY").toString());
            }
            if (targetRedisAllData.containsKey("SITE_ID")) {
                tmsCommonPInfo.setSiteId(targetRedisAllData.get("SITE_ID").toString());
            }
            if (targetRedisAllData.containsKey("NLS_LANG")) {
                tmsCommonPInfo.setNlsLang(targetRedisAllData.get("NLS_LANG").toString());
            }
            if (targetRedisAllData.containsKey("PUSH_IMG")) {
                tmsCommonPInfo.setPushImg(targetRedisAllData.get("PUSH_IMG").toString());
            }
            if (targetRedisAllData.containsKey("SWITCH_FLAG")) {
                tmsCommonPInfo.setSwitchFlag(targetRedisAllData.get("SWITCH_FLAG").toString());
            }
            if (targetRedisAllData.containsKey("SENDER_KEY")) {
                tmsCommonPInfo.setSenderKey(targetRedisAllData.get("SENDER_KEY").toString());
            }
            if (targetRedisAllData.containsKey("RETURN_PATH")) {
                tmsCommonPInfo.setReturnPath(targetRedisAllData.get("RETURN_PATH").toString());
            }
            if (targetRedisAllData.containsKey("TEMPLATE_CODE")) {
                tmsCommonPInfo.setTemplateCode(targetRedisAllData.get("TEMPLATE_CODE").toString());
            }
            if (targetRedisAllData.containsKey("TRACKING_CLOSE")) {
                tmsCommonPInfo.setTrackingClose(targetRedisAllData.get("TRACKING_CLOSE").toString());
            }
            if (targetRedisAllData.containsKey("CAMP_TYPE")) {
                tmsCommonPInfo.setCampType(targetRedisAllData.get("CAMP_TYPE").toString());
            }
            if (targetRedisAllData.containsKey("MKT_YN")) {
                tmsCommonPInfo.setMktYn(targetRedisAllData.get("MKT_YN").toString());
            }
        }
        catch (Exception e) {
            log.error("Road to Redis Data => #key : {}, #Error {}", (Object)pinfoKey, (Object)e);
            throw new Exception("[PINFO] road redis Data failed ");
        }
        return tmsCommonPInfo;
    }

    public boolean checkCancelSendId(String sendId) {
        boolean cancelFlag = false;
        try {
            cancelFlag = this.commonConfig.getWrapperRedisTemplate().hasHMKey("PCNCL", sendId);
            if (log.isDebugEnabled()) {
                log.debug("PCNCL TARGET SEND ID : {}, isCancled : {}", (Object)sendId, (Object)cancelFlag);
            }
        }
        catch (Exception e) {
            log.error("SD2001|Error occurred while importing canceled target data. target SendId : {}", (Object)sendId);
            log.error("SD2001 - Detail Error : {} ", (Throwable)e);
        }
        return cancelFlag;
    }

    public void startSenderProcess(TmsChannelInfo tmsChannelVo, List<JSONObject> targetJsonList, TMSCommonPInfo tmsCommonPInfo) throws Exception {
        List<TmsResponse> resultData = new ArrayList();
        boolean cancelTargetFalg = false;
        boolean isSendProcFlag = false;
        cancelTargetFalg = this.checkCancelSendId(tmsChannelVo.getTargetSendId());
        TmsResponse errorData = null;
        String startDate = DateUtil.getFullDate((String)"yyyyMMddHHmmss");
        if (!tmsChannelVo.getTargetMemberId().equals("SKIP_M_ID")) {
            for (JSONObject targetJson : targetJsonList) {
                try {
                    if (!cancelTargetFalg && !targetJson.has("STATUS")) {
                        if (!this.validationCheck(targetJson, tmsCommonPInfo)) continue;
                        if (log.isInfoEnabled()) {
                            log.info("SENDER TARGET PINFO DATA : {}", (Object)tmsCommonPInfo);
                        }
                        TmsResponse response = this.sendProcess(targetJson, tmsCommonPInfo, tmsChannelVo);
                        resultData.add(response);
                        continue;
                    }
                    errorData = new TmsResponse();
                    errorData.setMemberId(tmsChannelVo.getTargetMemberId());
                    errorData.setMemberIdSeq(tmsChannelVo.getTargetMemberIdSeq());
                    errorData.setStartDate(startDate);
                    errorData.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                    if (targetJson.has("STATUS")) {
                        errorData.setCode(targetJson.getString("STATUS"));
                        errorData.setDetail(targetJson.getString("LOG_DETAIL"));
                    }
                    if (!cancelTargetFalg) {
                        errorData.setCode("TMS6");
                        errorData.setDetail("this target send Cancel!");
                    }
                    resultData.add(errorData);
                    log.error("errorData :{}", (Object)errorData.toString());
                }
                catch (NullPointerException e1) {
                    log.error("target Error {}, targetJson:{}, tmsCommonPInfo:{}, ", new Object[]{e1.getMessage(), targetJson, tmsCommonPInfo, e1});
                    errorData = new TmsResponse();
                    resultData.add(errorData.createErrorData(tmsChannelVo.getTargetMemberId(), tmsChannelVo.getTargetMemberIdSeq(), e1.toString()));
                }
                catch (Exception e) {
                    log.error("target Error {}, targetJson:{}, tmsCommonPInfo:{}, ", new Object[]{e.getMessage(), targetJson, tmsCommonPInfo});
                    errorData = new TmsResponse();
                    resultData.add(errorData.createErrorData(tmsChannelVo.getTargetMemberId(), tmsChannelVo.getTargetMemberIdSeq(), e.toString()));
                }
            }
        } else if (!cancelTargetFalg) {
            try {
                resultData = this.sendBulkProcess(targetJsonList, tmsCommonPInfo, tmsChannelVo);
            }
            catch (Exception e) {
                for (JSONObject targetJson : targetJsonList) {
                    errorData = new TmsResponse();
                    errorData.setMemberId(targetJson.getString("MEMBER_ID"));
                    errorData.setMemberIdSeq(targetJson.getString("UNIQUE_SEQ"));
                    errorData.setCode("TMS9");
                    errorData.setStartDate(startDate);
                    errorData.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                    errorData.setDetail("this bulk send error! : " + e.toString());
                    resultData.add(errorData);
                    errorData = null;
                }
            }
        } else {
            for (JSONObject targetJson : targetJsonList) {
                errorData = new TmsResponse();
                errorData.setMemberId(targetJson.getString("MEMBER_ID"));
                errorData.setMemberIdSeq(targetJson.getString("UNIQUE_SEQ"));
                errorData.setCode("TMS6");
                errorData.setStartDate(startDate);
                errorData.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                errorData.setDetail("this target send Cancel!");
                resultData.add(errorData);
                errorData = null;
            }
        }
        if (resultData.size() > 0) {
            this.resultDataProcess(resultData, tmsCommonPInfo, tmsChannelVo);
        }
        resultData.clear();
    }

    public TmsResponse createErrorResponce(JSONObject targetJson, String errorDetail, String code, String startDate) throws JSONException {
        TmsResponse errorData = new TmsResponse();
        errorData.setMemberId(targetJson.getString("MEMBER_ID"));
        errorData.setMemberIdSeq(targetJson.getString("UNIQUE_SEQ"));
        errorData.setCode(code);
        errorData.setStartDate(startDate);
        errorData.setEndDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        errorData.setDetail(errorDetail);
        return errorData;
    }

    @Override
    public void errorDataProcess(JSONObject jObj, String targetKey, String targetMemberId, String errorMsg) {
    }

    @Override
    public void resultDataProcess(List<TmsResponse> tmsResponseList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType(chinfo.getChannelType()).schdId(chinfo.getTargetSchdId()).sendId(chinfo.getTargetSendId()).targetSeq(chinfo.getTargetSeq()).siteId(pinfo.getSiteId()).serverId(this.commonConfig.getServerID());
        if (chinfo.getSendType().equals(Constants.SendType.Q.toString())) {
            targetDataResult.resultType("Q");
            targetDataResult.intervalMin(30);
        } else {
            targetDataResult.resultType("S");
            targetDataResult.intervalMin(0);
        }
        targetDataResult.domain(chinfo.getDomain()).workday(pinfo.getWorkday());
        for (TmsResponse tmsResponse : tmsResponseList) {
            if (log.isDebugEnabled()) {
                log.debug("tmsResponse {}", (Object)tmsResponse);
            }
            TmsSendResult result = null;
            try {
                if (tmsResponse.getMemberId() != null) {
                    targetDataResult.memberId(tmsResponse.getMemberId());
                    targetDataResult.memberIdSeq(tmsResponse.getMemberIdSeq());
                } else {
                    targetDataResult.memberId(chinfo.getTargetMemberId());
                    targetDataResult.memberIdSeq(chinfo.getTargetMemberIdSeq());
                }
                if (tmsResponse.getStartDate() != null) {
                    targetDataResult.startDate(tmsResponse.getStartDate());
                } else {
                    targetDataResult.startDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                }
                if (tmsResponse.getEndDate() != null) {
                    targetDataResult.endDate(tmsResponse.getEndDate());
                } else {
                    targetDataResult.endDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                }
                result = targetDataResult.errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).campType(pinfo.getCampType()).build();
                this.commonConfig.getWrapperRedisTemplate().hmset(result.getRedisKey(), result.getRedisField(), result.getRedisValue());
                if (!log.isDebugEnabled()) continue;
                log.info("[REDIS - CRLST]  key:{}, filed:{}, value:{}", new Object[]{result.getRedisKey(), result.getRedisField(), result.getRedisValue()});
            }
            catch (Exception e) {
                log.error("Error Process Error targetKey :{}, targetMemberId :{}, ErrorMsg :{} ", new Object[]{result.getRedisKey(), result.getRedisField(), result.getRedisValue()});
            }
        }
    }

    public void resultDataAllFail(Map<String, List<JSONObject>> targetList, TMSCommonPInfo pInfo, TmsChannelInfo cInfo) throws Exception {
        TmsSendResult result;
        ResultBuilder targetDataResult;
        if (targetList == null || targetList.size() == 0) {
            return;
        }
        HashMap<String, String> crsltFiledValue = new HashMap<String, String>();
        String redisKey = null;
        for (JSONObject jsonTarget : targetList.get("TARGET_SUCCESS")) {
            targetDataResult = TmsResult.newResult("S");
            targetDataResult.channelType(cInfo.getChannelType());
            targetDataResult.schdId(cInfo.getTargetSchdId());
            targetDataResult.sendId(cInfo.getTargetSendId());
            targetDataResult.targetSeq(cInfo.getTargetSeq());
            targetDataResult.siteId(pInfo.getSiteId());
            targetDataResult.serverId(this.commonConfig.getServerID());
            targetDataResult.domain(cInfo.getDomain());
            targetDataResult.workday(pInfo.getWorkday());
            targetDataResult.campType(pInfo.getCampType());
            targetDataResult.errorCode("TMS9");
            targetDataResult.errorDetail(cInfo.getErrMsg());
            targetDataResult.memberId(jsonTarget.getString("TMS_M_ID"));
            targetDataResult.memberIdSeq(jsonTarget.getString("UNIQUE_SEQ"));
            result = targetDataResult.build();
            redisKey = result.getRedisKey();
            crsltFiledValue.put(result.getRedisField(), result.getRedisValue());
        }
        for (JSONObject jsonTarget : targetList.get("TARGET_FAIL")) {
            targetDataResult = TmsResult.newResult("S");
            targetDataResult.channelType(cInfo.getChannelType());
            targetDataResult.schdId(cInfo.getTargetSchdId());
            targetDataResult.sendId(cInfo.getTargetSendId());
            targetDataResult.targetSeq(cInfo.getTargetSeq());
            targetDataResult.siteId(pInfo.getSiteId());
            targetDataResult.serverId(this.commonConfig.getServerID());
            targetDataResult.domain(cInfo.getDomain());
            targetDataResult.workday(pInfo.getWorkday());
            targetDataResult.campType(pInfo.getCampType());
            targetDataResult.errorCode(jsonTarget.getString("STATUS"));
            targetDataResult.errorDetail(jsonTarget.getString("LOG_DETAIL"));
            targetDataResult.memberId(jsonTarget.getString("TMS_M_ID"));
            targetDataResult.memberIdSeq(jsonTarget.getString("UNIQUE_SEQ"));
            result = targetDataResult.build();
            if (redisKey == null) {
                redisKey = result.getRedisKey();
            }
            crsltFiledValue.put(result.getRedisField(), result.getRedisValue());
        }
        if (redisKey != null && crsltFiledValue.size() > 0) {
            this.commonConfig.getWrapperRedisTemplate().hmsetAll(redisKey, crsltFiledValue);
            log.info("[REDIS - CRSLT] resultDataAllFail key:{}, size:{}", redisKey, (Object)crsltFiledValue.size());
        }
    }

    public void resultTestDelDataProcess(List<TmsResponse> tmsResponseList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        if (log.isDebugEnabled()) {
            log.debug("DEL REDIS CRSLT Start: [{}]", (Object)DateUtil.getFullDateDefaultFormat());
        }
        ResultBuilder targetDataResult = TmsResult.newResult("S").channelType(chinfo.getChannelType()).schdId(chinfo.getTargetSchdId()).sendId(chinfo.getTargetSendId()).targetSeq(chinfo.getTargetSeq()).siteId(pinfo.getSiteId()).serverId(this.commonConfig.getDaemonType().concat(this.commonConfig.getServerID())).resultType("S").domain(chinfo.getDomain()).workday(pinfo.getWorkday());
        for (TmsResponse tmsResponse : tmsResponseList) {
            TmsSendResult result = null;
            try {
                result = targetDataResult.memberId(tmsResponse.getMemberId()).memberIdSeq(tmsResponse.getMemberIdSeq()).errorCode(tmsResponse.getCode()).errorDetail(tmsResponse.getDetail()).startDate(tmsResponse.getStartDate()).endDate(tmsResponse.getStartDate()).campType(pinfo.getCampType()).build();
                this.commonConfig.getWrapperRedisTemplate().hmdel(result.getRedisKey(), result.getRedisField());
            }
            catch (Exception e) {
                log.error("Error Process Error targetKey :{}, targetMemberId :{}, ErrorMsg :{} ", new Object[]{result.getRedisKey(), result.getRedisField(), result.getRedisValue()});
            }
        }
    }

    public JSONObject mqMsgToJObj(Message message) throws JMSException, JSONException {
        String mstToStrData = this.mqMsgToStr(message);
        if (!mstToStrData.equals("Do Notting")) {
            return this.jsonObjParser(this.mqMsgToStr(message));
        }
        return null;
    }

    public JSONObject jsonObjParser(String mqMessage) throws JSONException {
        return new JSONObject(mqMessage);
    }

    public String mqMsgToStr(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return textMessage.getText();
        }
        return "Do Notting";
    }

    @MessageExceptionHandler(value={RuntimeException.class})
    public void handleException(Throwable exception) {
        log.error("ERROR:{}", exception);
    }

    public TmsSenderCommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public void setCommonConfig(TmsSenderCommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsMessageListener)) {
            return false;
        }
        TmsMessageListener other = (TmsMessageListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TmsSenderCommonConfig this$commonConfig = this.getCommonConfig();
        TmsSenderCommonConfig other$commonConfig = other.getCommonConfig();
        return !(this$commonConfig == null ? other$commonConfig != null : !((Object)this$commonConfig).equals(other$commonConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsMessageListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TmsSenderCommonConfig $commonConfig = this.getCommonConfig();
        result = result * 59 + ($commonConfig == null ? 0 : ((Object)$commonConfig).hashCode());
        return result;
    }

    public String toString() {
        return "TmsMessageListener(commonConfig=" + this.getCommonConfig() + ")";
    }
}

