/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.biz.util;

import com.humuson.tms.sender.biz.model.ImcBizATColumn;
import com.humuson.tms.sender.biz.model.ImcBizFTColumn;
import com.humuson.tms.sender.common.TmsSenderConstants;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizUtil {
    private static final Logger log = LoggerFactory.getLogger(BizUtil.class);

    public static Map<String, Object> createBizTargetATData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(ImcBizATColumn.STATUS.getColumn(), ImcBizATColumn.STATUS.getValue());
            map.put(ImcBizATColumn.PRIORITY.getColumn(), ImcBizATColumn.PRIORITY.getValue());
            map.put(ImcBizATColumn.RESERVED_DATE.getColumn(), DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            map.put(ImcBizATColumn.SENDER_KEY.getColumn(), pinfo.getSenderKey());
            map.put(ImcBizATColumn.TMS_M_TARGET.getColumn(), targetJson.get(ImcBizATColumn.TMS_M_TARGET.getKey()));
            map.put(ImcBizATColumn.TEMPLATE_CODE.getColumn(), pinfo.getTemplateCode());
            map.put(ImcBizATColumn.CONTENT.getColumn(), targetJson.get(ImcBizATColumn.CONTENT.getKey()));
            map.put(ImcBizATColumn.ATTACHMENT_JSON.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizATColumn.ATTACHMENT_JSON.getKey(), ""));
            map.put(ImcBizATColumn.RESEND_TYPE.getColumn(), BizUtil.returnResendType(pinfo.getSwitchFlag()));
            map.put(ImcBizATColumn.RESEND_CALLBACK.getColumn(), pinfo.getFromNumber());
            map.put(ImcBizATColumn.TMS_M_PHONE.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizATColumn.TMS_M_PHONE.getKey(), ""));
            map.put(ImcBizATColumn.SUBJECT.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizATColumn.SUBJECT.getKey(), pinfo.getSubject()));
            map.put(ImcBizATColumn.RESEND_MT_MESSAGE_REUSE.getColumn(), pinfo.getContentReUse());
            map.put(ImcBizATColumn.RESEND_MT_MESSAGE.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizATColumn.RESEND_MT_MESSAGE.getKey(), ""));
            map.put(ImcBizATColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(ImcBizATColumn.DOMAIN.getColumn(), targetJson.get(ImcBizATColumn.DOMAIN.getKey()));
            map.put(ImcBizATColumn.TMS_M_ID.getColumn(), targetJson.get(ImcBizATColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            map.put(ImcBizATColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(ImcBizATColumn.BIZ_YN.getColumn(), ImcBizATColumn.BIZ_YN.getValue());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static Map<String, Object> createBizTargetFTData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(ImcBizFTColumn.FT_TYPE.getColumn(), pinfo.getFtType());
            map.put(ImcBizFTColumn.STATUS.getColumn(), ImcBizFTColumn.STATUS.getValue());
            map.put(ImcBizFTColumn.PRIORITY.getColumn(), ImcBizFTColumn.PRIORITY.getValue());
            map.put(ImcBizFTColumn.RESERVED_DATE.getColumn(), DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            map.put(ImcBizFTColumn.SENDER_KEY.getColumn(), pinfo.getSenderKey());
            map.put(ImcBizFTColumn.TMS_M_TARGET.getColumn(), targetJson.get(ImcBizFTColumn.TMS_M_TARGET.getKey()));
            map.put(ImcBizFTColumn.USER_KEY.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizFTColumn.USER_KEY.getKey(), ImcBizFTColumn.USER_KEY.getValue()));
            map.put(ImcBizFTColumn.CONTENT.getColumn(), targetJson.get(ImcBizFTColumn.CONTENT.getKey()));
            map.put(ImcBizFTColumn.ATTACHMENT_JSON.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizFTColumn.ATTACHMENT_JSON.getKey(), ImcBizFTColumn.ATTACHMENT_JSON.getValue()));
            map.put(ImcBizFTColumn.BILL_CODE.getColumn(), pinfo.getBillCode());
            map.put(ImcBizFTColumn.IMG_URL.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizFTColumn.IMG_URL.getKey(), ImcBizFTColumn.IMG_URL.getValue()));
            map.put(ImcBizFTColumn.IMG_CLICK_URL.getColumn(), BizUtil.returnDefaultValue(targetJson, ImcBizFTColumn.IMG_CLICK_URL.getKey(), ImcBizFTColumn.IMG_CLICK_URL.getValue()));
            map.put(ImcBizFTColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(ImcBizFTColumn.DOMAIN.getColumn(), targetJson.get(ImcBizATColumn.DOMAIN.getKey()));
            map.put(ImcBizFTColumn.TMS_M_ID.getColumn(), targetJson.get(ImcBizATColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            map.put(ImcBizFTColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(ImcBizFTColumn.BIZ_YN.getColumn(), ImcBizATColumn.BIZ_YN.getValue());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static String returnDefaultValue(JSONObject targetJson, String key, String defaultValue) throws JSONException {
        if (targetJson.has(key)) {
            return targetJson.get(key).toString();
        }
        return defaultValue;
    }

    public static String returnResendType(String switchTarget) {
        String resendType = null;
        switch (switchTarget) {
            case "S": {
                resendType = TmsSenderConstants.ResendType.SM.toString();
                break;
            }
            case "L": {
                resendType = TmsSenderConstants.ResendType.LM.toString();
                break;
            }
            case "N": {
                resendType = TmsSenderConstants.ResendType.NO.toString();
                break;
            }
            default: {
                resendType = TmsSenderConstants.ResendType.NO.toString();
            }
        }
        return resendType;
    }
}

