/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.biz.actor;

import com.humuson.tms.sender.biz.actor.TmsBizActor;
import com.humuson.tms.sender.biz.model.ImcBizFTColumn;
import com.humuson.tms.sender.biz.util.BizUtil;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class TmsBizFTSender
extends TmsBizActor {
    private static final Logger log = LoggerFactory.getLogger(TmsBizFTSender.class);

    public TmsBizFTSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.resultList = new ArrayList();
        this.batchValues = new ArrayList();
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetJson, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "";
        String memberId = "";
        String memberSeq = "";
        try {
            memberId = targetJson.getString("TMS_M_ID");
            memberSeq = targetJson.getString("UNIQUE_SEQ");
            Map<String, Object> map = BizUtil.createBizTargetFTData(targetJson, pinfo);
            this.batchValues.add(map);
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(ImcBizFTColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.error("target Data error : {}", (Throwable)e);
            errorCode = "TMS9";
            errorDetail = e.toString();
        }
        this.batchValues.clear();
        return new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq);
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "";
        String memberId = "";
        String memberSeq = "";
        try {
            for (JSONObject targetJson : targetList) {
                try {
                    errorCode = "TMS0";
                    errorDetail = "";
                    memberId = targetJson.getString("TMS_M_ID");
                    memberSeq = targetJson.getString("UNIQUE_SEQ");
                    Map<String, Object> map = BizUtil.createBizTargetFTData(targetJson, pinfo);
                    this.batchValues.add(map);
                }
                catch (Exception e) {
                    log.error("parse target data error {}", (Object)e.toString());
                    errorCode = "TMS9";
                    errorDetail = e.toString();
                }
                this.resultList.add(new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq));
            }
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(ImcBizFTColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.info("insert target Data Error {}", (Throwable)e);
            this.batchValues.clear();
            this.resultList.clear();
            for (JSONObject targetJson : targetList) {
                this.resultList.add(this.targetDataSendToServer(targetJson, pinfo, chinfo));
            }
        }
        this.batchValues.clear();
        log.info("end time {}", (Object)System.currentTimeMillis());
        return this.resultList;
    }
}

