/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.biz.actor;

import com.humuson.tms.sender.biz.actor.TmsBizActor;
import com.humuson.tms.sender.biz.model.ImcBizATColumn;
import com.humuson.tms.sender.biz.util.BizUtil;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.util.date.DateUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class TmsBizATSender
extends TmsBizActor {
    private static final Logger log = LoggerFactory.getLogger(TmsBizATSender.class);

    public TmsBizATSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.resultList = new ArrayList();
        this.batchValues = new ArrayList();
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetJson, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsBizTalkConfig().getJdbcTemplate();
        String atTable = this.tmsCommonConfig.getTmsBizTalkConfig().getAtTable();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = null;
        String memberSeq = null;
        String insertBizSql = null;
        try {
            errorCode = "TMS0";
            errorDetail = "SUCCESS";
            memberId = targetJson.getString("TMS_M_ID");
            memberSeq = targetJson.getString("UNIQUE_SEQ");
            Map<String, Object> map = BizUtil.createBizTargetATData(targetJson, pinfo);
            this.batchValues.add(map);
            if (this.tmsCommonConfig.getTmsBizTalkConfig().getDbType().equals("oracle")) {
                insertBizSql = SenderUtil.createInsertString(ImcBizATColumn.getColumnList(), null, atTable, this.tmsCommonConfig.getTmsBizTalkConfig().getAtGeneratedKey(), this.tmsCommonConfig.getTmsBizTalkConfig().getAtSequnce());
                smsConnection.batchUpdate(insertBizSql, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        Map batchVal = (Map)TmsBizATSender.this.batchValues.get(i);
                        ps.setString(1, batchVal.get(ImcBizATColumn.STATUS.getColumn()).toString());
                        ps.setString(2, batchVal.get(ImcBizATColumn.PRIORITY.getColumn()).toString());
                        ps.setString(3, batchVal.get(ImcBizATColumn.RESERVED_DATE.getColumn()).toString());
                        ps.setString(4, batchVal.get(ImcBizATColumn.SENDER_KEY.getColumn()).toString());
                        ps.setString(5, batchVal.get(ImcBizATColumn.TMS_M_TARGET.getColumn()).toString());
                        ps.setString(6, batchVal.get(ImcBizATColumn.TEMPLATE_CODE.getColumn()).toString());
                        ps.setString(7, batchVal.get(ImcBizATColumn.CONTENT.getColumn()).toString());
                        ps.setString(8, batchVal.get(ImcBizATColumn.ATTACHMENT_JSON.getColumn()).toString());
                        ps.setString(9, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_TYPE.getColumn())));
                        ps.setString(10, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_CALLBACK.getColumn())));
                        ps.setString(11, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.TMS_M_PHONE.getColumn())));
                        ps.setString(12, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.SUBJECT.getColumn())));
                        ps.setString(13, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_MT_MESSAGE_REUSE.getColumn())));
                        ps.setString(14, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_MT_MESSAGE.getColumn())));
                        ps.setString(15, batchVal.get(ImcBizATColumn.SCHD_ID.getColumn()).toString());
                        ps.setString(16, batchVal.get(ImcBizATColumn.DOMAIN.getColumn()).toString());
                        ps.setString(17, batchVal.get(ImcBizATColumn.TMS_M_ID.getColumn()).toString());
                        ps.setString(18, batchVal.get(ImcBizATColumn.WORKDAY.getColumn()).toString());
                        ps.setString(19, batchVal.get(ImcBizATColumn.BIZ_YN.getColumn()).toString());
                    }

                    public int getBatchSize() {
                        return TmsBizATSender.this.batchValues.size();
                    }
                });
            } else {
                SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(atTable).usingColumns(ImcBizATColumn.getColumnList());
                smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
            }
        }
        catch (Exception e) {
            log.info("target Data error : {}", (Throwable)e);
            if (log.isDebugEnabled()) {
                // empty if block
            }
            errorCode = "TMS9";
            errorDetail = e.getMessage();
        }
        this.batchValues.clear();
        return new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq);
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsBizTalkConfig().getJdbcTemplate();
        String atTable = this.tmsCommonConfig.getTmsBizTalkConfig().getAtTable();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = null;
        String memberSeq = null;
        String insertBizSql = null;
        try {
            for (JSONObject targetJson : targetList) {
                try {
                    errorCode = "TMS0";
                    errorDetail = "SUCCESS";
                    memberId = targetJson.getString("TMS_M_ID");
                    memberSeq = targetJson.getString("UNIQUE_SEQ");
                    Map<String, Object> map = BizUtil.createBizTargetATData(targetJson, pinfo);
                    this.batchValues.add(map);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("parse target data error {}", (Object)e.toString());
                    }
                    errorCode = "TMS9";
                    errorDetail = e.toString();
                }
                this.resultList.add(new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq));
            }
            if (this.tmsCommonConfig.getTmsBizTalkConfig().getDbType().equals("oracle")) {
                insertBizSql = SenderUtil.createInsertString(ImcBizATColumn.getColumnList(), null, atTable, this.tmsCommonConfig.getTmsBizTalkConfig().getAtGeneratedKey(), this.tmsCommonConfig.getTmsBizTalkConfig().getAtSequnce());
                smsConnection.batchUpdate(insertBizSql, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        Map batchVal = (Map)TmsBizATSender.this.batchValues.get(i);
                        ps.setString(1, batchVal.get(ImcBizATColumn.STATUS.getColumn()).toString());
                        ps.setString(2, batchVal.get(ImcBizATColumn.PRIORITY.getColumn()).toString());
                        ps.setString(3, batchVal.get(ImcBizATColumn.RESERVED_DATE.getColumn()).toString());
                        ps.setString(4, batchVal.get(ImcBizATColumn.SENDER_KEY.getColumn()).toString());
                        ps.setString(5, batchVal.get(ImcBizATColumn.TMS_M_TARGET.getColumn()).toString());
                        ps.setString(6, batchVal.get(ImcBizATColumn.TEMPLATE_CODE.getColumn()).toString());
                        ps.setString(7, batchVal.get(ImcBizATColumn.CONTENT.getColumn()).toString());
                        ps.setString(8, batchVal.get(ImcBizATColumn.ATTACHMENT_JSON.getColumn()).toString());
                        ps.setString(9, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_TYPE.getColumn())));
                        ps.setString(10, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_CALLBACK.getColumn())));
                        ps.setString(11, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.TMS_M_PHONE.getColumn())));
                        ps.setString(12, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.SUBJECT.getColumn())));
                        ps.setString(13, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_MT_MESSAGE_REUSE.getColumn())));
                        ps.setString(14, SenderUtil.nullCheck(batchVal.get(ImcBizATColumn.RESEND_MT_MESSAGE.getColumn())));
                        ps.setString(15, batchVal.get(ImcBizATColumn.SCHD_ID.getColumn()).toString());
                        ps.setString(16, batchVal.get(ImcBizATColumn.DOMAIN.getColumn()).toString());
                        ps.setString(17, batchVal.get(ImcBizATColumn.TMS_M_ID.getColumn()).toString());
                        ps.setString(18, batchVal.get(ImcBizATColumn.WORKDAY.getColumn()).toString());
                        ps.setString(19, batchVal.get(ImcBizATColumn.BIZ_YN.getColumn()).toString());
                    }

                    public int getBatchSize() {
                        return TmsBizATSender.this.batchValues.size();
                    }
                });
            } else {
                SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(atTable).usingColumns(ImcBizATColumn.getColumnList());
                smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
            }
        }
        catch (Exception e) {
            log.info("target Data error : {}", (Throwable)e);
            this.batchValues.clear();
            if (log.isDebugEnabled()) {
                log.debug("insert target Data Error {}", (Throwable)e);
            }
            this.resultList.clear();
            for (JSONObject targetJson : targetList) {
                this.resultList.add(this.targetDataSendToServer(targetJson, pinfo, chinfo));
            }
        }
        this.batchValues.clear();
        if (log.isDebugEnabled()) {
            log.info("Biz Talk Sender end time : {}", (Object)DateUtil.getFullDate((String)"yyyyMMddHH24mmss"));
        }
        return this.resultList;
    }
}

