/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.biz.actor;

import com.humuson.tms.sender.biz.actor.TmsBizATSender;
import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsBizATMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsBizATMessageListener.class);

    public TmsBizATMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) {
        return true;
    }

    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse result = null;
        TmsBizATSender tmsBizTalkActor = new TmsBizATSender(this.commonConfig);
        result = tmsBizTalkActor.targetDataSendToServer(targetData, pinfo, chinfo);
        log.info("BIZ Single SEND RESULT] : {}", (Object)result.toString());
        return result;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsBizATSender tmsBizTalkActor = new TmsBizATSender(this.commonConfig);
        List<Object> resultList = new ArrayList();
        resultList = tmsBizTalkActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        log.info("BIZ Bulk SEND RESULT] : {}", (Object)resultList.size());
        return resultList;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.equals("") && status.equals("") && domain.toUpperCase().equals("AT");
    }
}

