/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.google;

import com.humuson.tms.google.InvalidRequestException;
import com.humuson.tms.google.Message;
import com.humuson.tms.google.MulticastResult;
import com.humuson.tms.google.Notification;
import com.humuson.tms.google.Result;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger log = LoggerFactory.getLogger(Sender.class);
    protected static final String UTF8 = "UTF-8";
    protected static final int BACKOFF_INITIAL_DELAY = 1000;
    protected static final int MAX_BACKOFF_DELAY = 1024000;
    protected final Random random = new Random();
    protected static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(Sender.class.getName());
    private final String key;

    public Sender(String key) {
        this.key = Sender.nonNull(key);
    }

    public Result send(Message message, String to, int retries) throws IOException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            log.info("Attempt # {} to send message {} to regIds {}", new Object[]{++attempt, message, to});
            result = this.sendNoRetry(message, to);
            boolean bl = tryAgain = result == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw new IOException("Could not send message after " + attempt + " attempts");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result sendNoRetry(Message message, String to) throws IOException {
        Sender.nonNull(to);
        HashMap<Object, Object> jsonRequest = new HashMap<Object, Object>();
        this.messageToMap(message, jsonRequest);
        jsonRequest.put("to", to);
        String responseBody = this.makeGcmHttpRequest(jsonRequest);
        if (responseBody == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        try {
            Result.Builder resultBuilder = new Result.Builder();
            JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
            if (jsonResponse.containsKey((Object)"results")) {
                JSONArray jsonResults = (JSONArray)jsonResponse.get((Object)"results");
                if (jsonResults.size() == 1) {
                    JSONObject jsonResult = (JSONObject)jsonResults.get(0);
                    String messageId = (String)jsonResult.get((Object)"message_id");
                    String canonicalRegId = (String)jsonResult.get((Object)"registration_id");
                    String error = (String)jsonResult.get((Object)"error");
                    resultBuilder.messageId(messageId).canonicalRegistrationId(canonicalRegId).errorCode(error);
                    return resultBuilder.build();
                }
                log.warn("Found null or {} results, expected one", (Object)jsonResults.size());
                return null;
            }
            if (to.startsWith("/topics/")) {
                if (jsonResponse.containsKey((Object)"message_id")) {
                    Long messageId = (Long)jsonResponse.get((Object)"message_id");
                    resultBuilder.messageId(messageId.toString());
                    return resultBuilder.build();
                }
                if (jsonResponse.containsKey((Object)"error")) {
                    String error = (String)jsonResponse.get((Object)"error");
                    resultBuilder.errorCode(error);
                    return resultBuilder.build();
                }
                logger.log(Level.WARNING, "Expected message_id or error found: " + responseBody);
                return null;
            }
            if (jsonResponse.containsKey((Object)"success") && jsonResponse.containsKey((Object)"failure")) {
                int success = this.getNumber((Map<?, ?>)jsonResponse, "success").intValue();
                int failure = this.getNumber((Map<?, ?>)jsonResponse, "failure").intValue();
                ArrayList<String> failedIds = null;
                if (jsonResponse.containsKey((Object)"failed_registration_ids")) {
                    JSONArray jFailedIds = (JSONArray)jsonResponse.get((Object)"failed_registration_ids");
                    failedIds = new ArrayList<String>();
                    for (int i = 0; i < jFailedIds.size(); ++i) {
                        failedIds.add((String)jFailedIds.get(i));
                    }
                }
                resultBuilder.success(success).failure(failure).failedRegistrationIds(failedIds);
                return resultBuilder.build();
            }
            logger.warning("Unrecognized response: " + responseBody);
            throw this.newIoException(responseBody, new Exception("Unrecognized response."));
        }
        catch (ParseException e) {
            throw this.newIoException(responseBody, (Exception)((Object)e));
        }
        catch (CustomParserException e) {
            throw this.newIoException(responseBody, e);
        }
    }

    public MulticastResult send(Message message, List<String> regIds, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        HashMap<String, Result> results = new HashMap<String, Result>();
        List<String> unsentRegIds = new ArrayList<String>(regIds);
        ArrayList<Long> multicastIds = new ArrayList<Long>();
        do {
            MulticastResult multicastResult = null;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send message " + message + " to regIds " + unsentRegIds);
            }
            try {
                multicastResult = this.sendNoRetry(message, unsentRegIds);
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "IOException on attempt " + attempt, e);
            }
            if (multicastResult != null) {
                long multicastId = multicastResult.getMulticastId();
                logger.fine("multicast_id on attempt # " + attempt + ": " + multicastId);
                multicastIds.add(multicastId);
                unsentRegIds = this.updateStatus(unsentRegIds, results, multicastResult);
                tryAgain = !unsentRegIds.isEmpty() && attempt <= retries;
            } else {
                boolean bl = tryAgain = attempt <= retries;
            }
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (multicastIds.isEmpty()) {
            throw new IOException("Could not post JSON requests to GCM after " + attempt + " attempts");
        }
        int success = 0;
        int failure = 0;
        int canonicalIds = 0;
        for (Result result : results.values()) {
            if (result.getMessageId() != null) {
                ++success;
                if (result.getCanonicalRegistrationId() == null) continue;
                ++canonicalIds;
                continue;
            }
            ++failure;
        }
        long multicastId = (Long)multicastIds.remove(0);
        MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId).retryMulticastIds(multicastIds);
        for (String regId : regIds) {
            Result result = (Result)results.get(regId);
            builder.addResult(result);
        }
        return builder.build();
    }

    private List<String> updateStatus(List<String> unsentRegIds, Map<String, Result> allResults, MulticastResult multicastResult) {
        List<Result> results = multicastResult.getResults();
        if (results.size() != unsentRegIds.size()) {
            throw new RuntimeException("Internal error: sizes do not match. currentResults: " + results + "; unsentRegIds: " + unsentRegIds);
        }
        ArrayList<String> newUnsentRegIds = new ArrayList<String>();
        for (int i = 0; i < unsentRegIds.size(); ++i) {
            String regId = unsentRegIds.get(i);
            Result result = results.get(i);
            allResults.put(regId, result);
            String error = result.getErrorCodeName();
            if (error == null || !error.equals("Unavailable") && !error.equals("InternalServerError")) continue;
            newUnsentRegIds.add(regId);
        }
        return newUnsentRegIds;
    }

    public MulticastResult sendNoRetry(Message message, List<String> registrationIds) throws IOException {
        if (Sender.nonNull(registrationIds).isEmpty()) {
            throw new IllegalArgumentException("registrationIds cannot be empty");
        }
        HashMap<Object, Object> jsonRequest = new HashMap<Object, Object>();
        this.messageToMap(message, jsonRequest);
        jsonRequest.put("registration_ids", registrationIds);
        String responseBody = this.makeGcmHttpRequest(jsonRequest);
        if (responseBody == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
            int success = this.getNumber((Map<?, ?>)jsonResponse, "success").intValue();
            int failure = this.getNumber((Map<?, ?>)jsonResponse, "failure").intValue();
            int canonicalIds = this.getNumber((Map<?, ?>)jsonResponse, "canonical_ids").intValue();
            long multicastId = this.getNumber((Map<?, ?>)jsonResponse, "multicast_id").longValue();
            MulticastResult.Builder builder = new MulticastResult.Builder(success, failure, canonicalIds, multicastId);
            List results = (List)jsonResponse.get((Object)"results");
            if (results != null) {
                for (Map jsonResult : results) {
                    String messageId = (String)jsonResult.get("message_id");
                    String canonicalRegId = (String)jsonResult.get("registration_id");
                    String error = (String)jsonResult.get("error");
                    Result result = new Result.Builder().messageId(messageId).canonicalRegistrationId(canonicalRegId).errorCode(error).build();
                    builder.addResult(result);
                }
            }
            return builder.build();
        }
        catch (ParseException e) {
            throw this.newIoException(responseBody, (Exception)((Object)e));
        }
        catch (CustomParserException e) {
            throw this.newIoException(responseBody, e);
        }
    }

    private String makeGcmHttpRequest(Map<Object, Object> jsonRequest) throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        String requestBody = JSONValue.toJSONString(jsonRequest);
        logger.finest("JSON request:  " + requestBody);
        try {
            conn = this.post("https://fcm.googleapis.com/fcm/send", "application/json", requestBody);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "IOException posting to GCM", e);
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Sender.getAndClose(conn.getErrorStream());
                logger.finest("JSON error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Sender.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException reading response", e);
            return null;
        }
        logger.finest("JSON response: " + responseBody);
        return responseBody;
    }

    private void messageToMap(Message message, Map<Object, Object> mapRequest) {
        if (message == null || mapRequest == null) {
            return;
        }
        this.setJsonField(mapRequest, "priority", message.getPriority());
        this.setJsonField(mapRequest, "time_to_live", message.getTimeToLive());
        this.setJsonField(mapRequest, "collapse_key", message.getCollapseKey());
        this.setJsonField(mapRequest, "restricted_package_name", message.getRestrictedPackageName());
        this.setJsonField(mapRequest, "delay_while_idle", message.isDelayWhileIdle());
        this.setJsonField(mapRequest, "dry_run", message.isDryRun());
        Map<String, String> payload = message.getData();
        if (!payload.isEmpty()) {
            mapRequest.put("data", payload);
        }
        if (message.getNotification() != null) {
            Notification notification = message.getNotification();
            HashMap<Object, Object> nMap = new HashMap<Object, Object>();
            if (notification.getBadge() != null) {
                this.setJsonField(nMap, "badge", notification.getBadge().toString());
            }
            this.setJsonField(nMap, "body", notification.getBody());
            this.setJsonField(nMap, "body_loc_args", notification.getBodyLocArgs());
            this.setJsonField(nMap, "body_loc_key", notification.getBodyLocKey());
            this.setJsonField(nMap, "click_action", notification.getClickAction());
            this.setJsonField(nMap, "color", notification.getColor());
            this.setJsonField(nMap, "icon", notification.getIcon());
            this.setJsonField(nMap, "sound", notification.getSound());
            this.setJsonField(nMap, "tag", notification.getTag());
            this.setJsonField(nMap, "title", notification.getTitle());
            this.setJsonField(nMap, "title_loc_args", notification.getTitleLocArgs());
            this.setJsonField(nMap, "title_loc_key", notification.getTitleLocKey());
            mapRequest.put("notification", nMap);
        }
    }

    private IOException newIoException(String responseBody, Exception e) {
        String msg = "Error parsing JSON response (" + responseBody + ")";
        logger.log(Level.WARNING, msg, e);
        return new IOException(msg + ":" + e);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "IOException closing stream", e);
            }
        }
    }

    private void setJsonField(Map<Object, Object> json, String field, Object value) {
        if (value != null) {
            json.put(field, value);
        }
    }

    private Number getNumber(Map<?, ?> json, String field) {
        Object value = json.get(field);
        if (value == null) {
            throw new CustomParserException("Missing field: " + field);
        }
        if (!(value instanceof Number)) {
            throw new CustomParserException("Field " + field + " does not contain a number: " + value);
        }
        return (Number)value;
    }

    protected HttpURLConnection post(String url, String body) throws IOException {
        return this.post(url, "application/x-www-form-urlencoded;charset=UTF-8", body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection post(String url, String contentType, String body) throws IOException {
        if (url == null || contentType == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!url.startsWith("https://")) {
            logger.warning("URL does not use https: " + url);
        }
        logger.fine("Sending POST to " + url);
        logger.finest("POST body: " + body);
        byte[] bytes = body.getBytes(UTF8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Authorization", "key=" + this.key);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(bytes);
        }
        finally {
            Sender.close(out);
        }
        return conn;
    }

    protected static final Map<String, String> newKeyValues(String key, String value) {
        HashMap<String, String> keyValues = new HashMap<String, String>(1);
        keyValues.put(Sender.nonNull(key), Sender.nonNull(value));
        return keyValues;
    }

    protected static StringBuilder newBody(String name, String value) {
        return new StringBuilder(Sender.nonNull(name)).append('=').append(Sender.nonNull(value));
    }

    protected static void addParameter(StringBuilder body, String name, String value) {
        Sender.nonNull(body).append('&').append(Sender.nonNull(name)).append('=').append(Sender.nonNull(value));
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    private static String getAndClose(InputStream stream) throws IOException {
        try {
            String inputString;
            String string = inputString = Sender.getString(stream);
            return string;
        }
        finally {
            if (stream != null) {
                Sender.close(stream);
            }
        }
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    class CustomParserException
    extends RuntimeException {
        private static final long serialVersionUID = 6899454469986715109L;

        CustomParserException(String message) {
            super(message);
        }
    }
}

