/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.google;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class Notification
implements Serializable {
    private static final long serialVersionUID = 2236529988909981069L;
    private final String title;
    private final String body;
    private final String icon;
    private final String sound;
    private final Integer badge;
    private final String tag;
    private final String color;
    private final String clickAction;
    private final String bodyLocKey;
    private final List<String> bodyLocArgs;
    private final String titleLocKey;
    private final List<String> titleLocArgs;

    private Notification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        this.sound = builder.sound;
        this.badge = builder.badge;
        this.tag = builder.tag;
        this.color = builder.color;
        this.clickAction = builder.clickAction;
        this.bodyLocKey = builder.bodyLocKey;
        this.bodyLocArgs = builder.bodyLocArgs;
        this.titleLocKey = builder.titleLocKey;
        this.titleLocArgs = builder.titleLocArgs;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getSound() {
        return this.sound;
    }

    public Integer getBadge() {
        return this.badge;
    }

    public String getTag() {
        return this.tag;
    }

    public String getColor() {
        return this.color;
    }

    public String getClickAction() {
        return this.clickAction;
    }

    public String getBodyLocKey() {
        return this.bodyLocKey;
    }

    public List<String> getBodyLocArgs() {
        return this.bodyLocArgs;
    }

    public String getTitleLocKey() {
        return this.titleLocKey;
    }

    public List<String> getTitleLocArgs() {
        return this.titleLocArgs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Notification(");
        if (this.title != null) {
            builder.append("title=").append(this.title).append(", ");
        }
        if (this.body != null) {
            builder.append("body=").append(this.body).append(", ");
        }
        if (this.icon != null) {
            builder.append("icon=").append(this.icon).append(", ");
        }
        if (this.sound != null) {
            builder.append("sound=").append(this.sound).append(", ");
        }
        if (this.badge != null) {
            builder.append("badge=").append(this.badge).append(", ");
        }
        if (this.tag != null) {
            builder.append("tag=").append(this.tag).append(", ");
        }
        if (this.color != null) {
            builder.append("color=").append(this.color).append(", ");
        }
        if (this.clickAction != null) {
            builder.append("clickAction=").append(this.clickAction).append(", ");
        }
        if (this.bodyLocKey != null) {
            builder.append("bodyLocKey=").append(this.bodyLocKey).append(", ");
        }
        if (this.bodyLocArgs != null) {
            builder.append("bodyLocArgs=").append(this.bodyLocArgs).append(", ");
        }
        if (this.titleLocKey != null) {
            builder.append("titleLocKey=").append(this.titleLocKey).append(", ");
        }
        if (this.titleLocArgs != null) {
            builder.append("titleLocArgs=").append(this.titleLocArgs).append(", ");
        }
        if (builder.charAt(builder.length() - 1) == ' ') {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }

    public static final class Builder {
        private final String icon;
        private String title;
        private String body;
        private String sound;
        private Integer badge;
        private String tag;
        private String color;
        private String clickAction;
        private String bodyLocKey;
        private List<String> bodyLocArgs;
        private String titleLocKey;
        private List<String> titleLocArgs;

        public Builder(String icon) {
            this.icon = icon;
            this.sound = "default";
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder body(String value) {
            this.body = value;
            return this;
        }

        public Builder sound(String value) {
            this.sound = value;
            return this;
        }

        public Builder badge(int value) {
            this.badge = value;
            return this;
        }

        public Builder tag(String value) {
            this.tag = value;
            return this;
        }

        public Builder color(String value) {
            this.color = value;
            return this;
        }

        public Builder clickAction(String value) {
            this.clickAction = value;
            return this;
        }

        public Builder bodyLocKey(String value) {
            this.bodyLocKey = value;
            return this;
        }

        public Builder bodyLocArgs(List<String> value) {
            this.bodyLocArgs = Collections.unmodifiableList(value);
            return this;
        }

        public Builder titleLocKey(String value) {
            this.titleLocKey = value;
            return this;
        }

        public Builder titleLocArgs(List<String> value) {
            this.titleLocArgs = Collections.unmodifiableList(value);
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

