/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.test;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQClass {
    private static final Logger log = LoggerFactory.getLogger(MQClass.class);
    ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://211.48.18.51:61616");
    Connection connection = null;
    Session session = null;
    Destination destination = null;
    MessageProducer producer = null;
    TextMessage message = null;

    public MQClass() {
        try {
            this.connection = this.connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createQueue("mapper.queue");
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
        }
        catch (Exception e) {
            log.error("[ERROR] MQ init Fail :{}", (Object)e.getMessage());
        }
    }

    public void send(String jsonToString) {
        block7: {
            try {
                this.message = this.session.createTextMessage(jsonToString);
                this.producer.send((Message)this.message);
                log.info("[insertActiveMQ] SUCCESS : {} ", (Object)this.message.getText());
            }
            catch (JMSException e) {
                log.error("[ERROR] ActiveMQ send Fail.. :{}", (Object)e.getMessage());
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException e1) {
                        log.error("print stack trace ", (Throwable)e1);
                    }
                }
                if (this.connection == null) break block7;
                try {
                    this.connection.close();
                }
                catch (JMSException e2) {
                    log.error("print stack trace ", (Throwable)e2);
                }
            }
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                log.error("print stack trace ", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                log.error("print stack trace ", (Throwable)e);
            }
        }
    }
}

