/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import com.humuson.tms.mapper.util.FIFOBuffer;
import java.util.List;

public class eMsStringTokenizer {
    public static final boolean DEBUG = false;
    private static final int MAX_CONTAIN_SIZE = 10;
    private static FIFOBuffer INNER_CONTAINER = null;
    private String _SOURCE_ = null;
    private String _DELIM_ = null;
    private int _INDEX_ = 0;
    private int _STRING_SIZE_ = 0;
    private boolean _REACH_END_ = false;

    public static eMsStringTokenizer getInstance() {
        Object returnValue = INNER_CONTAINER.pop();
        if (returnValue == null) {
            return new eMsStringTokenizer();
        }
        return (eMsStringTokenizer)returnValue;
    }

    public static void recycleInstance(eMsStringTokenizer tmp) {
        if (tmp == null) {
            return;
        }
        INNER_CONTAINER.push(tmp);
    }

    public eMsStringTokenizer() {
        this._REACH_END_ = false;
    }

    public eMsStringTokenizer(String src, String delimit) {
        this.parse(src, delimit);
    }

    public void parse(String src, String delimit) {
        this._SOURCE_ = src;
        this._DELIM_ = delimit;
        this._INDEX_ = 0;
        this._STRING_SIZE_ = this._SOURCE_.length();
        this._REACH_END_ = false;
        if (this._DELIM_ == null || this._DELIM_.length() < 1) {
            throw new RuntimeException("DELIM IS NULL OR ZERO LENGTH");
        }
    }

    public void rewind() {
        this._INDEX_ = 0;
        this._REACH_END_ = false;
    }

    public boolean hasMoreTokens() {
        return !this._REACH_END_;
    }

    public int getCurrentIndex() {
        return this._INDEX_;
    }

    public String nextToken() {
        if (this._REACH_END_) {
            return null;
        }
        int idx = this._SOURCE_.indexOf(this._DELIM_, this._INDEX_);
        if (idx < 0) {
            this._REACH_END_ = true;
            return this._INDEX_ == this._STRING_SIZE_ ? "" : this._SOURCE_.substring(this._INDEX_);
        }
        String returnValue = this._INDEX_ == idx ? "" : this._SOURCE_.substring(this._INDEX_, idx);
        this._INDEX_ = idx + this._DELIM_.length();
        return returnValue;
    }

    public String nextToken(String delim) {
        if (this._REACH_END_) {
            return null;
        }
        int idx = this._SOURCE_.indexOf(delim, this._INDEX_);
        if (idx < 0) {
            this._REACH_END_ = true;
            return this._INDEX_ == this._STRING_SIZE_ ? "" : this._SOURCE_.substring(this._INDEX_);
        }
        String returnValue = this._INDEX_ == idx ? "" : this._SOURCE_.substring(this._INDEX_, idx);
        this._INDEX_ = idx + delim.length();
        return returnValue;
    }

    public List toList(List returnValue) {
        while (this.hasMoreTokens()) {
            returnValue.add(this.nextToken());
        }
        return returnValue;
    }

    static {
        INNER_CONTAINER = new FIFOBuffer(10);
    }
}

