/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class eMsFileWriter
extends PrintWriter {
    private static final Logger log = LoggerFactory.getLogger(eMsFileWriter.class);

    public eMsFileWriter(OutputStream stream, String charset) throws IOException {
        super(new OutputStreamWriter(stream, charset));
    }

    public eMsFileWriter(OutputStream stream) throws IOException {
        this(stream, "UTF-8");
    }

    public eMsFileWriter(String name, boolean append, String charset) throws IOException {
        this((OutputStream)new FileOutputStream(name, append), charset);
    }

    public eMsFileWriter(String name) throws IOException {
        this(name, false, "UTF-8");
    }

    public eMsFileWriter(String name, boolean append) throws IOException {
        this(name, append, "UTF-8");
    }

    public eMsFileWriter(String name, String charset) throws IOException {
        this(name, false, charset);
    }

    @Override
    public void println() {
        super.println();
        this.flush();
    }

    @Override
    public void println(String a) {
        super.println(a);
        this.flush();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static final void putLocalFile(String filename, String content, String charset) throws IOException {
        try (eMsFileWriter writer = new eMsFileWriter(filename, charset);){
            writer.print(content);
            writer.flush();
        }
        catch (Exception e) {
            log.error("writer error", (Throwable)e);
        }
    }
}

