/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QPEncodeOutputStream
extends BufferedOutputStream {
    private int count;
    private int bytesPerLine;
    private boolean gotSpace = false;
    private boolean gotCR = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public QPEncodeOutputStream(OutputStream out, int i) {
        super(out, i + 2);
        this.bytesPerLine = i - 1;
    }

    public QPEncodeOutputStream(OutputStream out) {
        this(out, 76);
    }

    @Override
    public synchronized void write(byte[] source, int i, int j) throws IOException {
        for (int k = 0; k < j; ++k) {
            this.write(source[i + k]);
        }
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public synchronized void write(int i) throws IOException {
        i &= 0xFF;
        if (this.gotSpace) {
            if (i == 13 || i == 10) {
                this.output(32, true);
            } else {
                this.output(32, false);
            }
            this.gotSpace = false;
        }
        if (i == 32) {
            this.gotSpace = true;
            return;
        }
        if (i == 13) {
            this.gotCR = true;
            this.outputCRLF();
            return;
        }
        if (i == 10) {
            if (this.gotCR) {
                this.gotCR = false;
                return;
            }
            this.outputCRLF();
            return;
        }
        if (i < 32 || i >= 127 || i == 61) {
            this.output(i, true);
            return;
        }
        this.output(i, false);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
    }

    private void outputCRLF() throws IOException {
        super.write(13);
        super.write(10);
        this.count = 0;
    }

    protected void output(int i, boolean flag) throws IOException {
        if (flag) {
            if ((this.count += 3) > this.bytesPerLine) {
                super.write(61);
                super.write(13);
                super.write(10);
                this.count = 3;
            }
            super.write(61);
            super.write(hex[i >> 4]);
            super.write(hex[i & 0xF]);
            return;
        }
        if (++this.count > this.bytesPerLine) {
            super.write(61);
            super.write(13);
            super.write(10);
            this.count = 1;
        }
        super.write(i);
    }
}

