/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import com.humuson.tms.mapper.util.BASE64EncodeOutputStream;
import com.humuson.tms.mapper.util.QPEncodeOutputStream;
import com.humuson.tms.mapper.util.UUEncodeOutputStream;
import com.humuson.tms.mapper.util.eMsByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeConvertor {
    private static final Logger log = LoggerFactory.getLogger(MimeConvertor.class);
    public static final int ENCODE_SUBJECT_HEADER_SPLIT_LIMIT = 15;
    public static final int NORMAL_SUBJECT_HEADER_SPLIT_LIMIT = 30;
    private static final String JIS_CONVERT = " SJIS ISO-2022-JP ";
    private static final byte[] JIS_ESC = new byte[]{27, 40, 66, 27, 36, 66, 27, 40, 73};
    private static final int EQUAL = 61;
    private static final int QUESTION = 63;
    private static final int BASE64_OUT = 66;
    private static final int QP_OUT = 81;

    public static final String getMimeText(String src, String baseCharset, String mimeCharset, short type, boolean header) throws Exception {
        eMsByteArrayOutputStream out = null;
        try {
            out = eMsByteArrayOutputStream.getInstance();
            if (header) {
                MimeConvertor.putHeaderToStream(out, src, baseCharset, mimeCharset, type);
            } else {
                MimeConvertor.putMimeToStream(out, src, baseCharset, mimeCharset, type);
            }
            String string = out.toString(mimeCharset);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(out);
        }
    }

    public static final void putMimeToStream(OutputStream out, String src, String baseCharset, String mimeCharset, short type) throws Exception {
        OutputStream ENC_STREAM = null;
        switch (type) {
            case 1: {
                ENC_STREAM = new BASE64EncodeOutputStream(out);
                break;
            }
            case 2: {
                ENC_STREAM = new QPEncodeOutputStream(out, 1024);
                break;
            }
            case 3: {
                ENC_STREAM = new UUEncodeOutputStream(out);
                break;
            }
            default: {
                ENC_STREAM = out;
            }
        }
        ENC_STREAM.write(src.getBytes(mimeCharset));
        ENC_STREAM.flush();
        out.flush();
    }

    public static final void putMimeToStreamNew(OutputStream out, String src, String baseCharset, String mimeCharset, short type) throws Exception {
        OutputStream ENC_STREAM = null;
        switch (type) {
            case 1: {
                ENC_STREAM = new BASE64EncodeOutputStream(out, 1024);
                break;
            }
            case 2: {
                ENC_STREAM = new QPEncodeOutputStream(out, 1024);
                break;
            }
            case 3: {
                ENC_STREAM = new UUEncodeOutputStream(out);
                break;
            }
            default: {
                ENC_STREAM = out;
            }
        }
        ENC_STREAM.flush();
        out.flush();
    }

    public static final void putHeaderToStream(OutputStream out, String src, String baseCharset, String mimeCharset, short type) throws Exception {
        OutputStream ENC_STREAM = null;
        switch (type) {
            case 1: {
                out.write(61);
                out.write(63);
                out.write(mimeCharset.getBytes());
                out.write(63);
                out.write(66);
                out.write(63);
                ENC_STREAM = new BASE64EncodeOutputStream(out, 1024);
                break;
            }
            case 2: {
                out.write(61);
                out.write(63);
                out.write(mimeCharset.getBytes());
                out.write(63);
                out.write(81);
                out.write(63);
                ENC_STREAM = new QPEncodeOutputStream(out, 1024);
                break;
            }
            default: {
                ENC_STREAM = out;
            }
        }
        if (JIS_CONVERT.indexOf(mimeCharset.toUpperCase()) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("convert jis:" + src);
            }
            MimeConvertor.sjis2jis(src.getBytes(baseCharset), ENC_STREAM);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("normal split");
            }
            ENC_STREAM.write(src.getBytes(baseCharset));
        }
        ENC_STREAM.flush();
        switch (type) {
            case 1: 
            case 2: {
                out.write(63);
                out.write(61);
            }
        }
        out.flush();
    }

    public static final void putSubjectToStream(OutputStream out, String src, String baseCharset, String mimeCharset, boolean encode) throws Exception {
        int limit = encode ? 15 : 30;
        int length = src.length();
        if (length > limit) {
            for (int idx = 0; idx < length; idx += limit) {
                String target;
                String string = target = idx + limit < length ? src.substring(idx, idx + limit) : src.substring(idx);
                if (idx > 0) {
                    out.write("\r\n ".getBytes());
                }
                MimeConvertor.putHeaderToStream(out, target, baseCharset, mimeCharset, encode ? (short)1 : 4);
            }
        } else {
            MimeConvertor.putHeaderToStream(out, src, baseCharset, mimeCharset, encode ? (short)1 : 4);
        }
    }

    public static void sjis2jis(byte[] b, OutputStream out) throws Exception {
        int b2 = 0;
        int c = 0;
        int n = b.length;
        for (int i = 0; i < n; ++i) {
            int b1;
            int n2 = b1 = b[i] < 0 ? b[i] + 256 : b[i];
            if (161 <= b1 && b1 <= 223) {
                if (c != 2) {
                    c = 2;
                    if (log.isDebugEnabled()) {
                        System.out.print("/");
                    }
                    out.write(JIS_ESC[6]);
                    out.write(JIS_ESC[8]);
                    out.write(JIS_ESC[8]);
                }
                out.write(b1);
                continue;
            }
            if (b1 >= 128) {
                if (c != 1) {
                    c = 1;
                    if (log.isDebugEnabled()) {
                        System.out.print("-");
                    }
                    out.write(JIS_ESC[3]);
                    out.write(JIS_ESC[4]);
                    out.write(JIS_ESC[5]);
                }
                b2 = b[i + 1] < 0 ? b[i + 1] + 256 : b[i + 1];
                b1 <<= 1;
                if (b2 < 159) {
                    b1 = b1 < 319 ? (b1 -= 225) : (b1 -= 97);
                    b2 = b2 > 126 ? (b2 -= 32) : (b2 -= 31);
                } else {
                    b1 = b1 < 319 ? (b1 -= 224) : (b1 -= 96);
                    b2 -= 126;
                }
                out.write(b1);
                out.write(b2);
                ++i;
                continue;
            }
            if (c != 0) {
                c = 0;
                if (log.isDebugEnabled()) {
                    System.out.print("\\");
                }
                out.write(JIS_ESC[0]);
                out.write(JIS_ESC[1]);
                out.write(JIS_ESC[2]);
            }
            out.write(b1);
        }
        if (c != 0) {
            if (log.isDebugEnabled()) {
                System.out.print("*");
            }
            out.write(JIS_ESC[0]);
            out.write(JIS_ESC[1]);
            out.write(JIS_ESC[2]);
        }
    }
}

