/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static byte[] __FILE_COPY_BUFFER = null;

    public static boolean isValidFile(String fileName) {
        boolean valid = true;
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            valid = false;
        }
        return valid;
    }

    public static boolean existsLocal(String fName, String fDir) {
        File oFile = new File(fDir);
        String[] aFiles = oFile.list();
        if (aFiles == null) {
            return false;
        }
        boolean bFileExist = false;
        for (int i = 0; i < aFiles.length; ++i) {
            if (!aFiles[i].equals(fName)) continue;
            bFileExist = true;
        }
        return bFileExist;
    }

    public static boolean moveFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
        File file = new File(fileDirPath + "/" + fileName);
        return file.renameTo(new File(destDirPath + "/" + toFileName));
    }

    public static boolean moveFile(String fileName, String fileDirPath, String destDirPath) {
        File file = new File(fileDirPath + "/" + fileName);
        return file.renameTo(new File(destDirPath + "/" + fileName));
    }

    public static void copyFile(String fileName, String fileDirPath, String destDirPath) {
        FileUtil.copyFile(fileName, fileName, fileDirPath, destDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcIn = null;
        AbstractInterruptibleChannel fcOut = null;
        try {
            File sourceFile = new File(fileDirPath + "/" + fileName);
            File destFile = new File(destDirPath + "/" + fileName);
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(destFile);
            fcIn = fis.getChannel();
            fcOut = fos.getChannel();
            long size = ((FileChannel)fcIn).size();
            ((FileChannel)fcIn).transferTo(0L, size, (WritableByteChannel)((Object)fcOut));
        }
        catch (IOException e) {
            logger.error("copyFile IOException", (Throwable)e);
        }
        finally {
            if (fcIn != null) {
                try {
                    fcIn.close();
                }
                catch (IOException e) {
                    logger.error("fcIn close IOException", (Throwable)e);
                }
            }
            if (fcOut != null) {
                try {
                    fcOut.close();
                }
                catch (IOException e) {
                    logger.error("fcOut close IOException", (Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("fis close IOException", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("fos close IOException", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String url) throws IOException {
        HttpURLConnection m_client;
        if (url == null) {
            return null;
        }
        URL myURL = new URL(url.trim());
        int __RESPONSE_CODE__ = 0;
        try {
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
            }
        }
        InputStream is = m_client.getInputStream();
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = is.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString("UTF-8");
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (m_client != null) {
                try {
                    m_client.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String url, String charset) throws IOException {
        HttpURLConnection m_client;
        if (url == null) {
            return null;
        }
        url = url.trim();
        URL myURL = new URL(url);
        int __RESPONSE_CODE__ = 0;
        try {
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
            }
        }
        InputStream is = m_client.getInputStream();
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = is.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString(charset);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (m_client != null) {
                try {
                    m_client.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readUrlToByteArray(String url, String charset) throws IOException {
        HttpURLConnection m_client;
        if (url == null) {
            return null;
        }
        url = url.trim();
        URL myURL = new URL(url);
        int __RESPONSE_CODE__ = 0;
        try {
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
            }
        }
        InputStream is = m_client.getInputStream();
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes;
            int j;
            while ((j = is.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (m_client != null) {
                try {
                    m_client.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static void makeUrl(String fileUploadUrl) throws IOException {
        File file = new File(fileUploadUrl);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static void writeLocal(String fName, String s, boolean add) throws IOException {
        File f = new File(fName);
        FileUtil.writeLocal(f, s, "UTF-8", add);
    }

    public static void writeLocal(String fName, String s, String enc, boolean add) throws IOException {
        File f = new File(fName);
        FileUtil.writeLocal(f, s, enc, add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLocal(File f, String s, String enc, boolean add) throws IOException {
        if (s == null) {
            return;
        }
        byte[] b = new byte[128];
        try (ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes(enc));
             FileOutputStream fos = new FileOutputStream(f, add);){
            int j;
            while ((j = bais.read(b)) > 0) {
                fos.write(b, 0, j);
                fos.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLocal(File f, String enc) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = fis.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString(enc);
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String readLocalReturnStream(String fileName, String enc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readLocal(String fName) throws IOException {
        File f = new File(fName);
        if (f.exists()) {
            return FileUtil.readLocal(f, "UTF-8");
        }
        return "";
    }

    public static String readLocal(String fName, String enc) throws IOException {
        File f = new File(fName);
        return FileUtil.readLocal(f, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean fileCopy(String src, String dest) {
        if (__FILE_COPY_BUFFER == null) {
            __FILE_COPY_BUFFER = new byte[4096];
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int size;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            while ((size = in.read(__FILE_COPY_BUFFER)) >= 0) {
                out.write(__FILE_COPY_BUFFER, 0, size);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(InputStream stream, String path) throws FileNotFoundException, IOException {
        int bytesRead = 0;
        try (FileOutputStream bos = new FileOutputStream(path);){
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String upload(InputStream stream, String originFileName, String filePath) throws FileNotFoundException, IOException {
        String fileName = FileUtil.makeName(originFileName, false);
        FileUtil.upload(stream, filePath + fileName);
        return fileName;
    }

    public static String uploadNew(InputStream stream, String originFileName, String filePath) throws FileNotFoundException, IOException {
        String fileName = FileUtil.makeNameNew(originFileName);
        FileUtil.upload(stream, filePath + fileName);
        return fileName;
    }

    public static String makeName(String sExt, boolean reverse) {
        int nRand;
        while ((nRand = (int)(Math.random() * 10000.0)) <= 1000) {
        }
        if (reverse) {
            return sExt + "_" + new Date().getTime() + "_" + nRand;
        }
        return new Date().getTime() + "_" + nRand + "_" + sExt;
    }

    public static String makeNameNew(String sExt) {
        int nRand;
        while ((nRand = (int)(Math.random() * 10000.0)) <= 1000) {
        }
        return new Date().getTime() + "_" + nRand + sExt.substring(sExt.lastIndexOf("."));
    }
}

