/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.util;

import com.humuson.tms.mapper.util.StringConvertUtil;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimConvertor {
    private static final Logger log = LoggerFactory.getLogger(DelimConvertor.class);
    public static final String ENC_CHARS = "\r\n|[]{}";
    protected static final String[] ENC_TARGETS = new String[7];
    protected static final Hashtable DEC_MAP = new Hashtable();

    public static void encodeToBuffer(StringBuffer __TMP_BUFFER__, String returnValue) {
        if (returnValue == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("DELIM ENCODE BEFORE", (Object)returnValue);
        }
        int enc_index = -1;
        char target_charactor = '\u0000';
        int length = returnValue.length();
        for (int idx = 0; idx < length; ++idx) {
            target_charactor = returnValue.charAt(idx);
            enc_index = ENC_CHARS.indexOf(target_charactor);
            if (enc_index < 0) {
                __TMP_BUFFER__.append(target_charactor);
                continue;
            }
            __TMP_BUFFER__.append(ENC_TARGETS[enc_index]);
        }
    }

    public static String encode(String returnValue) {
        if (returnValue == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("DELIM ENCODE BEFORE", (Object)returnValue);
        }
        int enc_index = -1;
        char target_charactor = '\u0000';
        int length = returnValue.length();
        StringBuffer __TMP_BUFFER__ = new StringBuffer();
        for (int idx = 0; idx < length; ++idx) {
            target_charactor = returnValue.charAt(idx);
            enc_index = ENC_CHARS.indexOf(target_charactor);
            if (enc_index < 0) {
                __TMP_BUFFER__.append(target_charactor);
                continue;
            }
            __TMP_BUFFER__.append(ENC_TARGETS[enc_index]);
        }
        return __TMP_BUFFER__.toString();
    }

    public static String decode(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer __TMP_BUFFER__ = null;
        try {
            __TMP_BUFFER__ = new StringBuffer(256);
            __TMP_BUFFER__.setLength(0);
            DelimConvertor.decodeToBuffer(__TMP_BUFFER__, source);
            String string = __TMP_BUFFER__.toString();
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            __TMP_BUFFER__ = null;
        }
    }

    public static void decodeToBuffer(StringBuffer __TMP_BUFFER__, String source) {
        if (source == null) {
            return;
        }
        StringConvertUtil.convertString(__TMP_BUFFER__, source, DEC_MAP, "$#", "#", false, false);
    }

    static {
        DelimConvertor.ENC_TARGETS[0] = "$#CR#";
        DelimConvertor.ENC_TARGETS[1] = "$#LF#";
        DelimConvertor.ENC_TARGETS[2] = "$#delim#";
        DelimConvertor.ENC_TARGETS[3] = "$#start_big#";
        DelimConvertor.ENC_TARGETS[4] = "$#end_big#";
        DelimConvertor.ENC_TARGETS[5] = "$#start_small#";
        DelimConvertor.ENC_TARGETS[6] = "$#end_small#";
        DEC_MAP.put("delim", "|");
        DEC_MAP.put("start_big", "[");
        DEC_MAP.put("end_big", "]");
        DEC_MAP.put("start_small", "{");
        DEC_MAP.put("end_small", "}");
        DEC_MAP.put("CR", "\r");
        DEC_MAP.put("LF", "\n");
    }
}

