/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.tracking;

import com.humuson.tms.mapper.db.MapperDao;
import com.humuson.tms.mapper.tracking.ContentTrackingExecutor;
import com.humuson.tms.mapper.tracking.LinkContent;
import com.humuson.tms.mapper.tracking.LinkParser;
import com.humuson.tms.util.Cal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultContentTrackingExecutor
implements ContentTrackingExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentTrackingExecutor.class);
    private final MapperDao mapperDao;
    @Value(value="${mapper.tracking-url}")
    private String trackingUrl;
    @Value(value="${mapper.link.length.limit}")
    private String linkLengthMin;
    @Value(value="${mapper.link.click-tracking-use:false}")
    private boolean clickTrackingUse;

    @Override
    public String contentTrackingParsing(String source, StringBuffer tmpBuffer, Properties campProp) throws Exception {
        String INSTANCE_TR_URL = "";
        String __FINAL_OUTPUT__ = source;
        StringBuffer resSb = new StringBuffer();
        INSTANCE_TR_URL = this.initProperty(campProp);
        if (campProp.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y")) {
            LinkParser __LINK_PARSER__ = new LinkParser();
            try {
                __LINK_PARSER__.parse(__FINAL_OUTPUT__);
            }
            catch (Exception e) {
                log.error("MP5202|content link parsing Error :{}", (Object)e.getMessage());
            }
            LinkContent linkContent = null;
            Object __LINK_ELEMENT__ = null;
            resSb.setLength(0);
            try {
                Iterator iter = __LINK_PARSER__.iterator();
                while (iter.hasNext()) {
                    __LINK_ELEMENT__ = iter.next();
                    if (__LINK_ELEMENT__ instanceof LinkContent) {
                        linkContent = (LinkContent)__LINK_ELEMENT__;
                        if (linkContent.getUrl().startsWith("http")) {
                            tmpBuffer.setLength(0);
                            tmpBuffer.append(INSTANCE_TR_URL);
                            tmpBuffer.append("&");
                            tmpBuffer.append("TYPE=C");
                            tmpBuffer.append("&");
                            tmpBuffer.append("CLICK_ID=" + linkContent.getID());
                            tmpBuffer.append("&");
                            tmpBuffer.append("MEMBER_ID=${ENC_MEMBER_ID}");
                            tmpBuffer.append("&");
                            tmpBuffer.append("MEMBER_ID_SEQ=${UNIQUE_SEQ}");
                            tmpBuffer.append("&");
                            tmpBuffer.append("URL=" + linkContent.getUrl());
                            resSb.append(linkContent.getLinkConvert(tmpBuffer.toString()));
                            continue;
                        }
                        resSb.append(__LINK_ELEMENT__.toString());
                        iter.remove();
                        continue;
                    }
                    resSb.append(__LINK_ELEMENT__.toString());
                    iter.remove();
                }
            }
            catch (Exception e) {
                log.error("MP5201|Tracking Link Create Fail:{}", (Throwable)e);
                throw new Exception("Tracking Link Create Fail");
            }
            __FINAL_OUTPUT__ = resSb.toString();
            try {
                this.storeTrackingInfoToDB(__LINK_PARSER__, campProp);
            }
            catch (Exception e) {
                log.error("MP1001|Content Link Data Insert Error...{}", (Throwable)e);
                throw new Exception("Content Link Data Insert Error");
            }
            finally {
                __LINK_PARSER__.clear();
            }
        }
        String head = null;
        String tail = null;
        int idxBodyEnd = __FINAL_OUTPUT__.toLowerCase().indexOf("</body");
        if (idxBodyEnd > 0) {
            head = __FINAL_OUTPUT__.substring(0, idxBodyEnd);
            tail = __FINAL_OUTPUT__.substring(idxBodyEnd);
        } else {
            head = __FINAL_OUTPUT__;
            tail = "";
        }
        resSb.setLength(0);
        resSb.append(head);
        resSb.append("<div style=\"display:none\">");
        resSb.append("<IMG width=0 height=0 src=\"");
        resSb.append(INSTANCE_TR_URL);
        resSb.append("&");
        resSb.append("TYPE=O");
        resSb.append("&");
        resSb.append("MEMBER_ID=${ENC_MEMBER_ID}");
        resSb.append("&");
        resSb.append("MEMBER_ID_SEQ=${UNIQUE_SEQ}");
        resSb.append("\">");
        resSb.append("</div>");
        resSb.append(tail);
        return resSb.toString();
    }

    @Override
    public void storeTrackingInfoToDB(List linkInfos, Properties campProp) throws Exception {
        if (!this.clickTrackingUse) {
            return;
        }
        try {
            HashMap<String, String> linkMap = new HashMap<String, String>();
            for (LinkContent linkContent : linkInfos) {
                int result;
                block7: {
                    String tempContent = linkContent.getContent();
                    if (tempContent.length() > Integer.parseInt(this.linkLengthMin)) {
                        tempContent = tempContent.substring(0, Integer.parseInt(this.linkLengthMin));
                    }
                    linkMap.put("SEND_ID", (String)campProp.get("SEND_ID"));
                    linkMap.put("CHANNEL_TYPE", (String)campProp.get("CHANNEL_TYPE"));
                    linkMap.put("CLICK_ID", linkContent.getID());
                    linkMap.put("CLICK_DESC", tempContent);
                    linkMap.put("LINK_URL", linkContent.getUrl());
                    result = 0;
                    try {
                        result = this.mapperDao.insertLinkInfo(linkMap);
                    }
                    catch (Exception e2) {
                        if (!e2.getMessage().contains("ORA-00001")) break block7;
                        result = this.mapperDao.insertLinkInfo(linkMap);
                    }
                }
                log.debug("[stroreTrackingInfoToDB] [SUCCESS] LINKINFO DB_INSERT CLICK_ID [{}] result [{}]", (Object)linkContent.getID(), (Object)result);
                linkMap.clear();
            }
        }
        catch (Exception e) {
            log.error("[ERROR] stroreTrackingInfoToDB Fail:{}", (Throwable)e);
            throw new Exception("[ERROR] stroreTrackingInfoToDB Fail:{}", e);
        }
    }

    @Override
    public String initProperty(Properties campProp) {
        StringBuilder tmpBuffer = new StringBuilder();
        try {
            String trURl = this.trackingUrl + "?";
            tmpBuffer.setLength(0);
            tmpBuffer.append(trURl);
            tmpBuffer.append("SITE_ID=" + campProp.getProperty("SITE_ID"));
            tmpBuffer.append("&");
            tmpBuffer.append("SEND_ID=" + campProp.getProperty("SEND_ID"));
            tmpBuffer.append("&");
            tmpBuffer.append("SCHD_ID=" + campProp.getProperty("SCHD_ID"));
            tmpBuffer.append("&");
            tmpBuffer.append("WORKDAY=" + campProp.getProperty("WORKDAY"));
            tmpBuffer.append("&");
            tmpBuffer.append("TRACKING_CLOSE=" + campProp.getProperty("TRACKING_CLOSE", Cal.getAddDayDate((int)7)));
        }
        catch (Exception e) {
            log.error("intProperty error", (Throwable)e);
        }
        return tmpBuffer.toString();
    }

    public DefaultContentTrackingExecutor(MapperDao mapperDao) {
        this.mapperDao = mapperDao;
    }
}

