/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.scheduler;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.mapper.config.ActivemqConnectorConfigMapper;
import com.humuson.tms.mapper.mq.TmsDefaultMessageListenerContainer;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.util.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class CheckLiveScheduler {
    private static final Logger log = LoggerFactory.getLogger(CheckLiveScheduler.class);
    @Value(value="${tms.daemon-type:MP}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Value(value="${mapper.memory-check.max-percent:80}")
    private int memoryMaxPercent;
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    DecimalFormat df = new DecimalFormat("#0");
    @Autowired
    ActivemqConnectorConfigMapper activemqConnectorConfigMapper;
    private Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.check-interval}")
    private void schedule() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        String smemUsed = this.df.format((double)memUsage.getUsed() / 1048576.0);
        String smemMax = this.df.format((double)memUsage.getMax() / 1048576.0);
        String[] dates = DateUtil.getDivideDateDefault();
        String key = "JSTAT:" + this.daemonType;
        String field = this.daemonId + ":" + dates[0];
        this.liveTraceLogger.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{key, field, dates[1], smemMax, smemUsed});
        log.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{key, field, dates[1], smemMax, smemUsed});
        try {
            String oldValue = this.wrapperRedisTemplate.hmget(key, field);
            oldValue = StringUtil.isNull(oldValue) ? "" : oldValue + "|";
            this.wrapperRedisTemplate.hmset(key, field, oldValue + dates[1] + ":" + smemMax + ":" + smemUsed);
        }
        catch (Exception e) {
            log.error("[ERROR] JSTAT Update Fail. key:{}, filed:{}, {}", new Object[]{key, field, e.toString()});
        }
        finally {
            this.wrapperRedisTemplate.close();
            memoryMxBean = null;
            memUsage = null;
            smemUsed = null;
            smemMax = null;
            dates = null;
            key = null;
            field = null;
        }
        this.checkMqConsumer();
    }

    public boolean isCheckMemory() {
        boolean res = false;
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String useMemory = df.format((double)memUsage.getUsed() / 1048576.0);
        String totalMemory = df.format((double)memUsage.getMax() / 1048576.0);
        int usePercent = (int)(Double.parseDouble(useMemory) / Double.parseDouble(totalMemory) * 100.0);
        log.info("[CheckMemory] totalMemory:{}/useMemory:{} / criticalPercent:{} %/ usePercent:{} %", new Object[]{totalMemory, useMemory, this.memoryMaxPercent, usePercent});
        if (usePercent >= this.memoryMaxPercent) {
            res = true;
        }
        return res;
    }

    public boolean checkMqConsumer() {
        String logMsg = "";
        ConcurrentHashMap<String, TmsDefaultMessageListenerContainer> list = this.activemqConnectorConfigMapper.getMessageListenerList();
        for (Map.Entry<String, TmsDefaultMessageListenerContainer> entry : list.entrySet()) {
            String key = entry.getKey();
            TmsDefaultMessageListenerContainer listener = entry.getValue();
            logMsg = logMsg + "queue: " + key + "(activeConsumerCount:" + listener.getActiveConsumerCount() + "), ";
        }
        if (logMsg.contains(",")) {
            logMsg = logMsg.trim().substring(0, logMsg.lastIndexOf(","));
        }
        if (logMsg.trim().length() > 0) {
            log.info(logMsg);
        }
        return true;
    }
}

