/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.mapping;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.DBTypeDetector;
import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.body.SourceAdd;
import com.humuson.tms.mapper.content.ContentReadWrite;
import com.humuson.tms.mapper.db.BatchExecutor;
import com.humuson.tms.mapper.db.MapperDao;
import com.humuson.tms.mapper.filter.Filter;
import com.humuson.tms.mapper.info.ConnectInfo;
import com.humuson.tms.mapper.info.KeyValueInfo;
import com.humuson.tms.mapper.info.MapperInfo;
import com.humuson.tms.mapper.info.MappingInfo;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.mq.MQProducer;
import com.humuson.tms.mapper.redis.RedisExecutor;
import com.humuson.tms.mapper.util.StringConvertUtil;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.mapper.util.eMsStringWriter;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.StringUtils;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.util.net.HttpUtil;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultContentMapping
implements ContentMapping {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentMapping.class);
    public static final String ATTACH_PREFIX = "ATTACH_";
    @Autowired
    private MapperDao mapperDao;
    @Autowired
    private Filter filter;
    @Autowired
    private RedisExecutor redisExecutor;
    @Autowired
    private BatchExecutor batchExecutor;
    @Autowired
    private MQProducer mqProducer;
    @Autowired
    private SourceAdd sourceAdd;
    @Autowired
    private ContentReadWrite contentReadWrite;
    @Value(value="${mapper.secure.default-attach-name}")
    private String defaultSecureAttachName;
    @Value(value="${mapper.content-save-file-yn}")
    public String contentSaveFileYn;
    @Value(value="${mapper.content-save-path}")
    private String contentRootPath;
    @Value(value="${mapper.content-save-url}")
    private String contentRootUrl;
    @Value(value="${mapper.content-save-file-separator}")
    private String contentSaveFileSeparator;
    @Value(value="${mapper.sms.max-byte}")
    private String smsMaxByte;
    @Value(value="${mapper.lms.max-byte}")
    private String lmsMaxByte;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${mapper.send-flag-count}")
    private String sendFlagCnt;
    @Value(value="${mapper.map-data-save-path}")
    private String mapDataSavePath;
    @Value(value="${mapper.map-data-save-ip}")
    private String mapDataSaveIp;
    @Value(value="${wt.port}")
    private String wtPort;
    @Value(value="${wt.get-file-path}")
    private String wtGetFilePath;
    @Value(value="${mapper.file-save-byte}")
    private String fileSaveByte;
    @Value(value="${mapper.content-compress-yn:Y}")
    private String isContentSaveCompress;
    Configuration cfg;

    @PostConstruct
    public void init() {
        this.cfg = this.configFreeMarker();
    }

    public Configuration configFreeMarker() {
        try {
            BeansWrapperBuilder builder = new BeansWrapperBuilder(Configuration.VERSION_2_3_23);
            builder.setUseModelCache(true);
            BeansWrapper wrapper = builder.build();
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel tplHashModelStringUtils = (TemplateHashModel)staticModels.get("com.humuson.tms.mapper.util.StringUtil");
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setSharedVariable("util", (TemplateModel)tplHashModelStringUtils);
            cfg.setDefaultEncoding("UTF-8");
            return cfg;
        }
        catch (Exception e) {
            log.error("FREEMARKER configruration fail : {} ", (Throwable)e);
            return null;
        }
    }

    @Override
    public int executeContentMapping(String content, List<MapperInfo> totalList, String targetSeq) throws Exception {
        String cRsltField;
        String tempIntroContent;
        Template templateContent = null;
        Template templateSecureAttach = null;
        Template templateSecureIntro = null;
        ArrayList<String> afterMQList = new ArrayList<String>();
        HashMap<String, String> afterTlistMap = new HashMap<String, String>();
        HashMap<String, String> afterCrsltMap = new HashMap<String, String>();
        HashMap<String, String> afterDlistMap = new HashMap<String, String>();
        Map<String, String> userCrsltMap = null;
        ArrayList<Map<String, Object>> afterInAppList = new ArrayList<Map<String, Object>>();
        MappingInfo mappingInfo = new MappingInfo();
        Properties campProp = totalList.get(0).getCampProp();
        log.info("campProp:{}", (Object)campProp);
        String campType = campProp.getProperty("CAMP_TYPE", "M");
        String channelType = (String)campProp.get("CHANNEL_TYPE");
        String channelTypeSub = (String)campProp.get("CHANNEL_TYPE_SUB");
        String tempChannelTypeSub = "";
        String schdId = campProp.getProperty("SCHD_ID");
        String sendId = campProp.getProperty("SEND_ID");
        String sendAddId = campProp.getProperty("SEND_ADD_ID");
        String switchFlag = campProp.getProperty("SWITCH_FLAG", "N");
        String pushType = campProp.getProperty("PUSH_TYPE");
        String nlsLang = campProp.getProperty("NLS_LANG", "UTF-8");
        String triggerMethod = campProp.getProperty("TRIGGER_METHOD", "O1");
        String workday = campProp.getProperty("WORKDAY", DateUtil.getWorkday());
        boolean sendFlag = false;
        List<Map<String, Object>> targetList = totalList.get(0).getTargetList();
        ArrayList<Map<String, Object>> attachList = new ArrayList();
        HashMap<String, Object> mqUserMap = new HashMap<String, Object>();
        if (targetList.size() < 1) {
            log.error("MP2001|TargetList size Zero : TargetList.size():[{}]", (Object)targetList.size());
            throw new Exception("TargetList size Zero");
        }
        if (StringUtil.isNull(content) && !"OP".equals(pushType)) {
            log.error("CM0501|Content is null : content:[{}] / sendId:{} / schdId:{} / targetSeq:{}", new Object[]{content, sendId, schdId, targetSeq});
            this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP104", "Content is Null");
            this.redisExecutor.updateSproc("40", schdId, targetSeq, sendId, -1);
            return -1;
        }
        sendFlag = targetList.size() >= Integer.parseInt(this.sendFlagCnt) && (Constants.TriggerMethod.O1.name().equals(triggerMethod) || Constants.TriggerMethod.O9.name().equals(triggerMethod));
        log.info("targetList.size() :{}", (Object)targetList.size());
        String tlistKey = "TLIST:" + schdId + ":" + targetSeq;
        String dlistKey = "DLIST:" + schdId + ":" + targetSeq;
        String crsltKey = "CRSLT:" + channelType + ":" + DateUtil.getFullDate((String)"yyyyMMddHHmm");
        String sendMqKey = sendId + ":" + schdId + ":" + targetSeq;
        long startT = 0L;
        long endT = 0L;
        if (campProp.getProperty("SAFEMAIL_YN", "N").equalsIgnoreCase("Y") && ChannelType.EMAIL.same(channelType)) {
            startT = System.currentTimeMillis();
            content = this.sourceAdd.addSafeMailSource(content, campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \uc548\uc2ec\uba54\uc77c\ucf54\ub4dc \uc0bd\uc785 \uc644\ub8cc ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (!campProp.getProperty("TRACKING_YN", "N").equalsIgnoreCase("N") && campProp.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H") && ChannelType.EMAIL.same(channelType)) {
            startT = System.currentTimeMillis();
            content = this.sourceAdd.addTrackingSource(content, campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \ud2b8\ub808\ud0b9\ucf54\ub4dc \uc0bd\uc785 \uc644\ub8cc ===========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (campProp.getProperty("ATTACH_YN", "N").equalsIgnoreCase("Y")) {
            startT = System.currentTimeMillis();
            attachList = this.mapperDao.getAttachFileInfo(sendAddId);
            endT = System.currentTimeMillis();
            log.info("[END] \ucca8\ubd80\ud30c\uc77c\ub9ac\uc2a4\ud2b8 \uac00\uc838\uc634 ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        boolean isAttachSizeError = false;
        if (campProp.getProperty("ATTACH_YN", "N").equalsIgnoreCase("Y") && this.filter.checkAttachSize(attachList)) {
            log.error("[\uc77c\ubc18\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:{}", (Object)sendId);
            isAttachSizeError = true;
        }
        if (Constants.TargetType.DB.name().equals(campProp.getProperty("TARGET_TYPE")) && !Constants.TriggerMethod.O7.name().equals(triggerMethod)) {
            startT = System.currentTimeMillis();
            mappingInfo = this.getMappingData(campProp);
            endT = System.currentTimeMillis();
            log.info("[END] \ub9e4\ud551\uc815\ubcf4 \uac00\uc838\uc640\uc11c Set ==========================[{}]", (Object)((double)(endT - startT) / 1000.0 + " \ucd08"));
        }
        if (!content.trim().isEmpty() && content.indexOf("${") > -1) {
            templateContent = new Template("templateContent", (Reader)new StringReader(content), this.cfg);
        }
        if (campProp.containsKey("SECURE_ATTACH_NAME") && campProp.getProperty("SECURE_ATTACH_NAME", "").indexOf("${") > -1) {
            templateSecureAttach = new Template("templateSecureAttach", (Reader)new StringReader(campProp.getProperty("SECURE_ATTACH_NAME", "")), this.cfg);
        }
        if (campProp.containsKey("SECURE_INTRO_TEMPLATE") && campProp.getProperty("SECURE_INTRO_TEMPLATE", "N").equalsIgnoreCase("Y") && (tempIntroContent = this.sourceAdd.getContentUrl(campProp.getProperty("SECURE_INTRO_TEMPLATE"))).indexOf("${") > -1) {
            templateSecureIntro = new Template("templateSecureIntro", (Reader)new StringReader(tempIntroContent), this.cfg);
        }
        int cnt = 0;
        int failCnt = 0;
        int noti_N_cnt = 0;
        for (Map<String, Object> userMap : targetList) {
            String memberId;
            String domain;
            boolean isError;
            String tempContent;
            String rsltJson;
            String userInfoMQJson;
            String userInfoJson;
            Map<String, Object> mappingDataMapTemp;
            HashMap<String, Object> mappingDataMap;
            List<Map<String, Object>> dynamicAttachList;
            block157: {
                ++cnt;
                dynamicAttachList = new ArrayList<Map<String, Object>>();
                mappingDataMap = null;
                mappingDataMapTemp = null;
                userInfoJson = "";
                userInfoMQJson = "";
                rsltJson = "";
                tempContent = "";
                isError = false;
                domain = "";
                userCrsltMap = new HashMap<String, String>();
                memberId = String.valueOf(userMap.get("FIELD_MEMBER_ID"));
                if (log.isDebugEnabled()) {
                    log.info("[\uac00\uc838\uc628 \ub300\uc0c1\uc790 \ub370\uc774\ud130] userMap ===========>  {}", userMap);
                }
                if (!StringUtil.isNull((String)userMap.get("STATUS"))) {
                    log.info("[ERROR] user STATUS not null STATUS [{}]  memberId [{}]", userMap.get("STATUS"), (Object)memberId);
                    ++failCnt;
                    isError = true;
                    userCrsltMap = this.putErrorCodeDetail((String)userMap.get("STATUS"), (String)userMap.get("LOG_DETAIL"), userCrsltMap);
                }
                if (isAttachSizeError && !isError) {
                    ++failCnt;
                    isError = true;
                    userMap.put("STATUS", "MP101");
                    userCrsltMap = this.putErrorCodeDetail("MP101", "[\uc77c\ubc18\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:" + sendId, userCrsltMap);
                }
                if (!Constants.TriggerMethod.O7.name().equals(triggerMethod)) {
                    mappingDataMap = new HashMap<String, Object>();
                    try {
                        mappingDataMapTemp = this.getMappingDataPut(userMap, campProp, mappingInfo);
                        mappingDataMap.putAll(mappingDataMapTemp);
                        userMap.putAll(mappingDataMapTemp);
                    }
                    catch (Exception e) {
                        log.error("[getMaappingDataPut] Error -> CRSLT input -> memberId:{}  sendId:{} :{}", new Object[]{memberId, sendId, e});
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP101");
                        userCrsltMap = this.putErrorCodeDetail("MP101", "[\ub9e4\ud551\ub370\uc774\ud130\uc624\ub958] Simple Mapping Result Size Over [Or] Mapping Query Error [Or] KeyValue Mapping key is NULL", userCrsltMap);
                    }
                    try {
                        if (!mappingDataMap.isEmpty() || this.checkByte(userMap, this.fileSaveByte)) {
                            String mapFolderPath = this.mapDataSavePath + "/" + workday + "/" + schdId + "/" + targetSeq;
                            File mappingFolderFile = new File(mapFolderPath);
                            if (!mappingFolderFile.exists()) {
                                mappingFolderFile.mkdirs();
                            }
                            String mapFullPath = mapFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".map";
                            if (!mappingDataMap.isEmpty()) {
                                mappingDataMap.putAll(userMap);
                                this.saveMapData(mappingDataMap, mapFullPath, memberId, nlsLang);
                            } else if (this.checkByte(userMap, this.fileSaveByte)) {
                                this.saveMapData(userMap, mapFullPath, memberId, nlsLang);
                            }
                            userMap.put("MAP_FILE_SAVE_YN", "Y");
                            userMap.put("MAP_FILE_PATH", mapFullPath);
                            userMap.put("MAP_FILE_IP", this.mapDataSaveIp);
                            break block157;
                        }
                        userMap.put("MAP_FILE_SAVE_YN", "N");
                    }
                    catch (Exception e) {
                        log.error("MP4001|MappingContent or TLIST save File Error. memberId:{}", (Object)memberId, (Object)e);
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP105");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[Error] Mapping Content or TLIST save File Error", userCrsltMap);
                    }
                } else if (Constants.TriggerMethod.O7.name().equals(triggerMethod) && "Y".equals(userMap.get("MAP_FILE_SAVE_YN")) && !isError) {
                    JSONObject resultJSON = new JSONObject();
                    try {
                        String resString;
                        JSONParser parser;
                        Object obj;
                        String mapFileIp = (String)userMap.get("MAP_FILE_IP");
                        String mapFilePath = (String)userMap.get("MAP_FILE_PATH");
                        if (StringUtil.isNull(mapFileIp) || StringUtil.isNull(mapFilePath)) {
                            log.error("[ERROR] MAP_FILE_IP is Null OR MAP_FILE_PATH is Null => [{}],[{}]", (Object)mapFileIp, (Object)mapFilePath);
                            throw new Exception("[ERROR] MAP_FILE_IP is Null OR MAP_FILE_PATH is Null =>  mapFileIp:" + mapFileIp + ",mapFilePath:" + mapFilePath);
                        }
                        StringBuilder mapCallUrlSb = new StringBuilder();
                        mapCallUrlSb.append("http://").append(mapFileIp).append(":").append(this.wtPort).append("/watcher").append(this.wtGetFilePath).append("?").append("path=").append(URLEncoder.encode(mapFilePath, nlsLang));
                        if (log.isDebugEnabled()) {
                            log.debug("mapFileIp : {}, wtPort:{}, wtGetFilePath:{}, mapFilePath:{} mapCallUrlSb.toString() : {}", new Object[]{mapFileIp, this.wtPort, this.wtGetFilePath, mapFilePath, mapCallUrlSb.toString()});
                        }
                        if ((resultJSON = (JSONObject)(obj = (parser = new JSONParser()).parse(resString = HttpUtil.jsonCallUrl((String)mapCallUrlSb.toString())))).containsKey((Object)"DOMAIN")) {
                            resultJSON.remove((Object)"DOMAIN");
                        }
                        if (ChannelType.EMAIL.same(channelType)) {
                            if (resultJSON.containsKey((Object)"TMS_M_EMAIL")) {
                                resultJSON.remove((Object)"TMS_M_EMAIL");
                            }
                        } else if ((ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) && resultJSON.containsKey((Object)"TMS_M_PHONE")) {
                            resultJSON.remove((Object)"TMS_M_PHONE");
                        }
                        if (resultJSON.containsKey((Object)"TMS_M_TARGET")) {
                            resultJSON.remove((Object)"TMS_M_TARGET");
                        }
                        userMap.putAll((Map<String, Object>)resultJSON);
                    }
                    catch (Exception e) {
                        log.error("MP4001|WATCH API Call Error memberId:{} :{}", (Object)memberId, (Object)e.getMessage());
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP106");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[API\uc5d0\ub7ec] Resend API Call Error:" + e.getMessage(), userCrsltMap);
                    }
                } else {
                    userMap.put("MAP_FILE_SAVE_YN", "N");
                }
            }
            if (userMap.containsKey("ATTACH_1") && !isError) {
                try {
                    dynamicAttachList = this.putDynamicAttachAdd(userMap, dynamicAttachList);
                    if (this.filter.checkAttachSize(dynamicAttachList)) {
                        log.error("[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:{}", (Object)sendId);
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP101");
                        userCrsltMap = this.putErrorCodeDetail("MP101", "[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] Attach File Size Over => sendId:" + sendId, userCrsltMap);
                    }
                }
                catch (Exception e) {
                    log.error("[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] dynamic Attach List Create Error memberId:{} / sendId:{} / schdId:{} / targetSeq:{}", new Object[]{memberId, sendId, schdId, targetSeq, e});
                    ++failCnt;
                    isError = true;
                    userMap.put("STATUS", "MP101");
                    userCrsltMap = this.putErrorCodeDetail("MP101", "[\uac1c\ubcc4\ucca8\ubd80\ud30c\uc77c\uc624\ub958] dynamic Attach List Create Error", userCrsltMap);
                }
            }
            if (this.filter.userInfoFilter(userMap, channelType) && !isError) {
                ++failCnt;
                isError = true;
                userMap.put("STATUS", "MP102");
                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] \ub300\uc0c1\uc790 \ud544\uc218\uc815\ubcf4 \uc720\ud6a8\uc131 \uc5d0\ub7ec", userCrsltMap);
            }
            userMap = this.sourceAdd.addEncValues(userMap, schdId, channelType);
            if (ChannelType.PUSH.same(channelType) && !isError) {
                if (campProp.containsKey("PUSH_VALUE")) {
                    String resultPushValue = "";
                    String pushValue = campProp.getProperty("PUSH_VALUE", "");
                    if (pushValue.indexOf("${") > -1) {
                        try {
                            resultPushValue = this.convertMappingExecutor(userMap, campProp, pushValue);
                            if (StringUtil.isNull(resultPushValue)) {
                                log.info("[FAIL] resultPushValue isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put("STATUS", "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PushValue isNull", userCrsltMap);
                            } else {
                                userMap.put("PUSH_VALUE", resultPushValue);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5304|PUSH_VALUE Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put("STATUS", "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (campProp.containsKey("PUSH_MSG")) {
                    String resultPushMsg = "";
                    String pushMsg = campProp.getProperty("PUSH_MSG", "");
                    if (pushMsg.indexOf("${") > -1) {
                        try {
                            resultPushMsg = this.convertMappingExecutor(userMap, campProp, pushMsg);
                            if (StringUtil.isNull(resultPushMsg)) {
                                log.info("[FAIL] resultPushMsg isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put("STATUS", "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] PushMsg isNull", userCrsltMap);
                            } else {
                                userMap.put("PUSH_MSG", resultPushMsg);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5305|PUSH_MSG Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put("STATUS", "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
            }
            if (!isError) {
                try {
                    tempContent = this.convertMappingExecutor(userMap, campProp, content, templateContent);
                }
                catch (Exception e) {
                    log.error("MP5306|Content Mapping Error :{}", (Object)e.getMessage());
                    ++failCnt;
                    isError = true;
                    userMap.put("STATUS", "MP103");
                    userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                }
                if (this.filter.contentFilter(tempContent, channelType, channelTypeSub, memberId, switchFlag) && !isError) {
                    ++failCnt;
                    isError = true;
                    userMap.put("STATUS", "MP104");
                    userCrsltMap = this.putErrorCodeDetail("MP104", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] Content Max Byte Over", userCrsltMap);
                }
                if (campProp.containsKey("SUBJECT") && !ChannelType.SMS.same(tempChannelTypeSub) && !isError) {
                    String resultSubject = "";
                    String subject = campProp.getProperty("SUBJECT", "");
                    if (subject.indexOf("${") > -1) {
                        try {
                            resultSubject = this.convertMappingExecutor(userMap, campProp, subject);
                            if (StringUtil.isNull(resultSubject)) {
                                log.info("[FAIL] resultSubject isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put("STATUS", "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] Subject isNull", userCrsltMap);
                            } else {
                                userMap.put("SUBJECT", resultSubject);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5308|SUBJECT Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put("STATUS", "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] Mapping Error", userCrsltMap);
                        }
                    }
                }
                if (ChannelType.PUSH.same(channelType) && userMap.get("DOMAIN").equals("ANDROID")) {
                    userMap.put("DOMAIN", channelTypeSub);
                }
                log.debug("[\ucee8\ud150\uce20\ub9e4\ud551 \ud6c4] tempContent \n:{}", (Object)tempContent);
                if (ChannelType.EMAIL.same(channelType) && !isError) {
                    if (campProp.getProperty("SECURE_YN", "N").equalsIgnoreCase("Y")) {
                        String secureAttachName = campProp.getProperty("SECURE_ATTACH_NAME", this.defaultSecureAttachName);
                        String tempSecureAttachName = this.convertMappingExecutor(userMap, campProp, secureAttachName, templateSecureAttach);
                        userMap.put("SECURE_ATTACH_NAME", tempSecureAttachName);
                    }
                    try {
                        tempContent = this.sourceAdd.addMailBody(tempContent, campProp, userMap, attachList, dynamicAttachList, templateSecureIntro);
                    }
                    catch (Exception e) {
                        log.error("MP5503|AddMailBody Fail. memberId:[{}]:{}", (Object)memberId, (Object)e.getMessage());
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP108");
                        userCrsltMap = this.putErrorCodeDetail("MP108", "[ERROR] AddMailBody Fail", userCrsltMap);
                    }
                } else if (ChannelType.KAKAO.same(channelType) && !isError) {
                    String kakaoContent = "";
                    String smsContent = "";
                    if (!"N".equals(switchFlag) && tempContent.indexOf("/**KAKAO_DELIM**/") > -1) {
                        int idx1 = tempContent.indexOf("/**KAKAO_DELIM**/");
                        int idx2 = "/**KAKAO_DELIM**/".length();
                        kakaoContent = tempContent.substring(0, idx1);
                        smsContent = tempContent.substring(idx1 + idx2, tempContent.length());
                        if (!StringUtil.isNull(smsContent) && smsContent.indexOf("/**KAKAO_BUTTON**/") > -1) {
                            int idx3 = smsContent.indexOf("/**KAKAO_BUTTON**/");
                            int idx4 = "/**KAKAO_BUTTON**/".length();
                            userMap.put("RESEND_MT_MESSAGE", smsContent.substring(0, idx3));
                            userMap.put("ATTACHMENT_JSON", smsContent.substring(idx3 + idx4, smsContent.length()));
                        } else {
                            userMap.put("RESEND_MT_MESSAGE", smsContent);
                        }
                        tempContent = kakaoContent;
                    } else if (!StringUtil.isNull(tempContent) && tempContent.indexOf("/**KAKAO_BUTTON**/") > -1) {
                        int idx3 = tempContent.indexOf("/**KAKAO_BUTTON**/");
                        int idx4 = "/**KAKAO_BUTTON**/".length();
                        tempContent = tempContent.substring(0, idx3);
                        userMap.put("ATTACHMENT_JSON", tempContent.substring(idx3 + idx4, tempContent.length()));
                    }
                } else if (ChannelType.SMS.same(channelType) && !isError) {
                    tempChannelTypeSub = this.filter.exchangeChannelTypeSub(tempContent, channelType, channelTypeSub, switchFlag, attachList, dynamicAttachList);
                    if (!StringUtil.isNull(tempChannelTypeSub)) {
                        userMap.put("DOMAIN", tempChannelTypeSub);
                    }
                    if (campProp.containsKey("FROM_NUMBER")) {
                        String resultFromNumber = "";
                        String originalFromNumber = campProp.getProperty("FROM_NUMBER", "");
                        try {
                            resultFromNumber = this.convertMappingExecutor(userMap, campProp, originalFromNumber);
                            if (StringUtil.isNull(resultFromNumber)) {
                                log.info("[FAIL] resultFromNumber isNull :[{}]", (Object)memberId);
                                ++failCnt;
                                isError = true;
                                userMap.put("STATUS", "MP102");
                                userCrsltMap = this.putErrorCodeDetail("MP102", "[\uc720\ud6a8\uc131\uc5d0\ub7ec] resultFromNumber isNull", userCrsltMap);
                            } else {
                                userMap.put("FROM_NUMBER", resultFromNumber);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5310| FromNumber Mapping Error :{}", (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put("STATUS", "MP103");
                            userCrsltMap = this.putErrorCodeDetail("MP103", "[\ub9e4\ud551\uc5d0\ub7ec] FromNumber Mapping Error", userCrsltMap);
                        }
                    }
                    if (ChannelType.MMS.getName().equals(tempChannelTypeSub)) {
                        try {
                            userMap = this.addAttachList(attachList, dynamicAttachList, userMap);
                        }
                        catch (Exception e) {
                            log.error("MP5505|MMS attach Parsing Error, memberId:[{}]:{}", (Object)memberId, (Object)e.getMessage());
                            ++failCnt;
                            isError = true;
                            userMap.put("STATUS", "MP107");
                            userCrsltMap = this.putErrorCodeDetail("MP107", "[FAIL] MMS attach Parsing Error", userCrsltMap);
                        }
                    }
                }
                if (ChannelType.EMAIL.same(channelType) && "Y".equals(this.contentSaveFileYn) && !isError) {
                    String folderPath;
                    File folder;
                    String fullContentFolderPath = this.contentRootPath + "/" + workday + "/" + schdId + "/" + targetSeq;
                    String fullContentFolderUrl = this.contentRootUrl + "/" + workday + "/" + schdId + "/" + targetSeq;
                    File contentFolderFile = new File(fullContentFolderPath);
                    if (!contentFolderFile.exists()) {
                        contentFolderFile.mkdirs();
                    }
                    String contentFullPath = fullContentFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".html";
                    String contentFullUrl = fullContentFolderUrl + "/" + URLEncoder.encode(memberId.replaceAll(":", this.contentSaveFileSeparator) + ".html", nlsLang);
                    if ("Y".equalsIgnoreCase(this.isContentSaveCompress)) {
                        contentFullPath = fullContentFolderPath + "/" + memberId.replaceAll(":", this.contentSaveFileSeparator) + ".zip";
                        contentFullUrl = fullContentFolderUrl + "/" + URLEncoder.encode(memberId.replaceAll(":", this.contentSaveFileSeparator) + ".zip", nlsLang);
                    }
                    if (!(folder = new File(folderPath = contentFullPath.substring(0, contentFullPath.lastIndexOf("/")))).exists()) {
                        folder.mkdirs();
                    }
                    long startFile = System.currentTimeMillis();
                    log.debug("[START] FullContent(content length:{}) Write START ===========================memberId :{}", (Object)tempContent.length(), (Object)memberId);
                    if ("Y".equalsIgnoreCase(this.isContentSaveCompress) && this.contentReadWrite.saveFullContentCompressFile(contentFullPath, "html", tempContent, nlsLang) || "N".equalsIgnoreCase(this.isContentSaveCompress) && this.contentReadWrite.saveFullContentFile(contentFullPath, tempContent, nlsLang)) {
                        File f = new File(contentFullPath);
                        if (!f.exists() || !f.isFile()) {
                            log.info("MP4002|Email Templte Not Exists [{}]", (Object)contentFullPath);
                        } else {
                            userMap.put("FULL_CONTENT_PATH", contentFullPath);
                            userMap.put("FULL_CONTENT_URL", contentFullUrl);
                            userMap.put("FULL_CONTENT_COMPRESS_YN", this.isContentSaveCompress);
                        }
                    } else {
                        log.error("MP4001|FullContent save Fail :{}", (Object)memberId);
                        ++failCnt;
                        isError = true;
                        userMap.put("STATUS", "MP105");
                        userCrsltMap = this.putErrorCodeDetail("MP105", "[FAIL] FullContent save Fail", userCrsltMap);
                    }
                    long endFile = System.currentTimeMillis();
                    log.debug("[END] FullContent(content length:{})memberId :{} Write END ===========================[{}]", new Object[]{tempContent.length(), memberId, (double)(endFile - startFile) / 1000.0 + " \ucd08"});
                } else if (!isError) {
                    userMap.put("CONTENT", tempContent);
                }
            }
            if (tempContent != null) {
                tempContent = "";
            }
            cRsltField = sendId + ":" + schdId + ":" + targetSeq + ":" + memberId;
            if (isError) {
                rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                afterCrsltMap.put(cRsltField, rsltJson);
            } else if (ChannelType.PUSH.same(channelType) && "OM".equals(pushType)) {
                userCrsltMap = this.putErrorCodeDetail("MP001", "SUCCESS", userCrsltMap);
                rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                afterCrsltMap.put(cRsltField, rsltJson);
            }
            domain = String.valueOf(userMap.get("DOMAIN"));
            userInfoJson = this.convertMapToJSONString(userMap, channelType);
            afterTlistMap.put(memberId, userInfoJson);
            if (sendFlag && !isError) {
                if (afterDlistMap.containsKey(domain)) {
                    afterDlistMap.put(domain, (String)afterDlistMap.get(domain) + "," + memberId);
                } else {
                    afterDlistMap.put(domain, memberId);
                }
            }
            if (!sendFlag) {
                mqUserMap.put("key", sendMqKey);
                mqUserMap.put("memberId", memberId);
                mqUserMap.put("domain", String.valueOf(userMap.get("DOMAIN")));
                mqUserMap.put("company", campProp.getProperty("COMPANY", "tms"));
                mqUserMap.put("channelType", channelType);
                userInfoMQJson = this.convertMapToJSONString(mqUserMap, channelType);
                if (ChannelType.PUSH.same(channelType)) {
                    if (!"OM".equals(pushType) && "Y".equals(userMap.get("NOTI_FLAG")) && !isError) {
                        afterMQList.add(userInfoMQJson);
                    }
                } else if (!isError) {
                    afterMQList.add(userInfoMQJson);
                }
            }
            if (ChannelType.PUSH.same(channelType)) {
                String msgUid = campProp.getProperty("SITE_ID").concat("-").concat(schdId).concat("-").concat(sendId).concat("-").concat(targetSeq).concat("-").concat(campProp.getProperty("WORKDAY")).concat("-").concat(String.valueOf(userMap.get("TMS_M_ID"))).concat("-").concat(String.valueOf(userMap.get("UNIQUE_SEQ")));
                userMap.put("MSG_UID", msgUid);
                userMap = this.putInAppValue(userMap, campProp);
                if (("MP".equals(pushType) || "OM".equals(pushType)) && !isError) {
                    afterInAppList.add(userMap);
                }
                if ("N".equals((String)userMap.get("NOTI_FLAG")) && !isError) {
                    ++noti_N_cnt;
                    log.info("==> NOFI_FLAG:N   memberId:{}  sendId:{}  schdId:{} targetSeq:{}", new Object[]{memberId, sendId, schdId, targetSeq});
                    userCrsltMap = this.putErrorCodeDetail("MP001", "NOTI_FLAG:N => [SUCCESS]", userCrsltMap);
                    rsltJson = this.putCrsltJsonString(userMap, campProp, targetSeq, userCrsltMap);
                    afterCrsltMap.put(cRsltField, rsltJson);
                }
            }
            if (!dynamicAttachList.isEmpty()) {
                dynamicAttachList.clear();
            }
            if (mappingDataMap != null && !mappingDataMap.isEmpty()) {
                mappingDataMap.clear();
            }
            if (mappingDataMapTemp == null || mappingDataMapTemp.isEmpty()) continue;
            mappingDataMapTemp.clear();
        }
        long start1 = 0L;
        long end1 = 0L;
        String pcnclKey = "PCNCL";
        if (this.redisExecutor.checkStop(pcnclKey, sendId)) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateTotalCrsltUser(totalList, sendId, schdId, targetSeq, "MP601", "SEND STOP");
            this.redisExecutor.updateSproc("42", schdId, targetSeq, sendId, -1);
            end1 = System.currentTimeMillis();
            log.info("[END] 2\ucc28 \ubc1c\uc1a1\uc911\uc9c0 \ucc98\ub9ac ===========================[{}]", (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
            return -1;
        }
        if (sendFlag && failCnt != cnt) {
            String userInfoMQJson = "";
            mqUserMap.clear();
            mqUserMap.put("key", sendMqKey);
            mqUserMap.put("domain", "ALL");
            mqUserMap.put("company", campProp.getProperty("COMPANY", "tms"));
            mqUserMap.put("channelType", channelType);
            userInfoMQJson = this.convertMapToJSONString(mqUserMap, channelType);
            afterMQList.add(userInfoMQJson);
        }
        if (!mqUserMap.isEmpty()) {
            mqUserMap.clear();
        }
        log.info("==> channelType:{} \t channelTypeSub:{} \t tempChannelTypeSub:{} \t switchFlag:{} \t sendFlag:{} ", new Object[]{channelType, channelTypeSub, tempChannelTypeSub, switchFlag, sendFlag});
        log.info("==> afterInAppList.size():{} \t afterMQList.size():{} \t afterTlistMap.size():{} \t afterDlistMap.size():{} \t afterCrsltMap.size():{} \t noti_N_cnt:{}", new Object[]{afterInAppList.size(), afterMQList.size(), afterTlistMap.size(), afterDlistMap.size(), afterCrsltMap.size(), noti_N_cnt});
        List<Map<String, Object>> failList = null;
        ArrayList<String> removeMQList = null;
        Map<String, String> userCrsltMap2 = null;
        if (!afterInAppList.isEmpty()) {
            start1 = System.currentTimeMillis();
            try {
                failList = this.batchExecutor.insertBatch(afterInAppList);
                log.info("==> Inapp Insert Fail.size(): {}", (Object)failList.size());
                userCrsltMap2 = new HashMap<String, String>();
                removeMQList = new ArrayList<String>();
                int equalsCnt = 0;
                for (Map<String, Object> failMap : failList) {
                    String failMemberId = String.valueOf(failMap.get("FIELD_MEMBER_ID"));
                    userCrsltMap2.clear();
                    cRsltField = sendId + ":" + schdId + ":" + targetSeq + ":" + failMemberId;
                    userCrsltMap2 = this.putErrorCodeDetail("MP701", "[DB_ERROR] INAPP_MSG insert Fail", userCrsltMap2);
                    String rsltJson = this.putCrsltJsonString(failMap, campProp, targetSeq, userCrsltMap2);
                    afterCrsltMap.put(cRsltField, rsltJson);
                    if (sendFlag) {
                        String doamin = (String)failMap.get("DOMAIN");
                        String domainValue = (String)afterDlistMap.get(doamin);
                        afterDlistMap.put(doamin, domainValue.replace(failMemberId, "").replace(failMemberId + ",", ""));
                    }
                    removeMQList.clear();
                    for (String jsonStr : afterMQList) {
                        String mqMemberId;
                        Map mqInfoMap = JsonUtil.getMapFromJson((String)jsonStr);
                        if (sendFlag || !failMemberId.equals(mqMemberId = (String)mqInfoMap.get("memberId"))) continue;
                        log.error("[ERROR] INSERT FAIL TARGET afterMqList remove : CNT:[{}] sendId[{}] schdId[{}] targetSeq[{}] ==> : [ failMemberId:{} / mqMemberId:{} ]", new Object[]{++equalsCnt, sendId, schdId, targetSeq, failMemberId, mqMemberId});
                        removeMQList.add(jsonStr);
                    }
                    if (sendFlag) continue;
                    for (String jsonStr : removeMQList) {
                        afterMQList.remove(jsonStr);
                        ++failCnt;
                    }
                }
                if (sendFlag) {
                    log.info("[afterMQList Clear] INAPP LIST SIZE({}) / INAPP INSERT FAIL SIZE({}) : sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{afterInAppList.size(), failList.size(), sendId, schdId, targetSeq});
                    if (afterInAppList.size() == failList.size()) {
                        afterMQList.clear();
                        failCnt = cnt;
                    }
                }
            }
            catch (Exception e) {
                log.error("MP1002|INAPP_MSG insertBatch(INAPP_MSG) Fail -> schdId:{} targetSeq:{} error:{}", new Object[]{schdId, targetSeq, e.getMessage()});
                throw new Exception("[ERROR] INAPP_MSG insertBatch(INAPP_MSG) Fail -> schdId:" + schdId + " targetSeq:" + targetSeq + " error:" + e.getMessage());
            }
            finally {
                if (!failList.isEmpty()) {
                    failList.clear();
                }
                if (removeMQList != null && !removeMQList.isEmpty()) {
                    removeMQList.clear();
                }
                if (userCrsltMap2 != null && !userCrsltMap2.isEmpty()) {
                    userCrsltMap2.clear();
                }
            }
            end1 = System.currentTimeMillis();
            log.info("[END] INSERT IN_APP_MSG size:{}============[{}]", (Object)afterInAppList.size(), (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
            if (!afterInAppList.isEmpty()) {
                afterInAppList.clear();
            }
        }
        if (!afterTlistMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(tlistKey, afterTlistMap);
            end1 = System.currentTimeMillis();
            log.info("[END] TLIST UPDATE :{}============[{}]", (Object)tlistKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        } else {
            log.info("afterTlistMap isEmpty .... sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{sendId, schdId, targetSeq});
        }
        if (!afterDlistMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(dlistKey, afterDlistMap);
            end1 = System.currentTimeMillis();
            log.info("[END] DLIST INSERT :{}============[{}]", (Object)dlistKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        }
        if (!afterCrsltMap.isEmpty()) {
            start1 = System.currentTimeMillis();
            this.redisExecutor.updateHashMap(crsltKey, afterCrsltMap);
            end1 = System.currentTimeMillis();
            log.info("[END] CRSLT UPDATE :{}============[{}]", (Object)crsltKey, (Object)((double)(end1 - start1) / 1000.0 + " \ucd08"));
        }
        if (!afterMQList.isEmpty()) {
            start1 = System.currentTimeMillis();
            for (String jsonStr : afterMQList) {
                this.mqProducer.send(campProp, jsonStr);
            }
            end1 = System.currentTimeMillis();
            log.info("[END] [{}] MQ SEND [{}] [{}] ==========================[{}]", new Object[]{campType, afterMQList.size(), sendId + ":" + schdId + ":" + targetSeq, (double)(end1 - start1) / 1000.0 + " \ucd08"});
        } else {
            log.info("afterMQList size Zero.... sendId:[{}] schdId:[{}] targetSeq:[{}]", new Object[]{sendId, schdId, targetSeq});
        }
        if (!afterMQList.isEmpty()) {
            afterMQList.clear();
        }
        if (!afterCrsltMap.isEmpty()) {
            afterCrsltMap.clear();
        }
        if (!afterTlistMap.isEmpty()) {
            afterTlistMap.clear();
        }
        if (!afterDlistMap.isEmpty()) {
            afterDlistMap.clear();
        }
        if (!userCrsltMap.isEmpty()) {
            userCrsltMap.clear();
        }
        if (mappingInfo != null) {
            Map<String, TmsJdbcTemplate> tmsJdbcMap = mappingInfo.getTmsJdbcMap();
            if (tmsJdbcMap != null && !tmsJdbcMap.isEmpty()) {
                for (String key : tmsJdbcMap.keySet()) {
                    tmsJdbcMap.get(key).close();
                }
            }
            mappingInfo = null;
        }
        if (campProp != null) {
            campProp.clear();
        }
        if (!targetList.isEmpty()) {
            targetList.clear();
        }
        if (!attachList.isEmpty()) {
            attachList.clear();
        }
        if (!afterInAppList.isEmpty()) {
            afterInAppList.clear();
        }
        if (!mqUserMap.isEmpty()) {
            mqUserMap.clear();
        }
        if (templateContent != null) {
            templateContent = null;
        }
        if (templateSecureAttach != null) {
            templateSecureAttach = null;
        }
        if (templateSecureIntro != null) {
            templateSecureIntro = null;
        }
        return cnt - failCnt;
    }

    @Override
    public Map<String, Object> getMappingDataPut(Map<String, Object> userMap, Properties campProp, MappingInfo mminfo) throws Exception {
        boolean isMappingQueryExecute;
        long startT;
        Map<String, TmsJdbcTemplate> jdbcMap;
        List<ConnectInfo> dbInfoList;
        HashMap<String, Object> tempUserInfoMap;
        block27: {
            tempUserInfoMap = new HashMap<String, Object>();
            dbInfoList = mminfo.getConnectionList();
            jdbcMap = mminfo.getTmsJdbcMap();
            startT = System.currentTimeMillis();
            isMappingQueryExecute = false;
            if (dbInfoList != null && jdbcMap != null) break block27;
            HashMap<String, Object> hashMap = tempUserInfoMap;
            long endT = System.currentTimeMillis();
            if (isMappingQueryExecute) {
                log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty("SEND_ID", "sendId"), userMap.get("TMS_M_ID"), (double)(endT - startT) / 1000.0 + " \ucd08"});
            }
            return hashMap;
        }
        try {
            tempUserInfoMap.putAll(userMap);
            int loop_idx = 1;
            for (ConnectInfo conInfo : dbInfoList) {
                ArrayList<Map<String, String>> rapList = new ArrayList<Map<String, String>>();
                String queryType = conInfo.getQueryType();
                String looping_key = "";
                StringBuffer buffer = new StringBuffer(128);
                if ("30".equals(queryType)) {
                    looping_key = "rap_" + String.valueOf(loop_idx++);
                }
                if ("10".equals(queryType) || "40".equals(queryType) || "50".equals(queryType)) continue;
                isMappingQueryExecute = true;
                long start = System.currentTimeMillis();
                TmsJdbcTemplate jdbcTemplate = jdbcMap.get(conInfo.getDbId());
                String query = conInfo.getQuery();
                if ("20".equals(queryType)) {
                    query = this.addConvertQuery(query, conInfo.getDbType());
                }
                if (query.indexOf("@{") > -1) {
                    StringConvertUtil.convertString(buffer, query, tempUserInfoMap, "@{", "}", false, false);
                } else {
                    buffer.append(query);
                }
                ArrayList<KeyValueInfo> kvList = new ArrayList<KeyValueInfo>();
                List resList = new ArrayList();
                List resListLink = new ArrayList();
                if ("70".equals(queryType)) {
                    resListLink = jdbcTemplate.selectListLinkedHashMap(buffer.toString());
                    for (Map<String, String> resultMap : resListLink) {
                        Iterator iter = ((LinkedHashMap)resultMap).entrySet().iterator();
                        KeyValueInfo kvInfo = new KeyValueInfo();
                        int i = 1;
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            String value = String.valueOf(entry.getValue());
                            if (i % 2 == 0) {
                                kvInfo.setValues(StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                            } else {
                                if (StringUtil.isNull(value) || "null".equalsIgnoreCase(value)) {
                                    log.error("MP5303| KeyValue Mapping key is NULL : memberId:{}", userMap.get("TMS_M_ID"));
                                    throw new Exception("[ERROR] KeyValue Mapping key is NULL : memberId:" + userMap.get("TMS_M_ID"));
                                }
                                kvInfo.setKeys(value);
                            }
                            kvList.add(kvInfo);
                            ++i;
                        }
                    }
                } else {
                    resList = jdbcTemplate.selectList(buffer.toString());
                    for (Map<String, String> resultMap : resList) {
                        Set key = resultMap.keySet();
                        Iterator iter = key.iterator();
                        while (iter.hasNext()) {
                            String keyName = String.valueOf(iter.next());
                            String value = String.valueOf(resultMap.get(keyName));
                            if (!"30".equals(queryType)) {
                                tempUserInfoMap.put(keyName, StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                                continue;
                            }
                            resultMap.put(keyName, StringUtil.isNull(value) || "null".equalsIgnoreCase(value) ? "" : value);
                        }
                        if (!"30".equals(queryType)) continue;
                        rapList.add(resultMap);
                    }
                }
                if (!kvList.isEmpty()) {
                    for (KeyValueInfo info : kvList) {
                        if (StringUtil.isNull(info.getKeys())) continue;
                        tempUserInfoMap.put(info.getKeys(), info.getValues());
                    }
                }
                if ("20".equals(queryType) && resList.size() > 1) {
                    log.error("[ERROR] Simple Mapping Result Count Over -> queryId [{}] size [{}] memberId [{}]", new Object[]{conInfo.getQueryId(), resList.size(), userMap.get("TMS_M_ID")});
                    throw new Exception("[ERROR] Simple Mapping Result Count Over");
                }
                if ("30".equals(queryType)) {
                    tempUserInfoMap.put(looping_key, rapList);
                }
                long end = System.currentTimeMillis();
                log.info("[END] \ub9e4\ud551\ucffc\ub9ac 1\uac1c \uc644\ub8cc. SEND_ID:[{}] TMS_M_ID:[{}] queryId [{}] resultSize [{}] ==========================[{}]", new Object[]{campProp.getProperty("SEND_ID", "sendId"), userMap.get("TMS_M_ID"), conInfo.getQueryId(), rapList.size(), (double)(end - start) / 1000.0 + " \ucd08"});
                tempUserInfoMap.putAll(userMap);
            }
        }
        catch (Exception e) {
            try {
                log.error("MP5303|convertMapping Fail :{}", (Object)e.getMessage());
                throw new Exception("[ERROR] convertMapping Fail :" + e);
            }
            catch (Throwable throwable) {
                long endT = System.currentTimeMillis();
                if (isMappingQueryExecute) {
                    log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty("SEND_ID", "sendId"), userMap.get("TMS_M_ID"), (double)(endT - startT) / 1000.0 + " \ucd08"});
                }
                throw throwable;
            }
        }
        long endT = System.currentTimeMillis();
        if (isMappingQueryExecute) {
            log.info("[END] \ub9e4\ud551\ucffc\ub9ac \uc804\uccb4 \uc644\ub8cc \uc2dc\uac04. \uc804\uccb4 \ucffc\ub9ac \uac2f\uc218:[{}], SEND_ID:[{}] TMS_M_ID [{}] ==========================[{}]", new Object[]{dbInfoList.size(), campProp.getProperty("SEND_ID", "sendId"), userMap.get("TMS_M_ID"), (double)(endT - startT) / 1000.0 + " \ucd08"});
        }
        return tempUserInfoMap;
    }

    @Override
    public MappingInfo getMappingData(Properties campProp) throws Exception {
        MappingInfo mminfo = new MappingInfo();
        ArrayList<ConnectInfo> connectionList = new ArrayList<ConnectInfo>();
        TreeMap<String, TmsJdbcTemplate> jdbcMap = new TreeMap<String, TmsJdbcTemplate>();
        String targetId = (String)campProp.get("TARGET_ID");
        try {
            List<Map<String, Object>> queryInfoList = this.mapperDao.getMappingQueryInfo(targetId);
            if (!queryInfoList.isEmpty()) {
                for (Map<String, Object> map : queryInfoList) {
                    ConnectInfo connectionInfo = new ConnectInfo();
                    connectionInfo.setDbId(String.valueOf(map.get("DB_ID")));
                    connectionInfo.setDbType(String.valueOf(map.get("DB_TYPE")));
                    connectionInfo.setQueryId(String.valueOf(map.get("QUERY_ID")));
                    connectionInfo.setDbName(String.valueOf(map.get("DB_NAME")));
                    connectionInfo.setDriver(String.valueOf(map.get("CONNECT_DRIVER")));
                    connectionInfo.setDbUrl(String.valueOf(map.get("CONNECT_IP")));
                    connectionInfo.setDbUid(String.valueOf(map.get("CONNECT_ID")));
                    connectionInfo.setDbPass(String.valueOf(map.get("CONNECT_PWD")));
                    connectionInfo.setDbBaseCharset(String.valueOf(map.get("BASE_CHARSET")));
                    connectionInfo.setDbInCharset(String.valueOf(map.get("IN_CHARSET")));
                    connectionInfo.setDbOutCharset(String.valueOf(map.get("OUT_CHARSET")));
                    connectionInfo.setQuerySeq(String.valueOf(map.get("QUERY_SEQ")));
                    connectionInfo.setQueryType(String.valueOf(map.get("QUERY_TYPE")));
                    connectionInfo.setEncryptYn(String.valueOf(map.get("ENCRYPT_YN")));
                    connectionInfo.setQuery(String.valueOf(map.get("QUERY_SELECT")));
                    connectionInfo.setAppendNull("Y".equalsIgnoreCase(String.valueOf(map.get("APPEND_NULL")) == null ? "N" : String.valueOf(map.get("APPEND_NULL"))));
                    if ("40".equals(connectionInfo.getQueryType())) continue;
                    if (!jdbcMap.containsKey(connectionInfo.getDbId())) {
                        TmsJdbcTemplate jdbcTemplate = (TmsJdbcTemplate)ClassDispatcher.getApplicationContext().getBean(TmsJdbcTemplate.class);
                        map.put("DB_DRV", String.valueOf(map.get("CONNECT_DRIVER")));
                        map.put("DB_URL", String.valueOf(map.get("CONNECT_IP")));
                        map.put("DB_USR", String.valueOf(map.get("CONNECT_ID")));
                        map.put("DB_PWD", String.valueOf(map.get("CONNECT_PWD")));
                        jdbcMap.put(connectionInfo.getDbId(), jdbcTemplate.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(map)));
                    }
                    connectionList.add(connectionInfo);
                }
            } else {
                log.error("MP5302|queryInfoList size zero");
                throw new Exception("[ERROR] queryInfoList size zero");
            }
            mminfo.setConnectionList(connectionList);
            mminfo.setTmsJdbcMap(jdbcMap);
        }
        catch (Exception e) {
            log.error("MP5301|getMappingData Fail:{}", (Throwable)e);
            throw new Exception("[ERROR] getMappingData Fafil:{}" + e);
        }
        return mminfo;
    }

    @Override
    public String convertMappingExecutor(Map<String, Object> userMap, Properties campProp, String source, Template template) throws Exception {
        String result = null;
        if (!StringUtil.isNull(source)) {
            try {
                result = this.customizingMappingString(userMap, campProp, source, template);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingString() Fail:" + e.getMessage());
            }
        }
        String contentPath = campProp.getProperty("CONTENT_PATH", "");
        if (StringUtils.isEmpty((CharSequence)contentPath) && contentPath.indexOf(".html") > -1) {
            String path = contentPath.substring(0, contentPath.lastIndexOf("/"));
            String[] contentArray = contentPath.split("/");
            String fileName = contentArray[contentArray.length - 1];
            try {
                result = this.customizingMappingFile(path, fileName, userMap);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingFile() Fail:" + e.getMessage());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String customizingMappingString(Map<String, Object> userMap, Properties campProp, String source, Template template) throws Exception {
        if (source.indexOf("&MEMBER_ID=${ENC_MEMBER_ID}") > -1) {
            source = source.replace("${ENC_MEMBER_ID}", StringUtils.validString((Object)userMap.get("ENC_MEMBER_ID")));
        }
        if (source.indexOf("&MEMBER_ID_SEQ=${UNIQUE_SEQ}") > -1) {
            source = source.replace("${UNIQUE_SEQ}", StringUtils.validString((Object)userMap.get("UNIQUE_SEQ")));
        }
        if (source.indexOf("${TMS_M_ID}") > -1) {
            source = source.replace("${TMS_M_ID}", StringUtils.validString((Object)userMap.get("TMS_M_ID")));
        }
        if (source.indexOf("${TMS_M_NAME}") > -1) {
            source = source.replace("${TMS_M_NAME}", StringUtils.validString((Object)userMap.get("TMS_M_NAME")));
        }
        if (source.indexOf("${TMS_M_EMAIL}") > -1) {
            source = source.replace("${TMS_M_EMAIL}", StringUtils.validString((Object)userMap.get("TMS_M_EMAIL")));
        }
        if (source.indexOf("${TMS_M_PHONE}") > -1) {
            source = source.replace("${TMS_M_PHONE}", StringUtils.validString((Object)userMap.get("TMS_M_PHONE")));
        }
        if (source.indexOf("${") < 0) {
            return source;
        }
        if (this.cfg == null) {
            this.cfg = this.configFreeMarker();
        }
        try (eMsStringWriter writerStringBuffer = new eMsStringWriter();){
            PrintWriter writerContentComposer = new PrintWriter(writerStringBuffer);
            writerContentComposer.flush();
            writerStringBuffer.reset();
            template.process(userMap, (Writer)writerContentComposer);
            writerContentComposer.flush();
            String string = writerStringBuffer.toString();
            return string;
        }
        catch (Exception e) {
            log.error("MP5306|freeMarker(String) Mapping Fail -> id:[{}] detail: {}", userMap.get("TMS_M_ID"), (Object)e);
            throw new Exception("freeMarker(String) Mapping Fail");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String customizingMappingFile(String path, String fileName, Map<String, Object> userMap) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, Object> putInAppValue(Map<String, Object> userMap, Properties campProp) {
        userMap.put("REQ_DATE", campProp.getProperty("REQ_DATE", DateUtil.getFullDateDefaultFormat()));
        userMap.put("REQ_UID", campProp.getProperty("REQ_UID", ""));
        userMap.put("MSG_UID", campProp.getProperty("MSG_UID", ""));
        userMap.put("PUSH_KEY", campProp.getProperty("PUSH_KEY", ""));
        userMap.put("APP_GRP_ID", campProp.getProperty("APP_GRP_ID", ""));
        userMap.put("PUSH_MSG", campProp.getProperty("PUSH_MSG", ""));
        userMap.put("PUSH_VALUE", campProp.getProperty("PUSH_VALUE", ""));
        userMap.put("SUBJECT", campProp.getProperty("SUBJECT", ""));
        userMap.put("SEND_ID", campProp.getProperty("SEND_ID", ""));
        userMap.put("SCHD_ID", campProp.getProperty("SCHD_ID", ""));
        userMap.put("WORKDAY", campProp.getProperty("WORKDAY", ""));
        userMap.put("TRACKING_CLOSE", campProp.getProperty("TRACKING_CLOSE", ""));
        userMap.put("CONTENT_TYPE", campProp.getProperty("CONTENT_TYPE", "T"));
        userMap.put("PUSH_IMG", campProp.getProperty("PUSH_IMG", ""));
        userMap.put("PUSH_TYPE", campProp.getProperty("PUSH_TYPE", ""));
        userMap.put("ETC1", campProp.getProperty("ETC1", ""));
        userMap.put("ETC2", campProp.getProperty("ETC2", ""));
        userMap.put("ETC3", campProp.getProperty("ETC3", ""));
        userMap.put("ETC4", campProp.getProperty("ETC4", ""));
        userMap.put("ETC5", campProp.getProperty("ETC5", ""));
        userMap.put("ETC6", campProp.getProperty("ETC6", ""));
        return userMap;
    }

    public String convertMapToJSONString(Map<String, Object> userMap, String channelType) throws Exception {
        JSONObject jsonObj = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : userMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals("FIELD_MEMBER_ID") || key.equals("enc_mid") || key.equals("m_id") || key.equals("enc_email") || key.equals("s_id") || key.equals("ENC_MEMBER_ID") || ChannelType.PUSH.same(channelType) && key.indexOf("CONTENT") > -1) continue;
                String value = String.valueOf(entry.getValue());
                jsonObj.put((Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            log.error("MP5504|convertMapToJSONString Fail:" + e);
            throw new Exception("convertMapToJSONString Fail:" + e);
        }
        return jsonObj.toString();
    }

    @Override
    public String putCrsltJsonString(Map<String, Object> userMap, Properties campProp, String targetSeq, Map<String, String> crsltMap) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"ERROR_CODE", (Object)crsltMap.get("ERROR_CODE"));
        jsonObj.put((Object)"ERROR_DETAIL", (Object)crsltMap.get("ERROR_DETAIL"));
        jsonObj.put((Object)"RESULT_TYPE", (Object)"S");
        jsonObj.put((Object)"WORKDAY", campProp.get("WORKDAY"));
        jsonObj.put((Object)"SCHD_ID", campProp.get("SCHD_ID"));
        jsonObj.put((Object)"SERVER_ID", (Object)(this.daemonType + this.daemonId));
        jsonObj.put((Object)"SITE_ID", campProp.get("SITE_ID"));
        jsonObj.put((Object)"TARGET_SEQ", (Object)targetSeq);
        jsonObj.put((Object)"MEMBER_ID", userMap.get("TMS_M_ID"));
        jsonObj.put((Object)"UNIQUE_SEQ", userMap.get("UNIQUE_SEQ"));
        jsonObj.put((Object)"DOMAIN", userMap.get("DOMAIN"));
        jsonObj.put((Object)"START_TIME", (Object)DateUtil.getFullDateDefaultFormat());
        jsonObj.put((Object)"END_TIME", (Object)DateUtil.getFullDateDefaultFormat());
        return jsonObj.toString();
    }

    @Override
    public Map<String, String> putErrorCodeDetail(String errorCode, String errorDetail, Map<String, String> map) {
        map.put("ERROR_CODE", errorCode);
        map.put("ERROR_DETAIL", errorDetail);
        return map;
    }

    public String addConvertQuery(String sql, String dbType) {
        String convertSql = null;
        convertSql = DBType.DB2 == DBTypeDetector.databaseType((String)dbType) ? " SELECT A.*     FROM \t          ( \t  " + sql + "        ) A           RIGHT OUTER JOIN ( SELECT '' FROM SYSIBM.SYSDUMMY1) B ON ( 1=1 )   " : " SELECT A.*     FROM \t          ( \t  " + sql + "        ) A           RIGHT OUTER JOIN ( SELECT '' FROM DUAL) B ON ( 1=1 )   ";
        return convertSql;
    }

    public List<Map<String, Object>> putDynamicAttachAdd(Map<String, Object> userMap, List<Map<String, Object>> dynamicAttachList) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        int cnt = 0;
        for (Map.Entry<String, Object> entry : userMap.entrySet()) {
            String key = entry.getKey();
            String value = (String)entry.getValue();
            if (key.indexOf(ATTACH_PREFIX) != 0 || key.indexOf("NAME") != -1) continue;
            if (key.indexOf("_NAME") > -1) {
                attachMap.put(key, value);
                continue;
            }
            if (key.indexOf("URL") != -1 || key.indexOf("CHARSET") != -1) continue;
            ++cnt;
            attachMap.put(key, value);
        }
        for (int i = 0; i < cnt; ++i) {
            HashMap<String, String> attachMap2 = new HashMap<String, String>();
            String pathKey = ATTACH_PREFIX + String.valueOf(i + 1);
            String pathValue = (String)attachMap.get(pathKey);
            String nameKey = pathKey + "_NAME";
            String nameValue = "";
            if (pathValue.indexOf("http:") > -1 || pathValue.indexOf("https:") > -1) {
                attachMap2.put("ATTACH_URL", pathValue);
            } else {
                attachMap2.put("ATTACH_PATH", pathValue);
            }
            nameValue = StringUtil.isNull((String)attachMap.get(nameKey)) || !attachMap.containsKey(nameKey) ? pathValue.substring(pathValue.lastIndexOf(47) + 1) : (String)attachMap.get(nameKey);
            attachMap2.put("ATTACH_NAME", nameValue);
            attachMap2.put("ATTACH_CHARSET", "UTF-8");
            dynamicAttachList.add(attachMap2);
        }
        return dynamicAttachList;
    }

    @Override
    public boolean saveMapData(Map<String, Object> map, String mapFullPath, String memberId, String nlsLang) {
        JSONObject mapJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                JSONArray mapJsonArr = new JSONArray();
                if (entry.getKey().indexOf("rap_") > -1) {
                    List rapList = (List)entry.getValue();
                    for (int i = 0; i < rapList.size(); ++i) {
                        Map tempMap = (Map)rapList.get(i);
                        JSONObject jsonObj = new JSONObject();
                        try {
                            for (Map.Entry entry2 : tempMap.entrySet()) {
                                String key = (String)entry2.getKey();
                                String value = String.valueOf(entry2.getValue());
                                jsonObj.put((Object)key, (Object)value);
                            }
                        }
                        catch (Exception e) {
                            log.error("MP5504|convertMapToJSONString Fail:" + e);
                            return false;
                        }
                        mapJsonArr.add((Object)JsonUtil.getMapFromJson((String)jsonObj.toString()));
                    }
                    mapJson.put((Object)entry.getKey(), (Object)mapJsonArr);
                    continue;
                }
                if (entry.getKey().indexOf("TMS_M_ID") > -1 || entry.getKey().indexOf("TMS_M_NAME") > -1 || entry.getKey().indexOf("TMS_M_EMAIL") > -1 || entry.getKey().indexOf("TMS_M_PHONE") > -1 || entry.getKey().indexOf("TMS_M_TARGET") > -1) continue;
                mapJson.put((Object)entry.getKey(), (Object)((String)entry.getValue()));
            }
            String folderPath = mapFullPath.substring(0, mapFullPath.lastIndexOf("/"));
            File folder = new File(folderPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!this.contentReadWrite.saveFullContentFile(mapFullPath, mapJson.toString(), nlsLang)) {
                log.error("MP4001|MappingContent save Fail :{}", (Object)memberId);
                return false;
            }
        }
        catch (Exception e) {
            log.error("MP5504|saveMappingData Fail:" + e);
            return false;
        }
        return true;
    }

    public boolean checkByte(Map<String, Object> userMap, String fileSaveByte) {
        JSONObject mapJson = new JSONObject();
        Iterator<Map.Entry<String, Object>> iter = userMap.entrySet().iterator();
        try {
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                String value = "";
                value = entry.getValue() == null ? "" : (entry.getValue() instanceof Long ? Long.toString((Long)entry.getValue()) : String.valueOf(entry.getValue()));
                mapJson.put((Object)entry.getKey(), (Object)value);
            }
            int mapSize = StringUtil.checkByteEnKrEtc(mapJson.toString());
            return mapSize > Integer.parseInt(fileSaveByte);
        }
        catch (Exception e) {
            log.error("MP5504|check Byte Data Fail:" + e);
            return false;
        }
    }

    public Map<String, Object> addAttachList(List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList, Map<String, Object> userMap) throws Exception {
        if (attachList != null && attachList.size() > 0 && dynamicAttachList.size() > 0) {
            log.error("MP5505|MMS attachList exist AND dynamicAttachList exist");
            throw new Exception("MMS attachList exist AND dynamicAttachList exist");
        }
        try {
            String attachKey;
            Map<String, Object> attachMap;
            int i;
            for (i = 0; i < attachList.size(); ++i) {
                attachMap = attachList.get(i);
                attachKey = ATTACH_PREFIX + String.valueOf(i + 1);
                if (attachMap.containsKey("ATTACH_URL")) {
                    userMap.put(attachKey, attachMap.get("ATTACH_URL"));
                    continue;
                }
                if (!attachMap.containsKey("ATTACH_PATH")) continue;
                userMap.put(attachKey, attachMap.get("ATTACH_PATH"));
            }
            for (i = 0; i < dynamicAttachList.size(); ++i) {
                attachMap = dynamicAttachList.get(i);
                attachKey = ATTACH_PREFIX + String.valueOf(i + 1);
                if (attachMap.containsKey("ATTACH_URL")) {
                    userMap.put(attachKey, attachMap.get("ATTACH_URL"));
                    continue;
                }
                if (!attachMap.containsKey("ATTACH_PATH")) continue;
                userMap.put(attachKey, attachMap.get("ATTACH_PATH"));
            }
        }
        catch (Exception e) {
            log.error("MP5505|MMS attachList/dynamicAttachList Parsing Error:{}", (Throwable)e);
            throw new Exception("MMS ttachList/dynamicAttachList Parsing Error." + e.getMessage());
        }
        return userMap;
    }

    @Override
    public String convertMappingExecutor(Map<String, Object> userMap, Properties campProp, String source) throws Exception {
        String result = null;
        if (!StringUtil.isNull(source)) {
            Template template = new Template("name", (Reader)new StringReader(source), this.cfg);
            try {
                result = this.customizingMappingString(userMap, campProp, source, template);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingString() Fail:" + e.getMessage());
            }
            finally {
                if (template != null) {
                    template = null;
                }
            }
        }
        String contentPath = (String)campProp.get("CONTENT_PATH");
        if (contentPath != null && contentPath.indexOf(".html") > -1) {
            String path = contentPath.substring(0, contentPath.lastIndexOf("/"));
            String[] contentArray = contentPath.split("/");
            String fileName = contentArray[contentArray.length - 1];
            try {
                result = this.customizingMappingFile(path, fileName, userMap);
            }
            catch (Exception e) {
                throw new Exception("[ERROR] customizingMappingFile() Fail:" + e.getMessage());
            }
        }
        return result;
    }
}

