/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.content;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.content.ContentReadWrite;
import com.humuson.tms.mapper.util.FileUtil;
import com.humuson.tms.mapper.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TmsComponent
public class DefaultContentReadWrite
implements ContentReadWrite {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentReadWrite.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getContent(Properties campProp) throws Exception {
        String contentPath = (String)campProp.get("CONTENT_PATH");
        String contentUrl = (String)campProp.get("CONTENT_URL");
        String content = "";
        if (!StringUtil.isNull(contentPath)) {
            try {
                return FileUtil.readLocal(contentPath, campProp.getProperty("NLS_LANG", "utf-8"));
            }
            catch (IOException e) {
                if (StringUtil.isNull(contentUrl)) return content;
                try {
                    return FileUtil.readUrl(contentUrl, campProp.getProperty("NLS_LANG", "utf-8"));
                }
                catch (IOException e1) {
                    log.error("CM0401|ReadUrl Fail:{}", (Throwable)e1);
                    throw new Exception("[ERROR] ReadUrl Fail:{}", e1);
                }
            }
        }
        if (StringUtil.isNull(contentUrl)) return content;
        try {
            return FileUtil.readUrl(contentUrl, campProp.getProperty("NLS_LANG", "utf-8"));
        }
        catch (IOException e) {
            if (StringUtil.isNull(contentPath)) return content;
            try {
                return FileUtil.readLocal(contentPath, campProp.getProperty("NLS_LANG", "utf-8"));
            }
            catch (IOException e1) {
                log.error("CM0402|ReadFile Fail:{}", (Throwable)e1);
                throw new Exception("[ERROR] ReadFile Fail:" + e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFullContentFile(String saveFullPath, String content, String charset) {
        try {
            File f = new File(saveFullPath);
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(charset));
            byte[] b = new byte[128];
            FileOutputStream fos = new FileOutputStream(f, false);
            try {
                int j;
                while ((j = bais.read(b)) > 0) {
                    fos.write(b, 0, j);
                    fos.flush();
                }
            }
            catch (Exception e) {
                log.error("print stack trace", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
        }
        catch (IOException e) {
            log.error("[ERROR] Content File Write Fail:{}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveFullContentCompressFile(String saveFullPath, String extention, String content, String charset) {
        try (FileOutputStream fos = new FileOutputStream(saveFullPath);){
            File f = new File(saveFullPath);
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(charset));
            int size = 1024;
            byte[] buf = new byte[size];
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)bos);
            String entryFileName = f.getName();
            entryFileName = entryFileName.substring(0, entryFileName.lastIndexOf(".")) + "." + extention;
            zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entryFileName));
            zos.setEncoding(charset);
            try {
                int len;
                while ((len = bais.read(buf, 0, size)) != -1) {
                    zos.write(buf, 0, len);
                    zos.flush();
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (zos != null) {
                        zos.closeArchiveEntry();
                        zos.finish();
                        zos.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error("file:{}, e:{}", (Object)saveFullPath, (Object)e);
            return false;
        }
        return true;
    }
}

