/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.mapper.body.Canonicalization;
import com.humuson.tms.mapper.body.DKIMSigner;
import com.humuson.tms.mapper.body.SimpleMessage;
import com.humuson.tms.mapper.body.SourceAdd;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.tracking.ContentTrackingExecutor;
import com.humuson.tms.mapper.tracking.TrackingInfoConvertor;
import com.humuson.tms.mapper.util.BASE64;
import com.humuson.tms.mapper.util.FileUtil;
import com.humuson.tms.mapper.util.MappingImgStripper;
import com.humuson.tms.mapper.util.MimeConvertor;
import com.humuson.tms.mapper.util.StringConvertUtil;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.mapper.util.eMsLocale;
import com.humuson.tms.util.Cal;
import com.unisecure.unisafemail.AttachsSet;
import com.unisecure.unisafemail.UniSafeSMailMaker;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class DefaultSourceAdd
implements SourceAdd {
    private static final Logger log = LoggerFactory.getLogger(DefaultSourceAdd.class);
    private final ContentTrackingExecutor contentTrackingExecutor;
    @Value(value="${mapper.header.encode.flag}")
    public boolean isHeaderEncode;
    @Value(value="${mapper.header.base.charset}")
    public String headerBaseCharSet;
    @Value(value="${mapper.header.mime.charset}")
    public String headerMimeCharSet;
    @Value(value="${mapper.content.encode.type}")
    public String contentMimeEncodeType;
    @Value(value="${mapper.header.base.charset}")
    public String contentBaseCharSet;
    @Value(value="${mapper.header.mime.charset}")
    public String contentMimeCharSet;
    @Value(value="${mapper.attach.base.charset}")
    public String attachBaseCharSet;
    @Value(value="${mapper.secure.passwd-question}")
    protected String uniSecurePasswdQuestion;
    @Value(value="${mapper.safemail.tag.start}")
    public String safemailStart;
    @Value(value="${mapper.safemail.tag.end}")
    public String safemailEnd;
    @Value(value="${mapper.safemail.cust-id}")
    public String safemailCustId;
    @Value(value="${mapper.secure.lic-file-path}")
    public String licFilePath;
    @Value(value="${mapper.mail.smtp.localhost}")
    public String smtpLocalhost;
    @Value(value="${mapper.secure.template-path}")
    public String secureTempltePath;
    @Value(value="${mapper.secure.default-attach-use}")
    public String secureDefautAttachUse;
    @Value(value="${mapper.secure.intro-mapping-use}")
    public String secureIntroMappingUse;
    @Autowired
    private ContentMapping contentMapping;
    @Autowired
    SimpleMessage simpleMessage;
    @Autowired
    DKIMSigner dkimSigner;
    protected static final byte[] NEW_LINE = "\r\n".getBytes();
    protected Properties ETC_HEADER = null;
    protected String ETC_HEADER_STRING = null;
    protected int BODY_TYPE = 2;
    @Value(value="${mapper.header.dkim-yn}")
    protected String DKIM_USE_YN;
    @Value(value="${mapper.header.dkim-domain}")
    protected String DKIM_DOMAIN;
    @Value(value="${mapper.header.dkim-selecter}")
    protected String DKIM_SELECTER;
    @Value(value="${mapper.header.dkim-file-path}")
    protected String DKIM_PRIVATEKEY_PATH;

    @PostConstruct
    public void init() {
        this.secureInit();
    }

    public void initDkimSigner() throws Exception {
        try {
            this.dkimSigner.DKIMSigner(this.DKIM_DOMAIN, this.DKIM_SELECTER, this.DKIM_PRIVATEKEY_PATH);
            this.dkimSigner.setHeaderCanonicalization(Canonicalization.RELAXED);
            this.dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
        }
        catch (Exception e) {
            log.error("MP5309|initDkimSigner Fail :{}", (Throwable)e);
            throw new Exception("[ERROR] initDkimSigner Fail :{}" + e);
        }
    }

    @Override
    public String addSafeMailSource(String content, Properties campProp) throws Exception {
        Properties prop = new Properties();
        try {
            String width = campProp.getProperty("TEMPLATE_WIDTH", "800");
            String enc_cid = BASE64.encode("CUST_ID=" + this.safemailCustId);
            String enc_sid = BASE64.encode("POST_ID=" + campProp.getProperty("SEND_ID"));
            if (Constants.CampType.A.name().equalsIgnoreCase(campProp.getProperty("CAMP_TYPE"))) {
                enc_sid = BASE64.encode("POST_ID=" + campProp.getProperty("SCHD_ID"));
            }
            prop.setProperty("ENC_CID", enc_cid);
            prop.setProperty("ENC_SID", enc_sid);
            prop.setProperty("TMS_M_WIDTH", width);
            String safeMailTagStartEncSid = StringUtil.convertString(this.safemailStart, prop, "@{", "}");
            int sStart = 0;
            int sEnd = 0;
            int eStart = 0;
            boolean eEnd = false;
            sStart = content.toLowerCase().indexOf("<body");
            if (sStart < 0) {
                sEnd = 0;
                eStart = content.length();
            } else {
                sEnd = content.toLowerCase().indexOf(">", sStart) + 1;
                eStart = content.toLowerCase().lastIndexOf("</body");
            }
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append(content.substring(0, sEnd)).append("\n").append(safeMailTagStartEncSid).append(content.substring(sEnd, eStart)).append("\n").append(this.safemailEnd).append(content.substring(eStart, content.length()));
            content = sbuffer.toString();
            content = content.replace("^^(", "$");
        }
        catch (Exception e) {
            log.error("MP5101|Add SafeMailSource Error :{}", (Object)e.getMessage());
            throw new Exception("[ERROR] Add SafeMailSource Fail :{}" + e);
        }
        finally {
            if (prop != null) {
                prop.clear();
                prop = null;
            }
        }
        return content;
    }

    @Override
    public String addTrackingSource(String content, Properties campProp) throws Exception {
        String strip_img_source = MappingImgStripper.process(content);
        StringBuffer tmpBuffer = null;
        String result = "";
        try {
            tmpBuffer = new StringBuffer(2048);
            result = this.contentTrackingExecutor.contentTrackingParsing(strip_img_source, tmpBuffer, campProp);
        }
        catch (Exception e) {
            throw new Exception("[ERROR] contentTrackingParsing Fail:" + e);
        }
        finally {
            tmpBuffer = null;
        }
        return result;
    }

    @Override
    public Map<String, Object> addEncValues(Map<String, Object> userMap, String schdId, String channelType) {
        if (ChannelType.EMAIL.same(channelType)) {
            userMap.put("ENC_MEMBER_ID", BASE64.encode((String)userMap.get("TMS_M_ID")));
            userMap.put("enc_mid", TrackingInfoConvertor.enc_MEMBER_ID((String)userMap.get("TMS_M_ID")));
        }
        return userMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String addMailBody(String tempContent, Properties campProp, Map<String, Object> userMap, List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList, Template secureIntroTemplate) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
        ByteArrayOutputStream headerBuffer = new ByteArrayOutputStream(512);
        ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream(512);
        this.init(campProp);
        this.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        boolean isDkim = false;
        if ("Y".equals(this.DKIM_USE_YN)) {
            isDkim = true;
            this.initDkimSigner();
        }
        String secureYn = campProp.getProperty("SECURE_YN", "N");
        String userChatset = campProp.getProperty("NLS_LANG", "UTF-8");
        String to_name = (String)userMap.get("TMS_M_NAME");
        String to_email = (String)userMap.get("TMS_M_EMAIL");
        String mapping_to_email = "@TMS_M_TARGET@";
        String originalTo = "";
        String mappingTo = "";
        String returnStr = "";
        String bodyBufforToString = "";
        int bodyIndex = 0;
        Map<String, Object> info1 = null;
        info1 = userMap;
        Properties scheduleInfo = new Properties();
        scheduleInfo.putAll((Map<?, ?>)campProp);
        this.BODY_TYPE = attachList.size() > 0 || dynamicAttachList.size() > 0 || "Y".equalsIgnoreCase(secureYn) ? 1 : 2;
        try {
            if (isDkim) {
                headerBuffer.flush();
                headerBuffer.reset();
                this.setHeaderString(info1, scheduleInfo, headerBuffer, userMap, isDkim);
            } else {
                byteBuffer.flush();
                byteBuffer.reset();
                this.setHeaderString(info1, scheduleInfo, byteBuffer, userMap, isDkim);
            }
            originalTo = this.getTo(to_name, to_email);
            mappingTo = this.getTo(to_name, mapping_to_email);
            switch (this.BODY_TYPE) {
                case 2: {
                    this.simpleMessage.CHAR_SET = userChatset;
                    if (isDkim) {
                        this.simpleMessage.putHeaderToStream(headerBuffer, this.BODY_TYPE, this.contentMimeEncodeType);
                        headerBuffer.write(NEW_LINE);
                        this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, bodyBuffer, tempContent, userChatset);
                        bodyBuffer.write(NEW_LINE);
                        bodyBufforToString = bodyBuffer.toString("UTF-8");
                        bodyIndex = bodyBufforToString.toLowerCase().indexOf("<html");
                        if (bodyIndex > 0) {
                            bodyBufforToString = bodyBufforToString.substring(bodyIndex);
                        }
                        String dkimHeader = this.dkimSigner.getDKIMHumusonHeader(bodyBufforToString, headerBuffer.toString("UTF-8"));
                        String dkimBody = this.dkimSigner.getDKIMAmailBody(bodyBufforToString);
                        byteBuffer.write(dkimHeader.getBytes());
                        byteBuffer.write(NEW_LINE);
                        byteBuffer.write(headerBuffer.toByteArray());
                        byteBuffer.write(dkimBody.getBytes());
                        break;
                    }
                    this.simpleMessage.putHeaderToStream(byteBuffer, this.BODY_TYPE, this.contentMimeEncodeType);
                    byteBuffer.write(NEW_LINE);
                    this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, byteBuffer, tempContent, userChatset);
                    byteBuffer.write(NEW_LINE);
                    break;
                }
                case 1: {
                    String boundary = this.getBoundaryString();
                    if (isDkim) {
                        this.simpleMessage.putHeaderToStreamMime(headerBuffer, this.BODY_TYPE, this.contentMimeEncodeType, boundary);
                        ByteArrayOutputStream byteBufferSub = new ByteArrayOutputStream(512);
                        byteBufferSub.write("\n--".getBytes());
                        byteBufferSub.write(boundary.getBytes());
                        byteBufferSub.write(NEW_LINE);
                        if (secureYn.equalsIgnoreCase("Y")) {
                            void var26_34;
                            if (StringUtil.isNull(campProp.getProperty("SECURE_INTRO_TEMPLATE"))) {
                                log.error("[Error] SECURE_INTRO_TEMPLATE is null : SECURE_YN [{}]", (Object)campProp.getProperty("SECURE_YN", "N"));
                                throw new Exception("[Error] SECURE_INTRO_TEMPLATE is null");
                            }
                            String securePwd = StringUtil.isNull((String)userMap.get("SECURE_PWD")) ? campProp.getProperty("SECURE_PWD") : (String)userMap.get("SECURE_PWD");
                            this.simpleMessage.putHeaderToStreamContent(byteBufferSub, campProp, this.contentMimeEncodeType, this.smtpLocalhost);
                            String string = this.getContentUrl(campProp.getProperty("SECURE_INTRO_TEMPLATE"));
                            byteBufferSub.write(NEW_LINE);
                            if (Boolean.parseBoolean(this.secureIntroMappingUse)) {
                                String string2 = this.contentMapping.convertMappingExecutor(userMap, scheduleInfo, string, secureIntroTemplate);
                            }
                            this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, byteBufferSub, (String)var26_34, userChatset);
                            byteBufferSub.write(NEW_LINE);
                            byteBufferSub.write("\n--".getBytes());
                            byteBufferSub.write(boundary.getBytes());
                            byteBufferSub.write(NEW_LINE);
                            Map<String, Object> map = null;
                            this.simpleMessage.putHeaderToStreamAttach(byteBufferSub, map, campProp, userMap, true);
                            byteBufferSub.write(NEW_LINE);
                            String unisafeString = this.customizingSecureMailBodyString(info1, campProp, tempContent, securePwd, attachList, dynamicAttachList);
                            MimeConvertor.putMimeToStream(byteBufferSub, unisafeString, "euc-kr", userChatset, (short)1);
                            byteBufferSub.write(NEW_LINE);
                            bodyBuffer.write(byteBufferSub.toString().getBytes());
                        } else {
                            this.simpleMessage.putHeaderToStreamContent(byteBufferSub, campProp, this.contentMimeEncodeType, this.smtpLocalhost);
                            byteBufferSub.write(NEW_LINE);
                            this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, byteBufferSub, tempContent, userChatset);
                            byteBufferSub.write(NEW_LINE);
                            for (Map map : attachList) {
                                byteBufferSub.write(NEW_LINE);
                                byteBufferSub.write("--".getBytes());
                                byteBufferSub.write(boundary.getBytes());
                                byteBufferSub.write(NEW_LINE);
                                this.simpleMessage.putHeaderToStreamAttach(byteBufferSub, map, campProp, userMap, false);
                                byteBufferSub.write(NEW_LINE);
                                scheduleInfo.putAll((Map<?, ?>)map);
                                scheduleInfo.put("SCHD_ID", campProp.getProperty("SCHD_ID"));
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                                byte[] fileBytes = null;
                                try {
                                    if (!StringUtil.isNull((String)map.get("ATTACH_URL"))) {
                                        try {
                                            fileBytes = FileUtil.readUrlToByteArray((String)map.get("ATTACH_URL"), this.attachBaseCharSet);
                                        }
                                        catch (Exception e) {
                                            log.error("[Fail] File Read URL Start Read File Path:{}", map.get("ATTACH_URL"), (Object)e);
                                            if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                                fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                            }
                                        }
                                    } else if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                        try {
                                            fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                        }
                                        catch (Exception e) {
                                            log.error("[Fail] File Read Path:{}", map.get("ATTACH_PATH"), (Object)e);
                                        }
                                    }
                                    byteArrayOutputStream.write(BASE64.encode(fileBytes).getBytes());
                                }
                                catch (IOException e) {
                                    throw new Exception("[ERROR] ReadFile Fail:" + e);
                                }
                                this.simpleMessage.putStringMessageToStreamNew(info1, scheduleInfo, byteArrayOutputStream);
                                byteBufferSub.write(byteArrayOutputStream.toString().getBytes());
                                byteBufferSub.write(NEW_LINE);
                                if (byteArrayOutputStream == null) continue;
                                byteArrayOutputStream.close();
                                Object var27_47 = null;
                            }
                            ByteArrayOutputStream dynamicByteBufferSub = new ByteArrayOutputStream(512);
                            for (Map<String, Object> map : dynamicAttachList) {
                                if (StringUtil.isNull((String)map.get("ATTACH_URL")) && StringUtil.isNull((String)map.get("ATTACH_PATH")) || "null".equals(map.get("ATTACH_URL")) && "null".equals(map.get("ATTACH_PATH"))) continue;
                                dynamicByteBufferSub.write("\n--".getBytes());
                                dynamicByteBufferSub.write(boundary.getBytes());
                                dynamicByteBufferSub.write(NEW_LINE);
                                this.simpleMessage.putHeaderToStreamAttach(dynamicByteBufferSub, map, campProp, userMap, false);
                                dynamicByteBufferSub.write(NEW_LINE);
                                scheduleInfo.putAll(map);
                                scheduleInfo.put("SCHD_ID", campProp.getProperty("SCHD_ID"));
                                ByteArrayOutputStream byteBufferSub2 = new ByteArrayOutputStream(512);
                                byte[] fileBytes = null;
                                try {
                                    if (!StringUtil.isNull((String)map.get("ATTACH_URL"))) {
                                        try {
                                            fileBytes = FileUtil.readUrlToByteArray((String)map.get("ATTACH_URL"), this.attachBaseCharSet);
                                        }
                                        catch (Exception e) {
                                            log.error("[Fail] File Read URL:{}", map.get("ATTACH_URL"), (Object)e);
                                            if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                                fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                            }
                                        }
                                    } else if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                        try {
                                            fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                        }
                                        catch (Exception e) {
                                            log.error("[Fail] File Read Path:{}", map.get("ATTACH_PATH"), (Object)e);
                                        }
                                    }
                                    byteBufferSub2.write(BASE64.encode(fileBytes).getBytes());
                                }
                                catch (IOException e) {
                                    throw new Exception("[ERROR] ReadFile Fail:" + e);
                                }
                                this.simpleMessage.putStringMessageToStreamNew(info1, scheduleInfo, byteBufferSub2);
                                dynamicByteBufferSub.write(byteBufferSub2.toString().getBytes());
                                dynamicByteBufferSub.write(NEW_LINE);
                                if (byteBufferSub2 == null) continue;
                                byteBufferSub2.close();
                                byteBufferSub2 = null;
                            }
                            bodyBuffer.write(byteBufferSub.toString().getBytes());
                            bodyBuffer.write(dynamicByteBufferSub.toString().getBytes());
                            if (dynamicByteBufferSub != null) {
                                dynamicByteBufferSub.close();
                                dynamicByteBufferSub = null;
                            }
                        }
                        bodyBuffer.write("\r\n--".getBytes());
                        bodyBuffer.write(boundary.getBytes());
                        bodyBuffer.write("--\r\n\r\n".getBytes());
                        String bodyString = bodyBuffer.toString("UTF-8");
                        bodyIndex = bodyString.toLowerCase().indexOf("<html");
                        if (bodyIndex > 0) {
                            bodyString = bodyString.substring(bodyIndex);
                        }
                        String string = this.dkimSigner.getDKIMHumusonHeader(bodyString, headerBuffer.toString());
                        String string3 = this.dkimSigner.getDKIMAmailBody(bodyString);
                        byteBuffer.write(string.getBytes());
                        byteBuffer.write(NEW_LINE);
                        byteBuffer.write(headerBuffer.toByteArray());
                        byteBuffer.write(string3.getBytes());
                        if (byteBufferSub == null) break;
                        byteBufferSub.close();
                        byteBufferSub = null;
                        break;
                    }
                    byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
                    byteBuffer.write("\tboundary=\"".getBytes());
                    byteBuffer.write(boundary.getBytes());
                    byteBuffer.write("\"\r\n\r\n".getBytes());
                    byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
                    ByteArrayOutputStream byteBufferSub = new ByteArrayOutputStream(512);
                    byteBufferSub.write("\n--".getBytes());
                    byteBufferSub.write(boundary.getBytes());
                    byteBufferSub.write("\n".getBytes());
                    if (secureYn.equalsIgnoreCase("Y")) {
                        void var26_41;
                        if (StringUtil.isNull(campProp.getProperty("SECURE_INTRO_TEMPLATE"))) {
                            log.error("[Error] SECURE_INTRO_TEMPLATE is null : SECURE_YN [{}]", (Object)campProp.getProperty("SECURE_YN", "N"));
                            throw new Exception("[Error] SECURE_INTRO_TEMPLATE is null");
                        }
                        String securePwd = StringUtil.isNull((String)userMap.get("SECURE_PWD")) ? campProp.getProperty("SECURE_PWD") : (String)userMap.get("SECURE_PWD");
                        this.simpleMessage.putHeaderToStreamContent(byteBufferSub, campProp, this.contentMimeEncodeType, this.smtpLocalhost);
                        String string = this.getContentUrl(campProp.getProperty("SECURE_INTRO_TEMPLATE"));
                        byteBufferSub.write(NEW_LINE);
                        if (Boolean.parseBoolean(this.secureIntroMappingUse)) {
                            String string4 = this.contentMapping.convertMappingExecutor(userMap, scheduleInfo, string, secureIntroTemplate);
                        }
                        this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, byteBufferSub, (String)var26_41, userChatset);
                        byteBufferSub.write(NEW_LINE);
                        byteBufferSub.write("\n--".getBytes());
                        byteBufferSub.write(boundary.getBytes());
                        byteBufferSub.write(NEW_LINE);
                        Map<String, Object> map = null;
                        this.simpleMessage.putHeaderToStreamAttach(byteBufferSub, map, campProp, userMap, true);
                        byteBufferSub.write(NEW_LINE);
                        String unisafeString = this.customizingSecureMailBodyString(info1, campProp, tempContent, securePwd, attachList, dynamicAttachList);
                        MimeConvertor.putMimeToStream(byteBufferSub, unisafeString, "euc-kr", userChatset, (short)1);
                        byteBufferSub.write(NEW_LINE);
                        byteBufferSub.write(NEW_LINE);
                        byteBufferSub.write(NEW_LINE);
                        byteBuffer.write(byteBufferSub.toString().getBytes());
                    } else {
                        this.simpleMessage.putHeaderToStreamContent(byteBufferSub, campProp, this.contentMimeEncodeType, this.smtpLocalhost);
                        byteBufferSub.write(NEW_LINE);
                        this.simpleMessage.putStringMessageToStreamSimple(info1, scheduleInfo, byteBufferSub, tempContent, userChatset);
                        byteBufferSub.write(NEW_LINE);
                        byteBufferSub.write(NEW_LINE);
                        byteBufferSub.write(NEW_LINE);
                        for (Map<String, Object> map : attachList) {
                            byteBufferSub.write("\n--".getBytes());
                            byteBufferSub.write(boundary.getBytes());
                            byteBufferSub.write(NEW_LINE);
                            this.simpleMessage.putHeaderToStreamAttach(byteBufferSub, map, campProp, userMap, false);
                            byteBufferSub.write(NEW_LINE);
                            scheduleInfo.putAll(map);
                            scheduleInfo.put("SCHD_ID", campProp.getProperty("SCHD_ID"));
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                            byte[] fileBytes = null;
                            try {
                                if (!StringUtil.isNull((String)map.get("ATTACH_URL"))) {
                                    try {
                                        fileBytes = FileUtil.readUrlToByteArray((String)map.get("ATTACH_URL"), this.attachBaseCharSet);
                                    }
                                    catch (Exception e) {
                                        log.error("[Fail] File Read URL:{}", map.get("ATTACH_URL"), (Object)e);
                                        if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                            fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                        }
                                    }
                                } else if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                    try {
                                        fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                    }
                                    catch (Exception e) {
                                        log.error("[Fail] File Read Path:{}", map.get("ATTACH_PATH"), (Object)e);
                                    }
                                }
                                byteArrayOutputStream.write(BASE64.encode(fileBytes).getBytes());
                            }
                            catch (IOException e) {
                                throw new Exception("[ERROR] ReadFile Fail:" + e);
                            }
                            this.simpleMessage.putStringMessageToStreamNew(info1, scheduleInfo, byteArrayOutputStream);
                            byteBufferSub.write(byteArrayOutputStream.toString().getBytes());
                            byteBufferSub.write(NEW_LINE);
                            if (byteArrayOutputStream == null) continue;
                            byteArrayOutputStream.close();
                            Object var27_55 = null;
                        }
                        ByteArrayOutputStream dynamicByteBufferSub = new ByteArrayOutputStream(512);
                        for (Map<String, Object> map : dynamicAttachList) {
                            if (StringUtil.isNull((String)map.get("ATTACH_URL")) && StringUtil.isNull((String)map.get("ATTACH_PATH")) || "null".equals(map.get("ATTACH_URL")) && "null".equals(map.get("ATTACH_PATH"))) continue;
                            dynamicByteBufferSub.write("\n--".getBytes());
                            dynamicByteBufferSub.write(boundary.getBytes());
                            dynamicByteBufferSub.write(NEW_LINE);
                            this.simpleMessage.putHeaderToStreamAttach(dynamicByteBufferSub, map, campProp, userMap, false);
                            dynamicByteBufferSub.write(NEW_LINE);
                            scheduleInfo.putAll(map);
                            scheduleInfo.put("SCHD_ID", campProp.getProperty("SCHD_ID"));
                            ByteArrayOutputStream byteBufferSub2 = new ByteArrayOutputStream(512);
                            byte[] fileBytes = null;
                            try {
                                if (!StringUtil.isNull((String)map.get("ATTACH_URL"))) {
                                    try {
                                        fileBytes = FileUtil.readUrlToByteArray((String)map.get("ATTACH_URL"), this.attachBaseCharSet);
                                    }
                                    catch (Exception e) {
                                        log.error("[Fail] File Read URL:{}", map.get("ATTACH_URL"), (Object)e);
                                        if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                            fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                        }
                                    }
                                } else if (!StringUtil.isNull((String)map.get("ATTACH_PATH"))) {
                                    try {
                                        fileBytes = FileUtils.readFileToByteArray((File)new File((String)map.get("ATTACH_PATH")));
                                    }
                                    catch (Exception e) {
                                        log.error("[Fail] File Read Path:{}", map.get("ATTACH_PATH"), (Object)e);
                                    }
                                }
                                byteBufferSub2.write(BASE64.encode(fileBytes).getBytes());
                            }
                            catch (IOException e) {
                                throw new Exception("[ERROR] ReadFile Fail:" + e);
                            }
                            this.simpleMessage.putStringMessageToStreamNew(info1, scheduleInfo, byteBufferSub2);
                            dynamicByteBufferSub.write(byteBufferSub2.toString().getBytes());
                            dynamicByteBufferSub.write(NEW_LINE);
                        }
                        byteBuffer.write(byteBufferSub.toString().getBytes());
                        byteBuffer.write(dynamicByteBufferSub.toString().getBytes());
                        if (dynamicByteBufferSub != null) {
                            dynamicByteBufferSub.close();
                            dynamicByteBufferSub = null;
                        }
                        if (byteBufferSub != null) {
                            byteBufferSub.close();
                            byteBufferSub = null;
                        }
                    }
                    byteBuffer.write("\r\n--".getBytes());
                    byteBuffer.write(boundary.getBytes());
                    byteBuffer.write("--\r\n\r\n".getBytes());
                }
            }
            returnStr = byteBuffer.toString(userChatset);
            if (!StringUtil.isNull(originalTo) && !StringUtil.isNull(mappingTo)) {
                returnStr = returnStr.replace(originalTo, mappingTo);
            }
        }
        catch (Exception e) {
            log.error("MP5503|AddMailBody Fail:{}", (Throwable)e);
            throw new Exception("MP5503|AddMailBody Fail:" + e.getMessage());
        }
        finally {
            if (byteBuffer != null) {
                byteBuffer.close();
                byteBuffer = null;
            }
            if (bodyBuffer != null) {
                bodyBuffer.close();
                bodyBuffer = null;
            }
            if (headerBuffer != null) {
                headerBuffer.close();
                headerBuffer = null;
            }
        }
        return returnStr;
    }

    @Override
    public void setHeaderString(Object info1, Properties campProp, ByteArrayOutputStream tmpOutStream, Map<String, Object> userMap, boolean isDkim) throws Exception {
        Map INFO_MAP1 = null;
        Object mail_id = null;
        Object member_id = null;
        if (info1 != null) {
            if (!(info1 instanceof Map)) {
                throw new RuntimeException("UNSUPPORTED HASH TYPE");
            }
            INFO_MAP1 = (Map)info1;
            mail_id = userMap.get("SCHD_ID");
            mail_id = mail_id == null ? null : TrackingInfoConvertor.enc_MAIL_ID(mail_id.toString());
            member_id = INFO_MAP1.get("enc_mid");
        }
        String from_name = campProp.getProperty("FROM_NAME");
        String from_email = campProp.getProperty("FROM_EMAIL");
        String subject = campProp.getProperty("SUBJECT");
        if (userMap.containsKey("SUBJECT")) {
            subject = (String)userMap.get("SUBJECT");
        }
        String to_name = (String)userMap.get("TMS_M_NAME");
        String to_email = (String)userMap.get("TMS_M_EMAIL");
        String TEST_ATTACH_HEADER = campProp.getProperty("TEST_ATTACH_HEADER");
        if (TEST_ATTACH_HEADER != null) {
            subject = subject.concat(TEST_ATTACH_HEADER);
        }
        String etc_header_string = this.ETC_HEADER_STRING;
        StringBuffer buffer = new StringBuffer(128);
        if (info1 != null) {
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, from_name, info1, "${", "}", false, false);
            from_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, from_email, info1, "${", "}", false, false);
            from_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, to_name, info1, "${", "}", false, false);
            to_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, to_email, info1, "${", "}", false, false);
            to_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, subject, info1, "${", "}", false, false);
            subject = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.convertString(buffer, etc_header_string, info1, "${", "}", false, false);
            etc_header_string = buffer.toString();
        }
        tmpOutStream.write("From: \"".getBytes(this.headerBaseCharSet));
        if (this.isHeaderEncode) {
            MimeConvertor.putHeaderToStream(tmpOutStream, from_name, this.headerBaseCharSet, this.headerMimeCharSet, (short)1);
        } else {
            tmpOutStream.write(from_name.getBytes(this.headerBaseCharSet));
        }
        tmpOutStream.write("\" <".getBytes());
        tmpOutStream.write(from_email.getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        tmpOutStream.write(this.getTo(to_name, to_email).getBytes());
        tmpOutStream.write("Reply-to: <".getBytes());
        tmpOutStream.write(campProp.getProperty("REPLY_TO", from_email).getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        tmpOutStream.write("Subject: ".getBytes(this.headerBaseCharSet));
        if (isDkim) {
            MimeConvertor.putHeaderToStream(tmpOutStream, subject, this.headerBaseCharSet, this.headerMimeCharSet, this.isHeaderEncode ? (short)1 : 4);
        } else {
            MimeConvertor.putSubjectToStream(tmpOutStream, subject, this.headerBaseCharSet, this.headerMimeCharSet, this.isHeaderEncode);
        }
        tmpOutStream.write("\r\n".getBytes());
        tmpOutStream.write("Date: ".getBytes());
        tmpOutStream.write(Cal.getHeaderDate().getBytes());
        tmpOutStream.write("\r\n".getBytes());
        tmpOutStream.write("X-WORKER_ID: <".getBytes());
        tmpOutStream.write(Thread.currentThread().getName().getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        if (mail_id != null) {
            tmpOutStream.write("X-MAIL_ID: <".getBytes());
            tmpOutStream.write(mail_id.toString().getBytes());
            tmpOutStream.write(">\r\n".getBytes());
        }
        if (member_id != null) {
            tmpOutStream.write("X-MEMBER_ID: <".getBytes());
            tmpOutStream.write(member_id.toString().getBytes(this.headerBaseCharSet));
            tmpOutStream.write(">\r\n".getBytes());
        }
        tmpOutStream.write("Precedence: ".getBytes());
        tmpOutStream.write("bulk".getBytes());
        tmpOutStream.write("\r\n".getBytes());
        tmpOutStream.write(etc_header_string.getBytes());
    }

    public String getTo(String to_name, String to_mail) {
        ByteArrayOutputStream tmpOutStream = new ByteArrayOutputStream();
        try {
            tmpOutStream.write("To: \"".getBytes());
            if (this.isHeaderEncode) {
                MimeConvertor.putHeaderToStream(tmpOutStream, to_name, this.headerBaseCharSet, this.headerMimeCharSet, (short)1);
            } else {
                tmpOutStream.write(to_name.getBytes(this.headerBaseCharSet));
            }
            tmpOutStream.write("\" <".getBytes());
            tmpOutStream.write(to_mail.getBytes());
            tmpOutStream.write(">\r\n".getBytes());
        }
        catch (Exception e) {
            log.error("[ERROR]  getTo() : ", (Throwable)e);
        }
        return tmpOutStream.toString();
    }

    @Override
    public String getBoundaryString() {
        return "_nextpart_" + Cal.getBoundaryDate() + "." + System.currentTimeMillis();
    }

    @Override
    public void setEtcHeader(Properties prop) throws Exception {
        this.ETC_HEADER = prop;
        Enumeration<?> keys = this.ETC_HEADER.propertyNames();
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
        String key = null;
        String value = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.startsWith("X-")) continue;
            value = this.ETC_HEADER.getProperty(key);
            byteBuffer.write(key.getBytes("UTF-8"));
            byteBuffer.write(": ".getBytes());
            byteBuffer.write(value.getBytes("UTF-8"));
            byteBuffer.write(NEW_LINE);
        }
        keys = this.ETC_HEADER.propertyNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (key.startsWith("X-")) continue;
            value = this.ETC_HEADER.getProperty(key);
            byteBuffer.write(key.getBytes("UTF-8"));
            byteBuffer.write(": ".getBytes());
            byteBuffer.write(value.getBytes("UTF-8"));
            byteBuffer.write(NEW_LINE);
        }
        this.ETC_HEADER_STRING = byteBuffer.toString();
    }

    public void init(Properties campProp) {
        this.headerBaseCharSet = campProp.getProperty("NLS_LANG", this.headerBaseCharSet);
        this.headerMimeCharSet = campProp.getProperty("NLS_LANG", this.headerBaseCharSet);
    }

    @Override
    public String getContentUrl(String contentUrl) throws Exception {
        String content;
        try {
            content = FileUtil.readUrl(contentUrl, "UTF-8");
        }
        catch (IOException e) {
            throw new Exception("[ERROR] ReadUrl(" + contentUrl + ") Fail:" + e);
        }
        return content;
    }

    @Override
    public byte[] customizingSecureMailBody(Object info1, Properties campProp, String content, String securePwd, List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList) throws Exception {
        byte[] byteArray;
        String attachName;
        String attachPath;
        String attachUrl;
        AttachsSet clsAttachsSet = null;
        if (attachList.size() > 0 || dynamicAttachList.size() > 0) {
            clsAttachsSet = new AttachsSet();
        }
        for (Map<String, Object> attachMap : attachList) {
            attachUrl = (String)attachMap.get("ATTACH_URL");
            attachPath = (String)attachMap.get("ATTACH_PATH");
            attachName = (String)attachMap.get("ATTACH_NAME");
            if (!StringUtil.isNull(attachUrl)) {
                byteArray = FileUtil.readUrlToByteArray(attachUrl, this.attachBaseCharSet);
                clsAttachsSet.addAttach(byteArray, attachName);
                continue;
            }
            if (StringUtil.isNull(attachPath)) continue;
            clsAttachsSet.addAttach(attachPath, attachName);
        }
        for (Map<String, Object> attachMap : dynamicAttachList) {
            attachUrl = (String)attachMap.get("ATTACH_URL");
            attachPath = (String)attachMap.get("ATTACH_PATH");
            attachName = (String)attachMap.get("ATTACH_NAME");
            if (!StringUtil.isNull(attachUrl)) {
                byteArray = FileUtil.readUrlToByteArray(attachUrl, this.attachBaseCharSet);
                clsAttachsSet.addAttach(byteArray, attachName);
                continue;
            }
            if (StringUtil.isNull(attachPath)) continue;
            clsAttachsSet.addAttach(attachPath, attachName);
        }
        String attachContent = null;
        try {
            if (StringUtil.isNull(securePwd)) {
                log.error("[ERROR] SECURE PWD IS NULL");
                throw new Exception("[ERROR] SECURE PWD IS NULL");
            }
            UniSafeSMailMaker clsMaker = new UniSafeSMailMaker();
            try {
                if (this.secureTempltePath != null && !"".equals(this.secureTempltePath)) {
                    log.debug("[UniSafeSMailMaker]custom template use: {}", (Object)this.secureTempltePath);
                    clsMaker.setTemplate(this.secureTempltePath);
                }
                attachContent = clsMaker.generateCombineMail(content, clsAttachsSet, Boolean.parseBoolean(this.secureDefautAttachUse), this.uniSecurePasswdQuestion, securePwd);
            }
            catch (Exception e) {
                this.secureInit();
                try {
                    if (this.secureTempltePath != null && !"".equals(this.secureTempltePath)) {
                        log.debug("[UniSafeSMailMaker]custom template use: {}", (Object)this.secureTempltePath);
                        clsMaker.setTemplate(this.secureTempltePath);
                    }
                    attachContent = clsMaker.generateCombineMail(content, clsAttachsSet, Boolean.parseBoolean(this.secureDefautAttachUse), this.uniSecurePasswdQuestion, securePwd);
                }
                catch (Exception e2) {
                    log.error("[ERROR] UniSecure Encrypt Fail:{}", (Throwable)e);
                    throw new Exception(e);
                }
            }
        }
        catch (Exception e) {
            log.error("[ERROR] customizingSecureMailBody Fail:{}", (Throwable)e);
            throw new Exception("makeJustSmail ERROR1:" + e);
        }
        return BASE64.encode(attachContent).getBytes();
    }

    public String customizingSecureMailBodyString(Object info1, Properties campProp, String content, String securePwd, List<Map<String, Object>> attachList, List<Map<String, Object>> dynamicAttachList) throws Exception {
        byte[] byteArray;
        String attachName;
        String attachPath;
        String attachUrl;
        AttachsSet clsAttachsSet = null;
        if (attachList.size() > 0 || dynamicAttachList.size() > 0) {
            clsAttachsSet = new AttachsSet();
        }
        for (Map<String, Object> attachMap : attachList) {
            attachUrl = (String)attachMap.get("ATTACH_URL");
            attachPath = (String)attachMap.get("ATTACH_PATH");
            attachName = (String)attachMap.get("ATTACH_NAME");
            if (!StringUtil.isNull(attachUrl)) {
                byteArray = FileUtil.readUrlToByteArray(attachUrl, this.attachBaseCharSet);
                clsAttachsSet.addAttach(byteArray, attachName);
                continue;
            }
            if (StringUtil.isNull(attachPath)) continue;
            clsAttachsSet.addAttach(attachPath, attachName);
        }
        for (Map<String, Object> attachMap : dynamicAttachList) {
            attachUrl = (String)attachMap.get("ATTACH_URL");
            attachPath = (String)attachMap.get("ATTACH_PATH");
            attachName = (String)attachMap.get("ATTACH_NAME");
            if (!StringUtil.isNull(attachUrl)) {
                byteArray = FileUtil.readUrlToByteArray(attachUrl, this.attachBaseCharSet);
                clsAttachsSet.addAttach(byteArray, attachName);
                continue;
            }
            if (StringUtil.isNull(attachPath)) continue;
            clsAttachsSet.addAttach(attachPath, attachName);
        }
        String attachContent = null;
        try {
            if (StringUtil.isNull(securePwd)) {
                log.error("[ERROR] SECURE PWD IS NULL");
                throw new Exception("[ERROR] SECURE PWD IS NULL");
            }
            UniSafeSMailMaker clsMaker = new UniSafeSMailMaker();
            try {
                if (this.secureTempltePath != null && !"".equals(this.secureTempltePath)) {
                    log.debug("[UniSafeSMailMaker]custom template use: {}", (Object)this.secureTempltePath);
                    clsMaker.setTemplate(this.secureTempltePath);
                }
                attachContent = clsMaker.generateCombineMail(content, clsAttachsSet, Boolean.parseBoolean(this.secureDefautAttachUse), this.uniSecurePasswdQuestion, securePwd);
            }
            catch (Exception e) {
                this.secureInit();
                try {
                    if (this.secureTempltePath != null && !"".equals(this.secureTempltePath)) {
                        log.debug("[UniSafeSMailMaker]custom template use: {}", (Object)this.secureTempltePath);
                        clsMaker.setTemplate(this.secureTempltePath);
                    }
                    attachContent = clsMaker.generateCombineMail(content, clsAttachsSet, Boolean.parseBoolean(this.secureDefautAttachUse), this.uniSecurePasswdQuestion, securePwd);
                }
                catch (Exception e2) {
                    log.error("[ERROR] UniSecure Encrypt Fail:{}", (Throwable)e);
                    throw new Exception(e);
                }
            }
        }
        catch (Exception e) {
            log.error("[ERROR] customizingSecureMailBodyString Fail:{}", (Throwable)e);
            throw new Exception("makeJustSmail ERROR1:" + e);
        }
        return attachContent;
    }

    public void secureInit() {
        try {
            File file = new File(this.licFilePath);
            if (file.exists()) {
                UniSafeSMailMaker.init((String)this.licFilePath);
                UniSafeSMailMaker.setUseJava();
                log.info("[{}] UniSafeSMailMaker Init SUCCESS.", (Object)this.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            log.error("[ERROR] UniSecure init Fail::{}", (Throwable)e);
        }
    }

    public DefaultSourceAdd(ContentTrackingExecutor contentTrackingExecutor) {
        this.contentTrackingExecutor = contentTrackingExecutor;
    }
}

