/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import com.humuson.tms.mapper.body.DKIMSignerException;
import com.sun.mail.util.QPEncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Base64;

public class DKIMUtil {
    protected static String[] splitHeader(String header) throws DKIMSignerException {
        int colonPos = header.indexOf(58);
        if (colonPos == -1) {
            throw new DKIMSignerException("The header string " + header + " is no valid RFC 822 header-line");
        }
        return new String[]{header.substring(0, colonPos), header.substring(colonPos + 1)};
    }

    protected static String concatArray(ArrayList l, String separator) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next()).append(separator);
        }
        return buf.substring(0, buf.length() - separator.length());
    }

    protected static boolean isValidDomain(String domainname) {
        Pattern pattern = Pattern.compile("(.+)\\.(.+)");
        Matcher matcher = pattern.matcher(domainname);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String QuotedPrintable(String s) {
        ByteArrayOutputStream boas = null;
        QPEncoderStream encodeStream = null;
        try {
            boas = new ByteArrayOutputStream();
            encodeStream = new QPEncoderStream((OutputStream)boas);
            encodeStream.write(s.getBytes());
            String encoded = boas.toString();
            encoded = encoded.replaceAll(";", "=3B");
            String string = encoded = encoded.replaceAll(" ", "=20");
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (boas != null) {
                try {
                    boas.close();
                }
                catch (IOException iOException) {}
                boas = null;
            }
            if (encodeStream != null) {
                try {
                    encodeStream.close();
                }
                catch (IOException iOException) {}
                encodeStream = null;
            }
        }
        return null;
    }

    protected static String base64Encode(byte[] b) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])b);
        String encoded = new String(encodedBytes);
        encoded = encoded.replace("\n", "");
        return encoded.replace("\r", "");
    }

    public boolean checkDNSForPublickey(String signingDomain, String selector) throws DKIMSignerException {
        String[] tags;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        String recordname = selector + "._domainkey." + signingDomain;
        String value = null;
        try {
            InitialDirContext dnsContext = new InitialDirContext(env);
            Attributes attribs = dnsContext.getAttributes(recordname, new String[]{"TXT"});
            Attribute txtrecord = attribs.get("txt");
            if (txtrecord == null) {
                throw new DKIMSignerException("There is no TXT record available for " + recordname);
            }
            value = (String)txtrecord.get();
        }
        catch (NamingException ne) {
            throw new DKIMSignerException("Selector lookup failed" + ne);
        }
        if (value == null) {
            throw new DKIMSignerException("Value of RR " + recordname + " couldn't be retrieved");
        }
        for (String tag : tags = value.split(";")) {
            if (!(tag = tag.trim()).startsWith("p=")) continue;
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PKCS8EncodedKeySpec pubSpec = new PKCS8EncodedKeySpec(tag.substring(2).getBytes());
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((Object)keyFactory.generatePublic(pubSpec));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new DKIMSignerException("RSA algorithm not found by JVM." + nsae);
            }
            catch (InvalidKeySpecException ikse) {
                throw new DKIMSignerException("The public key " + tag + " in RR " + recordname + " couldn't be decoded." + ikse);
            }
            return true;
        }
        throw new DKIMSignerException("No public key available in " + recordname);
    }
}

