/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.mapper.body;

import com.humuson.tms.mapper.body.Canonicalization;
import com.humuson.tms.mapper.body.DKIMSignerException;
import com.humuson.tms.mapper.body.DKIMUtil;
import com.humuson.tms.mapper.body.SigningAlgorithm;
import com.sun.mail.util.CRLFOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DKIMSigner {
    private static final Logger log = LoggerFactory.getLogger(DKIMSigner.class);
    private String DKIMSIGNATUREHEADER = "DKIM-Signature";
    private int MAXHEADERLENGTH = 67;
    private String[] defaultHeadersToSign = new String[]{"Content-Description", "Content-ID", "Content-Type", "Content-Transfer-Encoding", "Cc", "Date", "From", "In-Reply-To", "List-Subscribe", "List-Post", "List-Owner", "List-Id", "List-Archive", "List-Help", "List-Unsubscribe", "MIME-Version", "Message-ID", "Resent-Sender", "Resent-Cc", "Resent-Date", "Resent-To", "Reply-To", "References", "Resent-Message-ID", "Resent-From", "Sender", "Subject", "To"};
    private SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256withRSA;
    @Value(value="${mapper.header.dkim-yn}")
    protected String DKIM_USE_YN;
    @Value(value="${mapper.header.dkim-domain}")
    protected String signingDomain;
    @Value(value="${mapper.header.dkim-selecter}")
    protected String selector;
    @Value(value="${mapper.header.dkim-file-path}")
    protected String DKIM_PRIVATEKEY_PATH;
    private String identity = null;
    private boolean lengthParam = false;
    private boolean zParam = false;
    private Canonicalization headerCanonicalization = Canonicalization.RELAXED;
    private Canonicalization bodyCanonicalization = Canonicalization.SIMPLE;
    private PrivateKey privkey;

    public void DKIMSigner(String signingDomain, String selector, String privkeyFilename) throws Exception {
        File privKeyFile = new File(privkeyFilename);
        byte[] privKeyBytes = null;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(privKeyFile));){
            privKeyBytes = new byte[(int)privKeyFile.length()];
            dis.readFully(privKeyBytes);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        this.initDKIMSigner(signingDomain, selector, privKey);
    }

    private void initDKIMSigner(String signingDomain, String selector, PrivateKey privkey) throws DKIMSignerException {
        if (!DKIMUtil.isValidDomain(signingDomain)) {
            throw new DKIMSignerException(signingDomain + " is an invalid signing domain");
        }
        this.signingDomain = signingDomain;
        this.selector = selector.trim();
        this.privkey = privkey;
        this.setSigningAlgorithm(this.signingAlgorithm);
    }

    public PrivateKey getPrivKey() {
        if (this.privkey == null) {
            try {
                File privKeyFile = new File(this.DKIM_PRIVATEKEY_PATH);
                byte[] privKeyBytes = null;
                try (DataInputStream dis = new DataInputStream(new FileInputStream(privKeyFile));){
                    privKeyBytes = new byte[(int)privKeyFile.length()];
                    dis.readFully(privKeyBytes);
                }
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privKeyBytes);
                RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
                this.privkey = privKey;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.privkey;
    }

    public String getDKIMHumusonHeader(String mailBody, String headlist) throws DKIMSignerException, MessagingException {
        String serializedSignature = null;
        MessageDigest messageDigest = null;
        SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256withRSA;
        try {
            Signature signatureService = Signature.getInstance(signingAlgorithm.getJavaSecNotation());
            try {
                signatureService.initSign(this.getPrivKey());
            }
            catch (InvalidKeyException ike) {
                throw new DKIMSignerException("The provided private key is invalid. " + ike);
            }
            catch (Exception e) {
                signatureService = Signature.getInstance(signingAlgorithm.getJavaSecNotation());
                try {
                    this.privkey = null;
                    signatureService.initSign(this.getPrivKey());
                }
                catch (InvalidKeyException e1) {
                    throw new DKIMSignerException("The provided private key is invalid. " + e1);
                }
            }
            try {
                messageDigest = MessageDigest.getInstance(signingAlgorithm.getJavaHashNotation());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new DKIMSignerException("The hashing algorithm " + signingAlgorithm.getJavaHashNotation() + " is not known by the JVM" + nsae);
            }
            StringBuffer headerContent = new StringBuffer();
            LinkedHashMap<String, String> dkimSignature = new LinkedHashMap<String, String>();
            dkimSignature.put("v", "1");
            dkimSignature.put("a", signingAlgorithm.getRfc4871Notation());
            dkimSignature.put("q", "dns/txt");
            dkimSignature.put("c", this.getHeaderCanonicalization().getType() + "/" + this.getBodyCanonicalization().getType());
            dkimSignature.put("t", new Date().getTime() / 1000L + "");
            dkimSignature.put("s", this.selector);
            dkimSignature.put("d", this.signingDomain);
            String[] head_list = headlist.split("\r\n");
            StringBuffer headerList = new StringBuffer();
            for (String tmp : head_list) {
                if (tmp.indexOf(":") <= -1 || tmp.startsWith("X-") || tmp.startsWith("Message-ID")) continue;
                String[] headerParts = DKIMUtil.splitHeader(tmp);
                headerList.append(headerParts[0]).append(":");
                headerContent.append(this.headerCanonicalization.canonicalizeHeader(headerParts[0], headerParts[1])).append("\r\n");
            }
            dkimSignature.put("h", headerList.substring(0, headerList.length() - 1));
            String body = mailBody;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CRLFOutputStream crlfos = new CRLFOutputStream((OutputStream)baos);
            try {
                crlfos.write(body.getBytes());
            }
            catch (IOException e) {
                throw new DKIMSignerException("The body conversion to MIME canonical CRLF line terminator failed. " + e);
            }
            body = baos.toString();
            try {
                body = this.bodyCanonicalization.canonicalizeBody(body);
            }
            catch (IOException ioe) {
                throw new DKIMSignerException("The body canonicalization failed. " + ioe);
            }
            finally {
                if (crlfos != null) {
                    try {
                        crlfos.close();
                    }
                    catch (IOException iOException) {}
                    crlfos = null;
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            dkimSignature.put("bh", DKIMUtil.base64Encode(messageDigest.digest(body.getBytes())));
            serializedSignature = this.serializeDKIMSignature(dkimSignature);
            byte[] signedSignature = null;
            try {
                signatureService.update(headerContent.append(this.headerCanonicalization.canonicalizeHeader(this.DKIMSIGNATUREHEADER, " " + serializedSignature)).toString().getBytes());
                signedSignature = signatureService.sign();
            }
            catch (SignatureException se) {
                log.error("[ERROR] SignatureException : {}", (Throwable)se);
                throw new DKIMSignerException("The signing operation by Java security failed" + se);
            }
            String string = this.DKIMSIGNATUREHEADER + ": " + serializedSignature + this.foldSignedSignature(DKIMUtil.base64Encode(signedSignature), 3);
            return string;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DKIMSignerException("The signing algorithm " + signingAlgorithm.getJavaSecNotation() + " is not known by the JVM. " + nsae);
        }
        finally {
            messageDigest.reset();
        }
    }

    public void setSigningAlgorithm(SigningAlgorithm signingAlgorithm) throws DKIMSignerException {
        this.signingAlgorithm = signingAlgorithm;
    }

    public String getDKIMAmailBody(String mailBody) throws DKIMSignerException, MessagingException {
        String body = mailBody;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfos = new CRLFOutputStream((OutputStream)baos);
        try {
            crlfos.write(body.getBytes());
        }
        catch (IOException e) {
            throw new DKIMSignerException("The body conversion to MIME canonical CRLF line terminator failed" + e);
        }
        body = baos.toString();
        try {
            body = this.bodyCanonicalization.canonicalizeBody(body);
        }
        catch (IOException ioe) {
            throw new DKIMSignerException("The body canonicalization failed" + ioe);
        }
        finally {
            if (crlfos != null) {
                try {
                    crlfos.close();
                }
                catch (IOException iOException) {}
                crlfos = null;
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
                baos = null;
            }
        }
        return body;
    }

    public String getBodyHash(String mailBody) throws DKIMSignerException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(mailBody.getBytes());
            String digest = DKIMUtil.base64Encode(md.digest());
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("print stack trace", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error("print stack trace", (Throwable)e);
        }
        throw new DKIMSignerException(mailBody);
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) throws DKIMSignerException {
        if (identity != null && !(identity = identity.trim()).endsWith("@" + this.signingDomain) && !identity.endsWith("." + this.signingDomain)) {
            throw new DKIMSignerException("The domain part of " + identity + " has to be " + this.signingDomain + " or its subdomain");
        }
        this.identity = identity;
    }

    public Canonicalization getBodyCanonicalization() {
        return this.bodyCanonicalization;
    }

    public void setBodyCanonicalization(Canonicalization bodyCanonicalization) throws DKIMSignerException {
        this.bodyCanonicalization = bodyCanonicalization;
    }

    public Canonicalization getHeaderCanonicalization() {
        return this.headerCanonicalization;
    }

    public void setHeaderCanonicalization(Canonicalization headerCanonicalization) throws DKIMSignerException {
        this.headerCanonicalization = headerCanonicalization;
    }

    public String[] getDefaultHeadersToSign() {
        return this.defaultHeadersToSign;
    }

    public void addHeaderToSign(String header) {
        if (header == null || "".equals(header)) {
            return;
        }
        int len = this.defaultHeadersToSign.length;
        String[] headersToSign = new String[len + 1];
        for (int i = 0; i < len; ++i) {
            if (header.equals(this.defaultHeadersToSign[i])) {
                return;
            }
            headersToSign[i] = this.defaultHeadersToSign[i];
        }
        headersToSign[len] = header;
        this.defaultHeadersToSign = headersToSign;
    }

    public void removeHeaderToSign(String header) {
        if (header == null || "".equals(header)) {
            return;
        }
        int len = this.defaultHeadersToSign.length;
        if (len == 0) {
            return;
        }
        String[] headersToSign = new String[len - 1];
        int found = 0;
        for (int i = 0; i < len - 1; ++i) {
            if (header.equals(this.defaultHeadersToSign[i + found])) {
                found = 1;
            }
            headersToSign[i] = this.defaultHeadersToSign[i + found];
        }
        this.defaultHeadersToSign = headersToSign;
    }

    public void setLengthParam(boolean lengthParam) {
        this.lengthParam = lengthParam;
    }

    public boolean getLengthParam() {
        return this.lengthParam;
    }

    public boolean isZParam() {
        return this.zParam;
    }

    public void setZParam(boolean param) {
        this.zParam = param;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    private String serializeDKIMSignature(Map<String, String> dkimSignature) {
        Set<Map.Entry<String, String>> entries = dkimSignature.entrySet();
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        for (Map.Entry<String, String> entry : entries) {
            StringBuffer fbuf = new StringBuffer();
            fbuf.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            if (pos + fbuf.length() + 1 > this.MAXHEADERLENGTH) {
                pos = fbuf.length();
                buf.append("\r\n\t").append(fbuf);
                continue;
            }
            buf.append(" ").append(fbuf);
            pos += fbuf.length() + 1;
        }
        buf.append("\r\n\tb=");
        return buf.toString().trim();
    }

    private String foldSignedSignature(String s, int offset) {
        int i = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            if (offset > 0 && s.substring(i).length() > this.MAXHEADERLENGTH - offset) {
                buf.append(s.substring(i, i + this.MAXHEADERLENGTH - offset));
                i += this.MAXHEADERLENGTH - offset;
                offset = 0;
                continue;
            }
            if (s.substring(i).length() <= this.MAXHEADERLENGTH) break;
            buf.append("\r\n\t").append(s.substring(i, i + this.MAXHEADERLENGTH));
            i += this.MAXHEADERLENGTH;
        }
        buf.append("\r\n\t").append(s.substring(i));
        return buf.toString();
    }
}

