/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.config.Constants;
import com.humuson.tms.mapper.content.ContentReadWrite;
import com.humuson.tms.mapper.filter.Filter;
import com.humuson.tms.mapper.info.MappingInfo;
import com.humuson.tms.mapper.mapping.ContentMapping;
import com.humuson.tms.mapper.util.StringUtil;
import com.humuson.tms.util.date.DateUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiMappingController {
    private static final Logger log = LoggerFactory.getLogger(ApiMappingController.class);
    @Autowired
    private ContentMapping contentMapping;
    @Autowired
    private ContentReadWrite contentReadWrite;
    @Autowired
    private Filter filter;
    private Logger apiTraceLogger = LoggerFactory.getLogger((String)"apiTraceLog");
    @Value(value="${mapper.content-save-path}")
    private String contentRootPath;
    @Value(value="${mapper.content-save-url}")
    private String contentRootUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/mapper/api/previewMapping"}, produces={"application/json; charset=utf8"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> priviewMapping(@RequestBody Map<String, String> params, HttpServletRequest request) throws UnsupportedEncodingException {
        this.apiTraceLogger.info("[API] previewMapping Call... IP [{}] params : {}", (Object)request.getRemoteAddr(), params);
        log.debug("[API] previewMapping Call... IP [{}] params : {}", (Object)request.getRemoteAddr(), params);
        HttpHeaders responseHeaders = new HttpHeaders();
        org.json.JSONObject result = new org.json.JSONObject();
        MappingInfo mminfo = new MappingInfo();
        Properties campProp = new Properties();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> dynamicAttachList = new ArrayList<Map<String, Object>>();
        String sendId = "";
        String memberId = "";
        try {
            JSONParser parser;
            String type = params.containsKey("TYPE") ? params.get("TYPE") : Constants.Type.REALVIEW.name();
            memberId = params.containsKey("TMS_M_ID") ? params.get("TMS_M_ID") : "";
            String memberEmail = params.containsKey("TMS_M_EMAIL") ? params.get("TMS_M_EMAIL") : "";
            String memberPhone = params.containsKey("TMS_M_PHONE") ? params.get("TMS_M_PHONE") : "";
            sendId = params.containsKey("SEND_ID") ? params.get("SEND_ID") : "";
            String targetId = params.containsKey("TARGET_ID") ? params.get("TARGET_ID") : "";
            String targetType = params.containsKey("TARGET_TYPE") ? params.get("TARGET_TYPE") : "";
            String contentUrl = params.containsKey("CONTENT_URL") ? params.get("CONTENT_URL") : "";
            String contentPath = params.containsKey("CONTENT_PATH") ? params.get("CONTENT_PATH") : "";
            String channelType = params.containsKey("CHANNEL_TYPE") ? params.get("CHANNEL_TYPE") : "";
            String subject = params.containsKey("SUBJECT") ? params.get("SUBJECT") : "";
            String channelTypeSub = params.containsKey("CHANNEL_TYPE_SUB") ? params.get("CHANNEL_TYPE_SUB") : "";
            String switchFlag = params.containsKey("SWITCH_FLAG") ? params.get("SWITCH_FLAG") : "N";
            String pushValue = params.containsKey("PUSH_VALUE") ? params.get("PUSH_VALUE") : "";
            String pushMsg = params.containsKey("PUSH_MSG") ? params.get("PUSH_MSG") : "";
            String pushType = params.containsKey("PUSH_TYPE") ? params.get("PUSH_TYPE") : "";
            String mapping = params.containsKey("MAPPING") ? params.get("MAPPING") : "";
            String content = params.containsKey("CONTENT") ? params.get("CONTENT") : "";
            String tempContent = "";
            String resultSubject = "";
            String resultPushValue = "";
            String resultPushMsg = "";
            boolean isBroadcastSubject = true;
            boolean isBroadcastPushValue = true;
            boolean isBroadcastPushMsg = true;
            boolean isRealView = false;
            if (subject.indexOf("${") > -1) {
                isBroadcastSubject = false;
            }
            if (pushValue.indexOf("${") > -1) {
                isBroadcastPushValue = false;
            }
            if (pushMsg.indexOf("${") > -1) {
                isBroadcastPushMsg = false;
            }
            if (Constants.Type.PREVIEW.name().equals(type)) {
                isRealView = false;
            } else if (Constants.Type.REALVIEW.name().equals(type)) {
                isRealView = true;
            } else {
                this.apiTraceLogger.error("[API] Parameter Invalid Error [type] isEmpty");
                result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                result.put("RESULT_CODE", (Object)"401");
                result.put("RESULT_MSG", (Object)"[API] Parameter Invalid Error [type] isEmpty");
                ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                return responseEntity;
            }
            if (isRealView) {
                if (!"OP".equals(pushType) && StringUtil.isNull(content)) {
                    String errorKey = "content";
                    this.apiTraceLogger.error("[API] Parameter Invalid Error [{}] isEmpty", (Object)errorKey);
                    result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                    result.put("RESULT_CODE", (Object)"401");
                    result.put("RESULT_MSG", (Object)("[API] Parameter Invalid Error [" + errorKey + "] isEmpty"));
                    ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                    return responseEntity;
                }
            } else if (!"OP".equals(pushType) && contentUrl.isEmpty() && contentPath.isEmpty() || targetId.isEmpty() || targetType.isEmpty()) {
                String errorKey = "";
                if (!"OP".equals(pushType) && contentUrl.isEmpty() && contentPath.isEmpty()) {
                    errorKey = "contentUrl/contentPath";
                } else if (targetId.isEmpty()) {
                    errorKey = "targetId";
                } else if (targetType.isEmpty()) {
                    errorKey = "targetType";
                }
                this.apiTraceLogger.error("[API] Parameter Invalid Error [{}] isEmpty", (Object)errorKey);
                log.debug("[API] Parameter Invalid Error [{}] isEmpty", (Object)errorKey);
                result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                result.put("RESULT_CODE", (Object)"401");
                result.put("RESULT_MSG", (Object)("[API] Parameter Invalid Error [" + errorKey + "] isEmpty"));
                ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                return responseEntity;
            }
            campProp.putAll(params);
            userMap.putAll(params);
            if (!isRealView) {
                try {
                    content = this.contentReadWrite.getContent(campProp);
                }
                catch (Exception e) {
                    this.apiTraceLogger.error("[API] Content readUrl Error:" + e);
                    log.debug("[API] Content readUrl Error:" + e);
                    result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                    result.put("RESULT_CODE", (Object)"500");
                    result.put("RESULT_MSG", (Object)e.getMessage());
                    ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                    if (!userMap.isEmpty()) {
                        userMap.clear();
                    }
                    if (!campProp.isEmpty()) {
                        campProp.clear();
                    }
                    if (mminfo != null) {
                        mminfo = null;
                    }
                    return responseEntity;
                }
            }
            if (ChannelType.EMAIL.same(channelType)) {
                userMap.put("TMS_M_TARGET", memberEmail);
            } else if (ChannelType.SMS.same(channelType) || ChannelType.KAKAO.same(channelType)) {
                userMap.put("TMS_M_TARGET", memberPhone);
            }
            if (!isRealView) {
                if (Constants.TargetType.DB.name().equals(targetType)) {
                    mminfo = this.contentMapping.getMappingData(campProp);
                    userMap.putAll(this.contentMapping.getMappingDataPut(userMap, campProp, mminfo));
                }
            } else if (!StringUtil.isNull(mapping)) {
                JSONObject resultJSON = new JSONObject();
                parser = new JSONParser();
                try {
                    Object obj = parser.parse(mapping);
                    resultJSON = (JSONObject)obj;
                    userMap.putAll((Map<String, Object>)resultJSON);
                }
                catch (Exception e) {
                    this.apiTraceLogger.error("[API] Mapping Data Parsing Error :[{}]", (Object)memberId);
                    log.debug("[API] Mapping Data Parsing Error :[{}]", (Object)memberId);
                    result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                    result.put("RESULT_CODE", (Object)"500");
                    result.put("RESULT_MSG", (Object)e.getMessage());
                    ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                    if (!userMap.isEmpty()) {
                        userMap.clear();
                    }
                    if (!campProp.isEmpty()) {
                        campProp.clear();
                    }
                    if (mminfo != null) {
                        mminfo = null;
                    }
                    return responseEntity;
                }
            }
            if (ChannelType.PUSH.same(channelType)) {
                if (!StringUtil.isNull(pushValue) && !isBroadcastPushValue) {
                    try {
                        resultPushValue = this.contentMapping.convertMappingExecutor(userMap, campProp, pushValue);
                        userMap.put("PUSH_VALUE", resultPushValue);
                    }
                    catch (Exception e) {
                        this.apiTraceLogger.error("[API] PUSH_VALUE mapping Error :[{}]", (Object)memberId);
                        log.debug("[API] PUSH_VALUE mapping Error :[{}]", (Object)memberId);
                        result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                        result.put("RESULT_CODE", (Object)"500");
                        result.put("RESULT_MSG", (Object)e.getMessage());
                        parser = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                        if (!userMap.isEmpty()) {
                            userMap.clear();
                        }
                        if (!campProp.isEmpty()) {
                            campProp.clear();
                        }
                        if (mminfo != null) {
                            mminfo = null;
                        }
                        return parser;
                    }
                }
                if (!StringUtil.isNull(pushMsg) && !isBroadcastPushMsg) {
                    try {
                        resultPushMsg = this.contentMapping.convertMappingExecutor(userMap, campProp, pushMsg);
                        userMap.put("PUSH_MSG", resultPushMsg);
                    }
                    catch (Exception e) {
                        this.apiTraceLogger.error("[API] PUSH_MSG Mapping Error :[{}]", (Object)memberId);
                        log.debug("[API] PUSH_MSG Mapping Error :[{}]", (Object)memberId);
                        result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                        result.put("RESULT_CODE", (Object)"500");
                        result.put("RESULT_MSG", (Object)e.getMessage());
                        parser = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                        if (!userMap.isEmpty()) {
                            userMap.clear();
                        }
                        if (!campProp.isEmpty()) {
                            campProp.clear();
                        }
                        if (mminfo != null) {
                            mminfo = null;
                        }
                        return parser;
                    }
                }
            }
            try {
                tempContent = this.contentMapping.convertMappingExecutor(userMap, campProp, content);
            }
            catch (Exception ee) {
                this.apiTraceLogger.error("[API] Content Mapping Error => OriginalContent Return :{}", (Throwable)ee);
                tempContent = content;
            }
            userMap.put("CONTENT", tempContent);
            String tempChannelTypeSub = this.filter.exchangeChannelTypeSub(tempContent, channelType, channelTypeSub, switchFlag, attachList, dynamicAttachList);
            if (!(StringUtil.isNull(subject) || ChannelType.SMS.same(tempChannelTypeSub) || isBroadcastSubject)) {
                try {
                    resultSubject = this.contentMapping.convertMappingExecutor(userMap, campProp, subject);
                    userMap.put("SUBJECT", resultSubject);
                }
                catch (Exception e) {
                    this.apiTraceLogger.error("[API] SUBJECT Mapping Error :[{}]", (Object)memberId);
                    log.debug("[API] SUBJECT Mapping Error :[{}]", (Object)memberId);
                    result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                    result.put("RESULT_CODE", (Object)"500");
                    result.put("RESULT_MSG", (Object)e.getMessage());
                    ResponseEntity responseEntity = new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
                    if (!userMap.isEmpty()) {
                        userMap.clear();
                    }
                    if (!campProp.isEmpty()) {
                        campProp.clear();
                    }
                    if (mminfo != null) {
                        mminfo = null;
                    }
                    return responseEntity;
                }
            }
            result = this.convertMapToJSONAppand(userMap, result);
            result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
            result.put("RESULT_CODE", (Object)"200");
            result.put("RESULT_MSG", (Object)"SUCCESS");
            this.apiTraceLogger.info("[API] SUCCESS -> sendId:{}  memberId:{}", (Object)sendId, (Object)memberId);
            log.debug("[API] SUCCESS -> sendId:{}  memberId:{}", (Object)sendId, (Object)memberId);
        }
        catch (Exception e) {
            this.apiTraceLogger.error("[API] priviewMapping Fail  sendId:{} memberId:{} ", new Object[]{sendId, memberId, e});
            log.debug("[API] priviewMapping Fail  sendId:{} memberId:{} ", new Object[]{sendId, memberId, e});
            try {
                result.put("RESULT_TIME", (Object)DateUtil.getNowDate((String)"yyyy-MM-dd hh:mm:ss"));
                result.put("RESULT_CODE", (Object)"500");
                result.put("RESULT_MSG", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                this.apiTraceLogger.error("[API] priviewMapping Fail-catch   sendId:{} memberId:{} ", new Object[]{sendId, memberId, e1});
                log.debug("[API] priviewMapping Fail  sendId:{} memberId:{} ", new Object[]{sendId, memberId, e1});
            }
        }
        finally {
            if (!userMap.isEmpty()) {
                userMap.clear();
            }
            if (!campProp.isEmpty()) {
                campProp.clear();
            }
            if (mminfo != null) {
                mminfo = null;
            }
        }
        return new ResponseEntity((Object)result.toString(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private org.json.JSONObject convertMapToJSONAppand(Map<String, Object> userMap, org.json.JSONObject jsonObj) throws Exception {
        try {
            for (Map.Entry<String, Object> entry : userMap.entrySet()) {
                String key = entry.getKey();
                if (key.indexOf("rap_") > -1 || key.equals("FIELD_MEMBER_ID")) continue;
                String value = String.valueOf(entry.getValue());
                jsonObj.put(key, (Object)value);
            }
        }
        catch (Exception e) {
            this.apiTraceLogger.error("[API] convertMapToJSONString Fail:{}", (Throwable)e);
            log.debug("[API] convertMapToJSONString Fail:{}", (Throwable)e);
            throw new Exception("convertMapToJSONString Fail:{}" + e);
        }
        return jsonObj;
    }
}

